/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices.columns;

import com.aelitis.azureus.core.devices.TranscodeFile;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;

public class ColumnTJ_Duration
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static final String COLUMN_ID = "duration";

    public ColumnTJ_Duration(TableColumn column) {
        column.initialize(2, -2, 85);
        column.addListeners(this);
        column.setRefreshInterval(-1);
        column.setType(3);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        TranscodeFile tf = (TranscodeFile)cell.getDataSource();
        if (tf == null) {
            return;
        }
        long duration = tf.getDurationMillis();
        cell.setText(duration == 0L ? "" : TimeFormatter.format(duration / 1000L));
    }
}

