/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices.columns;

import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeJob;
import com.aelitis.azureus.ui.common.table.impl.TableColumnImpl;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.utils.FontUtils;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;

public class ColumnTJ_Completion
implements TableCellAddedListener,
TableCellRefreshListener,
TableCellDisposeListener,
TableCellSWTPaintListener,
TableColumnExtraInfoListener {
    private static final int borderWidth = 1;
    public static final String COLUMN_ID = "trancode_completion";
    private static Font fontText;
    private Map mapCellLastPercentDone = new HashMap();
    private int marginHeight = -1;
    private String na_text;
    Color textColor;
    NumberFormat percentage_format = NumberFormat.getPercentInstance();

    public ColumnTJ_Completion(final TableColumn column) {
        this.percentage_format.setMinimumFractionDigits(0);
        this.percentage_format.setMaximumFractionDigits(0);
        column.initialize(1, -2, 145);
        column.addListeners(this);
        ((TableColumnImpl)column).addCellOtherListener("SWTPaint", this);
        column.setType(2);
        column.setRefreshInterval(-1);
        MessageText.addAndFireListener(new MessageText.MessageTextListener(){

            @Override
            public void localeChanged(Locale old_locale, Locale new_locale) {
                ColumnTJ_Completion.this.na_text = MessageText.getString("general.na.short");
                column.invalidateCells();
            }
        });
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    @Override
    public void cellAdded(TableCell cell) {
        if (this.marginHeight != -1) {
            cell.setMarginHeight(this.marginHeight);
        } else {
            cell.setMarginHeight(2);
        }
    }

    @Override
    public void dispose(TableCell cell) {
        this.mapCellLastPercentDone.remove(cell);
    }

    @Override
    public void refresh(TableCell cell) {
        int lastPercentDone;
        TranscodeFile tf = (TranscodeFile)cell.getDataSource();
        int percentDone = this.getPerThouDone(tf);
        Integer intObj = (Integer)this.mapCellLastPercentDone.get(cell);
        int n = lastPercentDone = intObj == null ? 0 : intObj;
        if (!cell.setSortValue(percentDone) && cell.isValid() && lastPercentDone == percentDone) {
            return;
        }
    }

    @Override
    public void cellPaint(GC gcImage, TableCellSWT cell) {
        String sText;
        Rectangle imgBounds;
        TranscodeFile tf = (TranscodeFile)cell.getDataSource();
        int perThouDone = this.getPerThouDone(tf);
        Rectangle bounds = cell.getBounds();
        int yOfs = (bounds.height - 13) / 2;
        int x1 = bounds.width - 1 - 2;
        int y1 = bounds.height - 3 - yOfs;
        if (x1 < 10 || y1 < 3) {
            return;
        }
        this.mapCellLastPercentDone.put(cell, new Integer(perThouDone));
        ImageLoader imageLoader = ImageLoader.getInstance();
        Image imgEnd = imageLoader.getImage("tc_bar_end");
        Image img0 = imageLoader.getImage("tc_bar_0");
        Image img1 = imageLoader.getImage("tc_bar_1");
        if (!imgEnd.isDisposed()) {
            gcImage.drawImage(imgEnd, bounds.x, bounds.y + yOfs);
            gcImage.drawImage(imgEnd, bounds.x + x1 + 1, bounds.y + yOfs);
        }
        int limit = x1 * perThouDone / 1000;
        if (!img1.isDisposed() && limit > 0) {
            imgBounds = img1.getBounds();
            gcImage.drawImage(img1, 0, 0, imgBounds.width, imgBounds.height, bounds.x + 1, bounds.y + yOfs, limit, imgBounds.height);
        }
        if (perThouDone < 1000 && !img0.isDisposed()) {
            imgBounds = img0.getBounds();
            gcImage.drawImage(img0, 0, 0, imgBounds.width, imgBounds.height, bounds.x + limit + 1, bounds.y + yOfs, x1 - limit, imgBounds.height);
        }
        imageLoader.releaseImage("tc_bar_end");
        imageLoader.releaseImage("tc_bar_0");
        imageLoader.releaseImage("tc_bar_1");
        if (this.textColor == null) {
            this.textColor = ColorCache.getColor(gcImage.getDevice(), "#006600");
        }
        gcImage.setForeground(this.textColor);
        if (fontText == null) {
            fontText = FontUtils.getFontWithHeight(gcImage.getFont(), gcImage, 10);
        }
        gcImage.setFont(fontText);
        if (tf != null && perThouDone == 1000 && !tf.getTranscodeRequired()) {
            sText = this.na_text;
        } else {
            String eta;
            sText = this.percentage_format.format((double)perThouDone / 1000.0);
            if (tf != null && perThouDone < 1000 && (eta = this.getETA(tf)) != null) {
                sText = sText + " - " + eta;
            }
        }
        GCStringPrinter.printString(gcImage, sText, new Rectangle(bounds.x + 4, bounds.y + yOfs, bounds.width - 4, 13), true, false, 0x1000000);
    }

    private int getPerThouDone(TranscodeFile tf) {
        if (tf == null) {
            return 0;
        }
        TranscodeJob job = tf.getJob();
        if (job == null) {
            return tf.isComplete() ? 1000 : 0;
        }
        return job.getPercentComplete() * 10;
    }

    private String getETA(TranscodeFile tf) {
        if (tf == null) {
            return null;
        }
        TranscodeJob job = tf.getJob();
        if (job == null) {
            return null;
        }
        return job.getETA();
    }
}

