/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices.columns;

import com.aelitis.azureus.core.devices.DeviceOfflineDownload;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;

public class ColumnOD_Name
implements TableCellRefreshListener,
TableColumnExtraInfoListener,
ObfusticateCellText {
    public static final String COLUMN_ID = "od_name";

    public ColumnOD_Name(TableColumn column) {
        column.initialize(1, -2, 300);
        column.addListeners(this);
        column.setRefreshInterval(-1);
        column.setType(3);
        column.setObfustication(true);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        DeviceOfflineDownload od = (DeviceOfflineDownload)cell.getDataSource();
        if (od == null) {
            return;
        }
        String text = od.getDownload().getName();
        if (text == null || text.length() == 0) {
            return;
        }
        cell.setText(text);
    }

    @Override
    public String getObfusticatedText(TableCell cell) {
        DeviceOfflineDownload od = (DeviceOfflineDownload)cell.getDataSource();
        if (od == null) {
            return null;
        }
        String name = od.getDownload().toString();
        int i = name.indexOf(35);
        if (i > 0) {
            name = name.substring(i + 1);
        }
        return name;
    }
}

