/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceListener;
import com.aelitis.azureus.core.devices.DeviceOfflineDownload;
import com.aelitis.azureus.core.devices.DeviceOfflineDownloader;
import com.aelitis.azureus.core.devices.DeviceOfflineDownloaderListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnThumbnail;
import com.aelitis.azureus.ui.swt.devices.columns.ColumnOD_Completion;
import com.aelitis.azureus.ui.swt.devices.columns.ColumnOD_Name;
import com.aelitis.azureus.ui.swt.devices.columns.ColumnOD_Remaining;
import com.aelitis.azureus.ui.swt.devices.columns.ColumnOD_Status;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;

public class SBC_DevicesODView
extends SkinView
implements UIUpdatable,
UIPluginViewToolBarListener {
    public static final String TABLE_ID = "DevicesOD";
    private static boolean columnsAdded = false;
    private DeviceOfflineDownloader device;
    private TableViewSWT<DeviceOfflineDownload> tv_downloads;
    private MdiEntrySWT mdi_entry;
    private Composite control_parent;

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                SBC_DevicesODView.this.initColumns(core);
            }
        });
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null) {
            this.mdi_entry = mdi.getCurrentEntrySWT();
            this.mdi_entry.addToolbarEnabler(this);
            this.device = (DeviceOfflineDownloader)this.mdi_entry.getDatasource();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumns(AzureusCore core) {
        Class<SBC_DevicesODView> clazz = SBC_DevicesODView.class;
        synchronized (SBC_DevicesODView.class) {
            if (columnsAdded) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            columnsAdded = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            UIManager uiManager = PluginInitializer.getDefaultInterface().getUIManager();
            TableManager tableManager = uiManager.getTableManager();
            tableManager.registerColumn(DeviceOfflineDownload.class, "Thumbnail", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnThumbnail(column);
                    column.setWidth(70);
                }
            });
            tableManager.registerColumn(DeviceOfflineDownload.class, "od_name", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnOD_Name(column);
                }
            });
            tableManager.registerColumn(DeviceOfflineDownload.class, "od_status", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnOD_Status(column);
                }
            });
            tableManager.registerColumn(DeviceOfflineDownload.class, "od_completion", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnOD_Completion(column);
                }
            });
            tableManager.registerColumn(DeviceOfflineDownload.class, "od_remaining", new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnOD_Remaining(column);
                }
            });
            TableColumnManager tcm = TableColumnManager.getInstance();
            TableColumnCore[] allTCs = tcm.getAllTableColumnCoreAsArray(DeviceOfflineDownload.class, TABLE_ID);
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < allTCs.length; ++i) {
                TableColumnCore tc = allTCs[i];
                if (!tc.isVisible()) continue;
                names.add(tc.getName());
            }
            tcm.setDefaultColumnNames(TABLE_ID, names.toArray(new String[0]));
            return;
        }
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        super.skinObjectShown(skinObject, params);
        SWTSkinObject so_list = this.getSkinObject("devicesod-list");
        if (so_list != null) {
            this.initTable((Composite)so_list.getControl());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        SBC_DevicesODView sBC_DevicesODView = this;
        synchronized (sBC_DevicesODView) {
            if (this.tv_downloads != null) {
                this.tv_downloads.delete();
                this.tv_downloads = null;
            }
        }
        Utils.disposeSWTObjects(new Object[]{this.control_parent});
        return super.skinObjectHidden(skinObject, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        SBC_DevicesODView sBC_DevicesODView = this;
        synchronized (sBC_DevicesODView) {
            if (this.tv_downloads != null) {
                this.tv_downloads.delete();
                this.tv_downloads = null;
            }
        }
        Utils.disposeSWTObjects(new Object[]{this.control_parent});
        return super.skinObjectDestroyed(skinObject, params);
    }

    private void initTable(final Composite control) {
        this.control_parent = new Composite(control, 0);
        Utils.setLayoutData((Control)this.control_parent, Utils.getFilledFormData());
        final StackLayout stack_layout = new StackLayout();
        this.control_parent.setLayout(stack_layout);
        final Composite enabled_device_parent = new Composite(this.control_parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        enabled_device_parent.setLayout(layout);
        this.tv_downloads = TableViewFactory.createTableViewSWT(DeviceOfflineDownload.class, TABLE_ID, TABLE_ID, new TableColumnCore[0], "od_name", 0x10010002);
        this.tv_downloads.setRowDefaultHeightEM(3.0f);
        this.tv_downloads.setHeaderVisible(true);
        this.tv_downloads.addSelectionListener(new TableSelectionListener(){

            @Override
            public void selected(TableRowCore[] row) {
                this.refreshIconBar();
            }

            @Override
            public void mouseExit(TableRowCore row) {
            }

            @Override
            public void mouseEnter(TableRowCore row) {
            }

            @Override
            public void focusChanged(TableRowCore focus) {
                this.refreshIconBar();
            }

            @Override
            public void deselected(TableRowCore[] rows) {
                this.refreshIconBar();
            }

            @Override
            public void defaultSelected(TableRowCore[] rows, int stateMask) {
                this.refreshIconBar();
            }

            protected void refreshIconBar() {
                SelectedContentManager.clearCurrentlySelectedContent();
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.refreshIconBar();
                }
            }
        }, false);
        this.tv_downloads.addLifeCycleListener(new TableLifeCycleListener(){
            private final TableViewSWT<DeviceOfflineDownload> f_table;
            private Set<DeviceOfflineDownload> download_set;
            private boolean destroyed;
            private DeviceOfflineDownloaderListener od_listener;
            {
                this.f_table = SBC_DevicesODView.this.tv_downloads;
                this.download_set = new HashSet<DeviceOfflineDownload>();
                this.od_listener = new DeviceOfflineDownloaderListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void downloadAdded(final DeviceOfflineDownload download) {
                        Set set = download_set;
                        synchronized (set) {
                            if (destroyed) {
                                return;
                            }
                            if (download_set.contains(download)) {
                                return;
                            }
                            download_set.add(download);
                        }
                        Utils.execSWTThread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (SBC_DevicesODView.this.tv_downloads == f_table && !f_table.isDisposed()) {
                                    Set set = download_set;
                                    synchronized (set) {
                                        if (destroyed) {
                                            return;
                                        }
                                    }
                                    f_table.addDataSources(new DeviceOfflineDownload[]{download});
                                }
                            }
                        });
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void downloadChanged(final DeviceOfflineDownload download) {
                        Set set = download_set;
                        synchronized (set) {
                            if (destroyed) {
                                return;
                            }
                            if (!download_set.contains(download)) {
                                return;
                            }
                        }
                        Utils.execSWTThread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (SBC_DevicesODView.this.tv_downloads == f_table && !f_table.isDisposed()) {
                                    Set set = download_set;
                                    synchronized (set) {
                                        if (destroyed) {
                                            return;
                                        }
                                    }
                                    TableRowCore row = f_table.getRow(download);
                                    if (row != null) {
                                        row.refresh(true);
                                    }
                                }
                            }
                        });
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void downloadRemoved(final DeviceOfflineDownload download) {
                        Set set = download_set;
                        synchronized (set) {
                            if (destroyed) {
                                return;
                            }
                            if (!download_set.remove(download)) {
                                return;
                            }
                        }
                        Utils.execSWTThread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (SBC_DevicesODView.this.tv_downloads == f_table && !f_table.isDisposed()) {
                                    Set set = download_set;
                                    synchronized (set) {
                                        if (destroyed) {
                                            return;
                                        }
                                    }
                                    f_table.removeDataSources(new DeviceOfflineDownload[]{download});
                                }
                            }
                        });
                    }
                };
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tableViewInitialized() {
                SBC_DevicesODView.this.device.addListener(this.od_listener);
                DeviceOfflineDownload[] downloads = SBC_DevicesODView.this.device.getDownloads();
                final ArrayList<DeviceOfflineDownload> new_downloads = new ArrayList<DeviceOfflineDownload>(downloads.length);
                Set<DeviceOfflineDownload> set = this.download_set;
                synchronized (set) {
                    if (this.destroyed) {
                        return;
                    }
                    for (DeviceOfflineDownload download : downloads) {
                        if (this.download_set.contains(download)) continue;
                        this.download_set.add(download);
                        new_downloads.add(download);
                    }
                }
                if (new_downloads.size() > 0) {
                    Utils.execSWTThread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (SBC_DevicesODView.this.tv_downloads == f_table && !f_table.isDisposed()) {
                                Set set = download_set;
                                synchronized (set) {
                                    if (destroyed) {
                                        return;
                                    }
                                }
                                f_table.addDataSources(new_downloads.toArray(new DeviceOfflineDownload[new_downloads.size()]));
                            }
                        }
                    });
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tableViewDestroyed() {
                SBC_DevicesODView.this.device.removeListener(this.od_listener);
                Set<DeviceOfflineDownload> set = this.download_set;
                synchronized (set) {
                    this.destroyed = true;
                    this.download_set.clear();
                }
            }
        });
        this.tv_downloads.initialize(enabled_device_parent);
        final Composite disabled_device_parent = new Composite(this.control_parent, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        disabled_device_parent.setLayout(layout);
        Label l = new Label(disabled_device_parent, 0);
        GridData grid_data = new GridData(768);
        grid_data.horizontalIndent = 5;
        Utils.setLayoutData((Control)l, grid_data);
        l.setText(MessageText.getString("device.is.disabled"));
        this.device.addListener(new DeviceListener(){

            @Override
            public void deviceChanged(Device d) {
                Composite x;
                Composite composite = x = SBC_DevicesODView.this.device.isEnabled() ? enabled_device_parent : disabled_device_parent;
                if (x.isDisposed()) {
                    SBC_DevicesODView.this.device.removeListener(this);
                } else if (x != stack_layout.topControl) {
                    Utils.execSWTThread(new Runnable(){

                        @Override
                        public void run() {
                            Composite x;
                            Composite composite = x = SBC_DevicesODView.this.device.isEnabled() ? enabled_device_parent : disabled_device_parent;
                            if (!x.isDisposed() && x != stack_layout.topControl) {
                                stack_layout.topControl = x;
                                control.layout(true, true);
                            }
                        }
                    });
                }
            }
        });
        stack_layout.topControl = this.device.isEnabled() ? enabled_device_parent : disabled_device_parent;
        control.layout(true);
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        long stateRemove = 0L;
        if (this.tv_downloads != null && this.tv_downloads.getSelectedRowsSize() > 0) {
            stateRemove = 1L;
        }
        list.put("remove", stateRemove);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        if (item.getID().equals("remove")) {
            MessageBoxShell mb = new MessageBoxShell(MessageText.getString("message.confirm.delete.title"), MessageText.getString("message.confirm.delete.text", new String[]{this.device.getName()}), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
            mb.open(new UserPrompterResultListener(){

                @Override
                public void prompterClosed(int result) {
                    if (result == 0) {
                        SBC_DevicesODView.this.device.remove();
                    }
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public String getUpdateUIName() {
        return "DevicesODView";
    }

    @Override
    public void updateUI() {
        if (this.tv_downloads != null) {
            this.tv_downloads.refreshTable(false);
        }
    }
}

