/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices;

import com.aelitis.azureus.core.devices.DeviceTemplate;
import com.aelitis.azureus.ui.swt.devices.DeviceManagerUI;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class DevicesWizard {
    private DeviceManagerUI device_manager_ui;
    private Display display;
    private Shell shell;
    private Label title;
    private Font boldFont;
    private Font titleFont;
    private Font subTitleFont;
    private Font textInputFont;
    private Composite main;
    private ImageLoader imageLoader;

    public DevicesWizard(DeviceManagerUI dm_ui) {
        this.device_manager_ui = dm_ui;
        this.imageLoader = ImageLoader.getInstance();
        this.shell = ShellFactory.createMainShell(113);
        this.shell.setSize(650, 400);
        Utils.centreWindow(this.shell);
        this.shell.setMinimumSize(550, 400);
        this.display = this.shell.getDisplay();
        Utils.setShellIcon(this.shell);
        this.createFonts();
        this.shell.setText(MessageText.getString("wizard.device.title"));
        this.shell.addListener(12, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                DevicesWizard.this.imageLoader.releaseImage("wizard_header_bg");
                if (DevicesWizard.this.titleFont != null && !DevicesWizard.this.titleFont.isDisposed()) {
                    DevicesWizard.this.titleFont.dispose();
                }
                if (DevicesWizard.this.textInputFont != null && !DevicesWizard.this.textInputFont.isDisposed()) {
                    DevicesWizard.this.textInputFont.dispose();
                }
                if (DevicesWizard.this.boldFont != null && !DevicesWizard.this.boldFont.isDisposed()) {
                    DevicesWizard.this.boldFont.dispose();
                }
                if (DevicesWizard.this.subTitleFont != null && !DevicesWizard.this.subTitleFont.isDisposed()) {
                    DevicesWizard.this.subTitleFont.dispose();
                }
            }
        });
        Composite header = new Composite(this.shell, 0);
        header.setBackgroundMode(1);
        header.setBackgroundImage(this.imageLoader.getImage("wizard_header_bg"));
        Label topSeparator = new Label(this.shell, 258);
        this.main = new Composite(this.shell, 0);
        Label bottomSeparator = new Label(this.shell, 258);
        Composite footer = new Composite(this.shell, 0);
        FormLayout layout = new FormLayout();
        this.shell.setLayout(layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        header.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(header, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        topSeparator.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(topSeparator, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(bottomSeparator, 0);
        this.main.setLayoutData(data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(footer, 0);
        bottomSeparator.setLayoutData(data);
        data = new FormData();
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        footer.setLayoutData(data);
        this.populateHeader(header);
        this.populateFooter(footer);
        this.shell.layout();
        this.shell.open();
    }

    private void populateHeader(Composite header) {
        header.setBackground(this.display.getSystemColor(1));
        this.title = new Label(header, 64);
        this.title.setFont(this.titleFont);
        this.title.setText(MessageText.getString("device.wizard.header"));
        FillLayout layout = new FillLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        header.setLayout(layout);
    }

    private void createFonts() {
        int i;
        FontData[] fDatas = this.shell.getFont().getFontData();
        for (i = 0; i < fDatas.length; ++i) {
            fDatas[i].setStyle(1);
        }
        this.boldFont = new Font((Device)this.display, fDatas);
        for (i = 0; i < fDatas.length; ++i) {
            if (Constants.isOSX) {
                fDatas[i].setHeight(12);
                continue;
            }
            fDatas[i].setHeight(10);
        }
        this.subTitleFont = new Font((Device)this.display, fDatas);
        for (i = 0; i < fDatas.length; ++i) {
            if (Constants.isOSX) {
                fDatas[i].setHeight(17);
                continue;
            }
            fDatas[i].setHeight(14);
        }
        this.titleFont = new Font((Device)this.display, fDatas);
        for (i = 0; i < fDatas.length; ++i) {
            if (Constants.isOSX) {
                fDatas[i].setHeight(14);
            } else {
                fDatas[i].setHeight(12);
            }
            fDatas[i].setStyle(0);
        }
        this.textInputFont = new Font((Device)this.display, fDatas);
    }

    private void populateFooter(Composite footer) {
        Button cancelButton = new Button(footer, 8);
        cancelButton.setText(MessageText.getString("Button.cancel"));
        Button createButton = new Button(footer, 8);
        createButton.setText(MessageText.getString("device.wizard.create"));
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.spacing = 5;
        footer.setLayout(layout);
        FormData data = new FormData();
        data.right = new FormAttachment(100);
        data.width = 100;
        cancelButton.setLayoutData(data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.width = 175;
        createButton.setLayoutData(data);
        createButton.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event arg0) {
                try {
                    DeviceTemplate[] templates;
                    for (DeviceTemplate template : templates = DevicesWizard.this.device_manager_ui.getDeviceManager().getDeviceTemplates(3)) {
                        if (template.isAuto()) continue;
                        com.aelitis.azureus.core.devices.Device device = template.createInstance(template.getName() + " test!");
                        device.requestAttention();
                        break;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        });
        cancelButton.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event arg0) {
                DevicesWizard.this.shell.close();
            }
        });
    }

    public static void main(String[] args) {
        DevicesWizard sw = new DevicesWizard(null);
        while (!sw.shell.isDisposed()) {
            if (sw.display.readAndDispatch()) continue;
            sw.display.sleep();
        }
        sw.display.dispose();
    }
}

