/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceManagerFactory;
import com.aelitis.azureus.core.messenger.config.PlatformDevicesMessenger;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.browser.listener.ConfigListener;
import com.aelitis.azureus.ui.swt.browser.listener.DisplayListener;
import com.aelitis.azureus.ui.swt.browser.listener.TorrentListener;
import com.aelitis.azureus.ui.swt.browser.listener.VuzeListener;
import com.aelitis.azureus.util.ConstantsVuze;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstallationListener;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.ui.swt.BrowserWrapper;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;

public class DevicesFTUX {
    private static final String URL_LEARN_MORE = "/devices/qos.start";
    private static final String URL_DEVICES_INFO = "/devices/turnon.start";
    public static DevicesFTUX instance;
    Shell shell;
    private BrowserWrapper browser;
    private Button checkITunes;
    private Button btnInstall;
    private Button btnCancel;
    private Composite install_area;
    private Button checkQOS;
    private Composite install_area_parent;
    private List<Runnable> to_fire_on_complete = new ArrayList<Runnable>();

    private boolean isDisposed() {
        return this.shell.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFocus(Runnable fire_on_install) {
        List<Runnable> list = this.to_fire_on_complete;
        synchronized (list) {
            this.to_fire_on_complete.add(fire_on_install);
        }
        this.shell.forceActive();
        this.shell.forceFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(Runnable fire_on_install) {
        List<Runnable> list = this.to_fire_on_complete;
        synchronized (list) {
            this.to_fire_on_complete.add(fire_on_install);
        }
        this.shell = ShellFactory.createMainShell(2144);
        this.shell.setText(MessageText.getString("devices.turnon.title"));
        Utils.setShellIcon(this.shell);
        try {
            this.browser = Utils.createSafeBrowser(this.shell, 0);
            if (this.browser != null) {
                BrowserContext context2 = new BrowserContext("DevicesFTUX", this.browser, null, true);
                context2.addMessageListener(new TorrentListener());
                context2.addMessageListener(new VuzeListener());
                context2.addMessageListener(new DisplayListener(this.browser));
                context2.addMessageListener(new ConfigListener(this.browser));
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        Label lblInfo = new Label(this.shell, 64);
        Messages.setLanguageText(lblInfo, "devices.turnon.prepageload");
        this.checkITunes = new Button(this.shell, 32);
        this.checkITunes.setSelection(true);
        Messages.setLanguageText(this.checkITunes, "devices.turnon.itunes");
        PluginInterface itunes_plugin = null;
        try {
            itunes_plugin = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azitunes", true);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (itunes_plugin != null && itunes_plugin.getPluginState().isOperational()) {
            this.checkITunes.setVisible(false);
        }
        this.checkQOS = new Button(this.shell, 32);
        this.checkQOS.setSelection(true);
        Messages.setLanguageText(this.checkQOS, "devices.turnon.qos");
        Link lblLearnMore = new Link(this.shell, 0);
        lblLearnMore.setText("<A HREF=\"/devices/qos.start\">" + MessageText.getString("label.learnmore") + "</A>");
        lblLearnMore.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                String url = ConstantsVuze.getDefaultContentNetwork().getExternalSiteRelativeURL(e.text, true);
                Utils.launch(url);
            }
        });
        this.btnInstall = new Button(this.shell, 0);
        Messages.setLanguageText(this.btnInstall, "Button.turnon");
        this.btnInstall.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                boolean sendQOS = DevicesFTUX.this.checkQOS.getSelection();
                DevicesFTUX.this.doInstall(DevicesFTUX.this.checkITunes.getSelection(), sendQOS);
            }
        });
        this.shell.setDefaultButton(this.btnInstall);
        this.btnCancel = new Button(this.shell, 0);
        Messages.setLanguageText(this.btnCancel, "Button.cancel");
        this.btnCancel.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event2) {
                DevicesFTUX.this.shell.dispose();
            }
        });
        this.shell.addTraverseListener(new TraverseListener(){

            @Override
            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    DevicesFTUX.this.shell.dispose();
                }
            }
        });
        this.install_area_parent = new Composite(this.shell, 0);
        this.install_area_parent.setLayout(new FormLayout());
        this.install_area_parent.setVisible(false);
        this.install_area = new Composite(this.install_area_parent, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        this.shell.setLayout(formLayout);
        FormData fd = Utils.getFilledFormData();
        fd.bottom = new FormAttachment(this.checkITunes, -5);
        fd.top = new FormAttachment(0, 8);
        fd.left = new FormAttachment(0, 8);
        fd.right = new FormAttachment(100, -8);
        lblInfo.setLayoutData(fd);
        fd = Utils.getFilledFormData();
        fd.bottom = new FormAttachment(this.checkITunes, -5);
        fd.width = 550;
        fd.height = 490;
        this.browser.setLayoutData(fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -10);
        fd.right = new FormAttachment(100, -10);
        this.btnCancel.setLayoutData(fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -10);
        fd.right = new FormAttachment(this.btnCancel, -12);
        this.btnInstall.setLayoutData(fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(this.checkQOS, -3);
        fd.left = new FormAttachment(0, 10);
        fd.right = new FormAttachment(this.btnInstall, -12);
        this.checkITunes.setLayoutData(fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -5);
        fd.left = new FormAttachment(0, 10);
        this.checkQOS.setLayoutData(fd);
        fd = new FormData();
        fd.top = new FormAttachment(this.checkQOS, 0, 0x1000000);
        fd.left = new FormAttachment(this.checkQOS, 5);
        lblLearnMore.setLayoutData(fd);
        fd = new FormData();
        fd.top = new FormAttachment(this.browser.getControl(), 0);
        fd.bottom = new FormAttachment(100, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.install_area_parent.setLayoutData(fd);
        fd = new FormData();
        fd.height = this.btnInstall.computeSize((int)-1, (int)-1).y;
        fd.bottom = new FormAttachment(100, -5);
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -12);
        this.install_area.setLayoutData(fd);
        String url = ConstantsVuze.getDefaultContentNetwork().getSiteRelativeURL(URL_DEVICES_INFO, true);
        this.browser.setUrl(url);
        this.shell.pack();
        Utils.centreWindow(this.shell);
        this.btnInstall.setFocus();
        this.shell.open();
    }

    protected void doInstall(final boolean itunes, final boolean sendQOS) {
        CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                DevicesFTUX.this._doInstall(core, itunes, sendQOS);
            }
        });
    }

    protected void _doInstall(AzureusCore core, boolean itunes, boolean sendQOS) {
        DevicesFTUX.qosTurnOn(sendQOS, itunes, false);
        ArrayList<StandardPlugin> plugins = new ArrayList<StandardPlugin>(2);
        PluginInstaller installer = core.getPluginManager().getPluginInstaller();
        StandardPlugin vuze_plugin = null;
        try {
            vuze_plugin = installer.getStandardPlugin("vuzexcode");
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (vuze_plugin != null && !vuze_plugin.isAlreadyInstalled()) {
            plugins.add(vuze_plugin);
        }
        if (itunes) {
            StandardPlugin itunes_plugin = null;
            try {
                itunes_plugin = installer.getStandardPlugin("azitunes");
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (itunes_plugin != null && !itunes_plugin.isAlreadyInstalled()) {
                plugins.add(itunes_plugin);
            }
        }
        if (plugins.size() == 0) {
            this.close();
            return;
        }
        InstallablePlugin[] installablePlugins = plugins.toArray(new InstallablePlugin[0]);
        try {
            this.install_area_parent.setVisible(true);
            this.install_area_parent.moveAbove(null);
            HashMap<Integer, Object> properties = new HashMap<Integer, Object>();
            properties.put(1, 2);
            properties.put(2, this.install_area);
            properties.put(3, true);
            installer.install(installablePlugins, false, properties, new PluginInstallationListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void completed() {
                    ArrayList to_fire;
                    MdiEntryVitalityImage[] vitalityImages;
                    DevicesFTUX.this.close();
                    MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                    MdiEntry entry = mdi.getEntry("header.devices");
                    for (MdiEntryVitalityImage vi : vitalityImages = entry.getVitalityImages()) {
                        if (!vi.getImageID().contains("turnon")) continue;
                        vi.setVisible(false);
                    }
                    List len$ = DevicesFTUX.this.to_fire_on_complete;
                    synchronized (len$) {
                        to_fire = new ArrayList(DevicesFTUX.this.to_fire_on_complete);
                        DevicesFTUX.this.to_fire_on_complete.clear();
                    }
                    for (Runnable r : to_fire) {
                        if (r == null) continue;
                        try {
                            Utils.execSWTThread(r);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }

                @Override
                public void cancelled() {
                    DevicesFTUX.this.close();
                }

                @Override
                public void failed(PluginException e) {
                    Debug.out(e);
                    DevicesFTUX.this.close();
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    private static void qosTurnOn(boolean on, boolean itunes, boolean isBugFix) {
        COConfigurationManager.setParameter("devices.sendQOS", on);
        if (!on) {
            return;
        }
        try {
            PlatformDevicesMessenger.qosTurnOn(itunes, isBugFix);
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        try {
            Device[] devices;
            DeviceManager device_manager = DeviceManagerFactory.getSingleton();
            for (Device device : devices = device_manager.getDevices()) {
                try {
                    PlatformDevicesMessenger.qosFoundDevice(device);
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void close() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (DevicesFTUX.this.shell != null && !DevicesFTUX.this.shell.isDisposed()) {
                    DevicesFTUX.this.shell.dispose();
                }
            }
        });
    }

    public static boolean ensureInstalled(final Runnable fire_on_install) {
        DeviceManager device_manager = DeviceManagerFactory.getSingleton();
        if (device_manager.getTranscodeManager().getProviders().length == 0) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    if (instance == null || instance.isDisposed()) {
                        instance = new DevicesFTUX();
                        instance.open(fire_on_install);
                    } else {
                        instance.setFocus(fire_on_install);
                    }
                }
            });
            return false;
        }
        return true;
    }

    public static void showForDebug() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (instance == null || instance.isDisposed()) {
                    instance = new DevicesFTUX();
                    instance.open(null);
                } else {
                    instance.setFocus(null);
                }
            }
        });
    }

    public static void alreadyInstalledFixup() {
        if (!COConfigurationManager.hasParameter("devices.sendQOS", true)) {
            PluginInterface itunes_plugin = null;
            try {
                itunes_plugin = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azitunes", true);
            }
            catch (Throwable e) {
                // empty catch block
            }
            boolean hasItunes = itunes_plugin != null && itunes_plugin.getPluginState().isOperational();
            DevicesFTUX.qosTurnOn(true, hasItunes, true);
            return;
        }
    }
}

