/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.vuzeactivity;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;

public class ColumnActivityType
extends CoreTableColumnSWT
implements TableCellSWTPaintListener,
TableCellRefreshListener {
    public static final String COLUMN_ID = "activityType";
    private static int WIDTH = 42;
    private static SimpleDateFormat timeFormat = new SimpleDateFormat("h:mm:ss a, EEEE, MMMM d, yyyy");

    public ColumnActivityType(String tableID) {
        super(COLUMN_ID, tableID);
        this.initializeAsGraphic(WIDTH);
    }

    @Override
    public void cellPaint(GC gc, final TableCellSWT cell) {
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)cell.getDataSource();
        Image imgIcon = null;
        String iconID = entry.getIconID();
        if (iconID != null) {
            ImageLoader imageLoader = ImageLoader.getInstance();
            if (iconID.startsWith("http")) {
                imgIcon = imageLoader.getUrlImage(iconID, new ImageLoader.ImageDownloaderListener(){

                    @Override
                    public void imageDownloaded(Image image, boolean returnedImmediately) {
                        if (returnedImmediately) {
                            return;
                        }
                        cell.invalidate();
                    }
                });
                if (imgIcon == null) {
                    return;
                }
            } else {
                imgIcon = imageLoader.getImage(iconID);
            }
            if (ImageLoader.isRealImage(imgIcon)) {
                Rectangle cellBounds = cell.getBounds();
                Rectangle imgBounds = imgIcon.getBounds();
                gc.drawImage(imgIcon, cellBounds.x + (cellBounds.width - imgBounds.width) / 2, cellBounds.y + (cellBounds.height - imgBounds.height) / 2);
            }
            imageLoader.releaseImage(iconID);
        }
    }

    @Override
    public void refresh(TableCell cell) {
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)cell.getDataSource();
        String sort = entry.getTypeID() + entry.getIconID();
        if (cell.setSortValue((Comparable)((Object)sort)) || !cell.isValid()) {
            String ts = timeFormat.format(new Date(entry.getTimestamp()));
            cell.setToolTip("Activity occurred on " + ts);
        }
    }
}

