/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.vuzeactivity;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.util.PlayUtils;
import com.aelitis.azureus.util.StringCompareUtils;
import com.aelitis.azureus.util.UrlFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseMoveListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;

public class ColumnActivityActions
extends CoreTableColumnSWT
implements TableCellSWTPaintListener,
TableCellRefreshListener,
TableCellMouseMoveListener,
TableCellAddedListener {
    public static final String COLUMN_ID = "activityActions";
    private Color colorLinkNormal;
    private Color colorLinkHover;
    private static Font font = null;
    boolean bMouseDowned = false;

    public ColumnActivityActions(String tableID) {
        super(COLUMN_ID, tableID);
        this.initializeAsGraphic(150);
        SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
        this.colorLinkNormal = skinProperties.getColor("color.links.normal");
        this.colorLinkHover = skinProperties.getColor("color.links.hover");
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)cell.getDataSource();
        if (entry == null) {
            return;
        }
        TableRow row = cell.getTableRow();
        if (row == null) {
            return;
        }
        String text = (String)row.getData("text");
        if (text != null && text.length() > 0) {
            if (font == null) {
                FontData[] fontData = gc.getFont().getFontData();
                fontData[0].setStyle(1);
                font = new Font(gc.getDevice(), fontData);
            }
            gc.setFont(font);
            Rectangle bounds = this.getDrawBounds(cell);
            GCStringPrinter sp = new GCStringPrinter(gc, text, bounds, true, true, 0x1000040);
            sp.calculateMetrics();
            if (sp.hasHitUrl()) {
                GCStringPrinter.URLInfo[] hitUrlInfo = sp.getHitUrlInfo();
                for (int i = 0; i < hitUrlInfo.length; ++i) {
                    GCStringPrinter.URLInfo info = hitUrlInfo[i];
                    info.urlUnderline = cell.getTableRow() == null || cell.getTableRow().isSelected();
                    info.urlColor = info.urlUnderline ? null : this.colorLinkNormal;
                }
                int[] mouseOfs = cell.getMouseOffset();
                if (mouseOfs != null) {
                    Rectangle realBounds = cell.getBounds();
                    GCStringPrinter.URLInfo hitUrl = sp.getHitUrl(mouseOfs[0] + realBounds.x, mouseOfs[1] + realBounds.y);
                    if (hitUrl != null) {
                        hitUrl.urlColor = this.colorLinkHover;
                    }
                }
            }
            sp.printString();
        }
    }

    @Override
    public void cellAdded(TableCell cell) {
        cell.setMarginHeight(0);
    }

    @Override
    public void refresh(TableCell cell) {
        boolean canRun;
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)cell.getDataSource();
        if (entry == null) {
            return;
        }
        String[] actions = entry.getActions();
        String sort_value = "";
        for (String action : actions) {
            sort_value = sort_value + "," + action;
        }
        if (sort_value.isEmpty()) {
            sort_value = entry.getTypeID();
        }
        if (!cell.setSortValue((Comparable)((Object)sort_value)) && cell.isValid()) {
            return;
        }
        DownloadManager dm = entry.getDownloadManger();
        boolean canPlay = PlayUtils.canPlayDS(entry, -1, false);
        boolean canDL = dm == null && entry.getDownloadManger() == null && (entry.getTorrent() != null || entry.getAssetHash() != null);
        boolean bl = canRun = !canPlay && dm != null;
        if (canRun && dm != null && !dm.getAssumedComplete()) {
            canRun = false;
        }
        StringBuilder sb = new StringBuilder();
        if (canDL) {
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            sb.append("<A HREF=\"download\">Download</A>");
        }
        if (canPlay) {
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            sb.append("<A HREF=\"play\">Play</A>");
        }
        if (canRun) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("<A HREF=\"launch\">Launch</A>");
        }
        for (String action : actions) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("<A HREF=\"action:").append(action).append("\">").append(action).append("</A>");
        }
        cell.getTableRow().setData("text", sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        String oldTooltip;
        Object o;
        VuzeActivitiesEntry entry = (VuzeActivitiesEntry)event2.cell.getDataSource();
        String tooltip = null;
        boolean invalidateAndRefresh = false;
        Rectangle bounds = ((TableCellSWT)event2.cell).getBounds();
        String text = (String)event2.cell.getTableRow().getData("text");
        if (text == null) {
            return;
        }
        GCStringPrinter sp = null;
        GC gc = new GC((Drawable)Display.getDefault());
        try {
            if (font != null) {
                gc.setFont(font);
            }
            Rectangle drawBounds = this.getDrawBounds((TableCellSWT)event2.cell);
            sp = new GCStringPrinter(gc, text, drawBounds, true, true, 0x1000040);
            sp.calculateMetrics();
        }
        catch (Exception e) {
            Debug.out(e);
        }
        finally {
            gc.dispose();
        }
        if (sp != null) {
            int newCursor;
            GCStringPrinter.URLInfo hitUrl = sp.getHitUrl(event2.x + bounds.x, event2.y + bounds.y);
            if (hitUrl != null) {
                Object ds;
                if (event2.eventType == 1) {
                    String referal;
                    if (hitUrl.url.equals("download")) {
                        referal = null;
                        Object ds2 = event2.cell.getDataSource();
                        if (ds2 instanceof VuzeActivitiesEntry) {
                            referal = "dashboardactivity-" + ((VuzeActivitiesEntry)ds2).getTypeID();
                        }
                        TorrentListViewsUtils.downloadDataSource(ds2, false, referal);
                    } else if (hitUrl.url.equals("play")) {
                        referal = null;
                        Object ds3 = event2.cell.getDataSource();
                        if (ds3 instanceof VuzeActivitiesEntry) {
                            referal = "playdashboardactivity-" + ((VuzeActivitiesEntry)ds3).getTypeID();
                        }
                        TorrentListViewsUtils.playOrStreamDataSource(ds3, referal, false, true);
                    } else if (hitUrl.url.equals("launch")) {
                        ds = event2.cell.getDataSource();
                        TorrentListViewsUtils.playOrStreamDataSource(ds, "launch", false, true);
                    } else if (hitUrl.url.startsWith("action:")) {
                        entry.invokeCallback(hitUrl.url.substring(7));
                    } else if (!UrlFilter.getInstance().urlCanRPC(hitUrl.url)) {
                        Utils.launch(hitUrl.url);
                    } else {
                        UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
                        if (uif != null) {
                            String target = hitUrl.target;
                            if (target == null) {
                                target = "browse";
                            }
                            uif.viewURL(hitUrl.url, target, "column.activity.action");
                            return;
                        }
                    }
                }
                ds = event2.cell.getDataSource();
                newCursor = 21;
                tooltip = UrlFilter.getInstance().urlCanRPC(hitUrl.url) ? hitUrl.title : hitUrl.url;
            } else {
                newCursor = 0;
            }
            int oldCursor = ((TableCellSWT)event2.cell).getCursorID();
            if (oldCursor != newCursor) {
                invalidateAndRefresh = true;
                ((TableCellSWT)event2.cell).setCursorID(newCursor);
            }
        }
        if (((o = event2.cell.getToolTip()) == null || o instanceof String) && !StringCompareUtils.equals(oldTooltip = (String)o, tooltip)) {
            invalidateAndRefresh = true;
            event2.cell.setToolTip(tooltip);
        }
        if (invalidateAndRefresh) {
            event2.cell.invalidate();
            ((TableCellSWT)event2.cell).redraw();
        }
    }

    private Rectangle getDrawBounds(TableCellSWT cell) {
        Rectangle bounds = cell.getBounds();
        bounds.height -= 12;
        bounds.y += 6;
        bounds.x += 4;
        bounds.width -= 4;
        return bounds;
    }
}

