/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefresher;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class ColumnUnopened
extends CoreTableColumnSWT
implements TableCellAddedListener,
TableCellRefreshListener,
TableCellMouseListener {
    public static final Class<?> DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "unopened";
    private static UISWTGraphicImpl graphicCheck;
    private static UISWTGraphicImpl graphicUnCheck;
    private static UISWTGraphicImpl[] graphicsProgress;
    private static int WIDTH;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content", "essential"});
        info.setProficiency((byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnUnopened(String tableID) {
        super(COLUMN_ID, tableID);
        Class<ColumnUnopened> clazz = ColumnUnopened.class;
        synchronized (ColumnUnopened.class) {
            Image img;
            if (graphicCheck == null) {
                img = ImageLoader.getInstance().getImage("image.unopened");
                graphicCheck = new UISWTGraphicImpl(img);
            }
            if (graphicUnCheck == null) {
                img = ImageLoader.getInstance().getImage("image.opened");
                graphicUnCheck = new UISWTGraphicImpl(img);
            }
            if (graphicsProgress == null) {
                Image[] imgs = ImageLoader.getInstance().getImages("image.sidebar.vitality.dl");
                graphicsProgress = new UISWTGraphicImpl[imgs.length];
                for (int i = 0; i < imgs.length; ++i) {
                    ColumnUnopened.graphicsProgress[i] = new UISWTGraphicImpl(imgs[i]);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            TableContextMenuItem menuItem = this.addContextMenuItem("label.toggle.new.marker");
            menuItem.addMultiListener(new MenuItemListener(){

                @Override
                public void selected(MenuItem menu, Object target) {
                    Object[] dataSources;
                    for (Object _ds : dataSources = (Object[])target) {
                        DownloadManager dm;
                        if (_ds instanceof TableRowCore) {
                            TableRowCore row = (TableRowCore)_ds;
                            _ds = row.getDataSource(true);
                        }
                        if (!(_ds instanceof DownloadManager)) continue;
                        boolean x = PlatformTorrentUtils.getHasBeenOpened(dm = (DownloadManager)_ds);
                        PlatformTorrentUtils.setHasBeenOpened(dm, !x);
                    }
                }
            });
            this.initializeAsGraphic(WIDTH);
            return;
        }
    }

    @Override
    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
    }

    @Override
    public void refresh(TableCell cell) {
        int sortVal;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm == null) {
            return;
        }
        boolean complete = dm.getAssumedComplete();
        boolean hasBeenOpened = false;
        if (complete) {
            hasBeenOpened = PlatformTorrentUtils.getHasBeenOpened(dm);
            sortVal = hasBeenOpened ? 1 : 0;
        } else {
            int n = sortVal = this.isSortAscending() ? 2 : -1;
        }
        if (!cell.setSortValue(sortVal) && cell.isValid() && complete) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        if (complete) {
            cell.setGraphic(hasBeenOpened ? graphicUnCheck : graphicCheck);
        } else if (dm.getState() == 50) {
            int i = TableCellRefresher.getRefreshIndex(1, graphicsProgress.length);
            cell.setGraphic(graphicsProgress[i]);
            TableCellRefresher.addCell(this, cell);
        } else {
            cell.setGraphic(null);
        }
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        if (event2.eventType == 1 && event2.button == 1) {
            DownloadManager dm = (DownloadManager)event2.cell.getDataSource();
            boolean complete = dm.getAssumedComplete();
            if (!complete) {
                return;
            }
            boolean hasBeenOpened = !PlatformTorrentUtils.getHasBeenOpened(dm);
            PlatformTorrentUtils.setHasBeenOpened(dm, hasBeenOpened);
            event2.cell.setGraphic(hasBeenOpened ? graphicUnCheck : graphicCheck);
            event2.cell.invalidate();
        }
    }

    static {
        WIDTH = 38;
    }
}

