/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.util.PlayUtils;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;

public class ColumnStream
extends CoreTableColumnSWT
implements TableCellSWTPaintListener,
TableCellAddedListener,
TableCellRefreshListener,
TableCellMouseListener,
TableCellToolTipListener {
    public static final String COLUMN_ID = "TorrentStream";
    public static final Class[] DATASOURCE_TYPES = new Class[]{DownloadTypeIncomplete.class, DiskManagerFileInfo.class};
    private static int WIDTH = 62;
    private static Image imgGreen;
    private static Image imgDisabled;
    private static Image imgBlue;
    private static Image imgGreenSmall;
    private static Image imgDisabledSmall;
    private static Image imgBlueSmall;
    private static Object firstLock;
    private static boolean first;
    private static boolean skipPaint;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential", "content"});
        info.setProficiency((byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnStream(String tableID) {
        super(COLUMN_ID, tableID);
        this.addDataSourceTypes(DATASOURCE_TYPES);
        this.initializeAsGraphic(WIDTH);
        this.setAlignment(3);
        Class<ColumnStream> clazz = ColumnStream.class;
        synchronized (ColumnStream.class) {
            if (imgGreen == null) {
                imgGreen = ImageLoader.getInstance().getImage("column.image.play.green");
                imgDisabled = ImageLoader.getInstance().getImage("column.image.play.off");
                imgBlue = ImageLoader.getInstance().getImage("column.image.play.blue");
                imgGreenSmall = ImageLoader.getInstance().getImage("column.image.play.green.small");
                imgDisabledSmall = ImageLoader.getInstance().getImage("column.image.play.off.small");
                imgBlueSmall = ImageLoader.getInstance().getImage("column.image.play.blue.small");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void preAdd() {
        int position;
        TableColumn column;
        if (!this.isFirstLoad() || this.getPosition() >= 0 || this.getColumnAdded()) {
            return;
        }
        TableColumnManager tcManager = TableColumnManager.getInstance();
        TableColumnInfo columnInfoTAN = tcManager.getColumnInfo(null, this.getTableID(), "name");
        if (columnInfoTAN != null && (column = columnInfoTAN.getColumn()) != null && (position = column.getPosition()) >= 0) {
            this.setPosition(position + 1);
        }
    }

    private boolean noIconForYou(Object ds, TableCell cell) {
        if (!(ds instanceof DownloadManager)) {
            return false;
        }
        if (!(cell instanceof TableCellCore)) {
            return false;
        }
        DownloadManager dm = (DownloadManager)ds;
        TableRowCore rowCore = ((TableCellCore)cell).getTableRowCore();
        if (rowCore == null) {
            return false;
        }
        return dm.getNumFileInfos() > 1 && rowCore.isExpanded();
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        boolean canPlay;
        Object ds = cell.getDataSource();
        if (this.noIconForYou(ds, cell)) {
            return;
        }
        Comparable sortValue = cell.getSortValue();
        if (!(sortValue instanceof Number)) {
            return;
        }
        int sortVal = ((Number)((Object)sortValue)).intValue();
        boolean canStream = (sortVal & 2) > 0;
        boolean bl = canPlay = (sortVal & 1) > 0;
        Image img = cell.getHeight() > 18 ? (canStream ? imgBlue : (canPlay ? imgGreen : imgDisabled)) : (canStream ? imgBlueSmall : (canPlay ? imgGreenSmall : imgDisabledSmall));
        Rectangle cellBounds = cell.getBounds();
        if (img != null && !img.isDisposed()) {
            Rectangle imgBounds = img.getBounds();
            gc.drawImage(img, cellBounds.x + (cellBounds.width - imgBounds.width) / 2, cellBounds.y + (cellBounds.height - imgBounds.height) / 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cellAdded(final TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
        Object object = firstLock;
        synchronized (object) {
            if (first) {
                first = false;
                new AEThread2("WaitForMS", true){

                    @Override
                    public void run() {
                        Object ds = cell.getDataSource();
                        PlayUtils.canStreamDS(ds, -1, true);
                        skipPaint = false;
                    }
                };
            }
        }
    }

    @Override
    public void refresh(TableCell cell) {
        int sortVal;
        Object ds = cell.getDataSource();
        if (this.noIconForYou(ds, cell)) {
            sortVal = 0;
        } else {
            boolean canStream = PlayUtils.canStreamDS(ds, -1, false);
            boolean canPlay = PlayUtils.canPlayDS(ds, -1, false);
            sortVal = (canStream ? 2 : 0) + (canPlay ? 1 : 0);
        }
        if (cell.setSortValue(sortVal)) {
            cell.invalidate();
        }
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        Object ds;
        if (event2.eventType == 0 && event2.button == 1 && (PlayUtils.canStreamDS(ds = event2.cell.getDataSource(), -1, true) || PlayUtils.canPlayDS(ds, -1, true))) {
            TorrentListViewsUtils.playOrStreamDataSource(ds, "column", true, false);
        }
    }

    @Override
    public void cellHover(TableCell cell) {
        Object ds = cell.getDataSource();
        if (this.noIconForYou(ds, cell)) {
            cell.setToolTip(null);
            return;
        }
        if (PlayUtils.canStreamDS(ds, -1, false) || PlayUtils.canPlayDS(ds, -1, false)) {
            cell.setToolTip(null);
            return;
        }
        String id = "TableColumn.TorrentStream.tooltip.disabled";
        if (ds instanceof DownloadManager && ((DownloadManager)ds).getNumFileInfos() > 1) {
            id = "TableColumn.TorrentStream.tooltip.expand";
        }
        cell.setToolTip(MessageText.getString(id));
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }

    static {
        firstLock = new Object();
        first = true;
        skipPaint = true;
    }
}

