/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.tagdiscovery;

import com.aelitis.azureus.core.tag.TagDiscovery;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;

public class ColumnTagDiscoveryTorrent
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "tag.discovery.torrent";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnTagDiscoveryTorrent(TableColumn column) {
        column.setWidth(400);
        column.addListeners(this);
        TableContextMenuItem menuShowTorrent = column.addContextMenuItem("ConfigView.option.dm.dblclick.details", 2);
        menuShowTorrent.addListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                UIFunctions uiFunctions;
                if (target instanceof TagDiscovery && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
                    byte[] hash = ((TagDiscovery)target).getHash();
                    uiFunctions.getMDI().showEntryByID("DMDetails", hash);
                }
            }
        });
    }

    @Override
    public void refresh(TableCell cell) {
        TagDiscovery discovery = (TagDiscovery)cell.getDataSource();
        cell.setText(discovery.getTorrentName());
    }
}

