/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.tag;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagFeatureRateLimit;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;

public class ColumnTagUpTotal
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "tag.uptotal";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnTagUpTotal(TableColumn column) {
        column.setWidth(60);
        column.setRefreshInterval(-2);
        column.setAlignment(2);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        long[] up;
        TagFeatureRateLimit rl;
        Tag tag = (Tag)cell.getDataSource();
        if (tag instanceof TagFeatureRateLimit && (rl = (TagFeatureRateLimit)((Object)tag)).supportsTagRates() && (up = rl.getTagUploadTotal()) != null) {
            long tot = 0L;
            for (long l : up) {
                tot += l;
            }
            if (!cell.setSortValue(tot) && cell.isValid()) {
                return;
            }
            if (!cell.isShown()) {
                return;
            }
            cell.setText(DisplayFormatters.formatByteCountToKiBEtc(tot));
        }
    }
}

