/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.subscriptions;

import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionHistory;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class ColumnSubscriptionEnabled
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static String COLUMN_ID = "enabled";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"settings"});
        info.setProficiency((byte)1);
    }

    public ColumnSubscriptionEnabled(String sTableID) {
        super(COLUMN_ID, 3, -2, 100, sTableID);
        this.setRefreshInterval(-2);
        this.setMinWidth(100);
        this.setMaxWidth(100);
    }

    @Override
    public void refresh(TableCell cell) {
        boolean enabled = false;
        Subscription sub = (Subscription)cell.getDataSource();
        if (sub != null) {
            SubscriptionHistory history = sub.getHistory();
            if (history != null) {
                enabled = history.isEnabled();
            }
            if (!cell.setSortValue(enabled ? 1L : 0L) && cell.isValid()) {
                return;
            }
            if (!cell.isShown()) {
                return;
            }
            if (!sub.isSearchTemplate()) {
                cell.setText(DisplayFormatters.getYesNo(enabled));
            } else {
                if (!cell.setSortValue(-1L) && cell.isValid()) {
                    return;
                }
                cell.setText("");
            }
        } else {
            cell.setText("");
        }
    }
}

