/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.subscriptions;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.subscriptions.SBC_SubscriptionResult;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;

public class ColumnSubResultNew
implements TableCellSWTPaintListener,
TableCellAddedListener,
TableCellRefreshListener,
TableCellMouseListener {
    public static final String COLUMN_ID = "new";
    private static int WIDTH = 38;
    private static Image imgNew;
    private static Image imgOld;

    public ColumnSubResultNew(TableColumn column) {
        column.initialize(3, -2, WIDTH);
        column.addListeners(this);
        column.setRefreshInterval(-1);
        column.setType(2);
        if (column instanceof TableColumnCore) {
            ((TableColumnCore)column).addCellOtherListener("SWTPaint", this);
        }
        imgNew = ImageLoader.getInstance().getImage("image.activity.unread");
        imgOld = ImageLoader.getInstance().getImage("image.activity.read");
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        Image img;
        SBC_SubscriptionResult entry = (SBC_SubscriptionResult)cell.getDataSource();
        Rectangle cellBounds = cell.getBounds();
        Image image = img = entry == null || entry.getRead() ? imgOld : imgNew;
        if (img != null && !img.isDisposed()) {
            Rectangle imgBounds = img.getBounds();
            gc.drawImage(img, cellBounds.x + (cellBounds.width - imgBounds.width) / 2, cellBounds.y + (cellBounds.height - imgBounds.height) / 2);
        }
    }

    @Override
    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
        if (cell instanceof TableCellSWT) {
            ((TableCellSWT)cell).setCursorID(21);
        }
    }

    @Override
    public void refresh(TableCell cell) {
        boolean unread;
        long sortVal;
        SBC_SubscriptionResult entry = (SBC_SubscriptionResult)cell.getDataSource();
        if (entry != null && !cell.setSortValue(sortVal = (long)(((unread = !entry.getRead()) ? 2 : 1) << 62) + (SystemTime.getCurrentTime() - entry.getTime()) / 1000L) && cell.isValid()) {
            return;
        }
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        SBC_SubscriptionResult entry;
        if (event2.eventType == 0 && event2.button == 1 && (entry = (SBC_SubscriptionResult)event2.cell.getDataSource()) != null) {
            entry.setRead(!entry.getRead());
            event2.cell.invalidate();
        }
    }
}

