/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.searchsubs;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.swt.utils.SearchSubsResultBase;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;

public class ColumnSearchSubResultSize
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "size";

    public ColumnSearchSubResultSize(TableColumn column) {
        column.initialize(2, -2, 80);
        column.addListeners(this);
        column.setRefreshInterval(-3);
        column.setType(3);
        if (column instanceof TableColumnCore) {
            ((TableColumnCore)column).setUseCoreDataSource(true);
        }
    }

    @Override
    public void refresh(TableCell cell) {
        SearchSubsResultBase rc = (SearchSubsResultBase)cell.getDataSource();
        if (rc == null) {
            return;
        }
        long size = rc.getSize();
        if (size > 0L && cell.setSortValue(size)) {
            cell.setText(DisplayFormatters.formatByteCountToKiBEtc(size));
        }
    }
}

