/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.searchsubs;

import com.aelitis.azureus.ui.swt.utils.SearchSubsResultBase;
import com.aelitis.azureus.ui.swt.utils.SearchSubsUtils;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;

public class ColumnSearchSubResultExisting
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "in";
    private static final String[] messages = new String[5];

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)0);
    }

    public ColumnSearchSubResultExisting(TableColumn column) {
        column.initialize(3, -1, 60);
        column.setRefreshInterval(-1);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        SearchSubsResultBase result = (SearchSubsResultBase)cell.getDataSource();
        int status = SearchSubsUtils.getHashStatus(result);
        if (!cell.setSortValue(status) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(messages[status]);
    }

    static {
        COConfigurationManager.addAndFireListener(new COConfigurationListener(){

            @Override
            public void configurationSaved() {
                messages[0] = "";
                messages[1] = MessageText.getString("label.library");
                messages[2] = MessageText.getString("label.archive");
                messages[3] = MessageText.getString("label.history");
                messages[4] = "?";
            }
        });
    }
}

