/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.searchsubs;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.swt.utils.SearchSubsResultBase;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;

public class ColumnSearchSubResultAge
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "age";

    public ColumnSearchSubResultAge(TableColumn column) {
        column.initialize(3, -2, 50);
        column.addListeners(this);
        column.setRefreshInterval(-1);
        column.setType(3);
        if (column instanceof TableColumnCore) {
            ((TableColumnCore)column).setUseCoreDataSource(true);
        }
    }

    @Override
    public void refresh(TableCell cell) {
        SearchSubsResultBase rc = (SearchSubsResultBase)cell.getDataSource();
        if (rc == null) {
            return;
        }
        long time = rc.getTime();
        long age_secs = (SystemTime.getCurrentTime() - time) / 1000L;
        if (cell.setSortValue(age_secs)) {
            if (time <= 0L) {
                cell.setText("--");
            } else {
                cell.setToolTip(time <= 0L ? "--" : DisplayFormatters.formatCustomDateOnly(time));
                cell.setText(age_secs < 0L ? "--" : TimeFormatter.format3(age_secs));
            }
        }
    }
}

