/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.searchsubs;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.common.RememberedDecisionsManager;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.swt.search.SBC_SearchResult;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinCheckboxListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectCheckbox;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.subscriptions.SBC_SubscriptionResult;
import com.aelitis.azureus.ui.swt.utils.SearchSubsResultBase;
import com.aelitis.azureus.ui.swt.views.skin.VuzeMessageBox;
import com.aelitis.azureus.ui.swt.views.skin.VuzeMessageBoxListener;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.StringCompareUtils;
import com.aelitis.azureus.util.UrlFilter;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseMoveListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;

public class ColumnSearchSubResultActions
implements TableCellSWTPaintListener,
TableCellRefreshListener,
TableCellMouseMoveListener,
TableCellAddedListener {
    public static final String COLUMN_ID = "actions";
    private Color colorLinkNormal;
    private Color colorLinkHover;
    private static Font font = null;
    boolean bMouseDowned = false;

    public ColumnSearchSubResultActions(TableColumn column) {
        column.initialize(1, -2, 180);
        column.addListeners(this);
        column.setRefreshInterval(-3);
        column.setType(2);
        if (column instanceof TableColumnCore) {
            ((TableColumnCore)column).setUseCoreDataSource(true);
            ((TableColumnCore)column).addCellOtherListener("SWTPaint", this);
        }
        SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
        this.colorLinkNormal = skinProperties.getColor("color.links.normal");
        this.colorLinkHover = skinProperties.getColor("color.links.hover");
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        SearchSubsResultBase entry = (SearchSubsResultBase)cell.getDataSource();
        if (entry == null) {
            return;
        }
        TableRow row = cell.getTableRow();
        if (row == null) {
            return;
        }
        String text = (String)row.getData("text");
        if (text != null && text.length() > 0) {
            if (font == null) {
                FontData[] fontData = gc.getFont().getFontData();
                fontData[0].setStyle(1);
                font = new Font(gc.getDevice(), fontData);
            }
            gc.setFont(font);
            Rectangle bounds = this.getDrawBounds(cell);
            GCStringPrinter sp = new GCStringPrinter(gc, text, bounds, true, true, 0x1000040);
            sp.calculateMetrics();
            if (sp.hasHitUrl()) {
                GCStringPrinter.URLInfo[] hitUrlInfo = sp.getHitUrlInfo();
                for (int i = 0; i < hitUrlInfo.length; ++i) {
                    GCStringPrinter.URLInfo info = hitUrlInfo[i];
                    info.urlUnderline = cell.getTableRow() == null || cell.getTableRow().isSelected();
                    info.urlColor = info.urlUnderline ? null : this.colorLinkNormal;
                }
                int[] mouseOfs = cell.getMouseOffset();
                if (mouseOfs != null) {
                    Rectangle realBounds = cell.getBounds();
                    GCStringPrinter.URLInfo hitUrl = sp.getHitUrl(mouseOfs[0] + realBounds.x, mouseOfs[1] + realBounds.y);
                    if (hitUrl != null) {
                        hitUrl.urlColor = this.colorLinkHover;
                    }
                }
            }
            sp.printString();
        }
    }

    @Override
    public void cellAdded(TableCell cell) {
        cell.setMarginHeight(0);
    }

    @Override
    public void refresh(TableCell cell) {
        SearchSubsResultBase entry = (SearchSubsResultBase)cell.getDataSource();
        if (entry == null) {
            return;
        }
        String link = entry.getTorrentLink();
        String details = entry.getDetailsLink();
        if (!cell.setSortValue((Comparable)((Object)link)) && cell.isValid()) {
            return;
        }
        boolean canDL = link != null && link.length() > 0;
        boolean canDetails = details != null && details.length() > 0;
        StringBuilder sb = new StringBuilder();
        if (canDL) {
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            String action = link.startsWith("chat:") ? MessageText.getString("label.view") : (link.startsWith("azplug:?id=subscription") ? MessageText.getString("subscriptions.listwindow.subscribe") : MessageText.getString("label.download"));
            sb.append("<A HREF=\"download\">" + action + "</A>");
        }
        if (canDetails) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("<A HREF=\"details\">" + MessageText.getString("popup.error.details") + "</A>");
        }
        cell.getTableRow().setData("text", sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        String oldTooltip;
        Object o;
        SearchSubsResultBase entry = (SearchSubsResultBase)event2.cell.getDataSource();
        String tooltip = null;
        boolean invalidateAndRefresh = false;
        Rectangle bounds = ((TableCellSWT)event2.cell).getBounds();
        String text = (String)event2.cell.getTableRow().getData("text");
        if (text == null) {
            return;
        }
        GCStringPrinter sp = null;
        GC gc = new GC((Drawable)Display.getDefault());
        try {
            if (font != null) {
                gc.setFont(font);
            }
            Rectangle drawBounds = this.getDrawBounds((TableCellSWT)event2.cell);
            sp = new GCStringPrinter(gc, text, drawBounds, true, true, 0x1000040);
            sp.calculateMetrics();
        }
        catch (Exception e) {
            Debug.out(e);
        }
        finally {
            gc.dispose();
        }
        if (sp != null) {
            int newCursor;
            GCStringPrinter.URLInfo hitUrl = sp.getHitUrl(event2.x + bounds.x, event2.y + bounds.y);
            if (hitUrl != null) {
                if (event2.eventType == 1 && event2.button == 1) {
                    if (hitUrl.url.equals("download")) {
                        ColumnSearchSubResultActions.downloadAction(entry);
                    } else if (hitUrl.url.equals("details")) {
                        String details_url = entry.getDetailsLink();
                        try {
                            Utils.launch(new URL(details_url));
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                } else if (hitUrl.url.equals("download")) {
                    tooltip = entry.getTorrentLink();
                } else if (hitUrl.url.equals("details")) {
                    tooltip = entry.getDetailsLink();
                }
                newCursor = 21;
            } else {
                newCursor = 0;
            }
            int oldCursor = ((TableCellSWT)event2.cell).getCursorID();
            if (oldCursor != newCursor) {
                invalidateAndRefresh = true;
                ((TableCellSWT)event2.cell).setCursorID(newCursor);
            }
        }
        if (((o = event2.cell.getToolTip()) == null || o instanceof String) && !StringCompareUtils.equals(oldTooltip = (String)o, tooltip)) {
            invalidateAndRefresh = true;
            event2.cell.setToolTip(tooltip);
        }
        if (invalidateAndRefresh) {
            event2.cell.invalidate();
            ((TableCellSWT)event2.cell).redraw();
        }
    }

    private Rectangle getDrawBounds(TableCellSWT cell) {
        Rectangle bounds = cell.getBounds();
        bounds.height -= 12;
        bounds.y += 6;
        bounds.x += 4;
        bounds.width -= 4;
        return bounds;
    }

    private static void downloadAction(final SearchSubsResultBase entry) {
        String link = entry.getTorrentLink();
        if (link.startsWith("chat:")) {
            Utils.launch(link);
            return;
        }
        ColumnSearchSubResultActions.showDownloadFTUX(entry, new UserPrompterResultListener(){

            @Override
            public void prompterClosed(int result) {
                if (result == 0) {
                    String referer_str = null;
                    String torrentUrl = entry.getTorrentLink();
                    if (UrlFilter.getInstance().isWhitelisted(torrentUrl)) {
                        ContentNetwork cn = ContentNetworkManagerFactory.getSingleton().getContentNetworkForURL(torrentUrl);
                        if (cn == null) {
                            cn = ConstantsVuze.getDefaultContentNetwork();
                        }
                        torrentUrl = cn.appendURLSuffix(torrentUrl, false, true);
                    }
                    try {
                        Map headers = UrlUtils.getBrowserHeaders(referer_str);
                        if (entry instanceof SBC_SubscriptionResult) {
                            SBC_SubscriptionResult sub_entry = (SBC_SubscriptionResult)entry;
                            Subscription subs = sub_entry.getSubscription();
                            try {
                                WebEngine webEngine;
                                Engine engine = subs.getEngine();
                                if (engine != null && engine instanceof WebEngine && (webEngine = (WebEngine)engine).isNeedsAuth()) {
                                    headers.put("Cookie", webEngine.getCookies());
                                }
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                            subs.addPotentialAssociation(sub_entry.getID(), torrentUrl);
                        } else {
                            SBC_SearchResult search_entry = (SBC_SearchResult)entry;
                            Engine engine = search_entry.getEngine();
                            if (engine != null) {
                                WebEngine webEngine;
                                engine.addPotentialAssociation(torrentUrl);
                                if (engine instanceof WebEngine && (webEngine = (WebEngine)engine).isNeedsAuth()) {
                                    headers.put("Cookie", webEngine.getCookies());
                                }
                            }
                        }
                        byte[] torrent_hash = entry.getHash();
                        if (torrent_hash != null && torrent_hash != null && !torrentUrl.toLowerCase().startsWith("magnet")) {
                            String title = entry.getName();
                            String magnet = UrlUtils.getMagnetURI(torrent_hash, title, null);
                            headers.put("X-Alternative-URI-1", magnet);
                        }
                        PluginInitializer.getDefaultInterface().getDownloadManager().addDownload(new URL(torrentUrl), headers);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    protected static void showDownloadFTUX(SearchSubsResultBase entry, final UserPrompterResultListener listener) {
        if (entry instanceof SBC_SubscriptionResult) {
            listener.prompterClosed(0);
            return;
        }
        if (RememberedDecisionsManager.getRememberedDecision("searchsubs.dl.ftux") == 1) {
            listener.prompterClosed(0);
            return;
        }
        VuzeMessageBox box = new VuzeMessageBox(MessageText.getString("searchsubs.dl.ftux.title"), null, new String[]{MessageText.getString("Button.ok"), MessageText.getString("Button.cancel")}, 0);
        box.setSubTitle(MessageText.getString("searchsubs.dl.ftux.heading"));
        final boolean[] check_state = new boolean[]{true};
        box.setListener(new VuzeMessageBoxListener(){

            @Override
            public void shellReady(Shell shell, SWTSkinObjectContainer soExtra) {
                SWTSkin skin = soExtra.getSkin();
                ColumnSearchSubResultActions.addResourceBundle(skin, "com/aelitis/azureus/ui/swt/columns/searchsubs/", "skin3_dl_ftux");
                String id = "searchsubs.dlftux.shell";
                skin.createSkinObject(id, id, soExtra);
                SWTSkinObjectCheckbox cb = (SWTSkinObjectCheckbox)skin.getSkinObject("agree-checkbox");
                cb.setChecked(true);
                cb.addSelectionListener(new SWTSkinCheckboxListener(){

                    @Override
                    public void checkboxChanged(SWTSkinObjectCheckbox so, boolean checked) {
                        check_state[0] = checked;
                    }
                });
            }
        });
        box.open(new UserPrompterResultListener(){

            @Override
            public void prompterClosed(int result) {
                if (result == 0 && check_state[0]) {
                    RememberedDecisionsManager.setRemembered("searchsubs.dl.ftux", 1);
                }
                listener.prompterClosed(result);
            }
        });
    }

    private static void addResourceBundle(SWTSkin skin, String path, String name) {
        String sFile = path + name;
        ClassLoader loader = ColumnSearchSubResultActions.class.getClassLoader();
        SWTSkinProperties skinProperties = skin.getSkinProperties();
        try {
            ResourceBundle subBundle = ResourceBundle.getBundle(sFile, Locale.getDefault(), loader);
            skinProperties.addResourceBundle(subBundle, path, loader);
        }
        catch (MissingResourceException mre) {
            Debug.out(mre);
        }
    }
}

