/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.dlhistory;

import org.gudy.azureus2.core3.history.DownloadHistory;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;

public class ColumnDLHistorySize
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "size";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnDLHistorySize(TableColumn column) {
        column.setWidth(80);
        column.setAlignment(2);
        column.setRefreshInterval(-3);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        DownloadHistory dl = (DownloadHistory)cell.getDataSource();
        long size = 0L;
        if (dl != null) {
            size = dl.getSize();
        }
        if (!cell.setSortValue(size) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(size <= 0L ? "" : DisplayFormatters.formatByteCountToKiBEtc(size));
    }
}

