/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.dlhistory;

import org.gudy.azureus2.core3.history.DownloadHistory;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;

public class ColumnDLHistorySaveLocation
implements TableCellRefreshListener,
TableColumnExtraInfoListener,
ObfusticateCellText {
    public static String COLUMN_ID = "savepath";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)0);
    }

    public ColumnDLHistorySaveLocation(TableColumn column) {
        column.setWidth(600);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        DownloadHistory dl = (DownloadHistory)cell.getDataSource();
        String sl = null;
        if (dl != null) {
            sl = dl.getSaveLocation();
        }
        if (sl == null) {
            sl = "";
        }
        if (!cell.setSortValue((Comparable)((Object)sl)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(sl);
    }

    @Override
    public String getObfusticatedText(TableCell cell) {
        DownloadHistory dl = (DownloadHistory)cell.getDataSource();
        if (dl == null) {
            return "";
        }
        return Debug.secretFileName(dl.getSaveLocation());
    }
}

