/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.dlhistory;

import org.gudy.azureus2.core3.history.DownloadHistory;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;

public class ColumnDLHistoryName
implements TableCellRefreshListener,
TableColumnExtraInfoListener,
ObfusticateCellText {
    public static String COLUMN_ID = "name";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnDLHistoryName(TableColumn column) {
        column.setWidth(400);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        DownloadHistory dl = (DownloadHistory)cell.getDataSource();
        String name = null;
        if (dl != null) {
            name = dl.getName();
        }
        if (name == null) {
            name = "";
        }
        if (!cell.setSortValue((Comparable)((Object)name)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(name);
    }

    @Override
    public String getObfusticatedText(TableCell cell) {
        DownloadHistory dl = (DownloadHistory)cell.getDataSource();
        if (dl == null) {
            return "";
        }
        return ByteFormatter.encodeString(dl.getTorrentHash());
    }
}

