/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.archivedls;

import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.DownloadStub;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;

public class ColumnArchiveDLSize
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "size";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnArchiveDLSize(TableColumn column) {
        column.setWidth(70);
        column.setAlignment(2);
        column.setMinWidthAuto(true);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        DownloadStub dl = (DownloadStub)cell.getDataSource();
        long size = 0L;
        if (dl != null) {
            size = dl.getTorrentSize();
        }
        if (cell.setSortValue(size) || cell.isValid()) {
            // empty if block
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(DisplayFormatters.formatByteCountToKiBEtc(size));
        if (Utils.getUserMode() > 0 && cell instanceof TableCellSWT) {
            if (size >= 0x40000000L) {
                ((TableCellSWT)cell).setTextAlpha(456);
            } else if (size < 0x100000L) {
                ((TableCellSWT)cell).setTextAlpha(180);
            } else {
                ((TableCellSWT)cell).setTextAlpha(255);
            }
        }
    }
}

