/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;

public abstract class ColumnCheckBox
implements TableCellRefreshListener,
TableColumnExtraInfoListener,
TableCellMouseListener {
    private static final UISWTGraphic tick_icon = new UISWTGraphicImpl(ImageLoader.getInstance().getImage("check_yes"));
    private static final UISWTGraphic tick_ro_icon = new UISWTGraphicImpl(ImageLoader.getInstance().getImage("check_ro_yes"));
    private static final UISWTGraphic cross_icon = new UISWTGraphicImpl(ImageLoader.getInstance().getImage("check_no"));
    private boolean read_only;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnCheckBox(TableColumn column, int width, boolean read_only) {
        this.read_only = read_only;
        column.setWidth(width);
        column.setType(2);
        column.addListeners(this);
        if (read_only) {
            column.removeCellMouseListener(this);
        }
    }

    public ColumnCheckBox(TableColumn column) {
        this(column, 40, false);
    }

    public ColumnCheckBox(TableColumn column, int width) {
        this(column, width, false);
    }

    protected abstract Boolean getCheckBoxState(Object var1);

    protected abstract void setCheckBoxState(Object var1, boolean var2);

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        if (event2.eventType == 1) {
            Object datasource;
            Boolean state;
            TableCell cell = event2.cell;
            int event_x = event2.x;
            int event_y = event2.y;
            int cell_width = cell.getWidth();
            int cell_height = cell.getHeight();
            Rectangle icon_bounds = tick_icon.getImage().getBounds();
            int x_pad = (cell_width - icon_bounds.width) / 2;
            int y_pad = (cell_height - icon_bounds.height) / 2;
            if (event_x >= x_pad && event_x <= cell_width - x_pad && event_y >= y_pad && event_y <= cell_height - y_pad && (state = this.getCheckBoxState(datasource = cell.getDataSource())) != null) {
                this.setCheckBoxState(datasource, state == false);
                cell.invalidate();
                if (cell instanceof TableCellCore) {
                    ((TableCellCore)cell).refresh(true);
                }
            }
        }
    }

    @Override
    public void refresh(TableCell cell) {
        Object dataSource = cell.getDataSource();
        Boolean state = this.getCheckBoxState(dataSource);
        long sortVal = 0L;
        UISWTGraphic icon = null;
        if (state != null) {
            if (state.booleanValue()) {
                sortVal = 2L;
                icon = this.read_only ? tick_ro_icon : tick_icon;
            } else {
                sortVal = 1L;
                UISWTGraphic uISWTGraphic = icon = this.read_only ? null : cross_icon;
            }
        }
        if (!cell.setSortValue(sortVal = this.adjustSortVal(dataSource, sortVal)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        if (cell.getGraphic() != icon) {
            cell.setGraphic(icon);
        }
    }

    public long adjustSortVal(Object ds, long sortVal) {
        return sortVal;
    }
}

