/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.core.messenger.browser.listeners.AbstractBrowserMessageListener;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfoContentNetwork;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.browser.listener.DownloadUrlInfoSWT;
import com.aelitis.azureus.ui.swt.feature.FeatureManagerUI;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.shells.BrowserWindow;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import com.aelitis.azureus.ui.swt.views.skin.SBC_BurnFTUX;
import com.aelitis.azureus.ui.swt.views.skin.SBC_PlusFTUX;
import com.aelitis.azureus.util.ContentNetworkUtils;
import com.aelitis.azureus.util.JSONUtils;
import com.aelitis.azureus.util.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.BrowserWrapper;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.donations.DonationWindow;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;

public class DisplayListener
extends AbstractBrowserMessageListener {
    public static final String DEFAULT_LISTENER_ID = "display";
    public static final String OP_COPY_TO_CLIPBOARD = "copy-text";
    public static final String OP_OPEN_URL = "open-url";
    public static final String OP_RESET_URL = "reset-url";
    public static final String OP_SEND_EMAIL = "send-email";
    public static final String OP_IRC_SUPPORT = "irc-support";
    public static final String OP_BRING_TO_FRONT = "bring-to-front";
    public static final String OP_SWITCH_TO_TAB = "switch-to-tab";
    public static final String OP_REFRESH_TAB = "refresh-browser";
    public static final String VZ_NON_ACTIVE = "vz-non-active";
    public static final String OP_SET_SELECTED_CONTENT = "set-selected-content";
    public static final String OP_GET_SELECTED_CONTENT = "get-selected-content";
    public static final String OP_SHOW_DONATION_WINDOW = "show-donation-window";
    public static final String OP_OPEN_SEARCH = "open-search";
    public static final String OP_REGISTER = "open-register";
    private BrowserWrapper browser;

    public DisplayListener(String id, BrowserWrapper browser) {
        super(id);
        this.browser = browser;
    }

    public DisplayListener(BrowserWrapper browser) {
        this(DEFAULT_LISTENER_ID, browser);
    }

    @Override
    public void handleMessage(BrowserMessage message) {
        String opid = message.getOperationId();
        if (OP_COPY_TO_CLIPBOARD.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            this.copyToClipboard(MapUtils.getMapString(decodedMap, "text", ""));
        } else if (OP_OPEN_URL.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            String target = MapUtils.getMapString(decodedMap, "target", null);
            if ((target == null || "_blank".equals(target)) && !decodedMap.containsKey("width")) {
                this.launchUrl(MapUtils.getMapString(decodedMap, "url", null), MapUtils.getMapBoolean(decodedMap, "append-suffix", false));
            } else {
                ContentNetwork cn;
                String ref = message.getReferer();
                if (target != null && target.equals("browse") && ref != null && (cn = ContentNetworkManagerFactory.getSingleton().getContentNetworkForURL(ref)) != null) {
                    target = ContentNetworkUtils.getTarget(cn);
                    System.err.println("TARGET REWRITTEN TO " + target);
                }
                message.setCompleteDelayed(true);
                this.showBrowser(MapUtils.getMapString(decodedMap, "url", null), target, MapUtils.getMapInt(decodedMap, "width", 0), MapUtils.getMapInt(decodedMap, "height", 0), MapUtils.getMapBoolean(decodedMap, "resizable", false), message, MapUtils.getMapString(decodedMap, "source-ref", ref));
            }
        } else if (OP_RESET_URL.equals(opid)) {
            this.resetURL();
        } else if (OP_SEND_EMAIL.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            String to = MapUtils.getMapString(decodedMap, "to", "");
            String subject = MapUtils.getMapString(decodedMap, "subject", "");
            String body = MapUtils.getMapString(decodedMap, "body", null);
            this.sendEmail(to, subject, body);
        } else if (OP_IRC_SUPPORT.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            this.openIrc(null, MapUtils.getMapString(decodedMap, "channel", ""), MapUtils.getMapString(decodedMap, "user", ""));
        } else if (OP_BRING_TO_FRONT.equals(opid)) {
            this.bringToFront();
        } else if (OP_SWITCH_TO_TAB.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            DisplayListener.switchToTab(MapUtils.getMapString(decodedMap, "target", ""), MapUtils.getMapString(decodedMap, "source-ref", message.getReferer()));
        } else if (OP_REFRESH_TAB.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            DisplayListener.refreshTab(MapUtils.getMapString(decodedMap, "browser-id", ""));
        } else if (OP_SET_SELECTED_CONTENT.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            if (decodedMap != null) {
                this.setSelectedContent(message, decodedMap);
            }
        } else if (OP_GET_SELECTED_CONTENT.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            if (decodedMap != null) {
                this.getSelectedContent(message, decodedMap);
            }
        } else if (OP_SHOW_DONATION_WINDOW.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            DonationWindow.open(true, MapUtils.getMapString(decodedMap, "source-ref", "RPC"));
        } else if (OP_OPEN_SEARCH.equals(opid)) {
            Map decodedMap = message.getDecodedMap();
            UIFunctions uif = UIFunctionsManager.getUIFunctions();
            if (uif != null) {
                uif.doSearch(MapUtils.getMapString(decodedMap, "search-text", ""));
            }
        } else if (OP_REGISTER.equals(opid)) {
            FeatureManagerUI.openLicenceEntryWindow(false, null);
        } else {
            throw new IllegalArgumentException("Unknown operation: " + opid);
        }
    }

    private void getSelectedContent(BrowserMessage message, Map decodedMap) {
        String callback = MapUtils.getMapString(decodedMap, "callback", null);
        if (callback == null) {
            return;
        }
        ArrayList list = new ArrayList();
        DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
        if (dms != null) {
            for (DownloadManager dm : dms) {
                if (dm == null) continue;
                HashMap<String, String> mapDM = new HashMap<String, String>();
                TOTorrent torrent = dm.getTorrent();
                if (torrent == null || TorrentUtils.isReallyPrivate(torrent)) continue;
                try {
                    Map torrent_map = torrent.serialiseToMap();
                    TOTorrent torrent_to_send = TOTorrentFactory.deserialiseFromMap(torrent_map);
                    Map vuze_map = (Map)torrent_map.get("vuze");
                    torrent_to_send.removeAdditionalProperties();
                    torrent_map = torrent_to_send.serialiseToMap();
                    if (vuze_map != null) {
                        torrent_map.put("vuze", vuze_map);
                    }
                    byte[] encode = BEncoder.encode(torrent_map);
                    mapDM.put("name", PlatformTorrentUtils.getContentTitle2(dm));
                    mapDM.put("torrent", Base32.encode(encode));
                    list.add(mapDM);
                }
                catch (Throwable t) {
                    Debug.out(t);
                }
            }
        }
        if (list.size() > 0 && this.context != null) {
            this.context.executeInBrowser(callback + "(" + JSONUtils.encodeToJSON(list) + ")");
        }
    }

    private void setSelectedContent(BrowserMessage message, Map decodedMap) {
        String callback;
        String hash = MapUtils.getMapString(decodedMap, "torrent-hash", null);
        String displayName = MapUtils.getMapString(decodedMap, "display-name", null);
        String dlURL = MapUtils.getMapString(decodedMap, "download-url", null);
        String referer = MapUtils.getMapString(decodedMap, "referer", "displaylistener");
        if (hash == null && dlURL == null) {
            SelectedContentManager.changeCurrentlySelectedContent(referer, null);
        }
        if ((callback = MapUtils.getMapString(decodedMap, "callback", null)) != null && this.context != null) {
            DownloadUrlInfoSWT dlInfo = new DownloadUrlInfoSWT(this.context, callback, hash);
            boolean canPlay = MapUtils.getMapBoolean(decodedMap, "can-play", false);
            boolean isVuzeContent = MapUtils.getMapBoolean(decodedMap, "is-vuze-content", true);
            SelectedContentV3 content = new SelectedContentV3(hash, displayName, isVuzeContent, canPlay);
            content.setDownloadInfo(dlInfo);
            SelectedContentManager.changeCurrentlySelectedContent(referer, new ISelectedContent[]{content});
            return;
        }
        if (displayName != null && this.context != null) {
            Subscription subs;
            String dlReferer = MapUtils.getMapString(decodedMap, "download-referer", null);
            String dlCookies = MapUtils.getMapString(decodedMap, "download-cookies", null);
            HashMap<String, String> dlHeader = MapUtils.getMapMap(decodedMap, "download-header", null);
            boolean canPlay = MapUtils.getMapBoolean(decodedMap, "can-play", false);
            boolean isVuzeContent = MapUtils.getMapBoolean(decodedMap, "is-vuze-content", true);
            SelectedContentV3 content = new SelectedContentV3(hash, displayName, isVuzeContent, canPlay);
            content.setThumbURL(MapUtils.getMapString(decodedMap, "thumbnail.url", null));
            DownloadUrlInfoContentNetwork dlInfo = new DownloadUrlInfoContentNetwork(dlURL, ContentNetworkManagerFactory.getSingleton().getContentNetwork(this.context.getContentNetworkID()));
            dlInfo.setReferer(dlReferer);
            if (dlCookies != null) {
                if (dlHeader == null) {
                    dlHeader = new HashMap<String, String>();
                }
                dlHeader.put("Cookie", dlCookies);
            }
            dlInfo.setRequestProperties(dlHeader);
            String subID = MapUtils.getMapString(decodedMap, "subscription-id", null);
            String subresID = MapUtils.getMapString(decodedMap, "subscription-result-id", null);
            if (subID != null && subresID != null && (subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(subID)) != null) {
                subs.addPotentialAssociation(subresID, dlURL);
            }
            dlInfo.setAdditionalProperties(decodedMap);
            content.setDownloadInfo(dlInfo);
            SelectedContentManager.changeCurrentlySelectedContent(referer, new ISelectedContent[]{content});
        } else {
            SelectedContentManager.changeCurrentlySelectedContent(referer, null);
        }
    }

    public static void switchToTab(String tabID, String sourceRef) {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        if (sourceRef != null && ("Plus".equals(tabID) || "BurnInfo".equals(tabID))) {
            Pattern pattern = Pattern.compile("http.*//[^/]+/([^.]+)");
            Matcher matcher = pattern.matcher(sourceRef);
            String sourceRef2 = matcher.find() ? matcher.group(1) : sourceRef;
            if ("Plus".equals(tabID)) {
                SBC_PlusFTUX.setSourceRef(sourceRef2);
            } else {
                SBC_BurnFTUX.setSourceRef(sourceRef2);
            }
        }
        mdi.showEntryByID(tabID);
    }

    private void bringToFront() {
        UIFunctions functions = UIFunctionsManager.getUIFunctions();
        if (functions != null) {
            functions.bringToFront();
        }
    }

    private void resetURL() {
        if (this.browser == null || this.browser.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (DisplayListener.this.browser == null || DisplayListener.this.browser.isDisposed()) {
                    return;
                }
                String sURL = (String)DisplayListener.this.browser.getData("StartURL");
                DisplayListener.this.context.debug("reset " + sURL);
                if (sURL != null && sURL.length() > 0) {
                    String sRand = "rand=" + SystemTime.getCurrentTime();
                    String startURLUnique = sURL.indexOf("rand=") > 0 ? sURL.replaceAll("rand=[0-9.]+", sRand) : (sURL.indexOf(63) > 0 ? sURL + "&" + sRand : sURL + "?" + sRand);
                    DisplayListener.this.browser.setUrl(startURLUnique);
                }
            }
        });
    }

    public static void refreshTab(String tabID) {
        if (null == tabID || tabID.length() < 1) {
            return;
        }
        SWTSkin skin = SWTSkinFactory.getInstance();
        if (VZ_NON_ACTIVE.equals(tabID)) {
            ArrayList browserViewIDs = new ArrayList();
            Iterator iterator = browserViewIDs.iterator();
            while (iterator.hasNext()) {
                DisplayListener.refreshBrowser(iterator.next().toString());
            }
        } else {
            DisplayListener.refreshBrowser(tabID);
        }
    }

    private static void refreshBrowser(final String browserID) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                BrowserWrapper browser;
                SWTSkinObjectBrowser soBrowser;
                BaseMdiEntry entry;
                UIFunctionsSWT uiSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
                MultipleDocumentInterfaceSWT mdi = uiSWT == null ? null : uiSWT.getMDISWT();
                BaseMdiEntry baseMdiEntry = entry = mdi == null ? null : (BaseMdiEntry)mdi.getEntrySWT(browserID);
                if (entry != null && (soBrowser = SWTSkinUtils.findBrowserSO(entry.getSkinObject())) != null) {
                    soBrowser.refresh();
                    return;
                }
                SWTSkin skin = SWTSkinFactory.getInstance();
                SWTSkinObject skinObject = skin.getSkinObject(browserID);
                if (skinObject instanceof SWTSkinObjectBrowser && null != (browser = ((SWTSkinObjectBrowser)skinObject).getBrowser()) && !browser.isDisposed()) {
                    browser.refresh();
                }
            }
        });
    }

    private void launchUrl(String url, boolean appendSuffix) {
        ContentNetwork cn = ContentNetworkUtils.getContentNetworkFromTarget(null);
        if (url.startsWith("/")) {
            url = cn.getExternalSiteRelativeURL(url, appendSuffix);
        } else if (appendSuffix) {
            url = cn.appendURLSuffix(url, false, true);
        }
        if (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("mailto:")) {
            Utils.launch(url);
        }
    }

    private void sendEmail(String to, String subject, String body) {
        String url = "mailto:" + to + "?subject=" + UrlUtils.encode(subject);
        if (body != null) {
            url = url + "&body=" + UrlUtils.encode(body);
        }
        Utils.launch(url);
    }

    private void copyToClipboard(final String text) {
        if (this.browser == null || this.browser.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (DisplayListener.this.browser == null || DisplayListener.this.browser.isDisposed()) {
                    return;
                }
                Clipboard cb = new Clipboard(DisplayListener.this.browser.getDisplay());
                TextTransfer textTransfer = TextTransfer.getInstance();
                cb.setContents(new Object[]{text}, new Transfer[]{textTransfer});
                cb.dispose();
            }
        });
    }

    private void openIrc(final String server, final String channel2, final String alias) {
        try {
            PluginManager pluginManager = PluginInitializer.getDefaultInterface().getPluginManager();
            PluginInterface piChat = pluginManager.getPluginInterfaceByID("azplugins");
            if (piChat == null) {
                this.debug("IRC plugin not found");
            } else {
                UIManager manager = piChat.getUIManager();
                manager.addUIListener(new UIManagerListener(){

                    @Override
                    public void UIDetached(UIInstance instance) {
                    }

                    @Override
                    public void UIAttached(UIInstance instance) {
                        if (instance instanceof UISWTInstance) {
                            try {
                                DisplayListener.this.debug("Opening IRC channel " + channel2 + " on " + server + " for user " + alias);
                                UISWTInstance swtInstance = (UISWTInstance)instance;
                                UISWTView[] openViews = swtInstance.getOpenViews("Main");
                                for (int i = 0; i < openViews.length; ++i) {
                                    UISWTView view = openViews[i];
                                    view.closeView();
                                }
                                swtInstance.openView("Main", "IRC", new String[]{server, channel2, alias});
                            }
                            catch (Exception e) {
                                DisplayListener.this.debug("Failure opening IRC channel " + channel2 + " on " + server, e);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            this.debug("Failure opening IRC channel " + channel2 + " on " + server, e);
        }
    }

    private void showBrowser(final String url, final String target, final int w, final int h, final boolean allowResize, final BrowserMessage message, final String sourceRef) {
        final UIFunctions functions = UIFunctionsManager.getUIFunctions();
        if (functions == null) {
            AEThread2 thread = new AEThread2("show browser " + url, true){

                @Override
                public void run() {
                    final Display display = Display.getDefault();
                    display.asyncExec(new AERunnable(){

                        @Override
                        public void runSupport() {
                            BrowserWindow window = new BrowserWindow(display.getActiveShell(), url, w, h, allowResize, false);
                            window.waitUntilClosed();
                            message.complete(false, true, null);
                        }
                    });
                }
            };
            thread.start();
            return;
        }
        AEThread2 thread = new AEThread2("show browser " + url, true){

            @Override
            public void run() {
                if (w == 0 && target != null) {
                    functions.viewURL(url, target, sourceRef);
                } else {
                    functions.viewURL(url, target, w, h, allowResize, false);
                }
                message.complete(false, true, null);
            }
        };
        thread.start();
    }
}

