/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser.listener;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.core.messenger.browser.listeners.AbstractBrowserMessageListener;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.net.magneturi.MagnetURIHandler;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.ui.swt.BrowserWrapper;
import org.gudy.azureus2.ui.swt.update.UpdateMonitor;

public class ConfigListener
extends AbstractBrowserMessageListener {
    public static final String DEFAULT_LISTENER_ID = "config";
    public static final String OP_GET_VERSION = "get-version";
    public static final String OP_NEW_INSTALL = "is-new-install";
    public static final String OP_CHECK_FOR_UPDATES = "check-for-updates";
    public static final String OP_GET_MAGNET_PORT = "get-magnet-port";
    public static final String OP_LOG_DIAGS = "log-diags";
    public static final String OP_LOG = "log";

    public ConfigListener(String id, BrowserWrapper browser) {
        super(id);
    }

    public ConfigListener(BrowserWrapper browser) {
        this(DEFAULT_LISTENER_ID, browser);
    }

    @Override
    public void handleMessage(BrowserMessage message) {
        try {
            String opid = message.getOperationId();
            if (OP_GET_VERSION.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                String callback = MapUtils.getMapString(decodedMap, "callback", null);
                if (callback != null) {
                    this.context.executeInBrowser(callback + "('" + "5.7.5.0" + "')");
                } else {
                    message.debug("bad or no callback param");
                }
            } else if (OP_NEW_INSTALL.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                String callback = MapUtils.getMapString(decodedMap, "callback", null);
                if (callback != null) {
                    this.context.executeInBrowser(callback + "(" + COConfigurationManager.isNewInstall() + ")");
                } else {
                    message.debug("bad or no callback param");
                }
            } else if (OP_CHECK_FOR_UPDATES.equals(opid)) {
                ConfigListener.checkForUpdates();
            } else if (OP_GET_MAGNET_PORT.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                String callback = MapUtils.getMapString(decodedMap, "callback", null);
                if (callback != null) {
                    this.context.executeInBrowser(callback + "('" + MagnetURIHandler.getSingleton().getPort() + "')");
                } else {
                    message.debug("bad or no callback param");
                }
            } else if (OP_LOG_DIAGS.equals(opid)) {
                ConfigListener.logDiagnostics();
            } else if (OP_LOG.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                String loggerName = MapUtils.getMapString(decodedMap, "log-name", "browser");
                String text = MapUtils.getMapString(decodedMap, "text", "");
                AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger(loggerName);
                diag_logger.log(text);
                if (ConstantsVuze.DIAG_TO_STDOUT) {
                    System.out.println(Thread.currentThread().getName() + "|" + System.currentTimeMillis() + "] " + text);
                }
            }
        }
        catch (Throwable t) {
            message.debug("handle Config message", t);
        }
    }

    public static void logDiagnostics() {
        AEDiagnostics.dumpThreads();
    }

    public static void checkForUpdates() {
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null) {
            uiFunctions.bringToFront();
        }
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                UpdateMonitor.getSingleton(core).performCheck(true, false, false, null);
            }
        });
    }
}

