/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.tracker.local;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.instancemanager.AZInstance;
import com.aelitis.azureus.core.instancemanager.AZInstanceManager;
import com.aelitis.azureus.core.instancemanager.AZInstanceManagerListener;
import com.aelitis.azureus.core.instancemanager.AZInstanceTracked;
import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import com.aelitis.azureus.core.tracker.TrackerPeerSourceAdapter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfigListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class LocalTrackerPlugin
implements Plugin,
AZInstanceManagerListener,
DownloadManagerListener,
DownloadListener {
    private static final String PLUGIN_NAME = "LAN Peer Finder";
    private static final String PLUGIN_CONFIGSECTION_ID = "Plugin.localtracker.name";
    private static final long ANNOUNCE_PERIOD = 300000L;
    private static final long RE_ANNOUNCE_PERIOD = 60000L;
    private PluginInterface plugin_interface;
    private AZInstanceManager instance_manager;
    private boolean active;
    private TorrentAttribute ta_networks;
    private TorrentAttribute ta_peer_sources;
    private Map<Download, long[]> downloads = new HashMap<Download, long[]>();
    private Map<String, Map<String, Long>> track_times = new HashMap<String, Map<String, Long>>();
    private String last_autoadd = "";
    private String last_subnets = "";
    private BooleanParameter enabled;
    private long plugin_start_time;
    private long current_time;
    private LoggerChannel log;
    private Monitor mon;
    private AsyncDispatcher dispatcher = new AsyncDispatcher(30000);

    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.ta_networks = this.plugin_interface.getTorrentManager().getAttribute("Networks");
        this.ta_peer_sources = this.plugin_interface.getTorrentManager().getAttribute("PeerSources");
        this.mon = this.plugin_interface.getUtilities().getMonitor();
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel(PLUGIN_NAME);
        UIManager ui_manager = this.plugin_interface.getUIManager();
        BasicPluginConfigModel config = ui_manager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        config.addLabelParameter2("Plugin.localtracker.info");
        this.enabled = config.addBooleanParameter2("Plugin.localtracker.enable", "Plugin.localtracker.enable", true);
        config.addLabelParameter2("Plugin.localtracker.networks.info");
        final StringParameter subnets = config.addStringParameter2("Plugin.localtracker.networks", "Plugin.localtracker.networks", "");
        final BooleanParameter include_wellknown = config.addBooleanParameter2("Plugin.localtracker.wellknownlocals", "Plugin.localtracker.wellknownlocals", true);
        config.addLabelParameter2("Plugin.localtracker.autoadd.info");
        final StringParameter autoadd = config.addStringParameter2("Plugin.localtracker.autoadd", "Plugin.localtracker.autoadd", "");
        final BasicPluginViewModel view_model = this.plugin_interface.getUIManager().createBasicPluginViewModel(PLUGIN_CONFIGSECTION_ID);
        view_model.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        view_model.getActivity().setVisible(false);
        view_model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            @Override
            public void messageLogged(int type, String content) {
                view_model.getLogArea().appendText(content + "\n");
            }

            @Override
            public void messageLogged(String str, Throwable error) {
                if (str.length() > 0) {
                    view_model.getLogArea().appendText(str + "\n");
                }
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                error.printStackTrace(pw);
                pw.flush();
                view_model.getLogArea().appendText(sw.toString() + "\n");
            }
        });
        this.plugin_start_time = this.plugin_interface.getUtilities().getCurrentSystemTime();
        this.instance_manager = AzureusCoreFactory.getSingleton().getInstanceManager();
        this.instance_manager.addListener(this);
        this.plugin_interface.getPluginconfig().addListener(new PluginConfigListener(){

            @Override
            public void configSaved() {
                LocalTrackerPlugin.this.processSubNets(subnets.getValue(), include_wellknown.getValue());
                LocalTrackerPlugin.this.processAutoAdd(autoadd.getValue());
            }
        });
        this.processSubNets(subnets.getValue(), include_wellknown.getValue());
        this.processAutoAdd(autoadd.getValue());
        DelayedTask dt = this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

            @Override
            public void run() {
                LocalTrackerPlugin.this.plugin_interface.getDownloadManager().addListener(LocalTrackerPlugin.this);
            }
        });
        dt.queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void instanceFound(AZInstance instance) {
        if (!this.enabled.getValue()) {
            return;
        }
        this.log.log("Found: " + instance.getString());
        try {
            this.mon.enter();
            this.track_times.put(instance.getID(), new HashMap());
        }
        finally {
            this.mon.exit();
        }
        this.checkActivation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkActivation() {
        try {
            this.mon.enter();
            if (this.active) {
                return;
            }
            this.active = true;
            this.plugin_interface.getUtilities().createThread("Tracker", new Runnable(){

                @Override
                public void run() {
                    LocalTrackerPlugin.this.track();
                }
            });
        }
        finally {
            this.mon.exit();
        }
    }

    @Override
    public void instanceChanged(AZInstance instance) {
        if (!this.enabled.getValue()) {
            return;
        }
        this.log.log("Changed: " + instance.getString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void instanceLost(AZInstance instance) {
        try {
            this.mon.enter();
            this.track_times.remove(instance.getID());
        }
        finally {
            this.mon.exit();
        }
        if (!this.enabled.getValue()) {
            return;
        }
        this.log.log("Lost: " + instance.getString());
    }

    @Override
    public void instanceTracked(AZInstanceTracked instance) {
        if (!this.enabled.getValue()) {
            return;
        }
        this.handleTrackResult(instance);
    }

    protected void track() {
        long now = this.plugin_interface.getUtilities().getCurrentSystemTime();
        if (now - this.plugin_start_time < 60000L) {
            try {
                Thread.sleep(15000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.plugin_interface.getUtilities().createTimer("LanPeerFinder:Tracker", true).addPeriodicEvent(30000L, new UTTimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(UTTimerEvent event2) {
                LocalTrackerPlugin.this.current_time = LocalTrackerPlugin.this.plugin_interface.getUtilities().getCurrentSystemTime();
                try {
                    ArrayList<Download> todo = new ArrayList<Download>();
                    try {
                        LocalTrackerPlugin.this.mon.enter();
                        for (Map.Entry entry : LocalTrackerPlugin.this.downloads.entrySet()) {
                            Download dl = (Download)entry.getKey();
                            long when = ((long[])entry.getValue())[0];
                            if (when <= LocalTrackerPlugin.this.current_time && LocalTrackerPlugin.this.current_time - when <= 300000L) continue;
                            todo.add(dl);
                        }
                    }
                    finally {
                        LocalTrackerPlugin.this.mon.exit();
                    }
                    for (int i = 0; i < todo.size(); ++i) {
                        LocalTrackerPlugin.this.track((Download)todo.get(i));
                    }
                }
                catch (Throwable e) {
                    LocalTrackerPlugin.this.log.log(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void track(Download download) {
        long now = this.plugin_interface.getUtilities().getCurrentSystemTime();
        boolean ok = false;
        try {
            this.mon.enter();
            long[] data = this.downloads.get(download);
            if (data == null) {
                return;
            }
            long last_track = data[0];
            if (last_track > now || now - last_track > 60000L) {
                ok = true;
                data[0] = now;
            }
        }
        finally {
            this.mon.exit();
        }
        if (ok) {
            this.trackSupport(download);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackSupport(final Download download) {
        if (!this.enabled.getValue()) {
            return;
        }
        int state = download.getState();
        if (state == 8 || state == 7) {
            return;
        }
        String[] sources = download.getListAttribute(this.ta_peer_sources);
        boolean ok = false;
        if (sources != null) {
            for (int i = 0; i < sources.length; ++i) {
                if (!sources[i].equalsIgnoreCase("Plugin")) continue;
                ok = true;
                break;
            }
        }
        if (!ok) {
            return;
        }
        if (download.getTorrent() == null) {
            return;
        }
        byte[] hash = new SHA1Simple().calculateHash(download.getTorrent().getHash());
        AZInstanceTracked[] peers = this.instance_manager.track(hash, new AZInstanceTracked.TrackTarget(){

            @Override
            public Object getTarget() {
                return download;
            }

            @Override
            public boolean isSeed() {
                return download.isComplete();
            }
        });
        int total_seeds = 0;
        int total_leechers = 0;
        int total_peers = 0;
        for (int i = 0; i < peers.length; ++i) {
            int res = this.handleTrackResult(peers[i]);
            if (res == 1) {
                ++total_seeds;
                continue;
            }
            if (res == 2) {
                ++total_leechers;
                continue;
            }
            if (res == 3) {
                ++total_seeds;
                ++total_peers;
                continue;
            }
            if (res != 4) continue;
            ++total_leechers;
            ++total_peers;
        }
        try {
            this.mon.enter();
            long[] data = this.downloads.get(download);
            if (data != null) {
                data[1] = total_seeds;
                data[2] = total_leechers;
                data[3] = total_peers;
            }
        }
        finally {
            this.mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceTrack(final Download download) {
        try {
            this.mon.enter();
            long[] data = this.downloads.get(download);
            if (data == null) {
                data = new long[4];
                this.downloads.put(download, data);
            } else {
                data[0] = 0L;
            }
            String dl_key = this.plugin_interface.getUtilities().getFormatters().encodeBytesToString(download.getTorrent().getHash());
            Iterator<Map<String, Long>> it = this.track_times.values().iterator();
            while (it.hasNext()) {
                it.next().remove(dl_key);
            }
        }
        finally {
            this.mon.exit();
        }
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                LocalTrackerPlugin.this.track(download);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int handleTrackResult(AZInstanceTracked tracked_inst) {
        AZInstance inst = tracked_inst.getInstance();
        Download download = (Download)tracked_inst.getTarget().getTarget();
        boolean is_seed = tracked_inst.isSeed();
        long now = this.plugin_interface.getUtilities().getCurrentSystemTime();
        boolean skip = false;
        try {
            long lt;
            String dl_key;
            Long last_track;
            this.mon.enter();
            Map<String, Long> map = this.track_times.get(inst.getID());
            if (map == null) {
                map = new HashMap<String, Long>();
                this.track_times.put(inst.getID(), map);
            }
            if ((last_track = map.get(dl_key = this.plugin_interface.getUtilities().getFormatters().encodeBytesToString(download.getTorrent().getHash()))) != null && now - (lt = last_track.longValue()) < 30000L) {
                skip = true;
            }
            map.put(dl_key, new Long(now));
        }
        finally {
            this.mon.exit();
        }
        if (skip) {
            return -1;
        }
        this.log.log("Tracked: " + inst.getString() + ": " + download.getName() + ", seed = " + is_seed);
        if (download.isComplete() && is_seed) {
            return 1;
        }
        PeerManager peer_manager = download.getPeerManager();
        if (peer_manager != null) {
            String peer_ip = inst.getInternalAddress().getHostAddress();
            int peer_tcp_port = inst.getTCPListenPort();
            int peer_udp_port = inst.getUDPListenPort();
            this.log.log("    " + download.getName() + ": Injecting peer " + peer_ip + ":" + peer_tcp_port + "/" + peer_udp_port);
            peer_manager.addPeer(peer_ip, peer_tcp_port, peer_udp_port, false);
        }
        return is_seed ? 3 : 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadAdded(Download download) {
        try {
            long[] data;
            this.mon.enter();
            Torrent torrent = download.getTorrent();
            if (torrent == null) {
                return;
            }
            if (TorrentUtils.isReallyPrivate(PluginCoreUtils.unwrap(torrent))) {
                this.log.log("Not tracking " + download.getName() + ": torrent is private");
                return;
            }
            String[] networks = download.getListAttribute(this.ta_networks);
            boolean public_net = false;
            if (networks != null) {
                for (int i = 0; i < networks.length; ++i) {
                    if (!networks[i].equalsIgnoreCase("Public")) continue;
                    public_net = true;
                    break;
                }
            }
            if (!public_net) {
                this.log.log("Not tracking " + download.getName() + ": torrent has no public network");
                return;
            }
            if (this.enabled.getValue()) {
                this.log.log("Tracking " + download.getName());
            }
            if ((data = this.downloads.get(download)) == null) {
                data = new long[4];
                this.downloads.put(download, data);
            } else {
                data[0] = 0L;
            }
            download.addListener(this);
        }
        finally {
            this.mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadRemoved(Download download) {
        try {
            this.mon.enter();
            this.downloads.remove(download);
            download.removeListener(this);
        }
        finally {
            this.mon.exit();
        }
    }

    public TrackerPeerSource getTrackerPeerSource(final Download download) {
        return new TrackerPeerSourceAdapter(){
            private long[] _last_data;
            private boolean enabled;
            private boolean running;
            private long fixup_time;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long[] fixup() {
                long now = SystemTime.getMonotonousTime();
                if (now - this.fixup_time > 1000L) {
                    int ds;
                    try {
                        LocalTrackerPlugin.this.mon.enter();
                        this._last_data = (long[])LocalTrackerPlugin.this.downloads.get(download);
                    }
                    finally {
                        LocalTrackerPlugin.this.mon.exit();
                    }
                    this.enabled = LocalTrackerPlugin.this.enabled.getValue();
                    this.running = this.enabled ? (ds = download.getState()) == 4 || ds == 5 : false;
                    this.fixup_time = now;
                }
                return this._last_data;
            }

            @Override
            public int getType() {
                return 4;
            }

            @Override
            public String getName() {
                return MessageText.getString("tps.lan.details", new String[]{String.valueOf(LocalTrackerPlugin.this.instance_manager.getOtherInstanceCount(false))});
            }

            @Override
            public int getStatus() {
                long[] last_data = this.fixup();
                if (last_data == null || !this.enabled) {
                    return 1;
                }
                if (this.running) {
                    return 5;
                }
                return 2;
            }

            @Override
            public int getSeedCount() {
                long[] last_data = this.fixup();
                if (last_data == null || !this.running) {
                    return -1;
                }
                return (int)last_data[1];
            }

            @Override
            public int getLeecherCount() {
                long[] last_data = this.fixup();
                if (last_data == null || !this.running) {
                    return -1;
                }
                return (int)last_data[2];
            }

            @Override
            public int getPeers() {
                long[] last_data = this.fixup();
                if (last_data == null || !this.running) {
                    return -1;
                }
                return (int)last_data[3];
            }

            @Override
            public int getSecondsToUpdate() {
                long[] last_data = this.fixup();
                if (last_data == null || !this.running) {
                    return Integer.MIN_VALUE;
                }
                return (int)((300000L - (SystemTime.getCurrentTime() - last_data[0])) / 1000L);
            }

            @Override
            public int getInterval() {
                if (this.running) {
                    return 300;
                }
                return -1;
            }

            @Override
            public int getMinInterval() {
                if (this.running) {
                    return 60;
                }
                return -1;
            }

            @Override
            public boolean isUpdating() {
                int su = this.getSecondsToUpdate();
                return su != Integer.MIN_VALUE && su < 0;
            }
        };
    }

    @Override
    public void stateChanged(Download download, int old_state, int new_state) {
        if (new_state == 4 || new_state == 5) {
            this.forceTrack(download);
        }
    }

    @Override
    public void positionChanged(Download download, int oldPosition, int newPosition) {
    }

    protected void processSubNets(String subnets, boolean include_well_known) {
        if (include_well_known != this.instance_manager.getIncludeWellKnownLANs()) {
            this.instance_manager.setIncludeWellKnownLANs(include_well_known);
            this.log.log("Include well known local networks set to " + include_well_known);
        }
        if (subnets.equals(this.last_subnets)) {
            return;
        }
        this.last_subnets = subnets;
        StringTokenizer tok = new StringTokenizer(subnets, ";");
        while (tok.hasMoreTokens()) {
            String net = tok.nextToken().trim();
            try {
                if (!this.instance_manager.addLANSubnet(net)) continue;
                this.log.log("Added network '" + net + "'");
            }
            catch (Throwable e) {
                this.log.log("Failed to add network '" + net + "'", e);
            }
        }
    }

    protected void processAutoAdd(String autoadd) {
        if (autoadd.equals(this.last_autoadd)) {
            return;
        }
        this.last_autoadd = autoadd;
        StringTokenizer tok = new StringTokenizer(autoadd, ";");
        while (tok.hasMoreTokens()) {
            String peer = tok.nextToken();
            try {
                InetAddress p = InetAddress.getByName(peer.trim());
                if (!this.instance_manager.addInstance(p)) continue;
                this.log.log("Added peer '" + peer + "'");
            }
            catch (Throwable e) {
                this.log.log("Failed to decode peer '" + peer + "'", e);
            }
        }
    }
}

