/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.tracker.dht;

import com.aelitis.azureus.core.dht.transport.DHTTransportAlternativeContact;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

public class DHTTrackerPluginAlt {
    private static final long startup_time = SystemTime.getMonotonousTime();
    private static final int startup_grace = 60000;
    private static final int INITAL_DELAY = 5000;
    private static final int RPC_TIMEOUT = 15000;
    private static final int LOOKUP_TIMEOUT = 90000;
    private static final int LOOKUP_LINGER = 5000;
    private static final int CONC_LOOKUPS = 8;
    private static final int NUM_WANT = 32;
    private static final int NID_CLOSENESS_LIMIT = 10;
    private final int port;
    private final byte[] NID = new byte[20];
    private DatagramSocket current_server;
    private Throwable last_server_error;
    private ByteArrayHashMap<Object[]> tid_map = new ByteArrayHashMap();
    private TimerEventPeriodic timer_event;
    private AsyncDispatcher dispatcher = new AsyncDispatcher();
    private volatile long lookup_count;
    private volatile long hit_count;
    private volatile long packets_out;
    private volatile long packets_in;
    private volatile long bytes_out;
    private volatile long bytes_in;

    protected DHTTrackerPluginAlt(int _port) {
        this.port = _port;
        RandomUtils.nextBytes(this.NID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatagramSocket getServer() {
        DHTTrackerPluginAlt dHTTrackerPluginAlt = this;
        synchronized (dHTTrackerPluginAlt) {
            if (this.current_server != null) {
                if (this.current_server.isClosed()) {
                    this.current_server = null;
                } else {
                    return this.current_server;
                }
            }
            try {
                final DatagramSocket server = new DatagramSocket(null);
                server.setReuseAddress(true);
                InetAddress bind_ip = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
                if (bind_ip == null) {
                    bind_ip = InetAddress.getByName("127.0.0.1");
                }
                server.bind(new InetSocketAddress(bind_ip, this.port));
                this.current_server = server;
                this.last_server_error = null;
                new AEThread2("DHTPluginAlt:server"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            try {
                                while (true) {
                                    Object[] task2;
                                    byte[] buffer = new byte[5120];
                                    DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                                    server.receive(packet);
                                    DHTTrackerPluginAlt.this.packets_in++;
                                    DHTTrackerPluginAlt.this.bytes_in += packet.getLength();
                                    Map<String, Object> map = new BDecoder().decodeByteArray(packet.getData(), 0, packet.getLength(), false);
                                    byte[] tid = (byte[])map.get("t");
                                    if (tid == null) continue;
                                    ByteArrayHashMap byteArrayHashMap = DHTTrackerPluginAlt.this.tid_map;
                                    synchronized (byteArrayHashMap) {
                                        task2 = (Object[])DHTTrackerPluginAlt.this.tid_map.remove(tid);
                                    }
                                    if (task2 == null) continue;
                                    ((GetPeersTask)task2[0]).handleReply((InetSocketAddress)packet.getSocketAddress(), tid, map);
                                }
                            }
                            catch (Throwable e) {
                                try {
                                    server.close();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                DHTTrackerPluginAlt dHTTrackerPluginAlt = DHTTrackerPluginAlt.this;
                                synchronized (dHTTrackerPluginAlt) {
                                    if (DHTTrackerPluginAlt.this.current_server == server) {
                                        DHTTrackerPluginAlt.this.current_server = null;
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                server.close();
                            }
                            catch (Throwable f) {
                                // empty catch block
                            }
                            DHTTrackerPluginAlt dHTTrackerPluginAlt = DHTTrackerPluginAlt.this;
                            synchronized (dHTTrackerPluginAlt) {
                                if (DHTTrackerPluginAlt.this.current_server == server) {
                                    DHTTrackerPluginAlt.this.current_server = null;
                                }
                            }
                            throw throwable;
                        }
                    }
                }.start();
                return server;
            }
            catch (Throwable e) {
                this.last_server_error = e;
                return null;
            }
        }
    }

    protected void get(final byte[] hash, final boolean no_seeds, final LookupListener listener) {
        SimpleTimer.addEvent("altlookup.delay", SystemTime.getCurrentTime() + 5000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent event2) {
                if (listener.isComplete()) {
                    return;
                }
                if (DHTTrackerPluginAlt.this.dispatcher.getQueueSize() > 100) {
                    return;
                }
                DHTTrackerPluginAlt.this.dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        DHTTrackerPluginAlt.this.getSupport(hash, no_seeds, listener);
                    }
                });
            }
        });
    }

    private void getSupport(byte[] hash, boolean no_seeds, LookupListener listener) {
        List<DHTTransportAlternativeContact> contacts;
        block5: {
            while (true) {
                if (listener.isComplete()) {
                    return;
                }
                contacts = DHTUDPUtils.getAlternativeContacts(1, 16);
                if (contacts.size() != 0) break block5;
                long now = SystemTime.getMonotonousTime();
                if (now - startup_time >= 60000L) break;
                try {
                    Thread.sleep(5000L);
                }
                catch (Throwable e) {}
            }
            return;
        }
        DatagramSocket server = this.getServer();
        if (server == null) {
            return;
        }
        ++this.lookup_count;
        new GetPeersTask(server, contacts, hash, no_seeds, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private byte[] send(GetPeersTask task2, DatagramSocket server, InetSocketAddress address, Map<String, Object> map) throws IOException {
        byte[] tid;
        while (true) {
            tid = new byte[4];
            RandomUtils.nextBytes(tid);
            ByteArrayHashMap<Object[]> byteArrayHashMap = this.tid_map;
            // MONITORENTER : byteArrayHashMap
            if (!this.tid_map.containsKey(tid)) break;
            // MONITOREXIT : byteArrayHashMap
        }
        this.tid_map.put(tid, new Object[]{task2, SystemTime.getMonotonousTime()});
        if (this.timer_event == null) {
            this.timer_event = SimpleTimer.addPeriodicEvent("dhtalttimer", 2500L, new TimerEventPerformer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void perform(TimerEvent event2) {
                    DHTTrackerPluginAlt.this.checkTimeouts();
                    ByteArrayHashMap byteArrayHashMap = DHTTrackerPluginAlt.this.tid_map;
                    synchronized (byteArrayHashMap) {
                        if (DHTTrackerPluginAlt.this.tid_map.size() == 0) {
                            DHTTrackerPluginAlt.this.timer_event.cancel();
                            DHTTrackerPluginAlt.this.timer_event = null;
                        }
                    }
                }
            });
        }
        // MONITOREXIT : byteArrayHashMap
        try {
            map.put("t", tid);
            byte[] data_out = BEncoder.encode(map);
            DatagramPacket packet = new DatagramPacket(data_out, data_out.length);
            packet.setSocketAddress(address);
            ++this.packets_out;
            this.bytes_out += (long)data_out.length;
            server.send(packet);
            return tid;
        }
        catch (Throwable e) {
            try {
                server.close();
            }
            catch (Throwable f) {
                // empty catch block
            }
            ByteArrayHashMap<Object[]> byteArrayHashMap = this.tid_map;
            // MONITORENTER : byteArrayHashMap
            this.tid_map.remove(tid);
            // MONITOREXIT : byteArrayHashMap
            if (!(e instanceof IOException)) throw new IOException(Debug.getNestedExceptionMessage(e));
            throw (IOException)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTimeouts() {
        long now = SystemTime.getMonotonousTime();
        ArrayList<Object[]> timeouts = null;
        ByteArrayHashMap<Object[]> byteArrayHashMap = this.tid_map;
        synchronized (byteArrayHashMap) {
            for (byte[] key : this.tid_map.keys()) {
                Object[] value = this.tid_map.get(key);
                long time = (Long)value[1];
                if (now - time <= 15000L) continue;
                this.tid_map.remove(key);
                if (timeouts == null) {
                    timeouts = new ArrayList<Object[]>();
                }
                timeouts.add(new Object[]{key, value[0]});
            }
        }
        if (timeouts != null) {
            for (Object[] entry : timeouts) {
                try {
                    ((GetPeersTask)entry[1]).handleTimeout((byte[])entry[0]);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    protected String getString() {
        return "lookups=" + this.lookup_count + ", hits=" + this.hit_count + ", out=" + this.packets_out + "/" + DisplayFormatters.formatByteCountToKiBEtc(this.bytes_out) + ", in=" + this.packets_in + "/" + DisplayFormatters.formatByteCountToKiBEtc(this.bytes_in) + (this.last_server_error == null ? "" : ", error=" + Debug.getNestedExceptionMessage(this.last_server_error));
    }

    private class GetPeersTask {
        private long start_time = SystemTime.getMonotonousTime();
        private DatagramSocket server;
        private byte[] torrent_hash;
        private boolean no_seeds;
        private LookupListener listener;
        private List<DHTTransportAlternativeContact> initial_contacts;
        private ByteArrayHashMap<InetSocketAddress> active_queries = new ByteArrayHashMap();
        private Set<InetSocketAddress> queried_nodes = new HashSet<InetSocketAddress>();
        Comparator<byte[]> comparator = new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                for (int i = 0; i < o1.length; ++i) {
                    int d2;
                    byte t;
                    int d1;
                    byte b1 = o1[i];
                    byte b2 = o2[i];
                    if (b1 == b2 || (d1 = (b1 ^ (t = GetPeersTask.this.torrent_hash[i])) & 0xFF) == (d2 = (b2 ^ t) & 0xFF)) continue;
                    if (d1 < d2) {
                        return -1;
                    }
                    return 1;
                }
                return 0;
            }
        };
        private TreeMap<byte[], InetSocketAddress> to_query = new TreeMap(this.comparator);
        private TreeMap<byte[], InetSocketAddress> heard_from = new TreeMap(new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                return -GetPeersTask.this.comparator.compare(o1, o2);
            }
        });
        private long found_peer_time;
        private Set<InetSocketAddress> found_peers = new HashSet<InetSocketAddress>();
        private int query_count;
        private int timeout_count;
        private int reply_count;
        private boolean completed;
        private boolean failed;

        private GetPeersTask(DatagramSocket _server, List<DHTTransportAlternativeContact> _contacts, byte[] _torrent_hash, boolean _no_seeds, LookupListener _listener) {
            this.server = _server;
            this.torrent_hash = _torrent_hash;
            this.no_seeds = _no_seeds;
            this.listener = _listener;
            this.initial_contacts = _contacts;
            this.tryQuery();
        }

        private void search(InetSocketAddress address) throws IOException {
            if (this.queried_nodes.contains(address)) {
                return;
            }
            this.queried_nodes.add(address);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("q", "get_peers");
            map.put("y", "q");
            HashMap<String, Object> args = new HashMap<String, Object>();
            map.put("a", args);
            args.put("id", DHTTrackerPluginAlt.this.NID);
            args.put("info_hash", this.torrent_hash);
            args.put("noseed", new Long(this.no_seeds ? 1L : 0L));
            byte[] tid = DHTTrackerPluginAlt.this.send(this, this.server, address, map);
            ++this.query_count;
            this.active_queries.put(tid, address);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void tryQuery() {
            if (this.listener.isComplete()) {
                return;
            }
            try {
                GetPeersTask getPeersTask = this;
                synchronized (getPeersTask) {
                    if (this.failed) return;
                    if (this.active_queries.size() >= 8) {
                        return;
                    }
                    long now = SystemTime.getMonotonousTime();
                    if (now - this.start_time > 90000L) {
                        return;
                    }
                    if (this.found_peer_time > 0L) {
                        if (this.found_peers.size() > 32) {
                            this.setCompleted();
                            return;
                        }
                        if (now - this.found_peer_time > 5000L) {
                            this.setCompleted();
                            return;
                        }
                    }
                    try {
                        block24: {
                            byte[] limit_nid = this.heard_from.size() >= 10 ? this.heard_from.keySet().iterator().next() : null;
                            Iterator<Map.Entry<byte[], InetSocketAddress>> query_it = this.to_query.entrySet().iterator();
                            while (query_it.hasNext()) {
                                Map.Entry<byte[], InetSocketAddress> entry = query_it.next();
                                query_it.remove();
                                byte[] nid = entry.getKey();
                                if (limit_nid != null && this.comparator.compare(limit_nid, nid) <= 0) continue;
                                InetSocketAddress address = entry.getValue();
                                this.search(address);
                                if (this.active_queries.size() < 8) continue;
                                return;
                            }
                            if (this.heard_from.size() >= 10) return;
                            Iterator<DHTTransportAlternativeContact> contact_it = this.initial_contacts.iterator();
                            while (contact_it.hasNext()) {
                                DHTTransportAlternativeContact contact = contact_it.next();
                                contact_it.remove();
                                Map<String, Object> properties = contact.getProperties();
                                byte[] _a = (byte[])properties.get("a");
                                Long _p = (Long)properties.get("p");
                                if (_a == null || _p == null) continue;
                                try {
                                    InetSocketAddress address = new InetSocketAddress(InetAddress.getByAddress(_a), _p.intValue());
                                    this.search(address);
                                    if (this.active_queries.size() < 8) continue;
                                    break block24;
                                }
                                catch (Throwable e) {
                                }
                            }
                            return;
                        }
                        return;
                    }
                    finally {
                        if (this.active_queries.size() == 0) {
                            this.setCompleted();
                        }
                    }
                }
            }
            catch (Throwable e) {
                GetPeersTask getPeersTask = this;
                synchronized (getPeersTask) {
                    this.setFailed();
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleTimeout(byte[] tid) {
            GetPeersTask getPeersTask = this;
            synchronized (getPeersTask) {
                this.active_queries.remove(tid);
                ++this.timeout_count;
            }
            this.tryQuery();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleReply(InetSocketAddress from, byte[] tid, Map<String, Object> map) throws IOException {
            Object it;
            Map reply = (Map)map.get("r");
            GetPeersTask getPeersTask = this;
            synchronized (getPeersTask) {
                this.active_queries.remove(tid);
                ++this.reply_count;
                if (reply == null) {
                    return;
                }
                this.heard_from.put((byte[])reply.get("id"), from);
                if (this.heard_from.size() > 10) {
                    it = this.heard_from.keySet().iterator();
                    it.next();
                    it.remove();
                }
            }
            ArrayList values = (ArrayList)reply.get("values");
            if (values != null) {
                it = this;
                synchronized (it) {
                    if (this.found_peer_time == 0L) {
                        this.found_peer_time = SystemTime.getMonotonousTime();
                    }
                }
                for (byte[] value : values) {
                    try {
                        ByteBuffer bb = ByteBuffer.wrap(value);
                        byte[] address = new byte[value.length - 2];
                        bb.get(address);
                        int port = bb.getShort() & 0xFFFF;
                        InetSocketAddress addr = new InetSocketAddress(InetAddress.getByAddress(address), port);
                        GetPeersTask getPeersTask2 = this;
                        synchronized (getPeersTask2) {
                            if (this.found_peers.contains(addr)) {
                                continue;
                            }
                            this.found_peers.add(addr);
                        }
                        DHTTrackerPluginAlt.this.hit_count++;
                        this.listener.foundPeer(addr);
                    }
                    catch (Throwable e) {}
                }
            }
            byte[] nodes = (byte[])reply.get("nodes");
            byte[] nodes6 = (byte[])reply.get("nodes6");
            if (nodes != null) {
                int entry_size = 26;
                for (int i = 0; i < nodes.length; i += entry_size) {
                    ByteBuffer bb = ByteBuffer.wrap(nodes, i, entry_size);
                    byte[] nid = new byte[20];
                    bb.get(nid);
                    byte[] address = new byte[4];
                    bb.get(address);
                    int port = bb.getShort() & 0xFFFF;
                    try {
                        InetSocketAddress addr = new InetSocketAddress(InetAddress.getByAddress(address), port);
                        GetPeersTask getPeersTask3 = this;
                        synchronized (getPeersTask3) {
                            if (!this.queried_nodes.contains(addr)) {
                                this.to_query.put(nid, addr);
                            }
                            continue;
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
            this.tryQuery();
        }

        private void setCompleted() {
            if (!this.completed) {
                this.completed = true;
                this.listener.completed();
            }
        }

        private void setFailed() {
            this.failed = true;
            this.setCompleted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void log() {
            System.out.println(ByteFormatter.encodeString(this.torrent_hash) + ": send=" + this.query_count + ", recv=" + this.reply_count + ", t/o=" + this.timeout_count + ", elapsed=" + (SystemTime.getMonotonousTime() - this.start_time) + ", toq=" + this.to_query.size() + ", found=" + this.found_peers.size());
            GetPeersTask getPeersTask = this;
            synchronized (getPeersTask) {
                for (byte[] nid : this.heard_from.keySet()) {
                    System.out.println("    " + ByteFormatter.encodeString(nid));
                }
            }
        }
    }

    protected static interface LookupListener {
        public void foundPeer(InetSocketAddress var1);

        public boolean isComplete();

        public void completed();
    }
}

