/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.startstoprules.defaultplugin.ui.swt;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.util.ArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntListParameter;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeAdapter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionQueue
implements UISWTConfigSection {
    @Override
    public String configSectionGetParentSection() {
        return "root";
    }

    @Override
    public int maxUserMode() {
        return 0;
    }

    @Override
    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        Utils.setLayoutData((Control)cSection, gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        cSection.setLayout(layout);
        Label label = new Label(cSection, 0);
        Messages.setLanguageText(label, "ConfigView.label.maxdownloads");
        gridData = new GridData();
        final IntParameter maxDLs = new IntParameter(cSection, "max downloads");
        maxDLs.setLayoutData(gridData);
        Composite cMaxDownloads = new Composite(cSection, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cMaxDownloads.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalIndent = 15;
        gridData.horizontalSpan = 2;
        Utils.setLayoutData((Control)cMaxDownloads, gridData);
        ImageLoader imageLoader = ImageLoader.getInstance();
        label = new Label(cMaxDownloads, 0);
        imageLoader.setLabelImage(label, "subitem");
        gridData = new GridData(2);
        Utils.setLayoutData((Control)label, gridData);
        label = new Label(cMaxDownloads, 0);
        Messages.setLanguageText(label, "ConfigView.label.ignoreChecking");
        gridData = new GridData();
        BooleanParameter ignoreChecking = new BooleanParameter(cMaxDownloads, "StartStopManager_bMaxDownloadIgnoreChecking");
        ignoreChecking.setLayoutData(gridData);
        label = new Label(cSection, 0);
        Messages.setLanguageText(label, "ConfigView.label.maxactivetorrents");
        gridData = new GridData();
        final IntParameter maxActiv = new IntParameter(cSection, "max active torrents");
        maxActiv.setLayoutData(gridData);
        Composite cMaxActiveOptionsArea = new Composite(cSection, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cMaxActiveOptionsArea.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalIndent = 15;
        gridData.horizontalSpan = 2;
        Utils.setLayoutData((Control)cMaxActiveOptionsArea, gridData);
        label = new Label(cMaxActiveOptionsArea, 0);
        imageLoader.setLabelImage(label, "subitem");
        gridData = new GridData(2);
        Utils.setLayoutData((Control)label, gridData);
        gridData = new GridData();
        BooleanParameter maxActiveWhenSeedingEnabled = new BooleanParameter(cMaxActiveOptionsArea, "StartStopManager_bMaxActiveTorrentsWhenSeedingEnabled", "ConfigView.label.queue.maxactivetorrentswhenseeding");
        maxActiveWhenSeedingEnabled.setLayoutData(gridData);
        gridData = new GridData();
        IntParameter maxActivWhenSeeding = new IntParameter(cMaxActiveOptionsArea, "StartStopManager_iMaxActiveTorrentsWhenSeeding");
        maxActivWhenSeeding.setLayoutData(gridData);
        label = new Label(cSection, 0);
        Messages.setLanguageText(label, "ConfigView.label.mindownloads");
        gridData = new GridData();
        final IntParameter minDLs = new IntParameter(cSection, "min downloads");
        minDLs.setLayoutData(gridData);
        minDLs.setMaximumValue(maxDLs.getValue() / 2);
        maxActiveWhenSeedingEnabled.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(maxActivWhenSeeding));
        maxDLs.addChangeListener(new ParameterChangeAdapter(){

            @Override
            public void parameterChanged(Parameter p, boolean caused_internally) {
                int iMaxDLs = maxDLs.getValue();
                minDLs.setMaximumValue(iMaxDLs / 2);
                int iMinDLs = minDLs.getValue();
                int iMaxActive = maxActiv.getValue();
                if ((iMaxDLs == 0 || iMaxDLs > iMaxActive) && iMaxActive != 0) {
                    maxActiv.setValue(iMaxDLs);
                }
            }
        });
        maxActiv.addChangeListener(new ParameterChangeAdapter(){

            @Override
            public void parameterChanged(Parameter p, boolean caused_internally) {
                int iMaxDLs = maxDLs.getValue();
                int iMaxActive = maxActiv.getValue();
                if ((iMaxDLs == 0 || iMaxDLs > iMaxActive) && iMaxActive != 0) {
                    maxDLs.setValue(iMaxActive);
                }
            }
        });
        ArrayList<Integer> values = new ArrayList<Integer>();
        int exp = 29;
        int val = 0;
        while (val <= 0x800000) {
            values.add(new Integer(val));
            if (val < 256) {
                val += 64;
                continue;
            }
            if (val < 1024) {
                val += 256;
                continue;
            }
            if (val < 16384) {
                val += 1024;
                continue;
            }
            val = (int)(Math.pow(2.0, exp++ / 2) + (exp % 2 == 0 ? Math.pow(2.0, (exp - 3) / 2) : 0.0));
        }
        String[] activeDLLabels = new String[values.size()];
        int[] activeDLValues = new int[activeDLLabels.length];
        label = new Label(cSection, 0);
        Messages.setLanguageText(label, "ConfigView.label.minSpeedForActiveDL");
        for (int i = 0; i < activeDLLabels.length; ++i) {
            activeDLValues[i] = (Integer)values.get(i);
            activeDLLabels[i] = DisplayFormatters.formatByteCountToKiBEtcPerSec(activeDLValues[i], true);
        }
        new IntListParameter(cSection, "StartStopManager_iMinSpeedForActiveDL", activeDLLabels, activeDLValues);
        label = new Label(cSection, 0);
        Messages.setLanguageText(label, "ConfigView.label.minSpeedForActiveSeeding");
        String[] activeSeedingLabels = new String[values.size() - 4];
        int[] activeSeedingValues = new int[activeSeedingLabels.length];
        System.arraycopy(activeDLLabels, 0, activeSeedingLabels, 0, activeSeedingLabels.length);
        System.arraycopy(activeDLValues, 0, activeSeedingValues, 0, activeSeedingValues.length);
        new IntListParameter(cSection, "StartStopManager_iMinSpeedForActiveSeeding", activeSeedingLabels, activeSeedingValues);
        Composite cMinSpeedActiveCDing = new Composite(cSection, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cMinSpeedActiveCDing.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalIndent = 15;
        gridData.horizontalSpan = 2;
        Utils.setLayoutData((Control)cMinSpeedActiveCDing, gridData);
        label = new Label(cMinSpeedActiveCDing, 0);
        imageLoader.setLabelImage(label, "subitem");
        gridData = new GridData(2);
        Utils.setLayoutData((Control)label, gridData);
        label = new Label(cMinSpeedActiveCDing, 0);
        Messages.setLanguageText(label, "ConfigView.label.maxStalledSeeding");
        gridData = new GridData();
        IntParameter maxStalledSeeding = new IntParameter(cMinSpeedActiveCDing, "StartStopManager_iMaxStalledSeeding");
        maxStalledSeeding.setMinimumValue(0);
        maxStalledSeeding.setLayoutData(gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        new BooleanParameter(cSection, "StartStopManager_bStopOnceBandwidthMet", "ConfigView.label.queue.stoponcebandwidthmet").setLayoutData(gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        new BooleanParameter(cSection, "StartStopManager_bNewSeedsMoveTop", "ConfigView.label.queue.newseedsmovetop").setLayoutData(gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        new BooleanParameter(cSection, "StartStopManager_bRetainForceStartWhenComplete", "ConfigView.label.queue.retainforce").setLayoutData(gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        new BooleanParameter(cSection, "Alert on close", "ConfigView.label.showpopuponclose").setLayoutData(gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        new BooleanParameter(cSection, "StartStopManager_bDebugLog", "ConfigView.label.queue.debuglog").setLayoutData(gridData);
        return cSection;
    }

    @Override
    public String configSectionGetName() {
        return "queue";
    }

    @Override
    public void configSectionSave() {
    }

    @Override
    public void configSectionDelete() {
    }
}

