/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.sharing.hoster;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAttributeListener;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadStub;
import org.gudy.azureus2.plugins.download.DownloadWillBeAddedListener;
import org.gudy.azureus2.plugins.download.DownloadWillBeRemovedListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareItem;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDeletionVetoException;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceEvent;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.sharing.ShareResourceListener;
import org.gudy.azureus2.plugins.sharing.ShareResourceWillBeDeletedListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentRemovalVetoException;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentWillBeRemovedListener;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class ShareHosterPlugin
implements Plugin,
PluginListener,
ShareManagerListener {
    protected PluginInterface plugin_interface;
    protected LoggerChannel log;
    protected Tracker tracker;
    protected ShareManager share_manager;
    protected DownloadManager download_manager;
    protected Map resource_dl_map = new HashMap();
    protected Map resource_tt_map = new HashMap();
    protected Download download_being_removed;
    protected TrackerTorrent torrent_being_removed;

    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", "Share Hoster");
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.log = this.plugin_interface.getLogger().getChannel("ShareHosterPlugin");
        this.log.log(1, "ShareHosterPlugin: initialisation starts");
        this.plugin_interface.addListener(this);
    }

    @Override
    public void initializationComplete() {
        DelayedTask dt = this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

            @Override
            public void run() {
                ShareHosterPlugin.this.initialise();
            }
        });
        dt.queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialise() {
        this.log.log(1, "ShareHosterPlugin: initialisation complete");
        Thread.currentThread().setPriority(1);
        try {
            this.tracker = this.plugin_interface.getTracker();
            this.download_manager = this.plugin_interface.getDownloadManager();
            this.share_manager = this.plugin_interface.getShareManager();
            this.share_manager.addListener(this);
            this.share_manager.initialise();
        }
        catch (ShareException e) {
            Debug.printStackTrace(e);
            this.log.log(e);
        }
        finally {
            this.plugin_interface.getPluginManager().firePluginEvent(5);
        }
    }

    @Override
    public void closedownInitiated() {
    }

    @Override
    public void closedownComplete() {
    }

    @Override
    public void resourceAdded(final ShareResource resource) {
        this.log.log(1, "Resource added:".concat(resource.getName()));
        try {
            ShareResourceDir dir_resource;
            Download download;
            Torrent torrent;
            ShareItem item;
            resource.addDeletionListener(new ShareResourceWillBeDeletedListener(){

                @Override
                public void resourceWillBeDeleted(ShareResource resource) throws ShareResourceDeletionVetoException {
                    ShareHosterPlugin.this.canResourceBeDeleted(resource);
                }
            });
            Download new_download = null;
            int type = resource.getType();
            if (type == 1) {
                ShareResourceFile file_resource = (ShareResourceFile)resource;
                item = file_resource.getItem();
                torrent = item.getTorrent();
                download = this.download_manager.getDownload(torrent);
                if (download == null) {
                    new_download = this.addDownload(resource, torrent, item.getTorrentFile(), file_resource.getFile());
                }
            } else if (type == 2 && (download = this.download_manager.getDownload(torrent = (item = (dir_resource = (ShareResourceDir)resource).getItem()).getTorrent())) == null) {
                new_download = this.addDownload(resource, torrent, item.getTorrentFile(), dir_resource.getDir());
            }
            if (new_download != null) {
                final Download f_new_download = new_download;
                this.resource_dl_map.put(resource, new_download);
                resource.addChangeListener(new ShareResourceListener(){

                    @Override
                    public void shareResourceChanged(ShareResource resource, ShareResourceEvent event2) {
                        if (event2.getType() == 1) {
                            TorrentAttribute attribute = (TorrentAttribute)event2.getData();
                            f_new_download.setAttribute(attribute, resource.getAttribute(attribute));
                        }
                    }
                });
                TorrentAttribute[] attributes = resource.getAttributes();
                for (int i = 0; i < attributes.length; ++i) {
                    TorrentAttribute ta = attributes[i];
                    new_download.setAttribute(ta, resource.getAttribute(ta));
                }
                new_download.addAttributeListener(new DownloadAttributeListener(){

                    @Override
                    public void attributeEventOccurred(Download d, TorrentAttribute attr, int event_type) {
                        resource.setAttribute(attr, d.getAttribute(attr));
                    }
                }, this.plugin_interface.getTorrentManager().getAttribute("Category"), 1);
                boolean persistent = resource.isPersistent();
                Torrent dl_torrent = new_download.getTorrent();
                if (dl_torrent != null) {
                    TrackerTorrent tt = this.tracker.host(dl_torrent, persistent);
                    if (!persistent) {
                        tt.addRemovalListener(new TrackerTorrentWillBeRemovedListener(){

                            @Override
                            public void torrentWillBeRemoved(TrackerTorrent tt) throws TrackerTorrentRemovalVetoException {
                                if (tt != ShareHosterPlugin.this.torrent_being_removed) {
                                    throw new TrackerTorrentRemovalVetoException(MessageText.getString("plugin.sharing.torrent.remove.veto"));
                                }
                            }
                        });
                    }
                    this.resource_tt_map.put(resource, tt);
                }
                if (!persistent) {
                    new_download.addDownloadWillBeRemovedListener(new DownloadWillBeRemovedListener(){

                        @Override
                        public void downloadWillBeRemoved(Download dl) throws DownloadRemovalVetoException {
                            if (dl != ShareHosterPlugin.this.download_being_removed) {
                                throw new DownloadRemovalVetoException(MessageText.getString("plugin.sharing.download.remove.veto"));
                            }
                        }
                    });
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Download addDownload(ShareResource resource, final Torrent torrent, File torrent_file, File data_file) throws DownloadException {
        Map<String, String> properties = resource.getProperties();
        final ArrayList<String> networks = new ArrayList<String>();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (properties != null) {
            String tags_str;
            String nets = properties.get("networks");
            if (nets != null) {
                String[] bits;
                for (String bit : bits = nets.split(",")) {
                    if ((bit = AENetworkClassifier.internalise(bit.trim())) == null) continue;
                    networks.add(bit);
                }
            }
            if ((tags_str = properties.get("tags")) != null) {
                String[] bits = tags_str.split(",");
                TagManager tm = TagManagerFactory.getTagManager();
                for (String bit : bits) {
                    try {
                        long tag_uid = Long.parseLong(bit.trim());
                        Tag tag = tm.lookupTagByUID(tag_uid);
                        if (tag == null) continue;
                        tags.add(tag);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }
        DownloadWillBeAddedListener dwbal = null;
        if (networks.size() > 0) {
            dwbal = new DownloadWillBeAddedListener(){

                @Override
                public void initialised(Download download) {
                    if (Arrays.equals(download.getTorrentHash(), torrent.getHash())) {
                        PluginCoreUtils.unwrap(download).getDownloadState().setNetworks(networks.toArray(new String[networks.size()]));
                    }
                }
            };
            this.download_manager.addDownloadWillBeAddedListener(dwbal);
        }
        try {
            Download download;
            if (resource.isPersistent()) {
                DownloadStub stub = this.download_manager.lookupDownloadStub(torrent.getHash());
                if (stub != null) {
                    Download tm = null;
                    return tm;
                }
                try {
                    torrent.setComplete(data_file);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
                download = this.download_manager.addDownload(torrent, torrent_file, data_file);
            } else {
                download = this.download_manager.addNonPersistentDownload(torrent, torrent_file, data_file);
            }
            if (tags.size() > 0) {
                org.gudy.azureus2.core3.download.DownloadManager dm = PluginCoreUtils.unwrap(download);
                for (Tag tag : tags) {
                    tag.addTaggable(dm);
                }
            }
            Download download2 = download;
            return download2;
        }
        finally {
            if (dwbal != null) {
                this.download_manager.removeDownloadWillBeAddedListener(dwbal);
            }
        }
    }

    protected void canResourceBeDeleted(ShareResource resource) throws ShareResourceDeletionVetoException {
        TrackerTorrent tt;
        Download dl = (Download)this.resource_dl_map.get(resource);
        if (dl != null) {
            try {
                this.download_being_removed = dl;
                dl.canBeRemoved();
            }
            catch (DownloadRemovalVetoException e) {
                throw new ShareResourceDeletionVetoException(e.getMessage());
            }
            finally {
                this.download_being_removed = null;
            }
        }
        if ((tt = (TrackerTorrent)this.resource_tt_map.get(resource)) != null) {
            try {
                this.torrent_being_removed = tt;
                tt.canBeRemoved();
            }
            catch (TrackerTorrentRemovalVetoException e) {
                throw new ShareResourceDeletionVetoException(e.getMessage());
            }
            finally {
                this.torrent_being_removed = null;
            }
        }
    }

    @Override
    public void resourceModified(ShareResource old_resource, ShareResource new_resource) {
        this.log.log(1, "Resource modified:".concat(old_resource.getName()));
        this.resourceDeleted(old_resource);
        this.resourceAdded(new_resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resourceDeleted(ShareResource resource) {
        TrackerTorrent tt;
        this.log.log(1, "Resource deleted:".concat(resource.getName()));
        Download dl = (Download)this.resource_dl_map.get(resource);
        if (dl != null) {
            try {
                this.download_being_removed = dl;
                try {
                    dl.stop();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                dl.remove();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            finally {
                this.download_being_removed = null;
            }
            this.resource_dl_map.remove(resource);
        }
        if ((tt = (TrackerTorrent)this.resource_tt_map.get(resource)) != null) {
            try {
                this.torrent_being_removed = tt;
                tt.remove();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            finally {
                this.torrent_being_removed = null;
            }
            this.resource_tt_map.remove(resource);
        }
    }

    @Override
    public void reportProgress(int percent_complete) {
    }

    @Override
    public void reportCurrentTask(String task_description) {
        this.log.log(1, "Current Task:".concat(task_description));
    }
}

