/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.netstatus.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.plugins.net.netstatus.NetStatusPlugin;
import com.aelitis.azureus.plugins.net.netstatus.swt.NetStatusPluginTester;
import java.util.ArrayList;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;

public class NetStatusPluginView
implements UISWTViewEventListener {
    private NetStatusPlugin plugin;
    private boolean created = false;
    private Composite composite;
    private Button start_button;
    private Button cancel_button;
    private StyledText log;
    private int selected_tests;
    private NetStatusPluginTester current_test;
    private static final int LOG_NORMAL = 1;
    private static final int LOG_SUCCESS = 2;
    private static final int LOG_ERROR = 3;
    private static final int LOG_INFO = 4;
    private int log_type = 1;

    public NetStatusPluginView(NetStatusPlugin _plugin, UIInstance _ui, String VIEW_ID) {
        this.plugin = _plugin;
        ((UISWTInstance)_ui).addView("Main", VIEW_ID, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                if (this.created) {
                    return false;
                }
                this.created = true;
                break;
            }
            case 2: {
                this.initialise((Composite)event2.getData());
                break;
            }
            case 7: 
            case 8: {
                try {
                    this.destroy();
                    break;
                }
                finally {
                    this.created = false;
                }
            }
        }
        return true;
    }

    protected void initialise(Composite _composite) {
        this.composite = _composite;
        Composite main = new Composite(this.composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        main.setLayout(layout);
        GridData grid_data = new GridData(1808);
        Utils.setLayoutData((Control)main, grid_data);
        Composite control = new Composite(main, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        control.setLayout(layout);
        Label info = new Label(control, 0);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 3;
        Utils.setLayoutData((Control)info, grid_data);
        Messages.setLanguageText(info, "label.test.internet");
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 1;
        Utils.setLayoutData((Control)control, grid_data);
        ArrayList<Button> buttons = new ArrayList<Button>();
        this.start_button = new Button(control, 8);
        buttons.add(this.start_button);
        Messages.setLanguageText(this.start_button, "ConfigView.section.start");
        this.start_button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                NetStatusPluginView.this.start_button.setEnabled(false);
                NetStatusPluginView.this.cancel_button.setEnabled(true);
                NetStatusPluginView.this.startTest();
            }
        });
        this.cancel_button = new Button(control, 8);
        buttons.add(this.cancel_button);
        Messages.setLanguageText(this.cancel_button, "UpdateWindow.cancel");
        this.cancel_button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                NetStatusPluginView.this.cancel_button.setEnabled(false);
                NetStatusPluginView.this.cancelTest();
            }
        });
        this.cancel_button.setEnabled(false);
        Utils.makeButtonsEqualWidth(buttons);
        Group options = new Group(control, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        options.setLayout(layout);
        Messages.setLanguageText(options, "label.test.types");
        grid_data = new GridData(768);
        Utils.setLayoutData((Control)options, grid_data);
        Button opt = new Button(options, 32);
        Messages.setLanguageText(opt, "label.outbound");
        this.addOption(opt, 4, true);
        opt = new Button(options, 32);
        Messages.setLanguageText(opt, "label.inbound");
        this.addOption(opt, 8, true);
        opt = new Button(options, 32);
        Messages.setLanguageText(opt, "label.nat.proxies");
        this.addOption(opt, 2, true);
        opt = new Button(options, 32);
        Messages.setLanguageText(opt, "label.bt.connect");
        this.addOption(opt, 16, true);
        opt = new Button(options, 32);
        opt.setText("IPv6");
        boolean ipv6_enabled = COConfigurationManager.getBooleanParameter("IPV6 Enable Support");
        this.addOption(opt, 32, ipv6_enabled);
        opt = new Button(options, 32);
        Messages.setLanguageText(opt, "label.vuze.services");
        this.addOption(opt, 64, true);
        if (Constants.isWindows || Constants.isOSX) {
            opt = new Button(options, 32);
            Messages.setLanguageText(opt, "label.indirect.connect");
            boolean ic_enabled = AEProxyFactory.hasPluginProxy();
            this.addOption(opt, 128, ic_enabled);
        }
        this.log = new StyledText(main, 2824);
        grid_data = new GridData(1808);
        grid_data.horizontalSpan = 1;
        grid_data.horizontalIndent = 4;
        Utils.setLayoutData((Control)this.log, grid_data);
        this.log.setIndent(4);
        ClipboardCopy.addCopyToClipMenu(this.log, new ClipboardCopy.copyToClipProvider(){

            @Override
            public String getText() {
                return NetStatusPluginView.this.log.getText().trim();
            }
        });
    }

    protected void addOption(final Button button, final int type, boolean enable) {
        final String config = "test.option." + type;
        boolean selected = this.plugin.getBooleanParameter(config, enable);
        this.selected_tests = selected && enable ? (this.selected_tests |= type) : (this.selected_tests &= ~type);
        if (!enable) {
            button.setEnabled(false);
        }
        button.setSelection(selected);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                boolean selected = button.getSelection();
                if (selected) {
                    NetStatusPluginView.this.selected_tests |= type;
                } else {
                    NetStatusPluginView.this.selected_tests &= ~type;
                }
                NetStatusPluginView.this.plugin.setBooleanParameter(config, selected);
            }
        });
    }

    protected void startTest() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                NetStatusPluginView.this.startTestSupport(core);
            }
        });
    }

    protected void cancelTest() {
        new AEThread2("NetStatus:cancel", true){

            @Override
            public void run() {
                NetStatusPluginView.this.cancelTestSupport();
            }
        }.start();
    }

    /*
     * Exception decompiling
     */
    protected void startTestSupport(AzureusCore core) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void println(String str) {
        this.print(str + "\n", false);
    }

    protected void println(String str, boolean clear_first) {
        this.print(str + "\n", clear_first);
    }

    protected void print(final String str, final boolean clear_first) {
        this.plugin.log(str);
        if (!this.log.isDisposed() && !this.log.getDisplay().isDisposed()) {
            final int f_log_type = this.log_type;
            this.log.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    int start;
                    if (NetStatusPluginView.this.log.isDisposed()) {
                        return;
                    }
                    if (clear_first) {
                        start = 0;
                        NetStatusPluginView.this.log.setText(str);
                    } else {
                        start = NetStatusPluginView.this.log.getText().length();
                        NetStatusPluginView.this.log.append(str);
                    }
                    Color color = f_log_type == 1 ? Colors.black : (f_log_type == 2 ? Colors.green : (f_log_type == 4 ? Colors.blue : Colors.red));
                    StyleRange styleRange = new StyleRange();
                    styleRange.start = start;
                    styleRange.length = str.length();
                    styleRange.foreground = color;
                    NetStatusPluginView.this.log.setStyleRange(styleRange);
                    NetStatusPluginView.this.log.setSelection(NetStatusPluginView.this.log.getText().length());
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelTestSupport() {
        NetStatusPluginView netStatusPluginView = this;
        synchronized (netStatusPluginView) {
            if (this.current_test != null) {
                this.println("Cancelling test...");
                this.current_test.cancel();
            }
        }
    }

    protected void destroy() {
        this.cancelTest();
        this.composite = null;
    }
}

