/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy.swt.columns;

import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBeta;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginUtils;
import java.util.Map;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;

public class ColumnChatMessageCount
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "chat.msg.count";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnChatMessageCount(TableColumn column) {
        column.setWidth(60);
        column.setAlignment(2);
        column.setRefreshInterval(-2);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        Object dataSource = cell.getDataSource();
        int num = -1;
        if (dataSource instanceof Download) {
            Download dl = (Download)dataSource;
            BuddyPluginBeta beta = BuddyPluginUtils.getBetaPlugin();
            if (beta != null) {
                BuddyPluginBeta.ChatInstance chat = beta.peekChatInstance(dl);
                if (chat != null) {
                    num = chat.getMessageCount(true);
                } else {
                    Number message_count;
                    Map<String, Object> peek_data = beta.peekChat(dl, true);
                    if (peek_data != null && (message_count = (Number)peek_data.get("m")) != null) {
                        num = message_count.intValue();
                    }
                }
            }
        } else {
            BuddyPluginBeta.ChatInstance chat = (BuddyPluginBeta.ChatInstance)cell.getDataSource();
            if (chat != null) {
                num = chat.getMessageCount(true);
            }
        }
        if (!cell.setSortValue(num) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(num == -1 ? "" : (num < 100 ? String.valueOf(num) : "100+"));
    }
}

