/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy.swt;

import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBeta;
import com.aelitis.azureus.plugins.net.buddy.swt.ChatView;
import com.aelitis.azureus.plugins.net.buddy.swt.SBC_ChatOverview;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiCloseListener;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryDropListener;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;

public class ChatMDIEntry
implements ViewTitleInfo {
    private final MdiEntry mdi_entry;
    private final BuddyPluginBeta.ChatInstance chat;
    private ChatView view;
    private String drop_outstanding;
    private final BuddyPluginBeta.ChatAdapter adapter = new BuddyPluginBeta.ChatAdapter(){

        @Override
        public void updated() {
            ChatMDIEntry.this.update();
        }
    };

    public ChatMDIEntry(BuddyPluginBeta.ChatInstance _chat, MdiEntry _entry) {
        this.chat = _chat;
        this.mdi_entry = _entry;
        this.setupMdiEntry();
    }

    private void setupMdiEntry() {
        this.mdi_entry.setViewTitleInfo(this);
        MdiEntryDropListener drop_listener = new MdiEntryDropListener(){

            @Override
            public boolean mdiEntryDrop(MdiEntry entry, Object payload) {
                String[] derp;
                if (payload instanceof String[] && (derp = (String[])payload).length > 0) {
                    payload = derp[0];
                }
                if (!(payload instanceof String)) {
                    return false;
                }
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                if (mdi != null) {
                    String drop = (String)payload;
                    if (ChatMDIEntry.this.view == null) {
                        ChatMDIEntry.this.drop_outstanding = drop;
                    } else {
                        ChatMDIEntry.this.view.handleDrop(drop);
                    }
                    mdi.showEntry(ChatMDIEntry.this.mdi_entry);
                    return true;
                }
                return false;
            }
        };
        this.mdi_entry.addListener(drop_listener);
        this.mdi_entry.addListener(new MdiCloseListener(){

            @Override
            public void mdiEntryClosed(MdiEntry entry, boolean user) {
                ChatMDIEntry.this.chat.destroy();
            }
        });
        this.chat.addListener(this.adapter);
    }

    protected void setView(ChatView _view) {
        this.view = _view;
        String drop = this.drop_outstanding;
        if (drop != null) {
            this.drop_outstanding = null;
            this.view.handleDrop(drop);
        }
    }

    private void update() {
        this.mdi_entry.redraw();
        ViewTitleInfoManager.refreshTitleInfo(this.mdi_entry.getViewTitleInfo());
    }

    @Override
    public Object getTitleInfoProperty(int propertyID) {
        switch (propertyID) {
            case 1: {
                return this.chat.getName();
            }
            case 5: {
                return this.chat.getName(true);
            }
            case 8: {
                if (this.chat.getMessageOutstanding() && this.chat.hasUnseenMessageWithNick()) {
                    return SBC_ChatOverview.COLOR_MESSAGE_WITH_NICK;
                }
                return null;
            }
            case 0: {
                if (this.chat.getMessageOutstanding()) {
                    return "*";
                }
                return null;
            }
        }
        return null;
    }
}

