/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.impl;

import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.impl.ExternalSeedReaderImpl;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderListener;
import java.util.List;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;

public class ExternalSeedReaderRequest
implements ExternalSeedHTTPDownloaderListener {
    private ExternalSeedReaderImpl reader;
    private List<PeerReadRequest> requests;
    private int start_piece_number;
    private int start_piece_offset;
    private int length;
    private int current_request_index = 0;
    private PeerReadRequest current_request;
    private byte[] current_buffer;
    private int current_position;

    protected ExternalSeedReaderRequest(ExternalSeedReaderImpl _reader, List<PeerReadRequest> _requests) {
        this.reader = _reader;
        this.requests = _requests;
        for (int i = 0; i < this.requests.size(); ++i) {
            PeerReadRequest req = this.requests.get(i);
            if (i == 0) {
                this.start_piece_number = req.getPieceNumber();
                this.start_piece_offset = req.getOffset();
            }
            this.length += req.getLength();
        }
    }

    public int getStartPieceNumber() {
        return this.start_piece_number;
    }

    public int getStartPieceOffset() {
        return this.start_piece_offset;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public byte[] getBuffer() throws ExternalSeedException {
        if (this.current_request_index >= this.requests.size()) {
            throw new ExternalSeedException("Insufficient buffers to satisfy request");
        }
        this.current_request = this.requests.get(this.current_request_index++);
        this.current_buffer = new byte[this.current_request.getLength()];
        this.current_position = 0;
        return this.current_buffer;
    }

    @Override
    public boolean isCancelled() {
        for (int i = 0; i < this.requests.size(); ++i) {
            PeerReadRequest req = this.requests.get(i);
            if (!req.isCancelled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void done() {
        this.reader.informComplete(this.current_request, this.current_buffer);
    }

    protected void cancel() {
        for (int i = 0; i < this.requests.size(); ++i) {
            PeerReadRequest req = this.requests.get(i);
            if (req.isCancelled()) continue;
            req.cancel();
        }
    }

    public void failed() {
        for (int i = this.current_request_index; i < this.requests.size(); ++i) {
            PeerReadRequest request2 = this.requests.get(i);
            this.reader.informFailed(request2);
        }
    }

    @Override
    public void setBufferPosition(int pos) {
        this.current_position = pos;
    }

    @Override
    public int getBufferPosition() {
        return this.current_position;
    }

    @Override
    public int getBufferLength() {
        return this.current_buffer.length;
    }

    public int getPercentDoneOfCurrentIncomingRequest() {
        PeerReadRequest req = this.current_request;
        if (req == null) {
            return 0;
        }
        return 100 * this.current_position / req.getLength();
    }

    @Override
    public int getPermittedBytes() throws ExternalSeedException {
        PeerReadRequest req = this.current_request;
        if (req == null) {
            req = this.requests.get(0);
        }
        if (req.isCancelled()) {
            throw new ExternalSeedException("Request cancelled");
        }
        return this.reader.getPermittedBytes();
    }

    @Override
    public int getPermittedTime() {
        return 0;
    }

    @Override
    public void reportBytesRead(int num) {
        this.reader.reportBytesRead(num);
    }
}

