/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.dht.impl;

import com.aelitis.azureus.core.dht.nat.DHTNATPuncher;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginProgressListener;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginImpl;
import java.net.InetSocketAddress;
import java.util.Map;

public class DHTPluginContactImpl
implements DHTPluginContact {
    private DHTPluginImpl plugin;
    private DHTTransportContact contact;

    protected DHTPluginContactImpl(DHTPluginImpl _plugin, DHTTransportContact _contact) {
        this.plugin = _plugin;
        this.contact = _contact;
    }

    public DHTPluginImpl getDHT() {
        return this.plugin;
    }

    protected DHTTransportContact getContact() {
        return this.contact;
    }

    @Override
    public byte[] getID() {
        return this.contact.getID();
    }

    @Override
    public String getName() {
        return this.contact.getName();
    }

    @Override
    public int getNetwork() {
        return this.plugin.getDHT().getTransport().getNetwork();
    }

    @Override
    public byte getProtocolVersion() {
        return this.contact.getProtocolVersion();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.contact.getAddress();
    }

    @Override
    public Map<String, Object> exportToMap() {
        return this.contact.exportContactToMap();
    }

    @Override
    public boolean isAlive(long timeout) {
        return this.contact.isAlive(timeout);
    }

    @Override
    public void isAlive(long timeout, final DHTPluginOperationListener listener) {
        this.contact.isAlive(new DHTTransportReplyHandlerAdapter(){

            @Override
            public void pingReply(DHTTransportContact contact) {
                listener.complete(null, false);
            }

            @Override
            public void failed(DHTTransportContact contact, Throwable error) {
                listener.complete(null, true);
            }
        }, timeout);
    }

    @Override
    public boolean isOrHasBeenLocal() {
        return this.plugin.isRecentAddress(this.contact.getAddress().getAddress().getHostAddress());
    }

    @Override
    public Map openTunnel() {
        DHTNATPuncher puncher = this.plugin.getDHT().getNATPuncher();
        if (puncher == null) {
            return null;
        }
        return puncher.punch("Tunnel", this.contact, null, null);
    }

    public Map openTunnel(DHTPluginContact[] rendezvous, Map client_data) {
        DHTNATPuncher puncher = this.plugin.getDHT().getNATPuncher();
        if (puncher == null) {
            return null;
        }
        if (rendezvous == null || rendezvous.length == 0) {
            return puncher.punch("Tunnel", this.contact, null, client_data);
        }
        DHTTransportContact[] r = new DHTTransportContact[rendezvous.length];
        for (int i = 0; i < r.length; ++i) {
            r[0] = ((DHTPluginContactImpl)rendezvous[i]).contact;
        }
        Map result = puncher.punch("Tunnel", this.contact, r, client_data);
        DHTTransportContact used = r[0];
        if (used != null) {
            rendezvous[0] = new DHTPluginContactImpl(this.plugin, used);
        }
        return result;
    }

    @Override
    public byte[] read(DHTPluginProgressListener listener, byte[] handler_key, byte[] key, long timeout) {
        return this.plugin.read(listener, this, handler_key, key, timeout);
    }

    @Override
    public void write(DHTPluginProgressListener listener, byte[] handler_key, byte[] key, byte[] data, long timeout) {
        this.plugin.write(listener, this, handler_key, key, data, timeout);
    }

    @Override
    public byte[] call(DHTPluginProgressListener listener, byte[] handler_key, byte[] data, long timeout) {
        return this.plugin.call(listener, this, handler_key, data, timeout);
    }

    @Override
    public String getString() {
        return this.contact.getString();
    }
}

