/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.dns;

import com.aelitis.azureus.core.util.DNSUtils;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.gudy.azureus2.core3.util.Debug;

public class DNSUtilsImpl
implements DNSUtils.DNSUtilsIntf {
    private static final Map<String, String> test_records = new HashMap<String, String>();

    private static String getFactory() {
        return System.getProperty("azureus.dns.context.factory", "com.sun.jndi.dns.DnsContextFactory");
    }

    @Override
    public DNSDirContextImpl getInitialDirContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", DNSUtilsImpl.getFactory());
        return new DNSDirContextImpl(new InitialDirContext(env));
    }

    @Override
    public DNSDirContextImpl getDirContextForServer(String dns_server_ip) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", DNSUtilsImpl.getFactory());
        env.put("java.naming.provider.url", "dns://" + dns_server_ip + "/");
        return new DNSDirContextImpl(new InitialDirContext(env));
    }

    @Override
    public Inet6Address getIPV6ByName(String host) throws UnknownHostException {
        List<Inet6Address> all = this.getAllIPV6ByName(host);
        return all.get(0);
    }

    public List<Inet6Address> getAllIPV6ByName(String host) throws UnknownHostException {
        ArrayList<Inet6Address> result = new ArrayList<Inet6Address>();
        try {
            Attribute attr;
            DirContext context2 = this.getInitialDirContext().ctx;
            Attributes attrs = context2.getAttributes(host, new String[]{"AAAA"});
            if (attrs != null && (attr = attrs.get("aaaa")) != null) {
                NamingEnumeration<?> values = attr.getAll();
                while (values.hasMore()) {
                    Object value = values.next();
                    if (!(value instanceof String)) continue;
                    try {
                        result.add((Inet6Address)InetAddress.getByName((String)value));
                    }
                    catch (Throwable e) {}
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (result.size() > 0) {
            return result;
        }
        throw new UnknownHostException(host);
    }

    @Override
    public List<InetAddress> getAllByName(String host) throws UnknownHostException {
        try {
            return this.getAllByName(this.getInitialDirContext(), host);
        }
        catch (NamingException e) {
            throw new UnknownHostException(host);
        }
    }

    @Override
    public List<InetAddress> getAllByName(DNSUtils.DNSDirContext context2, String host) throws UnknownHostException {
        System.out.println("Lookup for " + host);
        ArrayList<InetAddress> result = new ArrayList<InetAddress>();
        try {
            String[] attributes = new String[]{"A", "AAAA"};
            Attributes attrs = ((DNSDirContextImpl)context2).ctx.getAttributes(host, attributes);
            if (attrs != null) {
                for (String a : attributes) {
                    Attribute attr = attrs.get(a);
                    if (attr == null) continue;
                    NamingEnumeration<?> values = attr.getAll();
                    while (values.hasMore()) {
                        Object value = values.next();
                        if (!(value instanceof String)) continue;
                        try {
                            result.add(InetAddress.getByName((String)value));
                        }
                        catch (Throwable e) {}
                    }
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (result.size() > 0) {
            return result;
        }
        throw new UnknownHostException(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTXTRecords(String query) {
        ArrayList<String> result = new ArrayList<String>();
        String test_reply = test_records.get(query);
        if (test_reply != null) {
            result.add(test_reply);
            return result;
        }
        DirContext context2 = null;
        try {
            context2 = this.getInitialDirContext().ctx;
            Attributes attrs = context2.getAttributes(query, new String[]{"TXT"});
            NamingEnumeration<? extends Attribute> n_enum = attrs.getAll();
            while (n_enum.hasMoreElements()) {
                Attribute attr = n_enum.next();
                NamingEnumeration<?> n_enum2 = attr.getAll();
                while (n_enum2.hasMoreElements()) {
                    String attribute = (String)n_enum2.nextElement();
                    if (attribute == null) continue;
                    if ((attribute = attribute.trim()).startsWith("\"")) {
                        attribute = attribute.substring(1);
                    }
                    if (attribute.endsWith("\"")) {
                        attribute = attribute.substring(0, attribute.length() - 1);
                    }
                    if (attribute.length() <= 0) continue;
                    result.add(attribute);
                }
            }
        }
        catch (Throwable e) {
        }
        finally {
            if (context2 != null) {
                try {
                    context2.close();
                }
                catch (Throwable e) {}
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getTXTRecord(String query) throws UnknownHostException {
        DirContext context2 = null;
        try {
            context2 = this.getInitialDirContext().ctx;
            Attributes attrs = context2.getAttributes(query, new String[]{"TXT"});
            NamingEnumeration<? extends Attribute> n_enum = attrs.getAll();
            block10: while (true) {
                if (!n_enum.hasMoreElements()) throw new UnknownHostException("DNS query returned no results");
                Attribute attr = n_enum.next();
                NamingEnumeration<?> n_enum2 = attr.getAll();
                while (true) {
                    if (!n_enum2.hasMoreElements()) continue block10;
                    String attribute = (String)n_enum2.nextElement();
                    if (attribute != null) {
                        if ((attribute = attribute.trim()).startsWith("\"")) {
                            attribute = attribute.substring(1);
                        }
                        if (attribute.endsWith("\"")) {
                            attribute = attribute.substring(0, attribute.length() - 1);
                        }
                        if (attribute.length() > 0) {
                            String string = attribute;
                            return string;
                        }
                    }
                    continue;
                    break;
                }
                break;
            }
        }
        catch (Throwable e) {
            throw new UnknownHostException("DNS query failed:" + Debug.getNestedExceptionMessage(e));
        }
        finally {
            if (context2 != null) {
                try {
                    context2.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    public static void main(String[] args) {
        try {
            DNSUtilsImpl impl = new DNSUtilsImpl();
            DNSDirContextImpl ctx = impl.getDirContextForServer("8.8.4.4");
            System.out.println(impl.getAllByName(ctx, "www.google.com"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        test_records.put("test1.test.null", "BITTORRENT DENY ALL");
        test_records.put("test2.test.null", "BITTORRENT");
        test_records.put("test3.test.null", "BITTORRENT TCP:1 TCP:2 UDP:1 UDP:2");
        test_records.put("test4.test.null", "BITTORRENT TCP:3");
        test_records.put("test5.test.null", "BITTORRENT UDP:4");
    }

    public static class DNSDirContextImpl
    implements DNSUtils.DNSDirContext {
        final DirContext ctx;

        private DNSDirContextImpl(DirContext _ctx) {
            this.ctx = _ctx;
        }

        @Override
        public String getString() {
            try {
                return String.valueOf(this.ctx.getEnvironment());
            }
            catch (Throwable e) {
                return Debug.getNestedExceptionMessage(e);
            }
        }
    }
}

