/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.average;

import com.aelitis.azureus.core.util.average.Average;

public class MovingAverage
implements Average {
    private final int periods;
    private double[] data;
    private int pos = 0;
    private double total;

    public MovingAverage(int periods) {
        this.periods = periods;
        this.reset();
    }

    @Override
    public void reset() {
        this.pos = 0;
        this.total = 0.0;
        this.data = new double[this.periods];
    }

    @Override
    public double update(double newValue) {
        this.total -= this.data[this.pos];
        this.total += newValue;
        this.data[this.pos] = newValue;
        ++this.pos;
        if (this.pos == this.periods) {
            this.pos = 0;
        }
        return this.calculateAve();
    }

    @Override
    public double getAverage() {
        return this.calculateAve();
    }

    private double calculateAve() {
        if (this.pos == 0) {
            double sum = 0.0;
            for (int i = 0; i < this.periods; ++i) {
                sum += this.data[i];
            }
            this.total = sum;
        }
        return this.total / (double)this.periods;
    }
}

