/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.average;

import com.aelitis.azureus.core.util.GeneralUtils;
import com.aelitis.azureus.core.util.average.ExponentialMovingAverage;
import com.aelitis.azureus.core.util.average.MovingAverage;
import com.aelitis.azureus.core.util.average.MovingImmediateAverage;
import com.aelitis.azureus.core.util.average.RunningAverage;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;

public abstract class AverageFactory {
    public static RunningAverage RunningAverage() {
        return new RunningAverage();
    }

    public static MovingAverage MovingAverage(int periods) {
        return new MovingAverage(periods);
    }

    public static MovingImmediateAverage MovingImmediateAverage(int periods) {
        return new MovingImmediateAverage(periods);
    }

    public static ExponentialMovingAverage ExponentialMovingAverage(int periods) {
        return new ExponentialMovingAverage(periods);
    }

    public static ExponentialMovingAverage ExponentialMovingAverage(float weight) {
        return new ExponentialMovingAverage(weight);
    }

    public static <T> long LazySmoothMovingImmediateAverage(LazyMovingImmediateAverageAdapter<T> adapter, T instance) {
        int update_window = GeneralUtils.getSmoothUpdateWindow();
        int update_interval = GeneralUtils.getSmoothUpdateInterval();
        return AverageFactory.LazyMovingImmediateAverage(update_window / update_interval, update_interval, adapter, instance);
    }

    public static <T> long LazyMovingImmediateAverage(final int periods, final int interval_secs, final LazyMovingImmediateAverageAdapter<T> adapter, final T instance) {
        LazyMovingImmediateAverageState current = adapter.getCurrent(instance);
        if (current == null) {
            final LazyMovingImmediateAverageState state = current = new LazyMovingImmediateAverageState();
            SimpleTimer.addTickReceiver(new SimpleTimer.TimerTickReceiver(){

                @Override
                public void tick(long mono_now, int tick_count) {
                    long now = SystemTime.getMonotonousTime();
                    if (now - state.last_read > 60000L) {
                        SimpleTimer.removeTickReceiver(this);
                        adapter.setCurrent(instance, null);
                    } else if (tick_count % interval_secs == 0) {
                        long value = adapter.getValue(instance);
                        long last = state.last_value;
                        long diff = value - last;
                        if (last >= 0L && diff >= 0L) {
                            long ave;
                            MovingImmediateAverage average = state.average;
                            if (diff == 0L) {
                                state.consec_zeros++;
                            } else {
                                state.consec_zeros = 0;
                            }
                            if (average == null && diff > 0L) {
                                average = AverageFactory.MovingImmediateAverage(periods);
                                state.average = average;
                                int zeros_to_do = Math.min(state.consec_zeros, periods);
                                for (int i = 0; i < zeros_to_do; ++i) {
                                    average.update(0.0);
                                }
                            }
                            if (average != null && (ave = (long)average.update(diff)) == 0L && average.getSampleCount() >= periods) {
                                state.average = null;
                            }
                        }
                        state.last_value = value;
                    }
                }
            });
            adapter.setCurrent(instance, current);
        } else {
            current.last_read = SystemTime.getMonotonousTime();
        }
        MovingImmediateAverage average = current.average;
        if (average == null) {
            return 0L;
        }
        return (long)average.getAverage() / (long)interval_secs;
    }

    public static interface LazyMovingImmediateAverageAdapter<T> {
        public LazyMovingImmediateAverageState getCurrent(T var1);

        public void setCurrent(T var1, LazyMovingImmediateAverageState var2);

        public long getValue(T var1);
    }

    public static class LazyMovingImmediateAverageState {
        private MovingImmediateAverage average;
        private int consec_zeros;
        private long last_value = -1L;
        private long last_read = SystemTime.getMonotonousTime();
    }
}

