/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.Debug;

public class RegExUtil {
    private static final ThreadLocal<Map<String, Object[]>> tls = new ThreadLocal<Map<String, Object[]>>(){

        @Override
        public Map<String, Object[]> initialValue() {
            return new HashMap<String, Object[]>();
        }
    };

    public static Pattern getCachedPattern(String namespace, String pattern) {
        return RegExUtil.getCachedPattern(namespace, pattern, 0);
    }

    public static Pattern getCachedPattern(String namespace, String pattern, int flags) {
        Map<String, Object[]> map = tls.get();
        Object[] entry = map.get(namespace);
        if (entry == null || !pattern.equals((String)entry[0])) {
            Pattern result = Pattern.compile(pattern, flags);
            map.put(namespace, new Object[]{pattern, result});
            return result;
        }
        return (Pattern)entry[1];
    }

    public static boolean mightBeEvil(String str) {
        if (!str.contains(")")) {
            return false;
        }
        char[] chars = str.toCharArray();
        Stack<Integer> stack = new Stack<Integer>();
        for (int i = 0; i < chars.length; ++i) {
            char next;
            char c = chars[i];
            if (c == '(') {
                stack.push(i + 1);
                continue;
            }
            if (c != ')') continue;
            if (stack.isEmpty()) {
                Debug.out("bracket un-matched in " + str + " - treating as evil");
                return true;
            }
            int start = (Integer)stack.pop();
            if (i >= chars.length - 1 || (next = chars[i + 1]) != '*' && next != '+' && next != '{') continue;
            for (int j = start; j < i; ++j) {
                c = chars[j];
                if ("+*{|".indexOf(c) == -1) continue;
                Debug.out("regular expression " + str + " might be evil due to '" + str.substring(start - 1, i + 2) + "'");
                return true;
            }
        }
        return false;
    }
}

