/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class NetUtils {
    private static final int MIN_NI_CHECK_MILLIS = 30000;
    private static final int INC1_NI_CHECK_MILLIS = 120000;
    private static final int INC2_NI_CHECK_MILLIS = 900000;
    private static int current_check_millis = 30000;
    private static long last_ni_check = -1L;
    private static volatile List<NetworkInterface> current_interfaces = new ArrayList<NetworkInterface>();
    private static boolean first_check = true;
    private static boolean check_in_progress;
    static final AESemaphore ni_sem;
    private static final Map<Object, Object[]> host_or_address_map;
    private static final Object RESULT_NULL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<NetworkInterface> getNetworkInterfaces() throws SocketException {
        long now = SystemTime.getMonotonousTime();
        boolean do_check = false;
        boolean is_first = false;
        Class<NetUtils> clazz = NetUtils.class;
        synchronized (NetUtils.class) {
            if (!(check_in_progress || last_ni_check >= 0L && now - last_ni_check <= (long)current_check_millis)) {
                do_check = true;
                check_in_progress = true;
                if (first_check) {
                    first_check = false;
                    is_first = true;
                }
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (do_check) {
                final UtilitiesImpl.runnableWithException<SocketException> do_it = new UtilitiesImpl.runnableWithException<SocketException>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() throws SocketException {
                        ArrayList result = new ArrayList();
                        try {
                            long start = SystemTime.getHighPrecisionCounter();
                            Enumeration nis = NetUtils.NetworkInterface_getNetworkInterfaces();
                            long elapsed_millis = (SystemTime.getHighPrecisionCounter() - start) / 1000000L;
                            long old_period = current_check_millis;
                            if (elapsed_millis > (long)(Constants.isAndroid ? 5000 : 1000) && current_check_millis < 900000) {
                                current_check_millis = 900000;
                            } else if (elapsed_millis > (long)(Constants.isAndroid ? 1000 : 250) && current_check_millis < 120000) {
                                current_check_millis = 120000;
                            }
                            if (old_period != (long)current_check_millis) {
                                Debug.out("Network interface enumeration took " + elapsed_millis + ": decreased refresh frequency to " + current_check_millis + "ms");
                            }
                            if (nis != null) {
                                while (nis.hasMoreElements()) {
                                    result.add(nis.nextElement());
                                }
                            }
                        }
                        finally {
                            Class<NetUtils> clazz = NetUtils.class;
                            synchronized (NetUtils.class) {
                                check_in_progress = false;
                                current_interfaces = result;
                                last_ni_check = SystemTime.getMonotonousTime();
                                // ** MonitorExit[var2_3] (shouldn't be in output)
                                ni_sem.releaseForever();
                            }
                        }
                    }
                };
                if (is_first) {
                    final AESemaphore do_it_sem = new AESemaphore("getNIs");
                    final SocketException[] error = new SocketException[]{null};
                    new AEThread2("getNIAsync"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                do_it.run();
                            }
                            catch (SocketException e) {
                                error[0] = e;
                            }
                            finally {
                                do_it_sem.release();
                            }
                        }
                    }.start();
                    if (!do_it_sem.reserve(15000L)) {
                        Debug.out("Timeout obtaining network interfaces");
                        ni_sem.releaseForever();
                    } else if (error[0] != null) {
                        throw error[0];
                    }
                } else {
                    do_it.run();
                }
            }
            ni_sem.reserve();
            return current_interfaces;
        }
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Throwable e) {
            try {
                List<NetworkInterface> nis = NetUtils.getNetworkInterfaces();
                for (NetworkInterface ni : nis) {
                    Enumeration<InetAddress> addresses = ni.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (address.isLoopbackAddress() || address instanceof Inet6Address) continue;
                        return address;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return InetAddress.getByName("127.0.0.1");
        }
    }

    public static NetworkInterface getByName(String name) throws SocketException {
        return NetUtils.getBySupport(name);
    }

    public static NetworkInterface getByInetAddress(InetAddress addr) throws SocketException {
        return NetUtils.getBySupport(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NetworkInterface getBySupport(Object name_or_address) throws SocketException {
        Object[] objectArray = host_or_address_map;
        synchronized (host_or_address_map) {
            Object[] entry = host_or_address_map.get(name_or_address);
            if (entry != null) {
                Object[] objectArray2 = entry;
                synchronized (entry) {
                    long now = SystemTime.getMonotonousTime();
                    Object result_or_error = entry[0];
                    if (result_or_error != null) {
                        if ((Long)entry[1] > now) {
                            if (result_or_error == RESULT_NULL) {
                                // ** MonitorExit[var3_3] (shouldn't be in output)
                                // ** MonitorExit[var2_1] (shouldn't be in output)
                                return null;
                            }
                            if (result_or_error instanceof NetworkInterface) {
                                // ** MonitorExit[var3_3] (shouldn't be in output)
                                // ** MonitorExit[var2_1] (shouldn't be in output)
                                return (NetworkInterface)result_or_error;
                            }
                            throw (SocketException)result_or_error;
                        }
                        entry[0] = null;
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            } else {
                entry = new Object[2];
                host_or_address_map.put(name_or_address, entry);
            }
            {
                // ** MonitorExit[var2_1] (shouldn't be in output)
            }
            {
                objectArray = entry;
                synchronized (entry) {
                    Object result_or_error = entry[0];
                    if (result_or_error != null) {
                        if (result_or_error == RESULT_NULL) {
                            // ** MonitorExit[var2_1] (shouldn't be in output)
                            return null;
                        }
                        if (result_or_error instanceof NetworkInterface) {
                            // ** MonitorExit[var2_1] (shouldn't be in output)
                            return (NetworkInterface)result_or_error;
                        }
                        throw (SocketException)result_or_error;
                    }
                    long start = SystemTime.getHighPrecisionCounter();
                    Object result = null;
                    SocketException error = null;
                    try {
                        result = name_or_address instanceof String ? NetworkInterface.getByName((String)name_or_address) : NetworkInterface.getByInetAddress((InetAddress)name_or_address);
                        if (result == null) {
                            result = RESULT_NULL;
                        }
                    }
                    catch (SocketException e) {
                        error = e;
                    }
                    long elapsed = (SystemTime.getHighPrecisionCounter() - start) / 1000000L;
                    entry[0] = result == null ? error : result;
                    long delay = 250L * elapsed;
                    if (delay > 300000L) {
                        delay = 300000L;
                    }
                    entry[1] = SystemTime.getMonotonousTime() + delay;
                    if (error != null) {
                        throw error;
                    }
                    if (result == RESULT_NULL) {
                        // ** MonitorExit[var2_1] (shouldn't be in output)
                        return null;
                    }
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    return (NetworkInterface)result;
                }
            }
        }
    }

    private static Enumeration<NetworkInterface> NetworkInterface_getNetworkInterfaces() throws SocketException {
        try {
            return NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            String[] commonNames;
            SocketException se = e;
            try {
                Method mGetByIndex = NetworkInterface.class.getDeclaredMethod("getByIndex", Integer.TYPE);
                ArrayList<NetworkInterface> list = new ArrayList<NetworkInterface>();
                int i = 0;
                while (true) {
                    NetworkInterface nif = null;
                    try {
                        nif = (NetworkInterface)mGetByIndex.invoke(null, i);
                    }
                    catch (IllegalAccessException e2) {
                        break;
                    }
                    catch (InvocationTargetException ignore) {
                        // empty catch block
                    }
                    if (nif != null) {
                        list.add(nif);
                    } else if (i > 0) break;
                    ++i;
                }
                if (list.size() > 0) {
                    return Collections.enumeration(list);
                }
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
            ArrayList<NetworkInterface> list = new ArrayList<NetworkInterface>();
            for (String commonName : commonNames = new String[]{"lo", "eth", "lan", "wlan", "en", "p2p", "net", "ppp"}) {
                try {
                    NetworkInterface nif = NetworkInterface.getByName(commonName);
                    if (nif != null) {
                        list.add(nif);
                    }
                    int i = 0;
                    while ((nif = NetworkInterface.getByName(commonName + i)) != null) {
                        list.add(nif);
                        ++i;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            if (list.size() > 0) {
                return Collections.enumeration(list);
            }
            throw se;
        }
    }

    static {
        ni_sem = new AESemaphore("NetUtils:ni");
        host_or_address_map = new HashMap<Object, Object[]>();
        RESULT_NULL = new Object();
    }
}

