/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import com.aelitis.azureus.core.util.average.AverageFactory;
import com.aelitis.azureus.core.util.average.MovingImmediateAverage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.Constants;

public class GeneralUtils {
    private static final String REGEX_URLHTML = "<A HREF=\"(.+?)\">(.+?)</A>";
    private static int SMOOTHING_UPDATE_WINDOW = 60;
    private static int SMOOTHING_UPDATE_INTERVAL = 1;

    public static String replaceAll(String str, String from_str, String replacement) {
        StringBuffer res = null;
        int pos = 0;
        while (true) {
            int p1;
            if ((p1 = str.indexOf(from_str, pos)) == -1) {
                if (res == null) {
                    return str;
                }
                res.append(str.substring(pos));
                return res.toString();
            }
            if (res == null) {
                res = new StringBuffer(str.length() * 2);
            }
            if (p1 > pos) {
                res.append(str.substring(pos, p1));
            }
            res.append(replacement);
            pos = p1 + from_str.length();
        }
    }

    public static String replaceAll(String str, String[] from_strs, String[] to_strs) {
        StringBuffer res = null;
        int pos = 0;
        while (true) {
            int min_match_pos = Integer.MAX_VALUE;
            int match_index = -1;
            for (int i = 0; i < from_strs.length; ++i) {
                int pt = str.indexOf(from_strs[i], pos);
                if (pt == -1 || pt >= min_match_pos) continue;
                min_match_pos = pt;
                match_index = i;
            }
            if (match_index == -1) {
                if (res == null) {
                    return str;
                }
                res.append(str.substring(pos));
                return res.toString();
            }
            if (res == null) {
                res = new StringBuffer(str.length() * 2);
            }
            if (min_match_pos > pos) {
                res.append(str.substring(pos, min_match_pos));
            }
            res.append(to_strs[match_index]);
            pos = min_match_pos + from_strs[match_index].length();
        }
    }

    public static String stripOutHyperlinks(String message) {
        return Pattern.compile(REGEX_URLHTML, 2).matcher(message).replaceAll("$2");
    }

    public static String[] splitQuotedTokens(String str) {
        ArrayList<String> bits = new ArrayList<String>();
        char quote = ' ';
        boolean escape = false;
        boolean bit_contains_quotes = false;
        String bit = "";
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isWhitespace(c)) {
                c = ' ';
            }
            if (escape) {
                bit = bit + c;
                escape = false;
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c == '\"' || c == '\'' && (i == 0 || chars[i - 1] != '\\')) {
                if (quote == ' ') {
                    bit_contains_quotes = true;
                    quote = c;
                    continue;
                }
                if (quote == c) {
                    quote = ' ';
                    continue;
                }
                bit = bit + c;
                continue;
            }
            if (quote == ' ') {
                if (c == ' ') {
                    if (bit.length() <= 0 && !bit_contains_quotes) continue;
                    bit_contains_quotes = false;
                    bits.add(bit);
                    bit = "";
                    continue;
                }
                bit = bit + c;
                continue;
            }
            bit = bit + c;
        }
        if (quote != ' ') {
            bit = bit + quote;
        }
        if (bit.length() > 0 || bit_contains_quotes) {
            bits.add(bit);
        }
        return bits.toArray(new String[bits.size()]);
    }

    public static ProcessBuilder createProcessBuilder(File workingDir, String[] cmd, String[] extra_env) throws IOException {
        HashMap<String, String> newEnv = new HashMap<String, String>();
        newEnv.putAll(System.getenv());
        newEnv.put("LANG", "C.UTF-8");
        if (extra_env != null && extra_env.length > 1) {
            for (int i = 1; i < extra_env.length; i += 2) {
                newEnv.put(extra_env[i - 1], extra_env[i]);
            }
        }
        if (Constants.isWindows) {
            String[] i18n = new String[cmd.length + 2];
            i18n[0] = "cmd";
            i18n[1] = "/C";
            i18n[2] = GeneralUtils.escapeDosCmd(cmd[0]);
            for (int counter = 1; counter < cmd.length; ++counter) {
                if (cmd[counter].length() == 0) {
                    i18n[counter + 2] = "";
                    continue;
                }
                String envName = "JENV_" + counter;
                i18n[counter + 2] = "%" + envName + "%";
                newEnv.put(envName, cmd[counter]);
            }
            cmd = i18n;
        }
        ProcessBuilder pb = new ProcessBuilder(cmd);
        Map<String, String> env = pb.environment();
        env.putAll(newEnv);
        if (workingDir != null) {
            pb.directory(workingDir);
        }
        return pb;
    }

    private static String escapeDosCmd(String string) {
        String s = string.replaceAll("([&%^])", "^$1");
        s = s.replaceAll("'", "\"'\"");
        return s;
    }

    public static int getSmoothUpdateWindow() {
        return SMOOTHING_UPDATE_WINDOW;
    }

    public static int getSmoothUpdateInterval() {
        return SMOOTHING_UPDATE_INTERVAL;
    }

    public static MovingImmediateAverage getSmoothAverage() {
        return AverageFactory.MovingImmediateAverage(SMOOTHING_UPDATE_WINDOW / SMOOTHING_UPDATE_INTERVAL);
    }

    public static String stringJoin(Collection list, String delim) {
        StringBuilder sb = new StringBuilder();
        for (Object s : list) {
            if (s == null) continue;
            if (sb.length() > 0) {
                sb.append(delim);
            }
            sb.append(s.toString());
        }
        return sb.toString();
    }

    static {
        COConfigurationManager.addAndFireParameterListener("Stats Smoothing Secs", new ParameterListener(){

            @Override
            public void parameterChanged(String xxx) {
                SMOOTHING_UPDATE_WINDOW = COConfigurationManager.getIntParameter("Stats Smoothing Secs");
                if (SMOOTHING_UPDATE_WINDOW < 30) {
                    SMOOTHING_UPDATE_WINDOW = 30;
                } else if (SMOOTHING_UPDATE_WINDOW > 1800) {
                    SMOOTHING_UPDATE_WINDOW = 1800;
                }
                SMOOTHING_UPDATE_INTERVAL = SMOOTHING_UPDATE_WINDOW / 60;
                if (SMOOTHING_UPDATE_INTERVAL < 1) {
                    SMOOTHING_UPDATE_INTERVAL = 1;
                } else if (SMOOTHING_UPDATE_INTERVAL > 20) {
                    SMOOTHING_UPDATE_INTERVAL = 20;
                }
            }
        });
    }
}

