/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.gudy.azureus2.core3.util.Debug;

public class DNSUtils {
    private static DNSUtilsIntf impl;

    public static DNSUtilsIntf getSingleton() {
        return impl;
    }

    static {
        String cla = System.getProperty("az.factory.dnsutils.impl", "com.aelitis.azureus.core.util.dns.DNSUtilsImpl");
        try {
            impl = (DNSUtilsIntf)Class.forName(cla).newInstance();
        }
        catch (Throwable e) {
            Debug.out("Failed to instantiate impl: " + cla, e);
        }
    }

    public static interface DNSDirContext {
        public String getString();
    }

    public static interface DNSUtilsIntf {
        public DNSDirContext getInitialDirContext() throws Exception;

        public DNSDirContext getDirContextForServer(String var1) throws Exception;

        public Inet6Address getIPV6ByName(String var1) throws UnknownHostException;

        public List<InetAddress> getAllByName(String var1) throws UnknownHostException;

        public List<InetAddress> getAllByName(DNSDirContext var1, String var2) throws UnknownHostException;

        public List<String> getTXTRecords(String var1);

        public String getTXTRecord(String var1) throws UnknownHostException;
    }
}

