/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.tag.impl;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagDownload;
import com.aelitis.azureus.core.tag.TagFeatureProperties;
import com.aelitis.azureus.core.tag.TagFeatureRateLimit;
import com.aelitis.azureus.core.tag.TagListener;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.tag.impl.TagManagerImpl;
import com.aelitis.azureus.core.tag.impl.TagTypeBase;
import com.aelitis.azureus.core.tag.impl.TagWithState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class TagDownloadWithState
extends TagWithState
implements TagDownload {
    private int upload_rate_limit;
    private int download_rate_limit;
    private int upload_rate = -1;
    private int download_rate = -1;
    private int aggregate_sr;
    private long session_up;
    private long session_down;
    private long last_rate_update;
    final Object UPLOAD_PRIORITY_ADDED_KEY = new Object();
    private int upload_priority;
    private int min_share_ratio;
    private int max_share_ratio;
    private int max_share_ratio_action;
    private int max_aggregate_share_ratio;
    private int max_aggregate_share_ratio_action;
    private boolean max_aggregate_share_ratio_priority;
    private boolean supports_xcode;
    private boolean supports_file_location;
    final Object rate_lock = new Object();
    private final LimitedRateGroup upload_limiter = new LimitedRateGroup(){

        @Override
        public String getName() {
            String str = "tag_up: " + TagDownloadWithState.this.getTagName(true);
            if (TagDownloadWithState.this.upload_rate_limit < 0) {
                str = str + ": disabled";
            }
            return str;
        }

        @Override
        public int getRateLimitBytesPerSecond() {
            int res = TagDownloadWithState.this.upload_rate_limit;
            if (res < 0) {
                res = 0;
            }
            return res;
        }

        @Override
        public boolean isDisabled() {
            return TagDownloadWithState.this.upload_rate_limit < 0;
        }

        @Override
        public void updateBytesUsed(int used) {
            TagDownloadWithState.this.session_up += used;
        }
    };
    private final LimitedRateGroup download_limiter = new LimitedRateGroup(){

        @Override
        public String getName() {
            String str = "tag_down: " + TagDownloadWithState.this.getTagName(true);
            if (TagDownloadWithState.this.download_rate_limit < 0) {
                str = str + ": disabled";
            }
            return str;
        }

        @Override
        public int getRateLimitBytesPerSecond() {
            int res = TagDownloadWithState.this.download_rate_limit;
            if (res < 0) {
                res = 0;
            }
            return res;
        }

        @Override
        public boolean isDisabled() {
            return TagDownloadWithState.this.download_rate_limit < 0;
        }

        @Override
        public void updateBytesUsed(int used) {
            TagDownloadWithState.this.session_down += used;
        }
    };
    private boolean do_rates;
    private boolean do_up;
    private boolean do_down;
    private boolean do_bytes;
    private int run_states;
    private static final AsyncDispatcher rs_async = new AsyncDispatcher(2000);
    private final TagFeatureProperties.TagProperty[] tag_properties = new TagFeatureProperties.TagProperty[]{this.createTagProperty("trackers", 1), this.createTagProperty("untagged", 2), this.createTagProperty("tracker_templates", 1), this.createTagProperty("constraint", 1)};
    private final DownloadManagerPeerListener peer_listener = new DownloadManagerPeerListener(){

        @Override
        public void peerManagerWillBeAdded(PEPeerManager manager) {
        }

        @Override
        public void peerManagerAdded(PEPeerManager manager) {
        }

        @Override
        public void peerManagerRemoved(PEPeerManager manager) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void peerAdded(PEPeer peer) {
            Object object = TagDownloadWithState.this.rate_lock;
            synchronized (object) {
                if (TagDownloadWithState.this.upload_rate_limit < 0) {
                    peer.setUploadDisabled(this, true);
                }
                if (TagDownloadWithState.this.download_rate_limit < 0) {
                    peer.setDownloadDisabled(this, true);
                }
            }
        }

        @Override
        public void peerRemoved(PEPeer peer) {
        }
    };
    private static final boolean[] AUTO_BOTH = new boolean[]{true, true};
    private static final boolean[] AUTO_NONE = new boolean[]{false, false};

    public TagDownloadWithState(TagTypeBase tt, int tag_id, String name, boolean do_rates, boolean do_up, boolean do_down, boolean do_bytes, int run_states) {
        super(tt, tag_id, name);
        this.init(do_rates, do_up, do_down, do_bytes, run_states);
    }

    protected TagDownloadWithState(TagTypeBase tt, int tag_id, Map details, boolean do_rates, boolean do_up, boolean do_down, boolean do_bytes, int run_states) {
        super(tt, tag_id, details);
        this.init(do_rates, do_up, do_down, do_bytes, run_states);
    }

    private void init(boolean _do_rates, boolean _do_up, boolean _do_down, boolean _do_bytes, int _run_states) {
        this.do_rates = _do_rates;
        this.do_up = _do_up;
        this.do_down = _do_down;
        this.do_bytes = _do_bytes;
        this.run_states = _run_states;
        if (this.do_up) {
            this.setRateLimit(this.readLongAttribute("rl.up", 0L).intValue(), true);
        }
        if (this.do_down) {
            this.setRateLimit(this.readLongAttribute("rl.down", 0L).intValue(), false);
        }
        this.upload_priority = this.readLongAttribute("rl.uppri", 0L).intValue();
        this.min_share_ratio = this.readLongAttribute("rl.minsr", 0L).intValue();
        this.max_share_ratio = this.readLongAttribute("rl.maxsr", 0L).intValue();
        this.max_share_ratio_action = this.readLongAttribute("rl.maxsr.a", 0L).intValue();
        this.max_aggregate_share_ratio = this.readLongAttribute("rl.maxaggsr", 0L).intValue();
        this.max_aggregate_share_ratio_action = this.readLongAttribute("rl.maxaggsr.a", 1L).intValue();
        this.max_aggregate_share_ratio_priority = this.readBooleanAttribute("rl.maxaggsr.p", true);
        this.addTagListener(new TagListener(){

            @Override
            public void taggableAdded(Tag tag, Taggable tagged) {
                DownloadManager manager = (DownloadManager)tagged;
                TagDownloadWithState.this.setRateLimit(manager, true);
                if (TagDownloadWithState.this.upload_priority > 0) {
                    manager.updateAutoUploadPriority(TagDownloadWithState.this.UPLOAD_PRIORITY_ADDED_KEY, true);
                }
                if (TagDownloadWithState.this.min_share_ratio > 0) {
                    this.updateMinShareRatio(manager, TagDownloadWithState.this.min_share_ratio);
                }
                if (TagDownloadWithState.this.max_share_ratio > 0) {
                    this.updateMaxShareRatio(manager, TagDownloadWithState.this.max_share_ratio);
                }
            }

            @Override
            public void taggableSync(Tag tag) {
            }

            @Override
            public void taggableRemoved(Tag tag, Taggable tagged) {
                DownloadManager manager = (DownloadManager)tagged;
                TagDownloadWithState.this.setRateLimit(manager, false);
                if (TagDownloadWithState.this.upload_priority > 0) {
                    manager.updateAutoUploadPriority(TagDownloadWithState.this.UPLOAD_PRIORITY_ADDED_KEY, false);
                }
                if (TagDownloadWithState.this.min_share_ratio > 0) {
                    this.updateMinShareRatio(manager, 0);
                }
                if (TagDownloadWithState.this.max_share_ratio > 0) {
                    this.updateMaxShareRatio(manager, 0);
                }
            }

            private void updateMinShareRatio(DownloadManager manager, int sr) {
                List<Tag> dm_tags = TagDownloadWithState.this.getTagType().getTagsForTaggable(manager);
                for (Tag t : dm_tags) {
                    int o_sr;
                    if (t == TagDownloadWithState.this || !(t instanceof TagFeatureRateLimit) || (o_sr = ((TagFeatureRateLimit)((Object)t)).getTagMinShareRatio()) <= sr) continue;
                    sr = o_sr;
                }
                manager.getDownloadState().setIntParameter("sr.min", sr);
            }

            private void updateMaxShareRatio(DownloadManager manager, int sr) {
                List<Tag> dm_tags = TagDownloadWithState.this.getTagType().getTagsForTaggable(manager);
                for (Tag t : dm_tags) {
                    int o_sr;
                    if (t == TagDownloadWithState.this || !(t instanceof TagFeatureRateLimit) || (o_sr = ((TagFeatureRateLimit)((Object)t)).getTagMaxShareRatio()) <= sr) continue;
                    sr = o_sr;
                }
                manager.getDownloadState().setIntParameter("sr.max", sr);
            }
        }, true);
    }

    @Override
    public void removeTag() {
        for (DownloadManager dm : this.getTaggedDownloads()) {
            this.setRateLimit(dm, false);
            if (this.upload_priority <= 0) continue;
            dm.updateAutoUploadPriority(this.UPLOAD_PRIORITY_ADDED_KEY, false);
        }
        super.removeTag();
    }

    @Override
    public void addTaggable(Taggable t) {
        if (t instanceof DownloadManager) {
            final DownloadManager dm = (DownloadManager)t;
            if (!dm.isDestroyed()) {
                super.addTaggable(t);
                int actions = this.getSupportedActions();
                if (actions != 0) {
                    String script;
                    int dm_state;
                    if (this.isActionEnabled(2) || this.isActionEnabled(128)) {
                        dm_state = dm.getState();
                        if (dm_state == 70 || dm_state == 100) {
                            rs_async.dispatch(new AERunnable(){

                                @Override
                                public void runSupport() {
                                    if (TagDownloadWithState.this.isActionEnabled(2)) {
                                        dm.setStateQueued();
                                    } else {
                                        dm.resume();
                                    }
                                }
                            });
                        }
                    } else if ((this.isActionEnabled(4) || this.isActionEnabled(64)) && (dm_state = dm.getState()) != 70 && dm_state != 65 && dm_state != 100) {
                        rs_async.dispatch(new AERunnable(){

                            @Override
                            public void runSupport() {
                                if (TagDownloadWithState.this.isActionEnabled(4)) {
                                    dm.stopIt(70, false, false);
                                } else {
                                    dm.pause();
                                }
                            }
                        });
                    }
                    if (this.isActionEnabled(8)) {
                        rs_async.dispatch(new AERunnable(){

                            @Override
                            public void runSupport() {
                                dm.setForceStart(true);
                            }
                        });
                    } else if (this.isActionEnabled(16)) {
                        rs_async.dispatch(new AERunnable(){

                            @Override
                            public void runSupport() {
                                dm.setForceStart(false);
                            }
                        });
                    }
                    if (this.isActionEnabled(32) && (script = this.getActionScript()).length() > 0) {
                        rs_async.dispatch(new AERunnable(){

                            @Override
                            public void runSupport() {
                                TagManagerImpl.getSingleton().evalScript(TagDownloadWithState.this, script, dm, "execAssign");
                            }
                        });
                    }
                }
            }
        } else {
            Debug.out("Invalid Taggable added: " + t);
        }
    }

    @Override
    public int getTaggableTypes() {
        return 2;
    }

    @Override
    public Set<DownloadManager> getTaggedDownloads() {
        return this.getTagged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRateLimit(DownloadManager manager, boolean added) {
        Object object = this.rate_lock;
        synchronized (object) {
            if (added) {
                if (manager.getUserData(this.rate_lock) == null) {
                    manager.setUserData(this.rate_lock, "");
                    manager.addPeerListener(this.peer_listener, true);
                    manager.addRateLimiter(this.upload_limiter, true);
                    manager.addRateLimiter(this.download_limiter, false);
                }
            } else if (manager.getUserData(this.rate_lock) != null) {
                manager.setUserData(this.rate_lock, null);
                manager.removeRateLimiter(this.upload_limiter, true);
                manager.removeRateLimiter(this.download_limiter, false);
                manager.removePeerListener(this.peer_listener);
                PEPeerManager pm = manager.getPeerManager();
                if (pm != null) {
                    List<PEPeer> peers = pm.getPeers();
                    if (this.upload_rate_limit < 0 || this.download_rate_limit < 0) {
                        for (PEPeer peer : peers) {
                            if (this.upload_rate_limit < 0) {
                                peer.setUploadDisabled(this.peer_listener, false);
                            }
                            if (this.download_rate_limit >= 0) continue;
                            peer.setDownloadDisabled(this.peer_listener, false);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRateLimit(int limit, boolean is_up) {
        if (limit < 0) {
            limit = -1;
        }
        Object object = this.rate_lock;
        synchronized (object) {
            if (is_up) {
                if (limit == this.upload_rate_limit) {
                    return;
                }
                if (limit < 0 || this.upload_rate_limit < 0) {
                    Set<DownloadManager> downloads = this.getTaggedDownloads();
                    for (DownloadManager dm : downloads) {
                        PEPeerManager pm = dm.getPeerManager();
                        if (pm == null) continue;
                        List<PEPeer> peers = pm.getPeers();
                        for (PEPeer peer : peers) {
                            peer.setUploadDisabled(this.peer_listener, limit < 0);
                        }
                    }
                }
                this.upload_rate_limit = limit;
            } else {
                if (limit == this.download_rate_limit) {
                    return;
                }
                if (limit < 0 || this.download_rate_limit < 0) {
                    Set<DownloadManager> downloads = this.getTaggedDownloads();
                    for (DownloadManager dm : downloads) {
                        PEPeerManager pm = dm.getPeerManager();
                        if (pm == null) continue;
                        List<PEPeer> peers = pm.getPeers();
                        for (PEPeer peer : peers) {
                            peer.setDownloadDisabled(this.peer_listener, limit < 0);
                        }
                    }
                }
                this.download_rate_limit = limit;
            }
        }
    }

    @Override
    public boolean supportsTagRates() {
        return this.do_rates;
    }

    @Override
    public boolean supportsTagUploadLimit() {
        return this.do_up;
    }

    @Override
    public boolean supportsTagDownloadLimit() {
        return this.do_down;
    }

    @Override
    public int getTagUploadLimit() {
        return this.upload_rate_limit;
    }

    @Override
    public void setTagUploadLimit(int bps) {
        if (this.upload_rate_limit == bps) {
            return;
        }
        if (!this.do_up) {
            Debug.out("Not supported");
            return;
        }
        this.setRateLimit(bps, true);
        this.writeLongAttribute("rl.up", this.upload_rate_limit);
        this.getTagType().fireChanged(this);
    }

    @Override
    public int getTagCurrentUploadRate() {
        this.updateStuff();
        return this.upload_rate;
    }

    @Override
    public int getTagDownloadLimit() {
        return this.download_rate_limit;
    }

    @Override
    public void setTagDownloadLimit(int bps) {
        if (this.download_rate_limit == bps) {
            return;
        }
        if (!this.do_down) {
            Debug.out("Not supported");
            return;
        }
        this.setRateLimit(bps, false);
        this.writeLongAttribute("rl.down", this.download_rate_limit);
        this.getTagType().fireChanged(this);
    }

    @Override
    public int getTagCurrentDownloadRate() {
        this.updateStuff();
        return this.download_rate;
    }

    @Override
    public int getTagUploadPriority() {
        return this.upload_priority;
    }

    @Override
    protected long[] getTagSessionUploadTotalCurrent() {
        if (this.do_bytes && this.do_up) {
            return new long[]{this.session_up};
        }
        return null;
    }

    @Override
    protected long[] getTagSessionDownloadTotalCurrent() {
        if (this.do_bytes && this.do_down) {
            return new long[]{this.session_down};
        }
        return null;
    }

    @Override
    public void setTagUploadPriority(int priority) {
        if (priority < 0) {
            priority = 0;
        }
        if (priority == this.upload_priority) {
            return;
        }
        int old_up = this.upload_priority;
        this.upload_priority = priority;
        this.writeLongAttribute("rl.uppri", priority);
        if (old_up == 0 || priority == 0) {
            Set<DownloadManager> dms = this.getTaggedDownloads();
            for (DownloadManager dm : dms) {
                dm.updateAutoUploadPriority(this.UPLOAD_PRIORITY_ADDED_KEY, priority > 0);
            }
        }
        this.getTagType().fireChanged(this);
    }

    @Override
    public int getTagMinShareRatio() {
        return this.min_share_ratio;
    }

    @Override
    public void setTagMinShareRatio(int sr) {
        if (sr < 0) {
            sr = 0;
        }
        if (sr == this.min_share_ratio) {
            return;
        }
        this.min_share_ratio = sr;
        this.writeLongAttribute("rl.minsr", sr);
        Set<DownloadManager> dms = this.getTaggedDownloads();
        for (DownloadManager dm : dms) {
            List<Tag> dm_tags = this.getTagType().getTagsForTaggable(dm);
            for (Tag t : dm_tags) {
                int o_sr;
                if (t == this || !(t instanceof TagFeatureRateLimit) || (o_sr = ((TagFeatureRateLimit)((Object)t)).getTagMinShareRatio()) <= sr) continue;
                sr = o_sr;
            }
            dm.getDownloadState().setIntParameter("sr.min", sr);
        }
        this.getTagType().fireChanged(this);
    }

    @Override
    public int getTagMaxShareRatio() {
        return this.max_share_ratio;
    }

    @Override
    public void setTagMaxShareRatio(int sr) {
        if (sr < 0) {
            sr = 0;
        }
        if (sr == this.max_share_ratio) {
            return;
        }
        this.max_share_ratio = sr;
        this.writeLongAttribute("rl.maxsr", sr);
        Set<DownloadManager> dms = this.getTaggedDownloads();
        for (DownloadManager dm : dms) {
            List<Tag> dm_tags = this.getTagType().getTagsForTaggable(dm);
            for (Tag t : dm_tags) {
                int o_sr;
                if (t == this || !(t instanceof TagFeatureRateLimit) || (o_sr = ((TagFeatureRateLimit)((Object)t)).getTagMaxShareRatio()) <= sr) continue;
                sr = o_sr;
            }
            dm.getDownloadState().setIntParameter("sr.max", sr);
        }
        this.getTagType().fireChanged(this);
        this.checkIndividualShareRatio();
    }

    @Override
    public int getTagMaxShareRatioAction() {
        return this.max_share_ratio_action;
    }

    @Override
    public void setTagMaxShareRatioAction(int action) {
        if (action == this.max_share_ratio_action) {
            return;
        }
        this.max_share_ratio_action = action;
        this.writeLongAttribute("rl.maxsr.a", action);
        this.getTagType().fireChanged(this);
        this.checkIndividualShareRatio();
    }

    @Override
    public int getTagAggregateShareRatio() {
        this.updateStuff();
        return this.aggregate_sr;
    }

    @Override
    public int getTagMaxAggregateShareRatio() {
        return this.max_aggregate_share_ratio;
    }

    @Override
    public void setTagMaxAggregateShareRatio(int sr) {
        if (sr < 0) {
            sr = 0;
        }
        if (sr == this.max_aggregate_share_ratio) {
            return;
        }
        this.max_aggregate_share_ratio = sr;
        this.writeLongAttribute("rl.maxaggsr", sr);
        this.getTagType().fireChanged(this);
        this.checkAggregateShareRatio();
    }

    @Override
    public int getTagMaxAggregateShareRatioAction() {
        return this.max_aggregate_share_ratio_action;
    }

    @Override
    public void setTagMaxAggregateShareRatioAction(int action) {
        if (action == this.max_aggregate_share_ratio_action) {
            return;
        }
        this.max_aggregate_share_ratio_action = action;
        this.writeLongAttribute("rl.maxaggsr.a", action);
        this.getTagType().fireChanged(this);
        this.checkAggregateShareRatio();
    }

    @Override
    public boolean getTagMaxAggregateShareRatioHasPriority() {
        return this.max_aggregate_share_ratio_priority;
    }

    @Override
    public void setTagMaxAggregateShareRatioHasPriority(boolean priority) {
        if (priority == this.max_aggregate_share_ratio_priority) {
            return;
        }
        this.max_aggregate_share_ratio_priority = priority;
        this.writeBooleanAttribute("rl.maxaggsr.p", priority);
        this.getTagType().fireChanged(this);
        this.checkIndividualShareRatio();
        this.checkAggregateShareRatio();
    }

    private void updateStuff() {
        long now = SystemTime.getCurrentTime();
        if (now - this.last_rate_update > 2500L) {
            int new_up = 0;
            int new_down = 0;
            long new_agg_up = 0L;
            long new_agg_down = 0L;
            Set<DownloadManager> dms = this.getTaggedDownloads();
            if (dms.size() == 0) {
                new_up = -1;
                new_down = -1;
            } else {
                new_up = 0;
                new_down = 0;
                for (DownloadManager dm : dms) {
                    DownloadManagerStats stats2 = dm.getStats();
                    new_up = (int)((long)new_up + (stats2.getDataSendRate() + stats2.getProtocolSendRate()));
                    new_down = (int)((long)new_down + (stats2.getDataReceiveRate() + stats2.getProtocolReceiveRate()));
                    long downloaded = stats2.getTotalGoodDataBytesReceived();
                    long uploaded = stats2.getTotalDataBytesSent();
                    if (downloaded > 0L) {
                        new_agg_down += downloaded;
                    }
                    if (uploaded <= 0L) continue;
                    new_agg_up += uploaded;
                }
            }
            this.upload_rate = new_up;
            this.download_rate = new_down;
            this.aggregate_sr = new_agg_down <= 0L ? 0 : (int)(1000L * new_agg_up / new_agg_down);
            this.last_rate_update = now;
        }
    }

    private void checkIndividualShareRatio() {
        if (this.max_share_ratio <= 0) {
            return;
        }
        if (this.max_share_ratio_action == 0) {
            return;
        }
        if (this.max_aggregate_share_ratio_priority && this.max_aggregate_share_ratio > 0) {
            this.updateStuff();
            if (this.aggregate_sr < this.max_aggregate_share_ratio) {
                return;
            }
        }
        Set<DownloadManager> dms = this.getTaggedDownloads();
        HashSet<DownloadManager> to_action = new HashSet<DownloadManager>();
        for (DownloadManager dm : dms) {
            int sr;
            int state;
            if (!dm.isDownloadComplete(false) || dm.isForceStart() || (state = dm.getState()) != 75 && state != 60 || (sr = dm.getStats().getShareRatio()) < this.max_share_ratio) continue;
            to_action.add(dm);
        }
        if (to_action.size() > 0) {
            this.performOperation(this.max_share_ratio_action == 1 ? 2 : 1, to_action);
        }
    }

    private boolean isAggregateShareRatioMet() {
        if (this.max_aggregate_share_ratio == 0) {
            return true;
        }
        this.updateStuff();
        return this.aggregate_sr >= this.max_aggregate_share_ratio;
    }

    private void checkAggregateShareRatio() {
        if (this.max_aggregate_share_ratio > 0) {
            if (TorrentUtils.isTorrentDeleting() || TorrentUtils.getMillisecondsSinceLastTorrentDelete() < 10000L) {
                return;
            }
            this.updateStuff();
            if (this.aggregate_sr >= this.max_aggregate_share_ratio) {
                HashSet<DownloadManager> dms = new HashSet<DownloadManager>(this.getTaggedDownloads());
                Iterator it = dms.iterator();
                block0: while (it.hasNext()) {
                    int sr;
                    DownloadManager dm = (DownloadManager)it.next();
                    if (dm.isForceStart() || !dm.isDownloadComplete(false)) {
                        it.remove();
                        continue;
                    }
                    if (!this.max_aggregate_share_ratio_priority && this.max_share_ratio > 0 && (sr = dm.getStats().getShareRatio()) < this.max_share_ratio) {
                        it.remove();
                        continue;
                    }
                    List<Tag> all_tags = this.getTagType().getTagManager().getTagsForTaggable(dm);
                    for (Tag tag : all_tags) {
                        TagDownloadWithState other_tag;
                        if (tag == this || !(tag instanceof TagDownloadWithState) || (other_tag = (TagDownloadWithState)tag).isAggregateShareRatioMet()) continue;
                        it.remove();
                        continue block0;
                    }
                }
                this.performOperation(this.max_aggregate_share_ratio_action == 1 ? 2 : 1, dms);
            } else {
                this.performOperation(this.max_aggregate_share_ratio_action == 1 ? 4 : 8);
            }
        }
    }

    @Override
    protected void sync() {
        this.checkIndividualShareRatio();
        this.checkAggregateShareRatio();
        super.sync();
    }

    @Override
    public int getRunStateCapabilities() {
        return this.run_states;
    }

    @Override
    public boolean hasRunStateCapability(int capability) {
        return (this.run_states & capability) != 0;
    }

    @Override
    public boolean[] getPerformableOperations(int[] ops) {
        boolean[] result = new boolean[ops.length];
        Set<DownloadManager> dms = this.getTaggedDownloads();
        for (DownloadManager dm : dms) {
            int dm_state = dm.getState();
            for (int i = 0; i < ops.length; ++i) {
                if (result[i]) continue;
                int op = ops[i];
                if ((op & 8) != 0 && (dm_state == 70 || dm_state == 100)) {
                    result[i] = true;
                }
                if ((op & 1) != 0 && dm_state != 70 && dm_state != 65 && dm_state != 100) {
                    result[i] = true;
                }
                if ((op & 2) != 0 && dm_state != 70 && dm_state != 65 && dm_state != 100 && !dm.isPaused()) {
                    result[i] = true;
                }
                if ((op & 4) == 0 || !dm.isPaused()) continue;
                result[i] = true;
            }
        }
        return result;
    }

    @Override
    public void performOperation(int op) {
        Set<DownloadManager> dms = this.getTaggedDownloads();
        this.performOperation(op, dms);
    }

    private void performOperation(int op, Set<DownloadManager> dms) {
        for (final DownloadManager dm : dms) {
            int dm_state = dm.getState();
            if (op == 8) {
                if (dm_state != 70 && dm_state != 100) continue;
                rs_async.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        dm.setStateQueued();
                    }
                });
                continue;
            }
            if (op == 1) {
                if (dm_state == 70 || dm_state == 65 || dm_state == 100) continue;
                rs_async.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        dm.stopIt(70, false, false);
                    }
                });
                continue;
            }
            if (op == 2) {
                if (dm_state == 70 || dm_state == 65 || dm_state == 100) continue;
                rs_async.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        dm.pause();
                    }
                });
                continue;
            }
            if (op != 4 || !dm.isPaused()) continue;
            rs_async.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    dm.resume();
                }
            });
        }
    }

    @Override
    public int getSupportedActions() {
        if (this.getTagType().getTagType() == 3) {
            return 254;
        }
        if (this.getTagType().getTagType() == 2) {
            return 32;
        }
        return 0;
    }

    protected void setSupportsTagTranscode(boolean sup) {
        this.supports_xcode = sup;
    }

    @Override
    public boolean supportsTagTranscode() {
        return this.supports_xcode;
    }

    @Override
    public String[] getTagTranscodeTarget() {
        String temp = this.readStringAttribute("xcode.to", null);
        if (temp == null) {
            return null;
        }
        String[] bits = temp.split("\n");
        if (bits.length != 2) {
            return null;
        }
        return bits;
    }

    @Override
    public void setTagTranscodeTarget(String uid, String name) {
        this.writeStringAttribute("xcode.to", uid == null ? null : uid + "\n" + name);
        this.getTagType().fireChanged(this);
        this.getManager().featureChanged(this, 8);
    }

    protected void setSupportsFileLocation(boolean sup) {
        this.supports_file_location = sup;
    }

    @Override
    public boolean supportsTagInitialSaveFolder() {
        return this.supports_file_location;
    }

    @Override
    public boolean supportsTagMoveOnComplete() {
        return this.supports_file_location;
    }

    @Override
    public boolean supportsTagCopyOnComplete() {
        return this.supports_file_location;
    }

    @Override
    public TagFeatureProperties.TagProperty[] getSupportedProperties() {
        return this.getTagType().isTagTypeAuto() ? new TagFeatureProperties.TagProperty[]{} : this.tag_properties;
    }

    @Override
    public boolean[] isTagAuto() {
        TagFeatureProperties.TagProperty[] props;
        for (TagFeatureProperties.TagProperty prop : props = this.getSupportedProperties()) {
            String options;
            String[] vals;
            String name = prop.getName(false);
            if (name.equals("tracker_templates")) continue;
            int type = prop.getType();
            if (type == 2) {
                Boolean b = prop.getBoolean();
                if (b == null || !b.booleanValue()) continue;
                return AUTO_BOTH;
            }
            if (type == 3) {
                Long l = prop.getLong();
                if (l == null || l == Long.MIN_VALUE) continue;
                return AUTO_BOTH;
            }
            if (type != 1 || (vals = prop.getStringList()) == null || vals.length <= 0) continue;
            if (name.equals("constraint") && vals.length > 1 && (options = vals[1]) != null) {
                if (options.contains("am=1;")) {
                    return new boolean[]{true, false};
                }
                if (options.contains("am=2;")) {
                    return new boolean[]{false, true};
                }
            }
            return AUTO_BOTH;
        }
        return AUTO_NONE;
    }

    @Override
    public int getMaximumTaggables() {
        if (this.getTagType().getTagType() != 3) {
            return -1;
        }
        return super.getMaximumTaggables();
    }

    @Override
    protected void checkMaximumTaggables() {
        if (this.getTagType().getTagType() != 3) {
            return;
        }
        int max = this.getMaximumTaggables();
        if (max <= 0) {
            return;
        }
        int removal_strategy = this.getRemovalStrategy();
        if (removal_strategy == 0) {
            return;
        }
        if (this.getTaggedCount() > max) {
            Set<DownloadManager> dms = this.getTaggedDownloads();
            ArrayList<DownloadManager> sorted_dms = new ArrayList<DownloadManager>(dms);
            Collections.sort(sorted_dms, new Comparator<DownloadManager>(){

                @Override
                public int compare(DownloadManager dm1, DownloadManager dm2) {
                    long t2;
                    long t1 = dm1.getDownloadState().getLongParameter("stats.download.added.time");
                    if (t1 < (t2 = dm2.getDownloadState().getLongParameter("stats.download.added.time"))) {
                        return -1;
                    }
                    if (t1 > t2) {
                        return 1;
                    }
                    return dm1.getInternalName().compareTo(dm2.getInternalName());
                }
            });
            Iterator it = sorted_dms.iterator();
            while (it.hasNext() && sorted_dms.size() > max) {
                DownloadManager dm = (DownloadManager)it.next();
                if (dm.isPersistent()) {
                    it.remove();
                    try {
                        if (removal_strategy == 1) {
                            Download download = PluginCoreUtils.wrap(dm);
                            if (!download.canStubbify()) continue;
                            this.removeTaggable(dm);
                            download.stubbify();
                            continue;
                        }
                        if (removal_strategy == 2) {
                            dm.getGlobalManager().removeDownloadManager(dm, false, false);
                            continue;
                        }
                        if (removal_strategy == 3) {
                            boolean reallyDeleteData = !dm.getDownloadState().getFlag(64L);
                            dm.getGlobalManager().removeDownloadManager(dm, true, reallyDeleteData);
                            continue;
                        }
                        if (removal_strategy != 4) continue;
                        String old_tag = this.getTagName(true) + "_";
                        old_tag = Character.isUpperCase(old_tag.charAt(0)) ? old_tag + "Old" : old_tag + "old";
                        Tag ot = this.getTagType().getTag(old_tag, true);
                        if (ot == null) {
                            ot = this.getTagType().createTag(old_tag, true);
                        }
                        ot.addTaggable(dm);
                        this.removeTaggable(dm);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    continue;
                }
                Logger.log(new LogAlert(false, 1, "Non-persistent downloads (e.g. shares) can't be automatically deleted or archived. Maximum entries not enforced for Tag '" + this.getTagName(true) + "'"));
            }
        }
    }
}

