/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionDownloadListener;
import com.aelitis.azureus.core.subs.SubscriptionException;
import com.aelitis.azureus.core.subs.SubscriptionHistory;
import com.aelitis.azureus.core.subs.SubscriptionManagerListener;
import com.aelitis.azureus.core.subs.SubscriptionResult;
import com.aelitis.azureus.core.subs.SubscriptionScheduler;
import com.aelitis.azureus.core.subs.impl.SubscriptionDownloader;
import com.aelitis.azureus.core.subs.impl.SubscriptionImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionManagerImpl;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.UrlFilter;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.search.SearchProvider;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class SubscriptionSchedulerImpl
implements SubscriptionScheduler,
SubscriptionManagerListener {
    private static final Object SCHEDULER_NEXT_SCAN_KEY = new Object();
    private static final Object SCHEDULER_FAILED_SCAN_CONSEC_KEY = new Object();
    private static final Object SCHEDULER_FAILED_SCAN_TIME_KEY = new Object();
    private static final int FAIL_INIT_DELAY = 600000;
    private static final int FAIL_MAX_DELAY = 28800000;
    private SubscriptionManagerImpl manager;
    private Map active_subscription_downloaders = new HashMap();
    private boolean active_subs_download_is_auto;
    private Map<String, Long> rate_limit_map = new HashMap<String, Long>();
    private Set active_result_downloaders = new HashSet();
    private ThreadPool result_downloader = new ThreadPool("SubscriptionDownloader", 5, true);
    private boolean schedulng_permitted;
    private TimerEvent schedule_event;
    private boolean schedule_in_progress;
    private long last_schedule;
    private String last_sched_str;

    protected SubscriptionSchedulerImpl(SubscriptionManagerImpl _manager) {
        this.manager = _manager;
        this.manager.addListener(this);
        DelayedTask delayed_task = UtilitiesImpl.addDelayedTask("Subscriptions Scheduler", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SubscriptionSchedulerImpl subscriptionSchedulerImpl = SubscriptionSchedulerImpl.this;
                synchronized (subscriptionSchedulerImpl) {
                    SubscriptionSchedulerImpl.this.schedulng_permitted = true;
                }
                SubscriptionSchedulerImpl.this.calculateSchedule();
            }
        });
        delayed_task.queue();
    }

    @Override
    public void downloadAsync(Subscription subs, boolean is_auto) throws SubscriptionException {
        this.download(subs, is_auto, new SubscriptionDownloadListener(){

            @Override
            public void complete(Subscription subs) {
            }

            @Override
            public void failed(Subscription subs, SubscriptionException error) {
                SubscriptionSchedulerImpl.this.log("Async download of " + subs.getName() + " failed", error);
            }
        });
    }

    @Override
    public void download(final Subscription subs, final boolean is_auto, final SubscriptionDownloadListener listener) {
        new AEThread2("SS:download", true){

            @Override
            public void run() {
                try {
                    SubscriptionSchedulerImpl.this.download(subs, is_auto);
                    listener.complete(subs);
                }
                catch (SubscriptionException e) {
                    listener.failed(subs, e);
                }
                catch (Throwable e) {
                    listener.failed(subs, new SubscriptionException("Download failed", e));
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean download(Subscription subs, boolean is_auto) throws SubscriptionException {
        SubscriptionDownloader downloader;
        AESemaphore sem = null;
        String rate_limits = this.manager.getRateLimits().trim();
        Map map = this.active_subscription_downloaders;
        synchronized (map) {
            List waiting;
            if (rate_limits.length() > 0) {
                try {
                    Engine engine = subs.getEngine();
                    if (engine instanceof WebEngine) {
                        String[] bits;
                        String url_str = ((WebEngine)engine).getSearchUrl(true);
                        String host = new URL(url_str).getHost();
                        for (String bit : bits = rate_limits.split(",")) {
                            int mins;
                            String lhs;
                            String[] temp = bit.trim().split("=");
                            if (temp.length != 2 || !(lhs = temp[0].trim()).equals(host) || (mins = Integer.parseInt(temp[1].trim())) <= 0) continue;
                            long now = SystemTime.getMonotonousTime();
                            Long last = this.rate_limit_map.get(host);
                            if (last != null && now - last < (long)(mins * 60 * 1000)) {
                                if (is_auto) {
                                    return false;
                                }
                                throw new SubscriptionException("Rate limiting prevents download from " + host);
                            }
                            this.rate_limit_map.put(host, now);
                        }
                    }
                }
                catch (SubscriptionException e) {
                    throw e;
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            if ((waiting = (List)this.active_subscription_downloaders.get(subs)) != null) {
                sem = new AESemaphore("SS:waiter");
                waiting.add(sem);
                if (!is_auto) {
                    this.active_subs_download_is_auto = false;
                }
            } else {
                this.active_subscription_downloaders.put(subs, new ArrayList());
                this.active_subs_download_is_auto = is_auto;
            }
            downloader = new SubscriptionDownloader(this.manager, (SubscriptionImpl)subs);
        }
        try {
            if (sem == null) {
                downloader.download();
            } else {
                sem.reserve();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            boolean was_auto;
            Map map2 = this.active_subscription_downloaders;
            synchronized (map2) {
                List waiting = (List)this.active_subscription_downloaders.remove(subs);
                if (waiting != null) {
                    for (int i = 0; i < waiting.size(); ++i) {
                        ((AESemaphore)waiting.get(i)).release();
                    }
                }
                was_auto = this.active_subs_download_is_auto;
            }
            ((SubscriptionImpl)subs).fireDownloaded(was_auto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(final Subscription subs, final SubscriptionResult original_result) {
        String download_link = original_result.getDownloadLink();
        if (download_link == null) {
            this.log(subs.getName() + ": can't download " + original_result.getID() + " as no direct download link available");
            return;
        }
        if (UrlFilter.getInstance().isWhitelisted(download_link)) {
            ContentNetwork cn = ContentNetworkManagerFactory.getSingleton().getContentNetworkForURL(download_link);
            if (cn == null) {
                cn = ConstantsVuze.getDefaultContentNetwork();
            }
            download_link = cn.appendURLSuffix(download_link, false, true);
        }
        final String key = subs.getID() + ":" + original_result.getID();
        final String dl = download_link;
        Set set = this.active_result_downloaders;
        synchronized (set) {
            if (this.active_result_downloaders.contains(key)) {
                return;
            }
            this.log(subs.getName() + ": queued result for download - " + original_result.getID() + "/" + download_link);
            this.active_result_downloaders.add(key);
            this.result_downloader.run(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    block42: {
                        SubscriptionResult result = subs.getHistory().getResult(original_result.getID());
                        boolean success = false;
                        try {
                            if (result == null) {
                                SubscriptionSchedulerImpl.this.log(subs.getName() + ": result has been deleted - " + original_result.getID());
                                success = true;
                                break block42;
                            }
                            if (result.getRead()) {
                                SubscriptionSchedulerImpl.this.log(subs.getName() + ": result already marked as read, skipping - " + result.getID());
                                success = true;
                                break block42;
                            }
                            boolean retry = true;
                            boolean use_ref = subs.getHistory().getDownloadWithReferer();
                            boolean tried_ref_switch = false;
                            while (retry) {
                                retry = false;
                                try {
                                    Download download;
                                    TorrentUtils.setTLSDescription("Subscription: " + subs.getName());
                                    URL original_url = new URL(dl);
                                    AEProxyFactory.PluginProxy plugin_proxy = null;
                                    if (dl.startsWith("tor:")) {
                                        String target_resource = dl.substring(4);
                                        original_url = new URL(target_resource);
                                        HashMap<String, Object> options = new HashMap<String, Object>();
                                        options.put("peer_networks", new String[]{"Tor"});
                                        plugin_proxy = AEProxyFactory.getPluginProxy("Subscription result download of '" + target_resource + "'", original_url, options, true);
                                        if (plugin_proxy == null) {
                                            throw new Exception("No Tor plugin proxy available for '" + dl + "'");
                                        }
                                    }
                                    URL current_url = plugin_proxy == null ? original_url : plugin_proxy.getURL();
                                    TorrentImpl torrent = null;
                                    try {
                                        while (true) {
                                            try {
                                                String cookies;
                                                WebEngine we;
                                                ResourceDownloaderFactory rdf = StaticUtilities.getResourceDownloaderFactory();
                                                ResourceDownloader url_rd = rdf.create(current_url, plugin_proxy == null ? null : plugin_proxy.getProxy());
                                                if (plugin_proxy != null) {
                                                    url_rd.setProperty("URL_HOST", plugin_proxy.getURLHostRewrite() + (current_url.getPort() == -1 ? "" : ":" + current_url.getPort()));
                                                }
                                                String referer = use_ref ? subs.getReferer() : null;
                                                UrlUtils.setBrowserHeaders(url_rd, referer);
                                                Engine engine = subs.getEngine();
                                                if (engine instanceof WebEngine && (we = (WebEngine)engine).isNeedsAuth() && (cookies = we.getCookies()) != null && cookies.length() > 0) {
                                                    url_rd.setProperty("URL_Cookie", cookies);
                                                }
                                                ResourceDownloader mr_rd = rdf.getMetaRefreshDownloader(url_rd);
                                                InputStream is = mr_rd.download();
                                                torrent = new TorrentImpl(TOTorrentFactory.deserialiseFromBEncodedInputStream(is));
                                            }
                                            catch (Throwable e) {
                                                if (plugin_proxy == null && (plugin_proxy = AEProxyFactory.getPluginProxy("Subscription result download", original_url)) != null) {
                                                    current_url = plugin_proxy.getURL();
                                                    continue;
                                                }
                                                throw e;
                                            }
                                            break;
                                        }
                                        if (plugin_proxy != null) {
                                            plugin_proxy.setOK(torrent != null);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (plugin_proxy != null) {
                                            plugin_proxy.setOK(torrent != null);
                                        }
                                        throw throwable;
                                    }
                                    byte[] hash = torrent.getHash();
                                    DownloadManager dm = PluginInitializer.getDefaultInterface().getDownloadManager();
                                    boolean stop_override = subs.getTagID() >= 0L || subs.getHistory().getDownloadNetworks() != null;
                                    boolean auto_start = SubscriptionSchedulerImpl.this.manager.shouldAutoStart(torrent);
                                    SubscriptionSchedulerImpl.this.manager.addPrepareTrigger(hash, new Subscription[]{subs}, new SubscriptionResult[]{result});
                                    try {
                                        download = auto_start && !stop_override ? dm.addDownload(torrent) : dm.addDownloadStopped(torrent, null, null);
                                    }
                                    finally {
                                        SubscriptionSchedulerImpl.this.manager.removePrepareTrigger(hash);
                                    }
                                    SubscriptionSchedulerImpl.this.log(subs.getName() + ": added download " + download.getName() + ": auto-start=" + auto_start);
                                    SubscriptionSchedulerImpl.this.manager.prepareDownload(download, new Subscription[]{subs}, new SubscriptionResult[]{result});
                                    subs.addAssociation(hash);
                                    if (auto_start && stop_override) {
                                        download.restart();
                                    }
                                    result.setRead(true);
                                    success = true;
                                    if (!tried_ref_switch) continue;
                                    subs.getHistory().setDownloadWithReferer(use_ref);
                                }
                                catch (Throwable e) {
                                    SubscriptionSchedulerImpl.this.log(subs.getName() + ": Failed to download result " + dl, e);
                                    if (!(e instanceof TOTorrentException) || tried_ref_switch) continue;
                                    use_ref = !use_ref;
                                    tried_ref_switch = true;
                                    retry = true;
                                    SubscriptionSchedulerImpl.this.log(subs.getName() + ": Retrying " + (use_ref ? "with referer" : "without referer"));
                                }
                                finally {
                                    TorrentUtils.setTLSDescription(null);
                                }
                            }
                        }
                        finally {
                            try {
                                if (!success) {
                                    if (dl.startsWith("azplug:") || dl.startsWith("chat:")) {
                                        result.setRead(true);
                                    } else {
                                        int rad = SubscriptionSchedulerImpl.this.manager.getAutoDownloadMarkReadAfterDays();
                                        if (rad > 0) {
                                            long rad_millis = (long)(rad * 24 * 60 * 60) * 1000L;
                                            long time_found = result.getTimeFound();
                                            if (time_found > 0L && time_found + rad_millis < SystemTime.getCurrentTime()) {
                                                SubscriptionSchedulerImpl.this.log(subs.getName() + ": result expired, marking as read - " + result.getID());
                                                result.setRead(true);
                                            }
                                        }
                                    }
                                }
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                            Set set = SubscriptionSchedulerImpl.this.active_result_downloaders;
                            synchronized (set) {
                                SubscriptionSchedulerImpl.this.active_result_downloaders.remove(key);
                            }
                            SubscriptionSchedulerImpl.this.calculateSchedule();
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculateSchedule() {
        Subscription[] subs = this.manager.getSubscriptions(true);
        SubscriptionSchedulerImpl subscriptionSchedulerImpl = this;
        synchronized (subscriptionSchedulerImpl) {
            if (!this.schedulng_permitted) {
                return;
            }
            if (this.schedule_in_progress) {
                return;
            }
            long next_ready_time = Long.MAX_VALUE;
            Subscription next_ready_subs = null;
            for (int i = 0; i < subs.length; ++i) {
                Subscription sub = subs[i];
                SubscriptionHistory history = sub.getHistory();
                if (!history.isEnabled()) continue;
                long next_scan = this.getNextScan(sub);
                sub.setUserData(SCHEDULER_NEXT_SCAN_KEY, new Long(next_scan));
                if (next_scan >= next_ready_time) continue;
                next_ready_time = next_scan;
                next_ready_subs = sub;
            }
            long old_when = 0L;
            if (this.schedule_event != null) {
                old_when = this.schedule_event.getWhen();
                this.schedule_event.cancel();
                this.schedule_event = null;
            }
            if (next_ready_time < Long.MAX_VALUE) {
                long now = SystemTime.getCurrentTime();
                if ((now < this.last_schedule || now - this.last_schedule < 30000L) && next_ready_time - now < 30000L) {
                    next_ready_time = now + 30000L;
                }
                if (next_ready_time < now) {
                    next_ready_time = now;
                }
                String sched_str = "Calculate : old_time=" + new SimpleDateFormat().format(new Date(old_when)) + ", new_time=" + new SimpleDateFormat().format(new Date(next_ready_time)) + ", next_sub=" + next_ready_subs.getName();
                if (this.last_sched_str == null || !sched_str.equals(this.last_sched_str)) {
                    this.last_sched_str = sched_str;
                    this.log(sched_str);
                }
                this.schedule_event = SimpleTimer.addEvent("SS:Scheduler", next_ready_time, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent event2) {
                        SubscriptionSchedulerImpl subscriptionSchedulerImpl = SubscriptionSchedulerImpl.this;
                        synchronized (subscriptionSchedulerImpl) {
                            if (SubscriptionSchedulerImpl.this.schedule_in_progress) {
                                return;
                            }
                            SubscriptionSchedulerImpl.this.schedule_in_progress = true;
                            SubscriptionSchedulerImpl.this.last_schedule = SystemTime.getCurrentTime();
                            SubscriptionSchedulerImpl.this.schedule_event = null;
                        }
                        new AEThread2("SS:Sched", true){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    SubscriptionSchedulerImpl.this.schedule();
                                }
                                finally {
                                    SubscriptionSchedulerImpl subscriptionSchedulerImpl = SubscriptionSchedulerImpl.this;
                                    synchronized (subscriptionSchedulerImpl) {
                                        SubscriptionSchedulerImpl.this.schedule_in_progress = false;
                                    }
                                    SubscriptionSchedulerImpl.this.calculateSchedule();
                                }
                            }
                        }.start();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule() {
        Subscription[] subs = this.manager.getSubscriptions(true);
        long now = SystemTime.getCurrentTime();
        subs = (Subscription[])subs.clone();
        SubscriptionSchedulerImpl subscriptionSchedulerImpl = this;
        synchronized (subscriptionSchedulerImpl) {
            Arrays.sort(subs, new Comparator<Subscription>(){

                @Override
                public int compare(Subscription s1, Subscription s2) {
                    Long l2;
                    Long l1 = (Long)s1.getUserData(SCHEDULER_NEXT_SCAN_KEY);
                    if (l1 == (l2 = (Long)s2.getUserData(SCHEDULER_NEXT_SCAN_KEY))) {
                        return 0;
                    }
                    if (l1 == null) {
                        return 1;
                    }
                    if (l2 == null) {
                        return -1;
                    }
                    long diff = l1 - l2;
                    if (diff < 0L) {
                        return -1;
                    }
                    if (diff < 0L) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        for (int i = 0; i < subs.length; ++i) {
            Subscription sub = subs[i];
            SubscriptionHistory history = sub.getHistory();
            if (!history.isEnabled()) continue;
            SubscriptionSchedulerImpl subscriptionSchedulerImpl2 = this;
            synchronized (subscriptionSchedulerImpl2) {
                Long scan_due = (Long)sub.getUserData(SCHEDULER_NEXT_SCAN_KEY);
                if (scan_due == null) {
                    continue;
                }
                long diff = now - scan_due;
                if (diff < -10000L) {
                    continue;
                }
                sub.setUserData(SCHEDULER_NEXT_SCAN_KEY, null);
            }
            long last_scan = history.getLastScanTime();
            boolean download_attempted = true;
            try {
                download_attempted = this.download(sub, true);
                continue;
            }
            catch (Throwable e) {
                continue;
            }
            finally {
                if (download_attempted) {
                    long new_last_scan = history.getLastScanTime();
                    if (new_last_scan == last_scan) {
                        this.scanFailed(sub);
                    } else {
                        this.scanSuccess(sub);
                    }
                }
            }
        }
    }

    protected long getNextScan(Subscription sub) {
        SubscriptionHistory history = sub.getHistory();
        Long fail_count = (Long)sub.getUserData(SCHEDULER_FAILED_SCAN_CONSEC_KEY);
        if (fail_count != null) {
            long fail_time = (Long)sub.getUserData(SCHEDULER_FAILED_SCAN_TIME_KEY);
            long fails = fail_count;
            long backoff = 600000L;
            int i = 1;
            while ((long)i < fails) {
                if ((backoff <<= 1) > 28800000L) {
                    backoff = 28800000L;
                    break;
                }
                ++i;
            }
            return fail_time + backoff;
        }
        return history.getNextScanTime();
    }

    protected void scanSuccess(Subscription sub) {
        sub.setUserData(SCHEDULER_FAILED_SCAN_CONSEC_KEY, null);
    }

    protected void scanFailed(Subscription sub) {
        sub.setUserData(SCHEDULER_FAILED_SCAN_TIME_KEY, new Long(SystemTime.getCurrentTime()));
        Long fail_count = (Long)sub.getUserData(SCHEDULER_FAILED_SCAN_CONSEC_KEY);
        fail_count = fail_count == null ? new Long(1L) : new Long(fail_count + 1L);
        sub.setUserData(SCHEDULER_FAILED_SCAN_CONSEC_KEY, fail_count);
    }

    protected void log(String str) {
        this.manager.log("Scheduler: " + str);
    }

    protected void log(String str, Throwable e) {
        this.manager.log("Scheduler: " + str, e);
    }

    @Override
    public void subscriptionAdded(Subscription subscription) {
        this.calculateSchedule();
    }

    @Override
    public void subscriptionChanged(Subscription subscription) {
        this.calculateSchedule();
    }

    @Override
    public void subscriptionSelected(Subscription subscription) {
    }

    @Override
    public void subscriptionRemoved(Subscription subscription) {
        this.calculateSchedule();
    }

    @Override
    public void associationsChanged(byte[] association_hash) {
    }

    @Override
    public void subscriptionRequested(URL url, Map<String, Object> options) {
    }

    public void subscriptionRequested(SearchProvider sp, Map<String, Object> properties) throws SubscriptionException {
    }
}

