/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.subs.SubscriptionResult;
import com.aelitis.azureus.core.subs.impl.SubscriptionHistoryImpl;
import com.aelitis.azureus.util.JSONUtils;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SystemTime;

public class SubscriptionResultImpl
implements SubscriptionResult {
    private static final long TIME_FOUND_DEFAULT;
    private final SubscriptionHistoryImpl history;
    private byte[] key1;
    private byte[] key2;
    private boolean read;
    private boolean deleted;
    private String result_json;
    private WeakReference<Map<Integer, Object>> props_ref = null;

    protected SubscriptionResultImpl(SubscriptionHistoryImpl _history, Result result) {
        this.history = _history;
        Map map = result.toJSONMap();
        this.result_json = JSONUtils.encodeToJSON(map);
        this.read = false;
        String key1_str = result.getEngine().getId() + ":" + result.getName();
        try {
            byte[] sha1 = new SHA1Simple().calculateHash(key1_str.getBytes("UTF-8"));
            this.key1 = new byte[10];
            System.arraycopy(sha1, 0, this.key1, 0, 10);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        String uid = result.getUID();
        if (uid != null && uid.length() > 0) {
            String key2_str = result.getEngine().getId() + ":" + uid;
            try {
                byte[] sha1 = new SHA1Simple().calculateHash(key2_str.getBytes("UTF-8"));
                this.key2 = new byte[10];
                System.arraycopy(sha1, 0, this.key2, 0, 10);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected SubscriptionResultImpl(SubscriptionHistoryImpl _history, Map map) {
        this.history = _history;
        this.key1 = (byte[])map.get("key");
        this.key2 = (byte[])map.get("key2");
        this.read = ((Long)map.get("read")).intValue() == 1;
        Long l_deleted = (Long)map.get("deleted");
        if (l_deleted != null) {
            this.deleted = true;
        } else {
            try {
                this.result_json = new String((byte[])map.get("result_json"), "UTF-8");
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateFrom(SubscriptionResultImpl other) {
        String other_json_str;
        if (this.deleted) {
            return false;
        }
        String my_json_str = this.getJSON();
        if (my_json_str.equals(other_json_str = other.getJSON())) {
            return false;
        }
        Map my_json_map = JSONUtils.decodeJSON(my_json_str);
        String my_tf = (String)my_json_map.remove("tf");
        if (my_tf != null) {
            Map other_json_map = JSONUtils.decodeJSON(other_json_str);
            other_json_map.put("tf", my_tf);
            other_json_str = JSONUtils.encodeToJSON(other_json_map);
        }
        if (my_json_str.equals(other_json_str)) {
            return false;
        }
        this.key2 = other.getKey2();
        this.result_json = other_json_str;
        SubscriptionResultImpl subscriptionResultImpl = this;
        synchronized (subscriptionResultImpl) {
            this.props_ref = null;
        }
        return true;
    }

    @Override
    public String getID() {
        return Base32.encode(this.key1);
    }

    protected byte[] getKey1() {
        return this.key1;
    }

    protected byte[] getKey2() {
        return this.key2;
    }

    @Override
    public boolean getRead() {
        return this.read;
    }

    @Override
    public void setRead(boolean _read) {
        if (this.read != _read) {
            this.read = _read;
            this.history.updateResult(this);
        }
    }

    protected void setReadInternal(boolean _read) {
        this.read = _read;
    }

    @Override
    public void delete() {
        if (!this.deleted) {
            this.deleted = true;
            this.history.updateResult(this);
        }
    }

    protected void deleteInternal() {
        this.deleted = true;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    protected Map toBEncodedMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", this.key1);
        if (this.key2 != null) {
            map.put("key2", this.key2);
        }
        map.put("read", new Long(this.read ? 1L : 0L));
        if (this.deleted) {
            map.put("deleted", new Long(1L));
        } else {
            try {
                map.put("result_json", this.result_json.getBytes("UTF-8"));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return map;
    }

    @Override
    public Map toJSONMap() {
        Map map = JSONUtils.decodeJSON(this.result_json);
        map.put("subs_is_read", this.read);
        map.put("subs_id", this.getID());
        Result.adjustRelativeTerms(map);
        String size = (String)map.get("l");
        if (size != null) {
            size = DisplayFormatters.trimDigits(size, 3);
            map.put("l", size);
        }
        return map;
    }

    private String getJSON() {
        return this.result_json;
    }

    @Override
    public String getDownloadLink() {
        String dl_link;
        Map map = this.toJSONMap();
        String link = (String)map.get("dbl");
        if (link != null && link.toLowerCase(Locale.US).startsWith("magnet:") && (dl_link = (String)map.get("dl")) != null) {
            link = dl_link;
        }
        if (link == null) {
            link = (String)map.get("dl");
        }
        return Result.adjustLink(link);
    }

    @Override
    public String getPlayLink() {
        return Result.adjustLink((String)this.toJSONMap().get("pl"));
    }

    public String getAssetHash() {
        return (String)this.toJSONMap().get("h");
    }

    @Override
    public long getTimeFound() {
        String tf_secs_str = (String)this.toJSONMap().get("tf");
        if (tf_secs_str == null) {
            return TIME_FOUND_DEFAULT;
        }
        return Long.parseLong(tf_secs_str) * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, Object> toPropertyMap() {
        SubscriptionResultImpl subscriptionResultImpl = this;
        synchronized (subscriptionResultImpl) {
            String contentType;
            String hash;
            String cdp_link;
            String size;
            Map cached;
            if (this.props_ref != null && (cached = (Map)this.props_ref.get()) != null) {
                return cached;
            }
            Map map = this.toJSONMap();
            HashMap<Integer, Object> result = new HashMap<Integer, Object>();
            String title = (String)map.get("n");
            result.put(20, this.getID());
            result.put(1, title);
            String pub_date = (String)map.get("ts");
            if (pub_date != null) {
                result.put(2, new Date(Long.parseLong(pub_date)));
            }
            if ((size = (String)map.get("lb")) != null) {
                result.put(3, Long.parseLong(size));
            }
            String dbl_link = (String)map.get("dbl");
            String dl_link = (String)map.get("dl");
            if (dbl_link == null) {
                dbl_link = dl_link;
            }
            if (dbl_link != null) {
                result.put(12, Result.adjustLink(dbl_link));
            }
            if (dl_link != null) {
                result.put(23, Result.adjustLink(dl_link));
            }
            if ((cdp_link = (String)map.get("cdp")) != null) {
                result.put(11, Result.adjustLink(cdp_link));
            }
            if ((hash = (String)map.get("h")) != null) {
                result.put(21, Base32.decode(hash));
            }
            String seeds = (String)map.get("s");
            result.put(5, seeds == null ? -1L : Long.parseLong(seeds));
            String peers = (String)map.get("p");
            result.put(4, peers == null ? -1L : Long.parseLong(peers));
            String votes = (String)map.get("v");
            result.put(9, votes == null ? -1L : Long.parseLong(votes));
            String comments = (String)map.get("co");
            result.put(8, comments == null ? -1L : Long.parseLong(comments));
            String rank = (String)map.get("r");
            result.put(17, rank == null ? -1L : (long)(100.0f * Float.parseFloat(rank)));
            String category = (String)map.get("c");
            if (category != null) {
                result.put(7, category);
            }
            if ((contentType = (String)map.get("ct")) != null) {
                result.put(10, contentType);
            }
            this.props_ref = new WeakReference(result);
            return result;
        }
    }

    static {
        long tfd = COConfigurationManager.getLongParameter("subscription.result.time.found.default", 0L);
        if (tfd == 0L) {
            tfd = SystemTime.getCurrentTime() / 1000L;
            COConfigurationManager.setParameter("subscription.result.time.found.default", tfd);
        }
        TIME_FOUND_DEFAULT = tfd * 1000L;
    }
}

