/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.custom.Customization;
import com.aelitis.azureus.core.custom.CustomizationManager;
import com.aelitis.azureus.core.custom.CustomizationManagerFactory;
import com.aelitis.azureus.core.lws.LightWeightSeed;
import com.aelitis.azureus.core.lws.LightWeightSeedManager;
import com.aelitis.azureus.core.messenger.config.PlatformSubscriptionsMessenger;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.MetaSearchListener;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.metasearch.impl.web.rss.RSSEngine;
import com.aelitis.azureus.core.security.CryptoECCUtils;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionAssociationLookup;
import com.aelitis.azureus.core.subs.SubscriptionDownloadListener;
import com.aelitis.azureus.core.subs.SubscriptionException;
import com.aelitis.azureus.core.subs.SubscriptionLookupListener;
import com.aelitis.azureus.core.subs.SubscriptionManager;
import com.aelitis.azureus.core.subs.SubscriptionManagerListener;
import com.aelitis.azureus.core.subs.SubscriptionPopularityListener;
import com.aelitis.azureus.core.subs.SubscriptionResult;
import com.aelitis.azureus.core.subs.SubscriptionScheduler;
import com.aelitis.azureus.core.subs.SubscriptionUtils;
import com.aelitis.azureus.core.subs.impl.SubscriptionBodyImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionHistoryImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionRSSFeed;
import com.aelitis.azureus.core.subs.impl.SubscriptionResultImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionSchedulerImpl;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.core.vuzefile.VuzeFileProcessor;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginInterface;
import com.aelitis.azureus.plugins.dht.DHTPluginKeyStats;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginValue;
import com.aelitis.azureus.plugins.magnet.MagnetPlugin;
import com.aelitis.azureus.plugins.magnet.MagnetPluginProgressListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBeta;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginUtils;
import com.aelitis.azureus.util.ImportExportUtils;
import com.aelitis.azureus.util.UrlFilter;
import com.aelitis.net.magneturi.MagnetURIHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadCompletionListener;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadWillBeAddedListener;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.plugins.utils.search.SearchException;
import org.gudy.azureus2.plugins.utils.search.SearchInstance;
import org.gudy.azureus2.plugins.utils.search.SearchObserver;
import org.gudy.azureus2.plugins.utils.search.SearchProvider;
import org.gudy.azureus2.plugins.utils.search.SearchResult;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;
import org.gudy.bouncycastle.util.encoders.Base64;

public class SubscriptionManagerImpl
implements SubscriptionManager,
AEDiagnosticsEvidenceGenerator {
    private static final String CONFIG_FILE = "subscriptions.config";
    private static final String LOGGER_NAME = "Subscriptions";
    private static final String CONFIG_MAX_RESULTS = "subscriptions.max.non.deleted.results";
    private static final String CONFIG_AUTO_START_DLS = "subscriptions.auto.start.downloads";
    private static final String CONFIG_AUTO_START_MIN_MB = "subscriptions.auto.start.min.mb";
    private static final String CONFIG_AUTO_START_MAX_MB = "subscriptions.auto.start.max.mb";
    private static final String CONFIG_AUTO_MARK_READ = "subscriptions.auto.dl.mark.read.days";
    private static final String CONFIG_RSS_ENABLE = "subscriptions.config.rss_enable";
    private static final String CONFIG_ENABLE_SEARCH = "subscriptions.config.search_enable";
    private static final String CONFIG_HIDE_SEARCH_TEMPLATES = "subscriptions.config.hide_search_templates";
    private static final String CONFIG_DL_SUBS_ENABLE = "subscriptions.config.dl_subs_enable";
    private static final String CONFIG_DL_RATE_LIMITS = "subscriptions.config.rate_limits";
    private static final String CONFIG_ACTIVATE_ON_CHANGE = "subscriptions.config.activate.sub.on.change";
    private static final int DELETE_UNUSED_AFTER_MILLIS = 1209600000;
    private static final int PUB_ASSOC_CONC_MAX;
    private static final int PUB_SLEEPING_ASSOC_CONC_MAX = 1;
    private static SubscriptionManagerImpl singleton;
    private static boolean pre_initialised;
    private static final int random_seed;
    private boolean started;
    private static final int TIMER_PERIOD = 30000;
    private static final int ASSOC_CHECK_PERIOD = 300000;
    private static final int ASSOC_CHECK_TICKS = 10;
    private static final int ASSOC_PUBLISH_PERIOD = 300000;
    private static final int ASSOC_PUBLISH_TICKS = 10;
    private static final int CHAT_CHECK_PERIOD = 180000;
    private static final int CHAT_CHECK_TICKS = 6;
    private static final int SERVER_PUB_CHECK_PERIOD = 600000;
    private static final int SERVER_PUB_CHECK_TICKS = 20;
    private static final int TIDY_POT_ASSOC_PERIOD = 1800000;
    private static final int TIDY_POT_ASSOC_TICKS = 60;
    private static final int SET_SELECTED_PERIOD = 82800000;
    private static final int SET_SELECTED_FIRST_TICK = 6;
    private static final int SET_SELECTED_TICKS = 2760;
    private static final Object SP_LAST_ATTEMPTED;
    private static final Object SP_CONSEC_FAIL;
    private AzureusCore azureus_core;
    private volatile DHTPluginInterface dht_plugin_public;
    private List<SubscriptionImpl> subscriptions = new ArrayList<SubscriptionImpl>();
    private boolean config_dirty;
    private int publish_associations_active;
    private boolean publish_next_asyc_pending;
    private boolean publish_subscription_active;
    private TorrentAttribute ta_subs_download;
    private TorrentAttribute ta_subs_download_rd;
    private TorrentAttribute ta_subscription_info;
    private TorrentAttribute ta_category;
    private TorrentAttribute ta_networks;
    private boolean periodic_lookup_in_progress;
    private int priority_lookup_pending;
    private CopyOnWriteList<SubscriptionManagerListener> listeners = new CopyOnWriteList();
    private SubscriptionSchedulerImpl scheduler;
    private List<Object[]> potential_associations = new ArrayList<Object[]>();
    private Map<HashWrapper, Object[]> potential_associations2 = new HashMap<HashWrapper, Object[]>();
    private Map<HashWrapper, Object[]> potential_associations3 = new HashMap<HashWrapper, Object[]>();
    private boolean meta_search_listener_added;
    private Pattern exclusion_pattern = Pattern.compile("azdev[0-9]+\\.azureus\\.com");
    private SubscriptionRSSFeed rss_publisher;
    private AEDiagnosticsLogger logger;
    private Map<SubscriptionImpl, Object[]> result_cache = new HashMap<SubscriptionImpl, Object[]>();
    private AsyncDispatcher async_dispatcher = new AsyncDispatcher("SubsManDispatcher");
    private static final Object SUBS_CHAT_KEY;
    private AsyncDispatcher chat_write_dispatcher = new AsyncDispatcher("Subscriptions:cwd");
    private Set<String> chat_st_done = new HashSet<String>();
    private LinkedList<BuddyPluginBeta.ChatInstance> chat_assoc_done = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preInitialise() {
        Class<SubscriptionManagerImpl> clazz = SubscriptionManagerImpl.class;
        synchronized (SubscriptionManagerImpl.class) {
            if (pre_initialised) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            pre_initialised = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

                @Override
                public void process(VuzeFile[] files, int expected_types) {
                    for (int i = 0; i < files.length; ++i) {
                        VuzeFile vf = files[i];
                        VuzeFileComponent[] comps = vf.getComponents();
                        for (int j = 0; j < comps.length; ++j) {
                            VuzeFileComponent comp2 = comps[j];
                            int type = comp2.getType();
                            if (type != 16 && type != 32) continue;
                            try {
                                Subscription subs = ((SubscriptionManagerImpl)SubscriptionManagerImpl.getSingleton(false)).importSubscription(type, comp2.getContent(), (expected_types & 0x30) == 0);
                                comp2.setProcessed();
                                comp2.setData(Subscription.VUZE_FILE_COMPONENT_SUBSCRIPTION_KEY, subs);
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                }
            });
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubscriptionManager getSingleton(boolean stand_alone) {
        SubscriptionManagerImpl.preInitialise();
        Class<SubscriptionManagerImpl> clazz = SubscriptionManagerImpl.class;
        synchronized (SubscriptionManagerImpl.class) {
            if (singleton != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return singleton;
            }
            singleton = new SubscriptionManagerImpl(stand_alone);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (!stand_alone) {
                singleton.initialise();
            }
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SubscriptionManagerImpl(boolean stand_alone) {
        if (!stand_alone) {
            this.loadConfig();
            AEDiagnostics.addEvidenceGenerator(this);
            CustomizationManager cust_man = CustomizationManagerFactory.getSingleton();
            Customization cust = cust_man.getActiveCustomization();
            if (cust != null) {
                boolean new_version;
                String cust_name = COConfigurationManager.getStringParameter("subscriptions.custom.name", "");
                String cust_version = COConfigurationManager.getStringParameter("subscriptions.custom.version", "0");
                boolean new_name = !cust_name.equals(cust.getName());
                boolean bl = new_version = Constants.compareVersions(cust_version, cust.getVersion()) < 0;
                if (new_name || new_version) {
                    this.log("Customization: checking templates for " + cust.getName() + "/" + cust.getVersion());
                    try {
                        InputStream[] streams = cust.getResources("subs");
                        for (int i = 0; i < streams.length; ++i) {
                            InputStream is = streams[i];
                            try {
                                VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(is);
                                if (vf == null) continue;
                                VuzeFileComponent[] comps = vf.getComponents();
                                for (int j = 0; j < comps.length; ++j) {
                                    VuzeFileComponent comp2 = comps[j];
                                    int type = comp2.getType();
                                    if (type != 16 && type != 32) continue;
                                    try {
                                        this.importSubscription(type, comp2.getContent(), false);
                                        comp2.setProcessed();
                                        continue;
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                    }
                                }
                                continue;
                            }
                            finally {
                                try {
                                    is.close();
                                }
                                catch (Throwable e) {}
                            }
                        }
                    }
                    finally {
                        COConfigurationManager.setParameter("subscriptions.custom.name", cust.getName());
                        COConfigurationManager.setParameter("subscriptions.custom.version", cust.getVersion());
                    }
                }
            }
            this.scheduler = new SubscriptionSchedulerImpl(this);
        }
        SimpleTimer.addPeriodicEvent("SubscriptionCacheCheck", 10000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent event2) {
                long now = SystemTime.getMonotonousTime();
                Map map = SubscriptionManagerImpl.this.result_cache;
                synchronized (map) {
                    Iterator it = SubscriptionManagerImpl.this.result_cache.values().iterator();
                    while (it.hasNext()) {
                        long time = (Long)((Object[])it.next())[1];
                        if (now - time <= 15000L) continue;
                        it.remove();
                    }
                }
            }
        });
    }

    protected void initialise() {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            @Override
            public void azureusCoreRunning(AzureusCore core) {
                SubscriptionManagerImpl.this.initWithCore(core);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initWithCore(AzureusCore _core) {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            if (this.started) {
                return;
            }
            this.started = true;
        }
        this.azureus_core = _core;
        final PluginInterface default_pi = PluginInitializer.getDefaultInterface();
        this.rss_publisher = new SubscriptionRSSFeed(this, default_pi);
        TorrentManager tm = default_pi.getTorrentManager();
        this.ta_subs_download = tm.getPluginAttribute("azsubs.subs_dl");
        this.ta_subs_download_rd = tm.getPluginAttribute("azsubs.subs_dl_rd");
        this.ta_subscription_info = tm.getPluginAttribute("azsubs.subs_info");
        this.ta_category = tm.getAttribute("Category");
        this.ta_networks = tm.getAttribute("Networks");
        PluginInterface dht_plugin_pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
        if (dht_plugin_pi != null) {
            this.dht_plugin_public = (DHTPlugin)dht_plugin_pi.getPlugin();
            default_pi.getDownloadManager().addListener(new DownloadManagerListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void downloadAdded(Download download) {
                    Torrent torrent = download.getTorrent();
                    if (torrent != null) {
                        Object[] entry;
                        byte[] hash = torrent.getHash();
                        Map map = SubscriptionManagerImpl.this.potential_associations2;
                        synchronized (map) {
                            entry = (Object[])SubscriptionManagerImpl.this.potential_associations2.remove(new HashWrapper(hash));
                        }
                        if (entry != null) {
                            SubscriptionImpl[] subs = (SubscriptionImpl[])entry[0];
                            String subs_str = "";
                            for (int i = 0; i < subs.length; ++i) {
                                subs_str = subs_str + (i == 0 ? "" : ",") + subs[i].getName();
                            }
                            SubscriptionManagerImpl.this.log("Applying deferred asocciation for " + ByteFormatter.encodeString(hash) + " -> " + subs_str);
                            SubscriptionManagerImpl.this.recordAssociationsSupport(hash, subs, (Boolean)entry[1]);
                        }
                    }
                }

                @Override
                public void downloadRemoved(Download download) {
                }
            }, false);
            default_pi.getDownloadManager().addDownloadWillBeAddedListener(new DownloadWillBeAddedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void initialised(Download download) {
                    Torrent torrent = download.getTorrent();
                    if (torrent != null) {
                        Subscription[] subs;
                        Object[] entry;
                        byte[] hash = torrent.getHash();
                        HashWrapper hw = new HashWrapper(hash);
                        Map map = SubscriptionManagerImpl.this.potential_associations2;
                        synchronized (map) {
                            entry = (Object[])SubscriptionManagerImpl.this.potential_associations2.get(hw);
                        }
                        if (entry != null) {
                            subs = (SubscriptionImpl[])entry[0];
                            SubscriptionManagerImpl.this.prepareDownload(download, subs, null);
                        } else {
                            subs = SubscriptionManagerImpl.this.potential_associations3;
                            synchronized (subs) {
                                entry = (Object[])SubscriptionManagerImpl.this.potential_associations3.get(hw);
                            }
                            if (entry != null) {
                                subs = (Subscription[])entry[0];
                                SubscriptionResult[] results = (SubscriptionResult[])entry[1];
                                SubscriptionManagerImpl.this.prepareDownload(download, subs, results);
                            }
                        }
                    }
                }
            });
            TorrentUtils.addTorrentAttributeListener(new TorrentUtils.torrentAttributeListener(){

                @Override
                public void attributeSet(TOTorrent torrent, String attribute, Object value) {
                    if (attribute == "obtained_from") {
                        try {
                            SubscriptionManagerImpl.this.checkPotentialAssociations(torrent.getHash(), (String)value);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            });
            DelayedTask delayed_task = UtilitiesImpl.addDelayedTask(LOGGER_NAME, new Runnable(){

                @Override
                public void run() {
                    new AEThread2("Subscriptions:delayInit", true){

                        @Override
                        public void run() {
                            this.asyncInit();
                        }
                    }.start();
                }

                protected void asyncInit() {
                    int i;
                    Download[] downloads = default_pi.getDownloadManager().getDownloads();
                    for (i = 0; i < downloads.length; ++i) {
                        boolean delete_it;
                        Download download = downloads[i];
                        if (!download.getBooleanAttribute(SubscriptionManagerImpl.this.ta_subs_download)) continue;
                        Map rd = download.getMapAttribute(SubscriptionManagerImpl.this.ta_subs_download_rd);
                        if (rd == null) {
                            delete_it = true;
                        } else {
                            boolean bl = delete_it = !SubscriptionManagerImpl.this.recoverSubscriptionUpdate(download, rd);
                        }
                        if (!delete_it) continue;
                        SubscriptionManagerImpl.this.removeDownload(download, true);
                    }
                    default_pi.getDownloadManager().addListener(new DownloadManagerListener(){

                        @Override
                        public void downloadAdded(final Download download) {
                            if (!SubscriptionManagerImpl.this.downloadIsIgnored(download)) {
                                if (!SubscriptionManagerImpl.this.dht_plugin_public.isInitialising()) {
                                    SubscriptionManagerImpl.this.lookupAssociations(download.getMapAttribute(SubscriptionManagerImpl.this.ta_subscription_info) == null);
                                } else {
                                    new AEThread2("Subscriptions:delayInit", true){

                                        @Override
                                        public void run() {
                                            SubscriptionManagerImpl.this.lookupAssociations(download.getMapAttribute(SubscriptionManagerImpl.this.ta_subscription_info) == null);
                                        }
                                    }.start();
                                }
                            }
                        }

                        @Override
                        public void downloadRemoved(Download download) {
                        }
                    }, false);
                    for (i = 0; i < PUB_ASSOC_CONC_MAX && !SubscriptionManagerImpl.this.publishAssociations(); ++i) {
                    }
                    SubscriptionManagerImpl.this.publishSubscriptions();
                    COConfigurationManager.addParameterListener(SubscriptionManagerImpl.CONFIG_MAX_RESULTS, new ParameterListener(){

                        @Override
                        public void parameterChanged(String name) {
                            final int max_results = COConfigurationManager.getIntParameter(SubscriptionManagerImpl.CONFIG_MAX_RESULTS);
                            new AEThread2("Subs:max results changer", true){

                                @Override
                                public void run() {
                                    SubscriptionManagerImpl.this.checkMaxResults(max_results);
                                }
                            }.start();
                        }
                    });
                    SimpleTimer.addPeriodicEvent("SubscriptionChecker", 30000L, new TimerEventPerformer(){
                        private int ticks;

                        @Override
                        public void perform(TimerEvent event2) {
                            ++this.ticks;
                            SubscriptionManagerImpl.this.checkStuff(this.ticks);
                        }
                    });
                }
            });
            delayed_task.queue();
        }
        if (this.isSearchEnabled()) {
            try {
                default_pi.getUtilities().registerSearchProvider(new SearchProvider(){
                    private Map<Integer, Object> properties = new HashMap<Integer, Object>();
                    {
                        this.properties.put(1, MessageText.getString("ConfigView.section.Subscriptions"));
                        try {
                            URL url = MagnetURIHandler.getSingleton().registerResource(new MagnetURIHandler.ResourceProvider(){

                                @Override
                                public String getUID() {
                                    return SubscriptionManager.class.getName() + ".2";
                                }

                                @Override
                                public String getFileType() {
                                    return "png";
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public byte[] getData() {
                                    InputStream is = this.getClass().getClassLoader().getResourceAsStream("com/aelitis/azureus/ui/images/subscription_icon_1616.png");
                                    if (is == null) {
                                        return null;
                                    }
                                    try {
                                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                        try {
                                            int len;
                                            byte[] buffer = new byte[8192];
                                            while ((len = is.read(buffer)) > 0) {
                                                baos.write(buffer, 0, len);
                                            }
                                        }
                                        finally {
                                            is.close();
                                        }
                                        return baos.toByteArray();
                                    }
                                    catch (Throwable e) {
                                        return null;
                                    }
                                }
                            });
                            this.properties.put(2, url.toExternalForm());
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }

                    @Override
                    public SearchInstance search(Map<String, Object> search_parameters, SearchObserver observer) throws SearchException {
                        try {
                            return SubscriptionManagerImpl.this.searchSubscriptions(search_parameters, observer);
                        }
                        catch (Throwable e) {
                            throw new SearchException("Search failed", e);
                        }
                    }

                    @Override
                    public Object getProperty(int property) {
                        return this.properties.get(property);
                    }

                    @Override
                    public void setProperty(int property, Object value) {
                        this.properties.put(property, value);
                    }
                });
            }
            catch (Throwable e) {
                Debug.out("Failed to register search provider");
            }
        }
        default_pi.getUtilities().registerJSONRPCServer(new Utilities.JSONServer(){
            private List<String> methods = new ArrayList<String>();
            {
                this.methods.add("vuze-subs-list");
            }

            @Override
            public String getName() {
                return SubscriptionManagerImpl.LOGGER_NAME;
            }

            @Override
            public List<String> getSupportedMethods() {
                return this.methods;
            }

            @Override
            public Map call(String method, Map args) throws PluginException {
                throw new PluginException("derp");
            }
        });
    }

    protected Object[] getSearchTemplateVuzeFile(SubscriptionImpl sub) {
        try {
            String subs_url_str = ((RSSEngine)sub.getEngine()).getSearchUrl(true);
            URL subs_url = new URL(subs_url_str);
            byte[] vf_bytes = FileUtil.readInputStreamAsByteArray(subs_url.openConnection().getInputStream());
            VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(vf_bytes);
            if (MetaSearchManagerFactory.getSingleton().isImportable(vf)) {
                return new Object[]{vf, vf_bytes};
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return null;
    }

    public boolean isSearchTemplateImportable(SubscriptionImpl sub) {
        try {
            String subs_url_str = ((RSSEngine)sub.getEngine()).getSearchUrl(true);
            URL subs_url = new URL(subs_url_str);
            byte[] vf_bytes = FileUtil.readInputStreamAsByteArray(subs_url.openConnection().getInputStream());
            VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(vf_bytes);
            return MetaSearchManagerFactory.getSingleton().isImportable(vf);
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    public SearchInstance searchSubscriptions(Map<String, Object> search_parameters, final SearchObserver observer) throws SearchException {
        final String term = (String)search_parameters.get("s");
        final SearchInstance si = new SearchInstance(){

            @Override
            public void cancel() {
                Debug.out("Cancelled");
            }
        };
        if (term == null) {
            try {
                observer.complete();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        } else {
            new AEThread2("Subscriptions:search", true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HashSet<String> hashes = new HashSet<String>();
                    searchMatcher matcher = new searchMatcher(term);
                    try {
                        List matches = SubscriptionManagerImpl.this.matchSubscriptionResults(matcher);
                        for (SubscriptionResult result : matches) {
                            final Map<Integer, Object> result_properties = result.toPropertyMap();
                            byte[] hash = (byte[])result_properties.get(21);
                            if (hash != null) {
                                String hash_str = Base32.encode(hash);
                                if (hashes.contains(hash_str)) continue;
                                hashes.add(hash_str);
                            }
                            SearchResult search_result = new SearchResult(){

                                @Override
                                public Object getProperty(int property_name) {
                                    return result_properties.get(property_name);
                                }
                            };
                            try {
                                observer.resultReceived(si, search_result);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                        HashMap<String, Object[]> template_matches = new HashMap<String, Object[]>();
                        Engine[] engines = MetaSearchManagerFactory.getSingleton().getMetaSearch().getEngines(false, false);
                        HashMap<Subscription, ArrayList<String>> sub_dl_name_map = null;
                        for (Subscription subscription : SubscriptionManagerImpl.this.getSubscriptions(false)) {
                            List names;
                            int t_ver;
                            if (!subscription.isSearchTemplate()) continue;
                            String sub_name = subscription.getName(false);
                            Engine sub_engine = subscription.getEngine();
                            if (sub_engine.isActive() || !(sub_engine instanceof RSSEngine)) continue;
                            int pos = sub_name.indexOf(":");
                            String t_name = sub_name.substring(pos + 1);
                            if ((pos = t_name.indexOf("(v")) == -1) {
                                t_ver = 1;
                            } else {
                                String s = t_name.substring(pos + 2, t_name.length() - 1);
                                t_name = t_name.substring(0, pos);
                                try {
                                    t_ver = Integer.parseInt(s);
                                }
                                catch (Throwable e) {
                                    t_ver = 1;
                                }
                            }
                            t_name = t_name.trim();
                            boolean skip = false;
                            for (Engine e : engines) {
                                if (e != sub_engine && e.sameLogicAs(sub_engine)) {
                                    skip = true;
                                    break;
                                }
                                if (!e.getName().equalsIgnoreCase(t_name) || e.getVersion() < t_ver) continue;
                                skip = true;
                            }
                            if (skip) continue;
                            if (sub_dl_name_map == null) {
                                SubscriptionUtils.SubscriptionDownloadDetails[] sdds;
                                sub_dl_name_map = new HashMap<Subscription, ArrayList<String>>();
                                for (SubscriptionUtils.SubscriptionDownloadDetails sdd : sdds = SubscriptionUtils.getAllCachedDownloadDetails(SubscriptionManagerImpl.this.azureus_core)) {
                                    Subscription[] x;
                                    String name = sdd.getDownload().getDisplayName();
                                    if (!matcher.matches(name)) continue;
                                    for (Subscription s : x = sdd.getSubscriptions()) {
                                        ArrayList<String> g = (ArrayList<String>)sub_dl_name_map.get(s);
                                        if (g == null) {
                                            g = new ArrayList<String>();
                                            sub_dl_name_map.put(s, g);
                                        }
                                        g.add(name);
                                    }
                                }
                            }
                            if ((names = (List)sub_dl_name_map.get(subscription)) == null) continue;
                            String key = t_name.toLowerCase();
                            Object[] entry = (Object[])template_matches.get(key);
                            if (entry == null) {
                                entry = new Object[]{subscription, t_ver};
                                template_matches.put(key, entry);
                                continue;
                            }
                            if (t_ver <= (Integer)entry[1]) continue;
                            entry[0] = subscription;
                            entry[1] = t_ver;
                        }
                        ArrayList<SubscriptionImpl> interesting = new ArrayList<SubscriptionImpl>();
                        for (Object[] entry : template_matches.values()) {
                            interesting.add((SubscriptionImpl)entry[0]);
                        }
                        Collections.sort(interesting, new Comparator<Subscription>(){

                            @Override
                            public int compare(Subscription o1, Subscription o2) {
                                long res = o2.getCachedPopularity() - o1.getCachedPopularity();
                                if (res < 0L) {
                                    return -1;
                                }
                                if (res > 0L) {
                                    return 1;
                                }
                                return 0;
                            }
                        });
                        int added = 0;
                        for (final SubscriptionImpl subscriptionImpl : interesting) {
                            if (added >= 3) {
                                break;
                            }
                            try {
                                Object[] vf_entry = SubscriptionManagerImpl.this.getSearchTemplateVuzeFile(subscriptionImpl);
                                if (vf_entry == null) continue;
                                final byte[] vf_bytes = (byte[])vf_entry[1];
                                final URL url = MagnetURIHandler.getSingleton().registerResource(new MagnetURIHandler.ResourceProvider(){

                                    @Override
                                    public String getUID() {
                                        return SubscriptionManager.class.getName() + ".sid." + subscriptionImpl.getID();
                                    }

                                    @Override
                                    public String getFileType() {
                                        return "vuze";
                                    }

                                    @Override
                                    public byte[] getData() {
                                        return vf_bytes;
                                    }
                                });
                                SearchResult search_result = new SearchResult(){

                                    @Override
                                    public Object getProperty(int property_name) {
                                        if (property_name == 1) {
                                            return subscriptionImpl.getName();
                                        }
                                        if (property_name == 12 || property_name == 16) {
                                            return url.toExternalForm();
                                        }
                                        if (property_name == 2) {
                                            return new Date(subscriptionImpl.getAddTime());
                                        }
                                        if (property_name == 3) {
                                            return 1024L;
                                        }
                                        if (property_name == 5 || property_name == 9) {
                                            return subscriptionImpl.getCachedPopularity();
                                        }
                                        if (property_name == 17) {
                                            return 100L;
                                        }
                                        return null;
                                    }
                                };
                                ++added;
                                try {
                                    observer.resultReceived(si, search_result);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    finally {
                        observer.complete();
                    }
                }
            }.start();
        }
        return si;
    }

    private List<SubscriptionResult> matchSubscriptionResults(searchMatcher matcher) {
        ArrayList<SubscriptionResult> result = new ArrayList<SubscriptionResult>();
        for (Subscription sub : this.getSubscriptions(true)) {
            SubscriptionResult[] results;
            for (SubscriptionResult r : results = sub.getResults(false)) {
                Map<Integer, Object> properties = r.toPropertyMap();
                String name = (String)properties.get(1);
                if (name == null || !matcher.matches(name)) continue;
                result.add(r);
            }
        }
        return result;
    }

    protected void checkMaxResults(int max) {
        Subscription[] subs = this.getSubscriptions();
        for (int i = 0; i < subs.length; ++i) {
            ((SubscriptionHistoryImpl)subs[i].getHistory()).checkMaxResults(max);
        }
    }

    @Override
    public SubscriptionScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public boolean isRSSPublishEnabled() {
        return COConfigurationManager.getBooleanParameter(CONFIG_RSS_ENABLE, false);
    }

    @Override
    public void setRSSPublishEnabled(boolean enabled) {
        COConfigurationManager.setParameter(CONFIG_RSS_ENABLE, enabled);
    }

    @Override
    public boolean isSearchEnabled() {
        return COConfigurationManager.getBooleanParameter(CONFIG_ENABLE_SEARCH, true);
    }

    @Override
    public void setSearchEnabled(boolean enabled) {
        COConfigurationManager.setParameter(CONFIG_ENABLE_SEARCH, enabled);
    }

    @Override
    public boolean hideSearchTemplates() {
        return COConfigurationManager.getBooleanParameter(CONFIG_HIDE_SEARCH_TEMPLATES, true);
    }

    @Override
    public boolean isSubsDownloadEnabled() {
        return COConfigurationManager.getBooleanParameter(CONFIG_DL_SUBS_ENABLE, true);
    }

    @Override
    public void setSubsDownloadEnabled(boolean enabled) {
        COConfigurationManager.setParameter(CONFIG_DL_SUBS_ENABLE, enabled);
    }

    @Override
    public void setRateLimits(String limits) {
        COConfigurationManager.setParameter(CONFIG_DL_RATE_LIMITS, limits);
    }

    @Override
    public String getRateLimits() {
        return COConfigurationManager.getStringParameter(CONFIG_DL_RATE_LIMITS, "");
    }

    @Override
    public void setActivateSubscriptionOnChange(boolean b) {
        COConfigurationManager.setParameter(CONFIG_ACTIVATE_ON_CHANGE, b);
    }

    @Override
    public boolean getActivateSubscriptionOnChange() {
        return COConfigurationManager.getBooleanParameter(CONFIG_ACTIVATE_ON_CHANGE, false);
    }

    @Override
    public String getRSSLink() {
        return this.rss_publisher.getFeedURL();
    }

    @Override
    public Subscription create(String name, boolean public_subs, String json) throws SubscriptionException {
        name = this.getUniqueName(name);
        boolean is_anonymous = false;
        SubscriptionImpl subs = new SubscriptionImpl(this, name, public_subs, is_anonymous, null, json, 1);
        this.log("Created new subscription: " + subs.getString());
        if (subs.isPublic()) {
            this.updatePublicSubscription(subs);
        }
        return this.addSubscription(subs);
    }

    @Override
    public Subscription createSingletonRSS(String name, URL url, int check_interval_mins) throws SubscriptionException {
        return this.createSingletonRSSSupport(name, url, true, check_interval_mins, 1, true);
    }

    @Override
    public Subscription createFromURI(String uri) throws SubscriptionException {
        String[] bits;
        final AESemaphore sem = new AESemaphore("subswait");
        final Object[] result = new Object[]{null};
        byte[] sid = null;
        int version = -1;
        int pos = uri.indexOf(63);
        for (String bit : bits = uri.substring(pos + 1).split("&")) {
            String[] temp = bit.split("=");
            if (temp.length != 2) continue;
            String lhs = temp[0].toLowerCase(Locale.US);
            String rhs = temp[1];
            if (lhs.equals("id")) {
                sid = Base32.decode(rhs);
                continue;
            }
            if (!lhs.equals("v")) continue;
            version = Integer.parseInt(rhs);
        }
        if (sid == null || version == -1) {
            throw new SubscriptionException("Invalid URI");
        }
        this.lookupSubscription(new byte[20], sid, version, new subsLookupListener(){

            @Override
            public void found(byte[] hash, Subscription subscription) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(byte[] hash, SubscriptionException error) {
                Object[] objectArray = result;
                synchronized (result) {
                    result[0] = error;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    sem.release();
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete(byte[] hash, Subscription[] subscriptions) {
                Object[] objectArray = result;
                synchronized (result) {
                    result[0] = subscriptions.length > 0 ? subscriptions[0] : new SubscriptionException("Subscription not found");
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    sem.release();
                    return;
                }
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        });
        sem.reserve();
        if (result[0] instanceof Subscription) {
            return (Subscription)result[0];
        }
        throw (SubscriptionException)result[0];
    }

    protected SubscriptionImpl lookupSingletonRSS(String name, URL url, boolean is_public, int check_interval_mins) throws SubscriptionException {
        this.checkURL(url);
        Map singleton_details = this.getSingletonMap(name, url, is_public, check_interval_mins);
        byte[] sid = SubscriptionBodyImpl.deriveSingletonShortID(singleton_details);
        return this.getSubscriptionFromSID(sid);
    }

    protected Subscription createSingletonRSSSupport(String name, URL url, boolean is_public, int check_interval_mins, int add_type, boolean subscribe) throws SubscriptionException {
        this.checkURL(url);
        try {
            SubscriptionImpl existing = this.lookupSingletonRSS(name, url, is_public, check_interval_mins);
            if (existing != null) {
                return existing;
            }
            Engine engine = MetaSearchManagerFactory.getSingleton().getMetaSearch().createRSSEngine(name, url);
            String json = SubscriptionImpl.getSkeletonJSON(engine, check_interval_mins);
            Map singleton_details = this.getSingletonMap(name, url, is_public, check_interval_mins);
            boolean is_anonymous = false;
            SubscriptionImpl subs = new SubscriptionImpl(this, name, is_public, is_anonymous, singleton_details, json, add_type);
            subs.setSubscribed(subscribe);
            this.log("Created new singleton subscription: " + subs.getString());
            subs = this.addSubscription(subs);
            return subs;
        }
        catch (SubscriptionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SubscriptionException("Failed to create subscription", e);
        }
    }

    protected String getUniqueName(String name) {
        for (int i = 0; i < 1024; ++i) {
            String test_name = name + (i == 0 ? "" : " (" + i + ")");
            if (this.getSubscriptionFromName(test_name) != null) continue;
            return test_name;
        }
        return name;
    }

    protected Map getSingletonMap(String name, URL url, boolean is_public, int check_interval_mins) throws SubscriptionException {
        try {
            HashMap<String, Object> singleton_details = new HashMap<String, Object>();
            if (url.getProtocol().equalsIgnoreCase("vuze")) {
                singleton_details.put("key", url.toExternalForm().getBytes("ISO-8859-1"));
            } else {
                singleton_details.put("key", url.toExternalForm().getBytes("UTF-8"));
            }
            String name2 = name.length() > 64 ? name.substring(0, 64) : name;
            singleton_details.put("name", name2);
            if (check_interval_mins != 120) {
                singleton_details.put("ci", new Long(check_interval_mins));
            }
            return singleton_details;
        }
        catch (Throwable e) {
            throw new SubscriptionException("Failed to create subscription", e);
        }
    }

    protected SubscriptionImpl createSingletonSubscription(Map singleton_details, int add_type, boolean subscribe) throws SubscriptionException {
        try {
            String name = ImportExportUtils.importString(singleton_details, "name", "(Anonymous)");
            URL url = new URL(ImportExportUtils.importString(singleton_details, "key"));
            int check_interval_mins = (int)ImportExportUtils.importLong(singleton_details, "ci", 120L);
            SubscriptionImpl s = (SubscriptionImpl)this.createSingletonRSSSupport(name, url, true, check_interval_mins, add_type, subscribe);
            return s;
        }
        catch (Throwable e) {
            this.log("Creation of singleton from " + singleton_details + " failed", e);
            throw new SubscriptionException("Creation of singleton from " + singleton_details + " failed", e);
        }
    }

    @Override
    public void requestSubscription(URL url, Map<String, Object> options) {
        for (SubscriptionManagerListener listener : this.listeners) {
            try {
                listener.subscriptionRequested(url, options);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public void requestSubscription(SearchProvider sp, Map<String, Object> search_parameters) throws org.gudy.azureus2.plugins.utils.subscriptions.SubscriptionException {
        try {
            Boolean silent;
            Engine engine = MetaSearchManagerFactory.getSingleton().getEngine(sp);
            if (engine == null) {
                throw new SubscriptionException("Engine not found ");
            }
            Boolean anonymous = (Boolean)search_parameters.get("_anonymous_");
            String term = (String)search_parameters.get("s");
            String[] networks = (String[])search_parameters.get("n");
            String networks_str = null;
            if (networks != null && networks.length > 0) {
                networks_str = "";
                for (String network : networks) {
                    networks_str = networks_str + (networks_str.length() == 0 ? "" : ",") + network;
                }
            }
            String json = SubscriptionImpl.getSkeletonJSON(engine, term, networks_str, 60);
            String name = (String)search_parameters.get("t");
            if (name == null || name.length() == 0) {
                name = engine.getName() + ": " + search_parameters.get("s");
            }
            boolean anon = anonymous != null && anonymous != false;
            SubscriptionImpl subs = new SubscriptionImpl(this, name, engine.isPublic(), anon, null, json, 1);
            if (anon) {
                subs.getHistory().setDownloadNetworks(new String[]{"I2P"});
            }
            this.log("Created new subscription: " + subs.getString());
            subs = this.addSubscription(subs);
            Number freq = (Number)search_parameters.get("_frequency_");
            if (freq != null) {
                subs.getHistory().setCheckFrequencyMins(freq.intValue());
            }
            if (subs.isPublic()) {
                this.updatePublicSubscription(subs);
            }
            if ((silent = (Boolean)search_parameters.get("_silent_")) == null || !silent.booleanValue()) {
                subs.requestAttention();
            }
        }
        catch (Throwable e) {
            throw new org.gudy.azureus2.plugins.utils.subscriptions.SubscriptionException("Failed to create subscription", e);
        }
    }

    @Override
    public Subscription createRSS(String name, URL url, int check_interval_mins, Map user_data) throws SubscriptionException {
        return this.createRSS(name, url, check_interval_mins, false, user_data);
    }

    @Override
    public Subscription createRSS(String name, URL url, int check_interval_mins, boolean is_anonymous, Map user_data) throws SubscriptionException {
        this.checkURL(url);
        try {
            name = this.getUniqueName(name);
            Engine engine = MetaSearchManagerFactory.getSingleton().getMetaSearch().createRSSEngine(name, url);
            String json = SubscriptionImpl.getSkeletonJSON(engine, check_interval_mins);
            SubscriptionImpl subs = new SubscriptionImpl(this, engine.getName(), engine.isPublic(), is_anonymous, null, json, 1);
            if (user_data != null) {
                for (Map.Entry entry : user_data.entrySet()) {
                    subs.setUserData(entry.getKey(), entry.getValue());
                }
            }
            this.log("Created new subscription: " + subs.getString());
            subs = this.addSubscription(subs);
            if (subs.isPublic()) {
                this.updatePublicSubscription(subs);
            }
            return subs;
        }
        catch (Throwable e) {
            throw new SubscriptionException("Failed to create subscription", e);
        }
    }

    protected void checkURL(URL url) throws SubscriptionException {
        String protocol;
        if (!(url.getHost().trim().length() != 0 || (protocol = url.getProtocol().toLowerCase()).equals("azplug") || protocol.equals("file") || protocol.equals("vuze"))) {
            throw new SubscriptionException("Invalid URL '" + url + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SubscriptionImpl addSubscription(SubscriptionImpl subs) {
        SubscriptionImpl existing;
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            int index = Collections.binarySearch(this.subscriptions, subs, new Comparator<Subscription>(){

                @Override
                public int compare(Subscription arg0, Subscription arg1) {
                    return arg0.getID().compareTo(arg1.getID());
                }
            });
            if (index < 0) {
                existing = null;
                index = -1 * index - 1;
                this.subscriptions.add(index, subs);
                this.saveConfig();
            } else {
                existing = this.subscriptions.get(index);
            }
        }
        if (existing != null) {
            this.log("Attempted to add subscription when already present: " + subs.getString());
            subs.destroy();
            return existing;
        }
        if (subs.isMine()) {
            this.addMetaSearchListener();
        }
        if (subs.getCachedPopularity() == -1L) {
            try {
                subs.getPopularity(new SubscriptionPopularityListener(){

                    @Override
                    public void gotPopularity(long popularity) {
                    }

                    @Override
                    public void failed(SubscriptionException error) {
                    }
                });
            }
            catch (Throwable e) {
                this.log("", e);
            }
        }
        Iterator<SubscriptionManagerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().subscriptionAdded(subs);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (subs.isSubscribed() && subs.isPublic()) {
            this.setSelected(subs);
        }
        if (this.dht_plugin_public != null) {
            new AEThread2("Publish check", true){

                @Override
                public void run() {
                    SubscriptionManagerImpl.this.publishSubscriptions();
                }
            }.start();
        }
        return subs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMetaSearchListener() {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            if (this.meta_search_listener_added) {
                return;
            }
            this.meta_search_listener_added = true;
        }
        MetaSearchManagerFactory.getSingleton().getMetaSearch().addListener(new MetaSearchListener(){

            @Override
            public void engineAdded(Engine engine) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void engineUpdated(Engine engine) {
                SubscriptionManagerImpl subscriptionManagerImpl = SubscriptionManagerImpl.this;
                synchronized (subscriptionManagerImpl) {
                    for (int i = 0; i < SubscriptionManagerImpl.this.subscriptions.size(); ++i) {
                        SubscriptionImpl subs = (SubscriptionImpl)SubscriptionManagerImpl.this.subscriptions.get(i);
                        if (!subs.isMine()) continue;
                        subs.engineUpdated(engine);
                    }
                }
            }

            @Override
            public void engineRemoved(Engine engine) {
            }

            @Override
            public void engineStateChanged(Engine engine) {
            }
        });
    }

    protected void changeSubscription(SubscriptionImpl subs) {
        if (!subs.isRemoved()) {
            Iterator<SubscriptionManagerListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                try {
                    it.next().subscriptionChanged(subs);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    protected void selectSubscription(SubscriptionImpl subs) {
        if (!subs.isRemoved()) {
            Iterator<SubscriptionManagerListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                try {
                    it.next().subscriptionSelected(subs);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubscription(SubscriptionImpl subs) {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            if (!this.subscriptions.remove(subs)) {
                return;
            }
            this.saveConfig();
        }
        try {
            Engine engine = subs.getEngine(true);
            if (engine.getType() == 4) {
                engine.delete();
                this.log("Removed engine " + engine.getName() + " due to subscription removal");
            }
        }
        catch (Throwable e) {
            this.log("Failed to check for engine deletion", e);
        }
        Iterator<SubscriptionManagerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().subscriptionRemoved(subs);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        try {
            FileUtil.deleteResilientFile(this.getResultsFile(subs));
            Map<SubscriptionImpl, Object[]> e = this.result_cache;
            synchronized (e) {
                this.result_cache.remove(subs);
            }
            File vuze_file = this.getVuzeFile(subs);
            vuze_file.delete();
            new File(vuze_file.getParent(), vuze_file.getName() + ".bak").delete();
        }
        catch (Throwable e) {
            this.log("Failed to delete results/vuze file", e);
        }
    }

    protected void updatePublicSubscription(final SubscriptionImpl subs) {
        if (subs.isSingleton()) {
            subs.setServerPublished();
        } else {
            final AESemaphore sem = new AESemaphore("pub:async");
            this.async_dispatcher.dispatch(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    try {
                        Long l_last_pub = (Long)subs.getUserData(SP_LAST_ATTEMPTED);
                        Long l_consec_fail = (Long)subs.getUserData(SP_CONSEC_FAIL);
                        if (l_last_pub != null && l_consec_fail != null) {
                            long delay = 600000L;
                            int i = 0;
                            while ((long)i < l_consec_fail && (delay <<= 1) <= 86400000L) {
                                ++i;
                            }
                            if (l_last_pub + delay > SystemTime.getMonotonousTime()) {
                                return;
                            }
                        }
                        try {
                            File vf = SubscriptionManagerImpl.this.getVuzeFile(subs);
                            byte[] bytes = FileUtil.readFileAsByteArray(vf);
                            byte[] encoded_subs = Base64.encode(bytes);
                            PlatformSubscriptionsMessenger.updateSubscription(!subs.getServerPublished(), subs.getName(false), subs.getPublicKey(), subs.getPrivateKey(), subs.getShortID(), subs.getVersion(), subs.isAnonymous(), new String(encoded_subs));
                            subs.setUserData(SP_LAST_ATTEMPTED, null);
                            subs.setUserData(SP_CONSEC_FAIL, null);
                            subs.setServerPublished();
                            SubscriptionManagerImpl.this.log("    Updated public subscription " + subs.getString());
                        }
                        catch (Throwable e) {
                            SubscriptionManagerImpl.this.log("    Failed to update public subscription " + subs.getString(), e);
                            subs.setUserData(SP_LAST_ATTEMPTED, new Long(SystemTime.getMonotonousTime()));
                            subs.setUserData(SP_CONSEC_FAIL, new Long(l_consec_fail == null ? 1L : l_consec_fail + 1L));
                            subs.setServerPublicationOutstanding();
                        }
                    }
                    finally {
                        sem.release();
                    }
                }
            });
            sem.reserve(5000L);
        }
    }

    protected void checkSingletonPublish(SubscriptionImpl subs) throws SubscriptionException {
        if (subs.getSingletonPublishAttempted()) {
            throw new SubscriptionException("Singleton publish already attempted");
        }
        subs.setSingletonPublishAttempted();
        try {
            File vf = this.getVuzeFile(subs);
            byte[] bytes = FileUtil.readFileAsByteArray(vf);
            byte[] encoded_subs = Base64.encode(bytes);
            KeyPair kp = CryptoECCUtils.createKeys();
            byte[] public_key = CryptoECCUtils.keyToRawdata(kp.getPublic());
            byte[] private_key = CryptoECCUtils.keyToRawdata(kp.getPrivate());
            PlatformSubscriptionsMessenger.updateSubscription(true, subs.getName(false), public_key, private_key, subs.getShortID(), 1, subs.isAnonymous(), new String(encoded_subs));
            this.log("    created singleton public subscription " + subs.getString());
        }
        catch (Throwable e) {
            throw new SubscriptionException("Failed to publish singleton", e);
        }
    }

    protected void checkServerPublications(List subs) {
        for (int i = 0; i < subs.size(); ++i) {
            SubscriptionImpl sub = (SubscriptionImpl)subs.get(i);
            if (!sub.getServerPublicationOutstanding()) continue;
            this.updatePublicSubscription(sub);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkStuff(int ticks) {
        ArrayList<SubscriptionImpl> subs;
        long now = SystemTime.getCurrentTime();
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            subs = new ArrayList<SubscriptionImpl>(this.subscriptions);
        }
        SubscriptionImpl expired_subs = null;
        for (int i = 0; i < subs.size(); ++i) {
            long age;
            SubscriptionImpl sub = (SubscriptionImpl)subs.get(i);
            if (!sub.isMine() && !sub.isSubscribed() && (age = now - sub.getAddTime()) > 1209600000L) {
                if (expired_subs != null && sub.getAddTime() >= expired_subs.getAddTime()) continue;
                expired_subs = sub;
                continue;
            }
            sub.checkPublish();
        }
        if (expired_subs != null) {
            this.log("Removing unsubscribed subscription '" + expired_subs.getName() + "' as expired");
            expired_subs.remove();
        }
        if (ticks % 6 == 0) {
            ArrayList<SubscriptionImpl> subs_copy = new ArrayList<SubscriptionImpl>(subs);
            Collections.shuffle(subs_copy);
            long mono_now = SystemTime.getMonotonousTime();
            for (final SubscriptionImpl sub : subs_copy) {
                Long data;
                if (!sub.isSubscribed() || sub.isSearchTemplate() || (data = (Long)sub.getUserData(SUBS_CHAT_KEY)) != null && (data < 0L || mono_now - data < 14400000L)) continue;
                String chat_key = SubscriptionUtils.getSubscriptionChatKey(sub);
                if (chat_key != null) {
                    sub.setUserData(SUBS_CHAT_KEY, -1L);
                    SubscriptionUtils.peekChatAsync(sub.isAnonymous() ? "I2P" : "Public", chat_key, new Runnable(){

                        @Override
                        public void run() {
                            sub.setUserData(SUBS_CHAT_KEY, SystemTime.getMonotonousTime());
                        }
                    });
                    break;
                }
                sub.setUserData(SUBS_CHAT_KEY, -2L);
            }
        }
        if (ticks % 10 == 0) {
            this.lookupAssociations(false);
        }
        if (ticks % 10 == 0) {
            int rem = this.getPublishRemainingCount();
            if (rem == 0) {
                this.log("No associations to publish");
            } else {
                this.log(rem + " associations remaining to publish");
                this.publishAssociations();
            }
        }
        if (ticks % 20 == 0) {
            this.checkServerPublications(subs);
        }
        if (ticks % 60 == 0) {
            this.tidyPotentialAssociations();
        }
        if (ticks == 6 || ticks % 2760 == 0) {
            this.setSelected(subs);
        }
    }

    public Subscription importSubscription(int type, Map map, boolean warn_user) throws SubscriptionException {
        boolean log_errors = true;
        try {
            try {
                String subs_name;
                if (type == 32) {
                    String name = new String((byte[])map.get("name"), "UTF-8");
                    URL url = new URL(new String((byte[])map.get("url"), "UTF-8"));
                    Long l_interval = (Long)map.get("check_interval_mins");
                    int check_interval_mins = l_interval == null ? 120 : l_interval.intValue();
                    Long l_public = (Long)map.get("public");
                    boolean is_public = l_public == null ? true : l_public == 1L;
                    SubscriptionImpl existing = this.lookupSingletonRSS(name, url, is_public, check_interval_mins);
                    if (UrlFilter.getInstance().urlCanRPC(url.toExternalForm())) {
                        warn_user = false;
                    }
                    if (existing != null && existing.isSubscribed()) {
                        if (warn_user) {
                            UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                            String details = MessageText.getString("subscript.add.dup.desc", new String[]{existing.getName()});
                            ui_manager.showMessageBox("subscript.add.dup.title", "!" + details + "!", 1L);
                        }
                        this.selectSubscription(existing);
                        return existing;
                    }
                    if (warn_user) {
                        UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                        String details = MessageText.getString("subscript.add.desc", new String[]{name});
                        long res = ui_manager.showMessageBox("subscript.add.title", "!" + details + "!", 12L);
                        if (res != 4L) {
                            log_errors = false;
                            throw new SubscriptionException("User declined addition");
                        }
                    }
                    if (existing == null) {
                        SubscriptionImpl new_subs = (SubscriptionImpl)this.createSingletonRSSSupport(name, url, is_public, check_interval_mins, 2, true);
                        this.log("Imported new singleton subscription: " + new_subs.getString());
                        return new_subs;
                    }
                    existing.setSubscribed(true);
                    this.selectSubscription(existing);
                    return existing;
                }
                SubscriptionBodyImpl body = new SubscriptionBodyImpl(this, map);
                SubscriptionImpl existing = this.getSubscriptionFromSID(body.getShortID());
                if (existing != null && existing.isSubscribed()) {
                    if (existing.getVersion() >= body.getVersion()) {
                        this.log("Not upgrading subscription: " + existing.getString() + " as supplied (" + body.getVersion() + ") is not more recent than existing (" + existing.getVersion() + ")");
                        if (warn_user) {
                            UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                            String details = MessageText.getString("subscript.add.dup.desc", new String[]{existing.getName()});
                            ui_manager.showMessageBox("subscript.add.dup.title", "!" + details + "!", 1L);
                        }
                        this.selectSubscription(existing);
                        return existing;
                    }
                    if (warn_user) {
                        UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                        String details = MessageText.getString("subscript.add.upgrade.desc", new String[]{existing.getName()});
                        long res = ui_manager.showMessageBox("subscript.add.upgrade.title", "!" + details + "!", 12L);
                        if (res != 4L) {
                            throw new SubscriptionException("User declined upgrade");
                        }
                    }
                    this.log("Upgrading subscription: " + existing.getString());
                    existing.upgrade(body);
                    this.saveConfig();
                    this.subscriptionUpdated();
                    return existing;
                }
                SubscriptionImpl new_subs = null;
                if (existing == null) {
                    new_subs = new SubscriptionImpl(this, body, 2, true);
                    subs_name = new_subs.getName();
                } else {
                    subs_name = existing.getName();
                }
                if (warn_user) {
                    UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                    String details = MessageText.getString("subscript.add.desc", new String[]{subs_name});
                    long res = ui_manager.showMessageBox("subscript.add.title", "!" + details + "!", 12L);
                    if (res != 4L) {
                        throw new SubscriptionException("User declined addition");
                    }
                }
                if (new_subs == null) {
                    existing.setSubscribed(true);
                    this.selectSubscription(existing);
                    return existing;
                }
                this.log("Imported new subscription: " + new_subs.getString());
                new_subs = this.addSubscription(new_subs);
                return new_subs;
            }
            catch (Throwable e) {
                throw new SubscriptionException("Subscription import failed", e);
            }
        }
        catch (SubscriptionException e) {
            if (warn_user && log_errors) {
                UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                String details = MessageText.getString("subscript.import.fail.desc", new String[]{Debug.getNestedExceptionMessage(e)});
                ui_manager.showMessageBox("subscript.import.fail.title", "!" + details + "!", 1L);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscription[] getSubscriptions() {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            return this.subscriptions.toArray(new SubscriptionImpl[this.subscriptions.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscription[] getSubscriptions(boolean subscribed_only) {
        if (!subscribed_only) {
            return this.getSubscriptions();
        }
        ArrayList<SubscriptionImpl> result = new ArrayList<SubscriptionImpl>();
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            for (int i = 0; i < this.subscriptions.size(); ++i) {
                SubscriptionImpl subs = this.subscriptions.get(i);
                if (!subs.isSubscribed()) continue;
                result.add(subs);
            }
        }
        return result.toArray(new SubscriptionImpl[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSubscriptionCount(boolean subscribed_only) {
        if (subscribed_only) {
            int total = 0;
            SubscriptionManagerImpl subscriptionManagerImpl = this;
            synchronized (subscriptionManagerImpl) {
                for (SubscriptionImpl subs : this.subscriptions) {
                    if (!subs.isSubscribed()) continue;
                    ++total;
                }
            }
            return total;
        }
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            return this.subscriptions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SubscriptionImpl getSubscriptionFromName(String name) {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            for (int i = 0; i < this.subscriptions.size(); ++i) {
                SubscriptionImpl s = this.subscriptions.get(i);
                if (!s.getName().equalsIgnoreCase(name)) continue;
                return s;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscription getSubscriptionByID(String id) {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            int index = Collections.binarySearch(this.subscriptions, id, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String id1 = o1 instanceof Subscription ? ((Subscription)o1).getID() : o1.toString();
                    String id2 = o2 instanceof Subscription ? ((Subscription)o2).getID() : o2.toString();
                    return id1.compareTo(id2);
                }
            });
            if (index >= 0) {
                return this.subscriptions.get(index);
            }
        }
        return null;
    }

    protected SubscriptionImpl getSubscriptionFromSID(byte[] sid) {
        return (SubscriptionImpl)this.getSubscriptionByID(Base32.encode(sid));
    }

    protected File getSubsDir() throws IOException {
        File dir = new File(SystemProperties.getUserPath());
        if (!(dir = new File(dir, "subs")).exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create '" + dir + "'");
        }
        return dir;
    }

    protected File getVuzeFile(SubscriptionImpl subs) throws IOException {
        File dir = this.getSubsDir();
        return new File(dir, ByteFormatter.encodeString(subs.getShortID()) + ".vuze");
    }

    protected File getResultsFile(SubscriptionImpl subs) throws IOException {
        File dir = this.getSubsDir();
        return new File(dir, ByteFormatter.encodeString(subs.getShortID()) + ".results");
    }

    @Override
    public int getKnownSubscriptionCount() {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        Download[] downloads = pi.getDownloadManager().getDownloads();
        ByteArrayHashMap<String> results = new ByteArrayHashMap<String>(Math.max(16, downloads.length * 2));
        try {
            for (Download download : downloads) {
                List s;
                Map m = download.getMapAttribute(this.ta_subscription_info);
                if (m == null || (s = (List)m.get("s")) == null || s.size() <= 0) continue;
                for (int i = 0; i < s.size(); ++i) {
                    byte[] sid = (byte[])s.get(i);
                    results.put(sid, "");
                }
            }
        }
        catch (Throwable e) {
            this.log("Failed to get known subscriptions", e);
        }
        return results.size();
    }

    @Override
    public Subscription[] getKnownSubscriptions(byte[] hash) {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        try {
            List s;
            Map m;
            Download download = pi.getDownloadManager().getDownload(hash);
            if (download != null && (m = download.getMapAttribute(this.ta_subscription_info)) != null && (s = (List)m.get("s")) != null && s.size() > 0) {
                ArrayList<SubscriptionImpl> result = new ArrayList<SubscriptionImpl>(s.size());
                boolean hide_search = this.hideSearchTemplates();
                for (int i = 0; i < s.size(); ++i) {
                    byte[] sid = (byte[])s.get(i);
                    SubscriptionImpl subs = this.getSubscriptionFromSID(sid);
                    if (subs == null || !this.isVisible(subs) || hide_search && subs.isSearchTemplate()) continue;
                    result.add(subs);
                }
                return result.toArray(new Subscription[result.size()]);
            }
        }
        catch (Throwable e) {
            this.log("Failed to get known subscriptions", e);
        }
        return new Subscription[0];
    }

    protected boolean subscriptionExists(Download download, SubscriptionImpl subs) {
        List s;
        byte[] sid = subs.getShortID();
        Map m = download.getMapAttribute(this.ta_subscription_info);
        if (m != null && (s = (List)m.get("s")) != null && s.size() > 0) {
            for (int i = 0; i < s.size(); ++i) {
                byte[] x = (byte[])s.get(i);
                if (!Arrays.equals(x, sid)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean downloadIsIgnored(Download download) {
        return download.getTorrent() == null || !download.isPersistent();
    }

    protected boolean isVisible(SubscriptionImpl subs) {
        if (Constants.isCVSVersion() || subs.isSubscribed()) {
            return true;
        }
        try {
            Engine engine = subs.getEngine(true);
            if (engine instanceof WebEngine) {
                String url = ((WebEngine)engine).getSearchUrl();
                try {
                    String host = new URL(url).getHost();
                    return !this.exclusion_pattern.matcher(host).matches();
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (Throwable e) {
            this.log("isVisible failed for " + subs.getString(), e);
            return false;
        }
    }

    @Override
    public Subscription[] getLinkedSubscriptions(byte[] hash) {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        try {
            List s;
            Map m;
            Download download = pi.getDownloadManager().getDownload(hash);
            if (download != null && (m = download.getMapAttribute(this.ta_subscription_info)) != null && (s = (List)m.get("s")) != null && s.size() > 0) {
                ArrayList<SubscriptionImpl> result = new ArrayList<SubscriptionImpl>(s.size());
                for (int i = 0; i < s.size(); ++i) {
                    byte[] sid = (byte[])s.get(i);
                    SubscriptionImpl subs = this.getSubscriptionFromSID(sid);
                    if (subs == null || !subs.hasAssociation(hash)) continue;
                    result.add(subs);
                }
                return result.toArray(new Subscription[result.size()]);
            }
        }
        catch (Throwable e) {
            this.log("Failed to get known subscriptions", e);
        }
        return new Subscription[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lookupAssociations(boolean high_priority) {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            if (this.periodic_lookup_in_progress) {
                if (high_priority) {
                    ++this.priority_lookup_pending;
                }
                return;
            }
            this.periodic_lookup_in_progress = true;
        }
        try {
            PluginInterface pi = PluginInitializer.getDefaultInterface();
            Download[] downloads = pi.getDownloadManager().getDownloads();
            long now = SystemTime.getCurrentTime();
            long newest_time = 0L;
            Download newest_download = null;
            for (int i = 0; i < downloads.length; ++i) {
                long create_time;
                int time_between_checks;
                List subs;
                int sub_count;
                long last_check;
                Download download = downloads[i];
                if (this.downloadIsIgnored(download)) continue;
                LightHashMap map = download.getMapAttribute(this.ta_subscription_info);
                map = map == null ? new LightHashMap() : new LightHashMap(map);
                Long l_last_check = (Long)map.get("lc");
                long l = last_check = l_last_check == null ? 0L : l_last_check;
                if (last_check > now) {
                    last_check = now;
                    map.put("lc", new Long(last_check));
                    download.setMapAttribute(this.ta_subscription_info, map);
                }
                int n = sub_count = (subs = (List)map.get("s")) == null ? 0 : subs.size();
                if (sub_count > 8 || now - last_check < (long)(time_between_checks = (sub_count + 1) * 24 * 60 * 60 * 1000 + (int)((create_time = download.getCreationTime()) % 4L * 60L * 60L * 1000L)) || create_time <= newest_time) continue;
                newest_time = create_time;
                newest_download = download;
            }
            if (newest_download != null) {
                DHTPluginInterface dht_plugin = this.selectDHTPlugin(newest_download);
                if (dht_plugin != null) {
                    byte[] hash = newest_download.getTorrent().getHash();
                    this.log("Association lookup starts for " + newest_download.getName() + "/" + ByteFormatter.encodeString(hash));
                    this.lookupAssociationsSupport(dht_plugin, hash, new SubscriptionLookupListener(){

                        @Override
                        public void found(byte[] hash, Subscription subscription) {
                        }

                        @Override
                        public void failed(byte[] hash, SubscriptionException error) {
                            SubscriptionManagerImpl.this.log("Association lookup failed for " + ByteFormatter.encodeString(hash), error);
                            SubscriptionManagerImpl.this.associationLookupComplete();
                        }

                        @Override
                        public void complete(byte[] hash, Subscription[] subs) {
                            SubscriptionManagerImpl.this.log("Association lookup complete for " + ByteFormatter.encodeString(hash));
                            SubscriptionManagerImpl.this.associationLookupComplete();
                        }
                    });
                } else {
                    this.associationLookupComplete();
                }
            } else {
                this.associationLookupComplete();
            }
        }
        catch (Throwable e) {
            this.log("Association lookup check failed", e);
            this.associationLookupComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void associationLookupComplete() {
        boolean recheck;
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            this.periodic_lookup_in_progress = false;
            boolean bl = recheck = this.priority_lookup_pending > 0;
            if (recheck) {
                --this.priority_lookup_pending;
            }
        }
        if (recheck) {
            new AEThread2("SM:priAssLookup", true){

                @Override
                public void run() {
                    SubscriptionManagerImpl.this.lookupAssociations(false);
                }
            }.start();
        }
    }

    protected void setSelected(List subs) {
        ArrayList<byte[]> sids = new ArrayList<byte[]>();
        ArrayList<SubscriptionImpl> used_subs = new ArrayList<SubscriptionImpl>();
        final ArrayList<SubscriptionImpl> dht_pops = new ArrayList<SubscriptionImpl>();
        for (int i = 0; i < subs.size(); ++i) {
            SubscriptionImpl sub = (SubscriptionImpl)subs.get(i);
            if (!sub.isSubscribed()) continue;
            if (sub.isPublic()) {
                if (!sub.isAnonymous()) {
                    used_subs.add(sub);
                    sids.add(sub.getShortID());
                    continue;
                }
                dht_pops.add(sub);
                continue;
            }
            this.checkInitialDownload(sub);
        }
        if (sids.size() > 0) {
            try {
                List[] result = PlatformSubscriptionsMessenger.setSelected(sids);
                List versions = result[0];
                List popularities = result[1];
                this.log("Popularity update: updated " + sids.size());
                for (int i = 0; i < sids.size(); ++i) {
                    SubscriptionImpl sub = (SubscriptionImpl)used_subs.get(i);
                    int latest_version = ((Long)versions.get(i)).intValue();
                    if (latest_version > sub.getVersion()) {
                        this.updateSubscription(sub, latest_version);
                    } else {
                        this.checkInitialDownload(sub);
                    }
                    if (latest_version > 0) {
                        try {
                            long pop = (Long)popularities.get(i);
                            if (pop < 0L || pop == sub.getCachedPopularity()) continue;
                            sub.setCachedPopularity(pop);
                        }
                        catch (Throwable e) {
                            this.log("Popularity update: Failed to extract popularity", e);
                        }
                        continue;
                    }
                    dht_pops.add(sub);
                }
            }
            catch (Throwable e) {
                this.log("Popularity update: Failed to record selected subscriptions", e);
            }
        } else {
            this.log("Popularity update: No selected, public subscriptions");
        }
        if (dht_pops.size() <= 3) {
            for (int i = 0; i < dht_pops.size(); ++i) {
                this.updatePopularityFromDHT((SubscriptionImpl)dht_pops.get(i), false);
            }
        } else {
            new AEThread2("SM:asyncPop", true){

                @Override
                public void run() {
                    for (int i = 0; i < dht_pops.size(); ++i) {
                        SubscriptionManagerImpl.this.updatePopularityFromDHT((SubscriptionImpl)dht_pops.get(i), true);
                    }
                }
            }.start();
        }
    }

    protected void checkUpgrade(SubscriptionImpl sub) {
        this.setSelected(sub);
    }

    protected void setSelected(final SubscriptionImpl sub) {
        if (sub.isSubscribed()) {
            if (sub.isPublic()) {
                new DelayedEvent("SM:setSelected", 0L, new AERunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void runSupport() {
                        block14: {
                            try {
                                if (!sub.isAnonymous()) {
                                    ArrayList<byte[]> sids = new ArrayList<byte[]>();
                                    sids.add(sub.getShortID());
                                    List[] result = PlatformSubscriptionsMessenger.setSelected(sids);
                                    SubscriptionManagerImpl.this.log("setSelected: " + sub.getName());
                                    int latest_version = ((Long)result[0].get(0)).intValue();
                                    if (latest_version == 0) {
                                        if (sub.isSingleton()) {
                                            SubscriptionManagerImpl.this.checkSingletonPublish(sub);
                                        }
                                    } else if (latest_version > sub.getVersion()) {
                                        SubscriptionManagerImpl.this.updateSubscription(sub, latest_version);
                                    }
                                    if (latest_version > 0) {
                                        try {
                                            long pop = (Long)result[1].get(0);
                                            if (pop >= 0L && pop != sub.getCachedPopularity()) {
                                                sub.setCachedPopularity(pop);
                                            }
                                            break block14;
                                        }
                                        catch (Throwable e) {
                                            SubscriptionManagerImpl.this.log("Popularity update: Failed to extract popularity", e);
                                        }
                                        break block14;
                                    }
                                    SubscriptionManagerImpl.this.updatePopularityFromDHT(sub, true);
                                    break block14;
                                }
                                SubscriptionManagerImpl.this.updatePopularityFromDHT(sub, true);
                            }
                            catch (Throwable e) {
                                SubscriptionManagerImpl.this.log("setSelected: failed for " + sub.getName(), e);
                            }
                            finally {
                                SubscriptionManagerImpl.this.checkInitialDownload(sub);
                            }
                        }
                    }
                });
            } else {
                this.checkInitialDownload(sub);
            }
        }
    }

    protected void checkInitialDownload(SubscriptionImpl subs) {
        if (subs.getHistory().getLastScanTime() == 0L) {
            this.scheduler.download(subs, true, new SubscriptionDownloadListener(){

                @Override
                public void complete(Subscription subs) {
                    SubscriptionManagerImpl.this.log("Initial download of " + subs.getName() + " complete");
                }

                @Override
                public void failed(Subscription subs, SubscriptionException error) {
                    SubscriptionManagerImpl.this.log("Initial download of " + subs.getName() + " failed", error);
                }
            });
        }
    }

    @Override
    public SubscriptionAssociationLookup lookupAssociations(byte[] hash, String[] networks, SubscriptionLookupListener listener) throws SubscriptionException {
        return this.lookupAssociations(this.selectDHTPlugin(networks), hash, listener);
    }

    @Override
    public SubscriptionAssociationLookup lookupAssociations(byte[] hash, SubscriptionLookupListener listener) throws SubscriptionException {
        DHTPluginInterface dht_plugin;
        try {
            Download download = PluginInitializer.getDefaultInterface().getDownloadManager().getDownload(hash);
            dht_plugin = download != null ? this.selectDHTPlugin(download) : this.dht_plugin_public;
        }
        catch (Throwable e) {
            dht_plugin = this.dht_plugin_public;
        }
        return this.lookupAssociations(dht_plugin, hash, listener);
    }

    private SubscriptionAssociationLookup lookupAssociations(DHTPluginInterface dht_plugin, final byte[] hash, final SubscriptionLookupListener listener) throws SubscriptionException {
        if (dht_plugin != null) {
            if (!dht_plugin.isInitialising()) {
                return this.lookupAssociationsSupport(dht_plugin, hash, listener);
            }
            final boolean[] cancelled = new boolean[]{false};
            final long[] timeout = new long[]{0L};
            final SubscriptionAssociationLookup[] actual_res = new SubscriptionAssociationLookup[]{null};
            SubscriptionAssociationLookup res = new SubscriptionAssociationLookup(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void cancel() {
                    SubscriptionManagerImpl.this.log("    Association lookup cancelled");
                    SubscriptionAssociationLookup[] subscriptionAssociationLookupArray = actual_res;
                    synchronized (actual_res) {
                        cancelled[0] = true;
                        if (actual_res[0] != null) {
                            actual_res[0].cancel();
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void setTimeout(long millis) {
                    SubscriptionAssociationLookup[] subscriptionAssociationLookupArray = actual_res;
                    synchronized (actual_res) {
                        timeout[0] = millis;
                        if (actual_res[0] != null) {
                            actual_res[0].setTimeout(millis);
                        }
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        return;
                    }
                }
            };
            final DHTPluginInterface f_dht_plugin = dht_plugin;
            new AEThread2("SM:initwait", true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SubscriptionAssociationLookup x = SubscriptionManagerImpl.this.lookupAssociationsSupport(f_dht_plugin, hash, listener);
                        SubscriptionAssociationLookup[] subscriptionAssociationLookupArray = actual_res;
                        synchronized (actual_res) {
                            actual_res[0] = x;
                            if (cancelled[0]) {
                                x.cancel();
                            }
                            if (timeout[0] != 0L) {
                                x.setTimeout(timeout[0]);
                            }
                            // ** MonitorExit[var2_3] (shouldn't be in output)
                        }
                    }
                    catch (SubscriptionException e) {
                        listener.failed(hash, e);
                    }
                    {
                        return;
                    }
                }
            }.start();
            return res;
        }
        throw new SubscriptionException("No DHT available");
    }

    protected SubscriptionAssociationLookup lookupAssociationsSupport(DHTPluginInterface dht_plugin, final byte[] hash, final SubscriptionLookupListener _listener) throws SubscriptionException {
        this.log("Looking up associations for '" + ByteFormatter.encodeString(hash));
        String key = "subscription:assoc:" + ByteFormatter.encodeString(hash);
        final boolean[] cancelled = new boolean[]{false};
        final SubscriptionException timeout_exception = new SubscriptionException("Timeout");
        final SubscriptionLookupListener listener = new SubscriptionLookupListener(){
            private boolean done = false;
            private List<Subscription> subs = new ArrayList<Subscription>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void found(byte[] hash, Subscription subscription) {
                27 var3_3 = this;
                synchronized (var3_3) {
                    if (this.done) {
                        return;
                    }
                    this.subs.add(subscription);
                }
                _listener.found(hash, subscription);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete(byte[] hash, Subscription[] subscriptions) {
                27 var3_3 = this;
                synchronized (var3_3) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                }
                _listener.complete(hash, subscriptions);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(byte[] hash, SubscriptionException error) {
                Subscription[] subscriptions;
                27 var4_3 = this;
                synchronized (var4_3) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                    subscriptions = this.subs.toArray(new Subscription[this.subs.size()]);
                }
                if (error == timeout_exception) {
                    _listener.complete(hash, subscriptions);
                } else {
                    _listener.failed(hash, error);
                }
            }
        };
        dht_plugin.get(this.getKeyBytes(key), "Subs assoc read: " + Base32.encode(hash).substring(0, 16), (byte)0, 30, 60000 * (dht_plugin != this.dht_plugin_public ? 2 : 1), true, true, new DHTPluginOperationListener(){
            private Map<HashWrapper, Integer> hits = new HashMap<HashWrapper, Integer>();
            private AESemaphore hits_sem = new AESemaphore("Subs:lookup");
            private List<Subscription> found_subscriptions = new ArrayList<Subscription>();
            private boolean complete;
            private AsyncDispatcher dispatcher = new AsyncDispatcher("SubsMan:AL");

            @Override
            public boolean diversified() {
                return true;
            }

            @Override
            public void starts(byte[] key) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                if (this.isCancelled2()) {
                    return;
                }
                byte[] val = value.getValue();
                if (val.length > 4) {
                    Object v;
                    final int ver = val[0] << 16 & 0xFF0000 | val[1] << 8 & 0xFF00 | val[2] & 0xFF;
                    final byte[] sid = new byte[val.length - 4];
                    System.arraycopy(val, 4, sid, 0, sid.length);
                    HashWrapper hw = new HashWrapper(sid);
                    boolean new_sid = false;
                    Map<HashWrapper, Integer> map = this.hits;
                    synchronized (map) {
                        if (this.complete) {
                            return;
                        }
                        v = this.hits.get(hw);
                        if (v != null) {
                            if (ver > (Integer)v) {
                                this.hits.put(hw, new Integer(ver));
                            }
                        } else {
                            new_sid = true;
                            this.hits.put(hw, new Integer(ver));
                        }
                    }
                    if (new_sid) {
                        SubscriptionManagerImpl.this.log("    Found subscription " + ByteFormatter.encodeString(sid) + " version " + ver);
                        SubscriptionImpl subs = SubscriptionManagerImpl.this.getSubscriptionFromSID(sid);
                        if (subs != null) {
                            v = this.hits;
                            synchronized (v) {
                                this.found_subscriptions.add(subs);
                            }
                            try {
                                listener.found(hash, subs);
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                            this.hits_sem.release();
                        } else {
                            this.dispatcher.dispatch(new AERunnable(){

                                @Override
                                public void runSupport() {
                                    SubscriptionManagerImpl.this.lookupSubscription(hash, sid, ver, new subsLookupListener(){
                                        private boolean sem_done = false;

                                        @Override
                                        public void found(byte[] hash, Subscription subscription) {
                                        }

                                        @Override
                                        public void complete(byte[] hash, Subscription[] subscriptions) {
                                            this.done(subscriptions);
                                        }

                                        @Override
                                        public void failed(byte[] hash, SubscriptionException error) {
                                            this.done(new Subscription[0]);
                                        }

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        protected void done(Subscription[] subs) {
                                            block14: {
                                                Object object = this;
                                                synchronized (object) {
                                                    if (this.sem_done) {
                                                        return;
                                                    }
                                                    this.sem_done = true;
                                                }
                                                try {
                                                    if (this.isCancelled()) {
                                                        return;
                                                    }
                                                    if (subs.length <= 0) break block14;
                                                    object = hits;
                                                    synchronized (object) {
                                                        found_subscriptions.add(subs[0]);
                                                    }
                                                    try {
                                                        listener.found(hash, subs[0]);
                                                    }
                                                    catch (Throwable e) {
                                                        Debug.printStackTrace(e);
                                                    }
                                                }
                                                finally {
                                                    hits_sem.release();
                                                }
                                            }
                                        }

                                        @Override
                                        public boolean isCancelled() {
                                            return this.isCancelled2();
                                        }
                                    });
                                }
                            });
                        }
                    }
                }
            }

            @Override
            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
            }

            @Override
            public void complete(byte[] original_key, boolean timeout_occurred) {
                new AEThread2("SubsManAL:comp"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Subscription[] s;
                        int num_hits;
                        Map map = hits;
                        synchronized (map) {
                            if (complete) {
                                return;
                            }
                            complete = true;
                            num_hits = hits.size();
                        }
                        for (int i = 0; i < num_hits; ++i) {
                            if (this.isCancelled2()) {
                                listener.failed(hash, new SubscriptionException("Cancelled"));
                                return;
                            }
                            hits_sem.reserve();
                        }
                        Map map2 = hits;
                        synchronized (map2) {
                            s = found_subscriptions.toArray(new SubscriptionImpl[found_subscriptions.size()]);
                        }
                        SubscriptionManagerImpl.this.log("    Association lookup complete - " + s.length + " found");
                        try {
                            SubscriptionManagerImpl.this.recordAssociations(hash, (SubscriptionImpl[])s, true);
                        }
                        finally {
                            listener.complete(hash, s);
                        }
                    }
                }.start();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected boolean isCancelled2() {
                boolean[] blArray = cancelled;
                synchronized (cancelled) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return cancelled[0];
                }
            }
        });
        return new SubscriptionAssociationLookup(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancel() {
                SubscriptionManagerImpl.this.log("    Association lookup cancelled");
                boolean[] blArray = cancelled;
                synchronized (cancelled) {
                    cancelled[0] = true;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }

            @Override
            public void setTimeout(long millis) {
                SimpleTimer.addEvent("subs:timeout", SystemTime.getOffsetTime(millis), new TimerEventPerformer(){

                    @Override
                    public void perform(TimerEvent event2) {
                        listener.failed(hash, timeout_exception);
                    }
                });
            }
        };
    }

    protected void getPopularity(SubscriptionImpl subs, SubscriptionPopularityListener listener) throws SubscriptionException {
        block6: {
            if (!subs.isAnonymous()) {
                try {
                    long pop = PlatformSubscriptionsMessenger.getPopularityBySID(subs.getShortID());
                    if (pop >= 0L) {
                        this.log("Got popularity of " + subs.getName() + " from platform: " + pop);
                        listener.gotPopularity(pop);
                        return;
                    }
                    if (!subs.isSingleton()) break block6;
                    try {
                        this.checkSingletonPublish(subs);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    listener.gotPopularity(subs.isSubscribed() ? 1L : 0L);
                    return;
                }
                catch (Throwable e) {
                    this.log("Subscription lookup via platform failed", e);
                }
            }
        }
        this.getPopularityFromDHT(subs, listener, true);
    }

    protected void getPopularityFromDHT(final SubscriptionImpl subs, final SubscriptionPopularityListener listener, final boolean sync) {
        final DHTPluginInterface dht_plugin = this.selectDHTPlugin(subs);
        if (dht_plugin != null) {
            if (!dht_plugin.isInitialising()) {
                this.getPopularitySupport(dht_plugin, subs, listener, sync);
            } else {
                new AEThread2("SM:popwait", true){

                    @Override
                    public void run() {
                        SubscriptionManagerImpl.this.getPopularitySupport(dht_plugin, subs, listener, sync);
                    }
                }.start();
            }
        } else {
            listener.failed(new SubscriptionException("DHT unavailable"));
        }
    }

    protected void updatePopularityFromDHT(final SubscriptionImpl subs, boolean sync) {
        this.getPopularityFromDHT(subs, new SubscriptionPopularityListener(){

            @Override
            public void gotPopularity(long popularity) {
                subs.setCachedPopularity(popularity);
            }

            @Override
            public void failed(SubscriptionException error) {
                SubscriptionManagerImpl.this.log("Failed to update subscription popularity from DHT", error);
            }
        }, sync);
    }

    protected void getPopularitySupport(final DHTPluginInterface dht_plugin, final SubscriptionImpl subs, final SubscriptionPopularityListener _listener, final boolean sync) {
        this.log("Getting popularity of " + subs.getName() + " from DHT (" + dht_plugin.getNetwork() + ")");
        byte[] sub_id = subs.getShortID();
        int sub_version = subs.getVersion();
        String key = "subscription:publish:" + ByteFormatter.encodeString(sub_id) + ":" + sub_version;
        byte[][] keys = new byte[][]{subs.getPublicationHash(), this.getKeyBytes(key)};
        final AESemaphore sem = new AESemaphore("SM:pop");
        final long[] result = new long[]{-1L};
        int timeout = 15000 * (subs.isAnonymous() ? 3 : 1);
        final SubscriptionPopularityListener listener = new SubscriptionPopularityListener(){
            private boolean done;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void gotPopularity(long popularity) {
                32 var3_2 = this;
                synchronized (var3_2) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                }
                _listener.gotPopularity(popularity);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(SubscriptionException error) {
                32 var2_2 = this;
                synchronized (var2_2) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                }
                _listener.failed(error);
            }
        };
        for (byte[] hash : keys) {
            dht_plugin.get(hash, "Popularity lookup for subscription " + subs.getName(), (byte)8, 5, timeout, false, true, new DHTPluginOperationListener(){
                private boolean diversified;
                private int hits = 0;

                @Override
                public boolean diversified() {
                    this.diversified = true;
                    return false;
                }

                @Override
                public void starts(byte[] key) {
                }

                @Override
                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    DHTPluginKeyStats stats2 = dht_plugin.decodeStats(value);
                    if (stats2 != null) {
                        result[0] = Math.max(result[0], (long)stats2.getEntryCount());
                        ++this.hits;
                        if (this.hits >= 3) {
                            this.done();
                        }
                    }
                }

                @Override
                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                }

                @Override
                public void complete(byte[] key, boolean timeout_occurred) {
                    if (this.diversified) {
                        result[0] = result[0] * 11L;
                        if (result[0] == 0L) {
                            result[0] = 10L;
                        }
                    }
                    this.done();
                }

                protected void done() {
                    if (sync) {
                        sem.release();
                    } else if (result[0] == -1L) {
                        SubscriptionManagerImpl.this.log("Failed to get popularity of " + subs.getName() + " from DHT");
                        listener.failed(new SubscriptionException("Timeout"));
                    } else {
                        SubscriptionManagerImpl.this.log("Get popularity of " + subs.getName() + " from DHT: " + result[0]);
                        listener.gotPopularity(result[0]);
                    }
                }
            });
        }
        if (sync) {
            sem.reserve(timeout);
            if (result[0] == -1L) {
                this.log("Failed to get popularity of " + subs.getName() + " from DHT");
                listener.failed(new SubscriptionException("Timeout"));
            } else {
                this.log("Get popularity of " + subs.getName() + " from DHT: " + result[0]);
                listener.gotPopularity(result[0]);
            }
        }
    }

    protected void lookupSubscription(final byte[] association_hash, final byte[] sid, final int version, final subsLookupListener listener) {
        try {
            SubscriptionImpl subs = this.getSubscriptionFromPlatform(sid, 3);
            this.log("Added temporary subscription: " + subs.getString());
            subs = this.addSubscription(subs);
            listener.complete(association_hash, new Subscription[]{subs});
            return;
        }
        catch (Throwable e) {
            if (listener.isCancelled()) {
                listener.failed(association_hash, new SubscriptionException("Cancelled"));
                return;
            }
            final String sid_str = ByteFormatter.encodeString(sid);
            this.log("Subscription lookup via platform for " + sid_str + " failed", e);
            if (this.getSubscriptionDownloadCount() > 8) {
                this.log("Too many existing subscription downloads");
                listener.complete(association_hash, new Subscription[0]);
                return;
            }
            this.log("Subscription lookup via DHT starts for " + sid_str);
            String key = "subscription:publish:" + ByteFormatter.encodeString(sid) + ":" + version;
            this.dht_plugin_public.get(this.getKeyBytes(key), "Subs lookup read: " + ByteFormatter.encodeString(sid) + ":" + version, (byte)0, 12, 60000L, false, true, new DHTPluginOperationListener(){
                private boolean listener_handled;

                @Override
                public boolean diversified() {
                    return true;
                }

                @Override
                public void starts(byte[] key) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    block14: {
                        byte[] data = value.getValue();
                        try {
                            final Map details = SubscriptionManagerImpl.this.decodeSubscriptionDetails(data);
                            if (SubscriptionImpl.getPublicationVersion(details) == version) {
                                Map singleton_details = (Map)details.get("x");
                                if (singleton_details == null) {
                                    34 var6_7 = this;
                                    synchronized (var6_7) {
                                        if (this.listener_handled) {
                                            return;
                                        }
                                        this.listener_handled = true;
                                    }
                                    SubscriptionManagerImpl.this.log("    found " + sid_str + ", non-singleton");
                                    new AEThread2("Subs:lookup download", true){

                                        @Override
                                        public void run() {
                                            SubscriptionManagerImpl.this.downloadSubscription(association_hash, SubscriptionImpl.getPublicationHash(details), sid, version, SubscriptionImpl.getPublicationSize(details), listener);
                                        }
                                    }.start();
                                    break block14;
                                }
                                34 var6_8 = this;
                                synchronized (var6_8) {
                                    if (this.listener_handled) {
                                        return;
                                    }
                                    this.listener_handled = true;
                                }
                                SubscriptionManagerImpl.this.log("    found " + sid_str + ", singleton");
                                try {
                                    SubscriptionImpl subs = SubscriptionManagerImpl.this.createSingletonSubscription(singleton_details, 3, false);
                                    listener.complete(association_hash, new Subscription[]{subs});
                                }
                                catch (Throwable e) {
                                    listener.failed(association_hash, new SubscriptionException("Subscription creation failed", e));
                                }
                                break block14;
                            }
                            SubscriptionManagerImpl.this.log("    found " + sid_str + " but version mismatch");
                        }
                        catch (Throwable e) {
                            SubscriptionManagerImpl.this.log("    found " + sid_str + " but verification failed", e);
                        }
                    }
                }

                @Override
                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void complete(byte[] original_key, boolean timeout_occurred) {
                    SubscriptionManagerImpl.this.log("    " + sid_str + " complete");
                    34 var3_3 = this;
                    synchronized (var3_3) {
                        if (this.listener_handled) {
                            return;
                        }
                        this.listener_handled = true;
                    }
                    listener.complete(association_hash, new Subscription[0]);
                }
            });
            return;
        }
    }

    protected SubscriptionImpl getSubscriptionFromPlatform(byte[] sid, int add_type) throws SubscriptionException {
        try {
            PlatformSubscriptionsMessenger.subscriptionDetails details = PlatformSubscriptionsMessenger.getSubscriptionBySID(sid);
            SubscriptionImpl res = this.getSubscriptionFromVuzeFileContent(sid, add_type, details.getContent());
            int pop = details.getPopularity();
            if (pop >= 0) {
                res.setCachedPopularity(pop);
            }
            return res;
        }
        catch (SubscriptionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SubscriptionException("Failed to read subscription from platform", e);
        }
    }

    protected SubscriptionImpl getSubscriptionFromVuzeFile(byte[] sid, int add_type, File file) throws SubscriptionException {
        String file_str;
        VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
        VuzeFile vf = vfh.loadVuzeFile(file_str = file.getAbsolutePath());
        if (vf == null) {
            this.log("Failed to load vuze file from " + file_str);
            throw new SubscriptionException("Failed to load vuze file from " + file_str);
        }
        return this.getSubscriptionFromVuzeFile(sid, add_type, vf);
    }

    protected SubscriptionImpl getSubscriptionFromVuzeFileContent(byte[] sid, int add_type, String content) throws SubscriptionException {
        VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
        VuzeFile vf = vfh.loadVuzeFile(Base64.decode(content));
        if (vf == null) {
            this.log("Failed to load vuze file from " + content);
            throw new SubscriptionException("Failed to load vuze file from content");
        }
        return this.getSubscriptionFromVuzeFile(sid, add_type, vf);
    }

    protected SubscriptionImpl getSubscriptionFromVuzeFile(byte[] sid, int add_type, VuzeFile vf) throws SubscriptionException {
        VuzeFileComponent[] comps = vf.getComponents();
        for (int j = 0; j < comps.length; ++j) {
            VuzeFileComponent comp2 = comps[j];
            if (comp2.getType() != 16) continue;
            Map map = comp2.getContent();
            try {
                SubscriptionBodyImpl body = new SubscriptionBodyImpl(this, map);
                SubscriptionImpl new_subs = new SubscriptionImpl(this, body, add_type, false);
                if (!Arrays.equals(new_subs.getShortID(), sid)) continue;
                return new_subs;
            }
            catch (Throwable e) {
                this.log("Subscription decode failed", e);
            }
        }
        throw new SubscriptionException("Subscription not found");
    }

    protected void downloadSubscription(final byte[] association_hash, byte[] torrent_hash, final byte[] sid, int version, int size, final subsLookupListener listener) {
        try {
            Object[] res = this.downloadTorrent(torrent_hash, size);
            if (listener.isCancelled()) {
                listener.failed(association_hash, new SubscriptionException("Cancelled"));
                return;
            }
            if (res == null) {
                listener.complete(association_hash, new Subscription[0]);
                return;
            }
            this.downloadSubscription((TOTorrent)res[0], (InetSocketAddress)res[1], sid, version, "Subscription " + ByteFormatter.encodeString(sid) + " for " + ByteFormatter.encodeString(association_hash), new downloadListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void complete(File data_file) {
                    boolean reported = false;
                    try {
                        if (listener.isCancelled()) {
                            listener.failed(association_hash, new SubscriptionException("Cancelled"));
                            return;
                        }
                        SubscriptionImpl subs = SubscriptionManagerImpl.this.getSubscriptionFromVuzeFile(sid, 3, data_file);
                        SubscriptionManagerImpl.this.log("Added temporary subscription: " + subs.getString());
                        subs = SubscriptionManagerImpl.this.addSubscription(subs);
                        listener.complete(association_hash, new Subscription[]{subs});
                        reported = true;
                    }
                    catch (Throwable e) {
                        SubscriptionManagerImpl.this.log("Subscription decode failed", e);
                    }
                    finally {
                        if (!reported) {
                            listener.complete(association_hash, new Subscription[0]);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void complete(Download download, File torrent_file) {
                    File data_file = new File(download.getSavePath());
                    try {
                        SubscriptionManagerImpl.this.removeDownload(download, false);
                        this.complete(data_file);
                    }
                    catch (Throwable e) {
                        SubscriptionManagerImpl.this.log("Failed to remove download", e);
                        listener.complete(association_hash, new Subscription[0]);
                    }
                    finally {
                        torrent_file.delete();
                        data_file.delete();
                    }
                }

                @Override
                public void failed(Throwable error) {
                    listener.complete(association_hash, new Subscription[0]);
                }

                @Override
                public Map getRecoveryData() {
                    return null;
                }

                @Override
                public boolean isCancelled() {
                    return listener.isCancelled();
                }
            });
        }
        catch (Throwable e) {
            this.log("Subscription download failed", e);
            listener.complete(association_hash, new Subscription[0]);
        }
    }

    protected int getSubscriptionDownloadCount() {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        Download[] downloads = pi.getDownloadManager().getDownloads();
        int res = 0;
        for (int i = 0; i < downloads.length; ++i) {
            Download download = downloads[i];
            if (!download.getBooleanAttribute(this.ta_subs_download)) continue;
            ++res;
        }
        return res;
    }

    protected void associationAdded(SubscriptionImpl subscription, byte[] association_hash) {
        this.recordAssociations(association_hash, new SubscriptionImpl[]{subscription}, false);
        DHTPluginInterface dht_plugin = this.selectDHTPlugin(subscription);
        if (dht_plugin != null) {
            this.publishAssociations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPotentialAssociation(SubscriptionImpl subs, String result_id, String key) {
        if (key == null) {
            Debug.out("Attempt to add null key!");
            return;
        }
        this.log("Added potential association: " + subs.getName() + "/" + result_id + " -> " + key);
        List<Object[]> list = this.potential_associations;
        synchronized (list) {
            this.potential_associations.add(new Object[]{subs, result_id, key, new Long(System.currentTimeMillis())});
            if (this.potential_associations.size() > 512) {
                this.potential_associations.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPotentialAssociations(byte[] hash, String key) {
        this.log("Checking potential association: " + key + " -> " + ByteFormatter.encodeString(hash));
        SubscriptionImpl subs = null;
        String result_id = null;
        List<Object[]> list = this.potential_associations;
        synchronized (list) {
            Object[] entry;
            Iterator<Object[]> it = this.potential_associations.iterator();
            while (it.hasNext()) {
                entry = it.next();
                String this_key = (String)entry[2];
                if (!key.startsWith(this_key)) continue;
                subs = (SubscriptionImpl)entry[0];
                result_id = (String)entry[1];
                this.log("    key matched to subscription " + subs.getName() + "/" + result_id);
                it.remove();
                break;
            }
            if (subs == null) {
                it = this.potential_associations.iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    SubscriptionImpl subs_temp = (SubscriptionImpl)entry[0];
                    String result_id_temp = (String)entry[1];
                    SubscriptionResult result = subs_temp.getHistory().getResult(result_id_temp);
                    if (result == null) continue;
                    Map<Integer, Object> props = result.toPropertyMap();
                    byte[] result_hash = (byte[])props.get(21);
                    if (result_hash == null) {
                        String url = (String)props.get(23);
                        if (url == null) {
                            url = (String)props.get(12);
                        }
                        if (url != null) {
                            String lc_url = url.toLowerCase(Locale.US);
                            if (lc_url.startsWith("http")) {
                                String alt_url = UrlUtils.parseTextForURL(url.substring(5), true);
                                if (key.startsWith(alt_url)) {
                                    result_hash = hash;
                                }
                            } else if (lc_url.startsWith("magnet")) {
                                result_hash = UrlUtils.extractHash(lc_url);
                            }
                        }
                    }
                    if (result_hash == null || !Arrays.equals(result_hash, hash)) continue;
                    subs = subs_temp;
                    result_id = result_id_temp;
                    this.log("    hash matched to subscription " + subs.getName() + "/" + result_id);
                    it.remove();
                    break;
                }
            }
        }
        if (subs == null) {
            this.log("    no potential associations found");
        } else {
            SubscriptionResult result = subs.getHistory().getResult(result_id);
            if (result != null) {
                this.log("    result found, marking as read");
                result.setRead(true);
            } else {
                this.log("    result not found");
            }
            this.log("    adding association");
            subs.addAssociation(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tidyPotentialAssociations() {
        Iterator<Object> it;
        long now = SystemTime.getCurrentTime();
        Object object = this.potential_associations;
        synchronized (object) {
            it = this.potential_associations.iterator();
            while (it.hasNext() && this.potential_associations.size() > 16) {
                Object[] entry = it.next();
                long created = (Long)entry[3];
                if (created > now) {
                    entry[3] = new Long(now);
                    continue;
                }
                if (now - created <= 3600000L) continue;
                SubscriptionImpl subs = (SubscriptionImpl)entry[0];
                String result_id = (String)entry[1];
                String key = (String)entry[2];
                this.log("Removing expired potential association: " + subs.getName() + "/" + result_id + " -> " + key);
                it.remove();
            }
        }
        object = this.potential_associations2;
        synchronized (object) {
            it = this.potential_associations2.entrySet().iterator();
            while (it.hasNext() && this.potential_associations2.size() > 16) {
                Map.Entry map_entry = (Map.Entry)it.next();
                byte[] hash = ((HashWrapper)map_entry.getKey()).getBytes();
                Object[] entry = (Object[])map_entry.getValue();
                long created = (Long)entry[2];
                if (created > now) {
                    entry[2] = new Long(now);
                    continue;
                }
                if (now - created <= 3600000L) continue;
                SubscriptionImpl[] subs = (SubscriptionImpl[])entry[0];
                String subs_str = "";
                for (int i = 0; i < subs.length; ++i) {
                    subs_str = subs_str + (i == 0 ? "" : ",") + subs[i].getName();
                }
                this.log("Removing expired potential association: " + ByteFormatter.encodeString(hash) + " -> " + subs_str);
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordAssociations(byte[] association_hash, SubscriptionImpl[] subscriptions, boolean full_lookup) {
        HashWrapper hw = new HashWrapper(association_hash);
        Map<HashWrapper, Object[]> map = this.potential_associations2;
        synchronized (map) {
            this.potential_associations2.put(hw, new Object[]{subscriptions, full_lookup, new Long(SystemTime.getCurrentTime())});
        }
        if (this.recordAssociationsSupport(association_hash, subscriptions, full_lookup)) {
            map = this.potential_associations2;
            synchronized (map) {
                this.potential_associations2.remove(hw);
            }
        } else {
            this.log("Deferring association for " + ByteFormatter.encodeString(association_hash));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPrepareTrigger(byte[] hash, Subscription[] subs, SubscriptionResult[] results) {
        Map<HashWrapper, Object[]> map = this.potential_associations3;
        synchronized (map) {
            this.potential_associations3.put(new HashWrapper(hash), new Object[]{subs, results});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePrepareTrigger(byte[] hash) {
        Map<HashWrapper, Object[]> map = this.potential_associations3;
        synchronized (map) {
            this.potential_associations3.remove(new HashWrapper(hash));
        }
    }

    protected void prepareDownload(Download download, Subscription[] subscriptions, SubscriptionResult[] results) {
        block9: {
            try {
                String[] nets;
                Tag tag;
                long tag_id;
                String existing;
                String category;
                DownloadManagerState state;
                DownloadManager core_dm;
                if (subscriptions.length <= 0) break block9;
                Subscription subs = subscriptions[0];
                if (results != null && results.length > 0) {
                    try {
                        SubscriptionResult result = results[0];
                        Map<Integer, Object> props = result.toPropertyMap();
                        Long leechers = (Long)props.get(4);
                        Long seeds = (Long)props.get(5);
                        if (leechers != null && seeds != null && leechers >= 0L && seeds >= 0L) {
                            core_dm = PluginCoreUtils.unwrap(download);
                            state = core_dm.getDownloadState();
                            long cache = (seeds & 0xFFFFFFL) << 32 | leechers & 0xFFFFFFL;
                            state.setLongAttribute("scsrc", 1L);
                            state.setLongAttribute("scrapecache", cache);
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if ((category = subs.getCategory()) != null && (existing = download.getAttribute(this.ta_category)) == null) {
                    download.setAttribute(this.ta_category, category);
                }
                if ((tag_id = subs.getTagID()) >= 0L && (tag = TagManagerFactory.getTagManager().lookupTagByUID(tag_id)) != null && !tag.hasTaggable(core_dm = PluginCoreUtils.unwrap(download))) {
                    tag.addTaggable(core_dm);
                }
                if ((nets = subs.getHistory().getDownloadNetworks()) != null) {
                    core_dm = PluginCoreUtils.unwrap(download);
                    state = core_dm.getDownloadState();
                    state.setNetworks(nets);
                    state.setFlag(4096L, true);
                }
            }
            catch (Throwable e) {
                this.log("Failed to prepare association", e);
            }
        }
    }

    protected boolean recordAssociationsSupport(byte[] association_hash, SubscriptionImpl[] subscriptions, boolean full_lookup) {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        boolean download_found = false;
        boolean changed = false;
        boolean assoc_added = false;
        try {
            Download download = pi.getDownloadManager().getDownload(association_hash);
            if (download != null) {
                download_found = true;
                LightHashMap map = download.getMapAttribute(this.ta_subscription_info);
                map = map == null ? new LightHashMap() : new LightHashMap(map);
                ArrayList<byte[]> s = (ArrayList<byte[]>)map.get("s");
                for (int i = 0; i < subscriptions.length; ++i) {
                    SubscriptionImpl subscription = subscriptions[i];
                    byte[] sid = subscription.getShortID();
                    if (s == null) {
                        s = new ArrayList<byte[]>();
                        s.add(sid);
                        changed = true;
                        map.put("s", s);
                        continue;
                    }
                    boolean found = false;
                    for (int j = 0; j < s.size(); ++j) {
                        byte[] existing = (byte[])s.get(j);
                        if (!Arrays.equals(sid, existing)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    s.add(sid);
                    if (subscription.isSubscribed() && subscription.isPublic() && !subscription.isSearchTemplate() && subscription.addAssociationSupport(association_hash, true)) {
                        assoc_added = true;
                    }
                    changed = true;
                }
                if (full_lookup) {
                    map.put("lc", new Long(SystemTime.getCurrentTime()));
                    changed = true;
                }
                if (changed) {
                    download.setMapAttribute(this.ta_subscription_info, map);
                }
                if (subscriptions.length == 1 && subscriptions[0].isSearchTemplate() && !full_lookup) {
                    this.searchTemplateOK(subscriptions[0]);
                }
            }
        }
        catch (Throwable e) {
            this.log("Failed to record associations", e);
        }
        if (changed) {
            Iterator<SubscriptionManagerListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                try {
                    it.next().associationsChanged(association_hash);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        if (assoc_added) {
            this.publishAssociations();
        }
        return download_found;
    }

    private void searchTemplateOK(final SubscriptionImpl subs) {
        if (BuddyPluginUtils.isBetaChatAvailable()) {
            this.chat_write_dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    String name = subs.getName();
                    int pos = name.indexOf(58);
                    if (pos != -1) {
                        name = name.substring(pos + 1).trim();
                    }
                    if (SubscriptionManagerImpl.this.chat_st_done.contains(name)) {
                        return;
                    }
                    SubscriptionManagerImpl.this.chat_st_done.add(name);
                    final BuddyPluginBeta.ChatInstance chat = BuddyPluginUtils.getChat("Public", "Search Templates");
                    if (chat != null) {
                        chat.setSharedNickname(false);
                        chat.setSaveMessages(false);
                        final String f_msg = subs.getURI() + "[[" + UrlUtils.encode(name) + "]]";
                        final Runnable do_write = new Runnable(){

                            @Override
                            public void run() {
                                HashMap<String, Object> flags = new HashMap<String, Object>();
                                flags.put("o", 3);
                                HashMap<String, Object> options = new HashMap<String, Object>();
                                chat.sendMessage(f_msg, flags, options);
                            }
                        };
                        SubscriptionManagerImpl.this.waitForChat(chat, new AERunnable(){

                            @Override
                            public void runSupport() {
                                List<BuddyPluginBeta.ChatMessage> messages = chat.getMessages();
                                for (BuddyPluginBeta.ChatMessage message : messages) {
                                    if (!message.getMessage().equals(f_msg)) continue;
                                    return;
                                }
                                do_write.run();
                            }
                        });
                    }
                }
            });
        }
    }

    private void assocOK(final SubscriptionImpl subs, final SubscriptionImpl.association assoc) {
        if (BuddyPluginUtils.isBetaChatAvailable()) {
            if (subs.isAnonymous()) {
                return;
            }
            this.chat_write_dispatcher.dispatch(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    block10: {
                        try {
                            Download download = SubscriptionManagerImpl.this.azureus_core.getPluginManager().getDefaultPluginInterface().getDownloadManager().getDownload(assoc.getHash());
                            if (download == null) break block10;
                            if (TorrentUtils.isReallyPrivate(PluginCoreUtils.unwrap(download.getTorrent()))) {
                                return;
                            }
                            final BuddyPluginBeta.ChatInstance chat = BuddyPluginUtils.getChat(download);
                            if (chat == null) break block10;
                            if (chat.getNetwork() == "Public") {
                                int pos;
                                LinkedList linkedList = SubscriptionManagerImpl.this.chat_assoc_done;
                                synchronized (linkedList) {
                                    if (!SubscriptionManagerImpl.this.chat_assoc_done.contains(chat)) {
                                        SubscriptionManagerImpl.this.chat_assoc_done.add(chat);
                                        if (SubscriptionManagerImpl.this.chat_assoc_done.size() > 50) {
                                            BuddyPluginBeta.ChatInstance c = (BuddyPluginBeta.ChatInstance)SubscriptionManagerImpl.this.chat_assoc_done.removeFirst();
                                            c.setInteresting(false);
                                            c.destroy();
                                        }
                                    }
                                }
                                String name = subs.getName();
                                if (subs.isSearchTemplate() && (pos = name.indexOf(58)) != -1) {
                                    name = name.substring(pos + 1).trim();
                                }
                                final String f_msg = (subs.isSearchTemplate() ? "Search Template" : "Subscription") + " " + subs.getURI() + "[[" + UrlUtils.encode(name) + "]]";
                                SubscriptionManagerImpl.this.waitForChat(chat, new AERunnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void runSupport() {
                                        List<BuddyPluginBeta.ChatMessage> messages = chat.getMessages();
                                        for (BuddyPluginBeta.ChatMessage message : messages) {
                                            if (!message.getMessage().equals(f_msg)) continue;
                                            LinkedList linkedList = SubscriptionManagerImpl.this.chat_assoc_done;
                                            synchronized (linkedList) {
                                                if (SubscriptionManagerImpl.this.chat_assoc_done.remove(chat)) {
                                                    chat.destroy();
                                                }
                                            }
                                            return;
                                        }
                                        HashMap<String, Object> flags = new HashMap<String, Object>();
                                        flags.put("o", 3);
                                        HashMap<String, Object> options = new HashMap<String, Object>();
                                        chat.sendMessage(f_msg, flags, options);
                                    }
                                });
                                break block10;
                            }
                            chat.destroy();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForChat(final BuddyPluginBeta.ChatInstance chat, final AERunnable runnable) {
        TimerEventPeriodic[] event2;
        TimerEventPeriodic[] timerEventPeriodicArray = event2 = new TimerEventPeriodic[]{null};
        synchronized (event2) {
            event2[0] = SimpleTimer.addPeriodicEvent("Subs:chat:checker", 30000L, new TimerEventPerformer(){
                private int elapsed_time;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void perform(TimerEvent e) {
                    this.elapsed_time += 30000;
                    if (chat.isDestroyed()) {
                        TimerEventPeriodic[] timerEventPeriodicArray = event2;
                        synchronized (event2) {
                            event2[0].cancel();
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                    }
                    if (chat.getIncomingSyncState() != 0 && this.elapsed_time < 300000) return;
                    TimerEventPeriodic[] timerEventPeriodicArray = event2;
                    synchronized (event2) {
                        event2[0].cancel();
                        // ** MonitorExit[var2_3] (shouldn't be in output)
                        SimpleTimer.addEvent("Subs:chat:checker", SystemTime.getOffsetTime(120000L), new TimerEventPerformer(){

                            @Override
                            public void perform(TimerEvent event2) {
                                if (!chat.isDestroyed()) {
                                    SubscriptionManagerImpl.this.chat_write_dispatcher.dispatch(new AERunnable(){

                                        @Override
                                        public void runSupport() {
                                            if (!chat.isDestroyed()) {
                                                runnable.runSupport();
                                            }
                                        }
                                    });
                                }
                            }
                        });
                        return;
                    }
                }
            });
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean publishAssociations() {
        SubscriptionImpl subs_to_publish = null;
        SubscriptionImpl.association assoc_to_publish = null;
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            if (this.publish_associations_active >= (this.dht_plugin_public.isSleeping() ? 1 : PUB_ASSOC_CONC_MAX)) {
                return false;
            }
            ++this.publish_associations_active;
            this.log("Publishing Associations Starts (conc=" + this.publish_associations_active + ")");
            ArrayList<SubscriptionImpl> shuffled_subs = new ArrayList<SubscriptionImpl>(this.subscriptions);
            Collections.shuffle(shuffled_subs);
            for (int i = 0; i < shuffled_subs.size(); ++i) {
                SubscriptionImpl sub = (SubscriptionImpl)shuffled_subs.get(i);
                if (!sub.isSubscribed() || !sub.isPublic() || (assoc_to_publish = sub.getAssociationForPublish()) == null) continue;
                subs_to_publish = sub;
                break;
            }
        }
        if (assoc_to_publish != null) {
            this.publishAssociation(subs_to_publish, assoc_to_publish);
            return false;
        }
        this.log("Publishing Associations Complete");
        subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            --this.publish_associations_active;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPublishRemainingCount() {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            int result = 0;
            for (SubscriptionImpl sub : this.subscriptions) {
                if (!sub.isSubscribed() || !sub.isPublic()) continue;
                result += sub.getAssociationsRemainingForPublish();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishAssociation(final SubscriptionImpl subs, final SubscriptionImpl.association assoc) {
        this.log("Checking association '" + subs.getString() + "' -> '" + assoc.getString() + "'");
        byte[] sub_id = subs.getShortID();
        int sub_version = subs.getVersion();
        byte[] assoc_hash = assoc.getHash();
        final String key = "subscription:assoc:" + ByteFormatter.encodeString(assoc_hash);
        final byte[] put_value = new byte[sub_id.length + 4];
        System.arraycopy(sub_id, 0, put_value, 4, sub_id.length);
        put_value[0] = (byte)(sub_version >> 16);
        put_value[1] = (byte)(sub_version >> 8);
        put_value[2] = (byte)sub_version;
        put_value[3] = (byte)subs.getFixedRandom();
        final DHTPluginInterface dht_plugin = this.selectDHTPlugin(subs);
        if (dht_plugin == null) {
            SubscriptionManagerImpl subscriptionManagerImpl = this;
            synchronized (subscriptionManagerImpl) {
                --this.publish_associations_active;
            }
            return;
        }
        dht_plugin.get(this.getKeyBytes(key), "Subs assoc read: " + Base32.encode(assoc_hash).substring(0, 16), (byte)0, 30, 60000 * (subs.isAnonymous() ? 2 : 1), false, false, new DHTPluginOperationListener(){
            private int hits;
            private boolean diversified;
            private int max_ver;

            @Override
            public boolean diversified() {
                this.diversified = true;
                return false;
            }

            @Override
            public void starts(byte[] key2) {
            }

            @Override
            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                byte[] val = value.getValue();
                if (val.length == put_value.length) {
                    boolean diff = false;
                    for (int i = 4; i < val.length; ++i) {
                        if (val[i] == put_value[i]) continue;
                        diff = true;
                        break;
                    }
                    if (!diff) {
                        ++this.hits;
                        int ver = val[0] << 16 & 0xFF0000 | val[1] << 8 & 0xFF00 | val[2] & 0xFF;
                        if (ver > this.max_ver) {
                            this.max_ver = ver;
                        }
                    }
                }
            }

            @Override
            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
            }

            @Override
            public void complete(byte[] original_key, boolean timeout_occurred) {
                SubscriptionManagerImpl.this.log("Checked association '" + subs.getString() + "' -> '" + assoc.getString() + "' - max_ver=" + this.max_ver + ",hits=" + this.hits + ",div=" + this.diversified);
                if (this.max_ver > subs.getVersion() && !subs.isMine()) {
                    SubscriptionManagerImpl.this.updateSubscription(subs, this.max_ver);
                }
                if (this.hits < 10 && !this.diversified) {
                    SubscriptionManagerImpl.this.log("    Publishing association '" + subs.getString() + "' -> '" + assoc.getString() + "', existing=" + this.hits + ", net=" + dht_plugin.getNetwork());
                    byte flags = 16;
                    if (this.hits < 3 && !this.diversified) {
                        flags = (byte)(flags | 0x20);
                    }
                    if (subs.isAnonymous()) {
                        flags = (byte)(flags | 0x40);
                    }
                    dht_plugin.put(SubscriptionManagerImpl.this.getKeyBytes(key), "Subs assoc write: " + Base32.encode(assoc.getHash()).substring(0, 16) + " -> " + Base32.encode(subs.getShortID()) + ":" + subs.getVersion(), put_value, flags, new DHTPluginOperationListener(){

                        @Override
                        public boolean diversified() {
                            return true;
                        }

                        @Override
                        public void starts(byte[] key) {
                        }

                        @Override
                        public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                        }

                        @Override
                        public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                        }

                        @Override
                        public void complete(byte[] key, boolean timeout_occurred) {
                            SubscriptionManagerImpl.this.log("        completed '" + subs.getString() + "' -> '" + assoc.getString() + "'");
                            this.publishNext();
                        }
                    });
                    SubscriptionManagerImpl.this.assocOK(subs, assoc);
                } else {
                    SubscriptionManagerImpl.this.log("    Not publishing association '" + subs.getString() + "' -> '" + assoc.getString() + "', existing =" + this.hits);
                    this.publishNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void publishNext() {
                SubscriptionManagerImpl subscriptionManagerImpl = SubscriptionManagerImpl.this;
                synchronized (subscriptionManagerImpl) {
                    SubscriptionManagerImpl.this.publish_associations_active--;
                }
                SubscriptionManagerImpl.this.publishNextAssociation();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishNextAssociation() {
        boolean dht_sleeping = this.dht_plugin_public.isSleeping();
        if (dht_sleeping) {
            SubscriptionManagerImpl subscriptionManagerImpl = this;
            synchronized (subscriptionManagerImpl) {
                if (this.publish_next_asyc_pending) {
                    return;
                }
                this.publish_next_asyc_pending = true;
            }
            SimpleTimer.addEvent("subs:pn:async", SystemTime.getCurrentTime() + 60000L, new TimerEventPerformer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void perform(TimerEvent event2) {
                    SubscriptionManagerImpl subscriptionManagerImpl = SubscriptionManagerImpl.this;
                    synchronized (subscriptionManagerImpl) {
                        SubscriptionManagerImpl.this.publish_next_asyc_pending = false;
                    }
                    SubscriptionManagerImpl.this.publishAssociations();
                }
            });
            return;
        }
        this.publishAssociations();
    }

    protected void subscriptionUpdated() {
        if (this.dht_plugin_public != null) {
            this.publishSubscriptions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishSubscriptions() {
        ArrayList<SubscriptionImpl> shuffled_subs;
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            if (this.publish_subscription_active) {
                return;
            }
            shuffled_subs = new ArrayList<SubscriptionImpl>(this.subscriptions);
            this.publish_subscription_active = true;
        }
        boolean publish_initiated = false;
        try {
            Collections.shuffle(shuffled_subs);
            for (int i = 0; i < shuffled_subs.size(); ++i) {
                SubscriptionImpl sub = (SubscriptionImpl)shuffled_subs.get(i);
                if (!sub.isSubscribed() || !sub.isPublic() || sub.getPublished()) continue;
                sub.setPublished(true);
                this.publishSubscription(sub);
                publish_initiated = true;
                break;
            }
        }
        finally {
            if (!publish_initiated) {
                this.log("Publishing Subscriptions Complete");
                SubscriptionManagerImpl subscriptionManagerImpl2 = this;
                synchronized (subscriptionManagerImpl2) {
                    this.publish_subscription_active = false;
                }
            }
        }
    }

    protected void publishSubscription(final SubscriptionImpl subs) {
        this.log("Checking subscription publication '" + subs.getString() + "'");
        byte[] sub_id = subs.getShortID();
        int sub_version = subs.getVersion();
        final String key = "subscription:publish:" + ByteFormatter.encodeString(sub_id) + ":" + sub_version;
        final DHTPluginInterface dht_plugin = this.selectDHTPlugin(subs);
        if (dht_plugin == null) {
            return;
        }
        dht_plugin.get(this.getKeyBytes(key), "Subs presence read: " + ByteFormatter.encodeString(sub_id) + ":" + sub_version, (byte)0, 24, 60000 * (subs.isAnonymous() ? 2 : 1), false, false, new DHTPluginOperationListener(){
            private int hits;
            private boolean diversified;

            @Override
            public boolean diversified() {
                this.diversified = true;
                return false;
            }

            @Override
            public void starts(byte[] key2) {
            }

            @Override
            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                byte[] data = value.getValue();
                try {
                    Map details = SubscriptionManagerImpl.this.decodeSubscriptionDetails(data);
                    if (subs.getVerifiedPublicationVersion(details) == subs.getVersion()) {
                        ++this.hits;
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }

            @Override
            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
            }

            @Override
            public void complete(byte[] original_key, boolean timeout_occurred) {
                block7: {
                    SubscriptionManagerImpl.this.log("Checked subscription publication '" + subs.getString() + "' - hits=" + this.hits + ",div=" + this.diversified);
                    if (this.hits < 10 && !this.diversified) {
                        SubscriptionManagerImpl.this.log("    Publishing subscription '" + subs.getString() + ", existing=" + this.hits);
                        try {
                            byte[] put_value = SubscriptionManagerImpl.this.encodeSubscriptionDetails(subs);
                            if (put_value.length < 512) {
                                byte flags = 0;
                                if (this.hits < 3 && !this.diversified) {
                                    flags = (byte)(flags | 0x20);
                                }
                                if (subs.isAnonymous()) {
                                    flags = (byte)(flags | 0x40);
                                }
                                dht_plugin.put(SubscriptionManagerImpl.this.getKeyBytes(key), "Subs presence write: " + Base32.encode(subs.getShortID()) + ":" + subs.getVersion(), put_value, flags, new DHTPluginOperationListener(){

                                    @Override
                                    public boolean diversified() {
                                        return true;
                                    }

                                    @Override
                                    public void starts(byte[] key) {
                                    }

                                    @Override
                                    public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                                    }

                                    @Override
                                    public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                                    }

                                    @Override
                                    public void complete(byte[] key, boolean timeout_occurred) {
                                        SubscriptionManagerImpl.this.log("        completed '" + subs.getString() + "'");
                                        this.publishNext();
                                    }
                                });
                                break block7;
                            }
                            this.publishNext();
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                            this.publishNext();
                        }
                    } else {
                        SubscriptionManagerImpl.this.log("    Not publishing subscription '" + subs.getString() + "', existing =" + this.hits);
                        this.publishNext();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void publishNext() {
                SubscriptionManagerImpl subscriptionManagerImpl = SubscriptionManagerImpl.this;
                synchronized (subscriptionManagerImpl) {
                    SubscriptionManagerImpl.this.publish_subscription_active = false;
                }
                SubscriptionManagerImpl.this.publishSubscriptions();
            }
        });
    }

    protected void updateSubscription(final SubscriptionImpl subs, final int new_version) {
        this.log("Subscription " + subs.getString() + " - higher version found: " + new_version);
        if (!subs.canAutoUpgradeCheck()) {
            this.log("    Checked too recently or not updateable, ignoring");
            return;
        }
        if (subs.getHighestUserPromptedVersion() >= new_version) {
            this.log("    User has already been prompted for version " + new_version + " so ignoring");
            return;
        }
        byte[] sub_id = subs.getShortID();
        if (!subs.isAnonymous()) {
            try {
                PlatformSubscriptionsMessenger.subscriptionDetails details = PlatformSubscriptionsMessenger.getSubscriptionBySID(sub_id);
                if (!this.askIfCanUpgrade(subs, new_version)) {
                    return;
                }
                VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
                VuzeFile vf = vfh.loadVuzeFile(Base64.decode(details.getContent()));
                vfh.handleFiles(new VuzeFile[]{vf}, 16);
                return;
            }
            catch (Throwable e) {
                this.log("Failed to read subscription from platform, trying DHT");
            }
        }
        this.log("Checking subscription '" + subs.getString() + "' upgrade to version " + new_version);
        String key = "subscription:publish:" + ByteFormatter.encodeString(sub_id) + ":" + new_version;
        DHTPluginInterface dht_plugin = this.selectDHTPlugin(subs);
        dht_plugin.get(this.getKeyBytes(key), "Subs update read: " + Base32.encode(sub_id) + ":" + new_version, (byte)0, 12, 60000 * (subs.isAnonymous() ? 2 : 1), false, false, new DHTPluginOperationListener(){
            private byte[] verified_hash;
            private int verified_size;

            @Override
            public boolean diversified() {
                return true;
            }

            @Override
            public void starts(byte[] key) {
            }

            @Override
            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                byte[] data = value.getValue();
                try {
                    Map details = SubscriptionManagerImpl.this.decodeSubscriptionDetails(data);
                    if (this.verified_hash == null && subs.getVerifiedPublicationVersion(details) == new_version) {
                        this.verified_hash = SubscriptionImpl.getPublicationHash(details);
                        this.verified_size = SubscriptionImpl.getPublicationSize(details);
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }

            @Override
            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
            }

            @Override
            public void complete(byte[] original_key, boolean timeout_occurred) {
                if (this.verified_hash != null) {
                    SubscriptionManagerImpl.this.log("    Subscription '" + subs.getString() + " upgrade verified as authentic");
                    SubscriptionManagerImpl.this.updateSubscription(subs, new_version, this.verified_hash, this.verified_size);
                } else {
                    SubscriptionManagerImpl.this.log("    Subscription '" + subs.getString() + " upgrade not verified");
                }
            }
        });
    }

    protected byte[] encodeSubscriptionDetails(SubscriptionImpl subs) throws IOException {
        byte[] data;
        byte header;
        Map details = subs.getPublicationDetails();
        details.put("!", new Long(random_seed));
        byte[] encoded = BEncoder.encode(details);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream os = new GZIPOutputStream(baos);
        os.write(encoded);
        os.close();
        byte[] compressed = baos.toByteArray();
        if (compressed.length < encoded.length) {
            header = 1;
            data = compressed;
        } else {
            header = 0;
            data = encoded;
        }
        byte[] result = new byte[data.length + 1];
        result[0] = header;
        System.arraycopy(data, 0, result, 1, data.length);
        return result;
    }

    protected Map decodeSubscriptionDetails(byte[] data) throws IOException {
        byte[] to_decode;
        if (data[0] == 0) {
            to_decode = new byte[data.length - 1];
            System.arraycopy(data, 1, to_decode, 0, data.length - 1);
        } else {
            GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(data, 1, data.length - 1));
            to_decode = FileUtil.readInputStreamAsByteArray(is);
            is.close();
        }
        Map<String, Object> res = BDecoder.decode(to_decode);
        res.remove("!");
        return res;
    }

    protected void updateSubscription(final SubscriptionImpl subs, final int update_version, final byte[] update_hash, final int update_size) {
        this.log("Subscription " + subs.getString() + " - update hash=" + ByteFormatter.encodeString(update_hash) + ", size=" + update_size);
        new AEThread2("SubsUpdate", true){

            @Override
            public void run() {
                try {
                    Object[] res = SubscriptionManagerImpl.this.downloadTorrent(update_hash, update_size);
                    if (res != null) {
                        SubscriptionManagerImpl.this.updateSubscription(subs, update_version, (TOTorrent)res[0], (InetSocketAddress)res[1]);
                    }
                }
                catch (Throwable e) {
                    SubscriptionManagerImpl.this.log("    update failed", e);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] downloadTorrent(byte[] hash, int update_size) {
        if (!this.isSubsDownloadEnabled()) {
            this.log("    Can't download subscription " + Base32.encode(hash) + " as feature disabled");
            return null;
        }
        MagnetPlugin magnet_plugin = this.getMagnetPlugin();
        if (magnet_plugin == null) {
            this.log("    Can't download, no magnet plugin");
            return null;
        }
        try {
            final InetSocketAddress[] sender = new InetSocketAddress[]{null};
            byte[] torrent_data = magnet_plugin.download(new MagnetPluginProgressListener(){

                @Override
                public void reportSize(long size) {
                }

                @Override
                public void reportActivity(String str) {
                    SubscriptionManagerImpl.this.log("    MagnetDownload: " + str);
                }

                @Override
                public void reportCompleteness(int percent) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void reportContributor(InetSocketAddress address) {
                    InetSocketAddress[] inetSocketAddressArray = sender;
                    synchronized (sender) {
                        sender[0] = address;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                @Override
                public boolean verbose() {
                    return false;
                }

                @Override
                public boolean cancelled() {
                    return false;
                }
            }, hash, "", new InetSocketAddress[0], 300000L, 1);
            if (torrent_data == null) {
                this.log("    download failed - timeout");
                return null;
            }
            this.log("Subscription torrent downloaded");
            TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedByteArray(torrent_data);
            if (torrent.getSize() > (long)(update_size + 10240)) {
                this.log("Subscription download abandoned, torrent size is " + torrent.getSize() + ", underlying data size is " + update_size);
                return null;
            }
            if (torrent.getSize() > 0x400000L) {
                this.log("Subscription download abandoned, torrent size is too large (" + torrent.getSize() + ")");
                return null;
            }
            InetSocketAddress[] inetSocketAddressArray = sender;
            synchronized (sender) {
                // ** MonitorExit[var7_8] (shouldn't be in output)
                return new Object[]{torrent, sender[0]};
            }
        }
        catch (Throwable e) {
            this.log("    download failed", e);
            return null;
        }
    }

    protected void downloadSubscription(final TOTorrent torrent, final InetSocketAddress peer, byte[] subs_id, int version, String name, final downloadListener listener) {
        try {
            LightWeightSeed lws = LightWeightSeedManager.getSingleton().get(new HashWrapper(torrent.getHash()));
            if (lws != null) {
                this.log("Light weight seed found");
                listener.complete(lws.getDataLocation());
            } else {
                String sid = ByteFormatter.encodeString(subs_id);
                File dir = this.getSubsDir();
                if (!(dir = new File(dir, "temp")).exists() && !dir.mkdirs()) {
                    throw new IOException("Failed to create dir '" + dir + "'");
                }
                final File torrent_file = new File(dir, sid + "_" + version + ".torrent");
                File data_file = new File(dir, sid + "_" + version + ".vuze");
                PluginInterface pi = PluginInitializer.getDefaultInterface();
                final org.gudy.azureus2.plugins.download.DownloadManager dm = pi.getDownloadManager();
                Download download = dm.getDownload(torrent.getHash());
                if (download == null) {
                    this.log("Adding download for subscription '" + new String(torrent.getName()) + "'");
                    boolean is_update = this.getSubscriptionFromSID(subs_id) != null;
                    PlatformTorrentUtils.setContentTitle(torrent, (is_update ? "Update" : "Download") + " for subscription '" + name + "'");
                    TorrentUtils.setFlag(torrent, 1, true);
                    TorrentImpl t = new TorrentImpl(torrent);
                    t.setDefaultEncoding();
                    t.writeToFile(torrent_file);
                    download = dm.addDownload(t, torrent_file, data_file);
                    download.setFlag(4L, true);
                    download.setBooleanAttribute(this.ta_subs_download, true);
                    Map rd = listener.getRecoveryData();
                    if (rd != null) {
                        download.setMapAttribute(this.ta_subs_download_rd, rd);
                    }
                } else {
                    this.log("Existing download found for subscription '" + new String(torrent.getName()) + "'");
                }
                final Download f_download = download;
                final TimerEventPeriodic[] event2 = new TimerEventPeriodic[]{null};
                event2[0] = SimpleTimer.addPeriodicEvent("SM:cancelTimer", 10000L, new TimerEventPerformer(){
                    private long start_time = SystemTime.getMonotonousTime();

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent ev) {
                        boolean kill = false;
                        try {
                            Download download = dm.getDownload(torrent.getHash());
                            if (listener.isCancelled() || download == null) {
                                kill = true;
                            } else {
                                int state = download.getState();
                                if (state == 8) {
                                    SubscriptionManagerImpl.this.log("Download entered error state, removing");
                                    kill = true;
                                } else {
                                    DownloadScrapeResult scrape;
                                    long now = SystemTime.getMonotonousTime();
                                    long running_for = now - this.start_time;
                                    if (running_for > 600000L) {
                                        SubscriptionManagerImpl.this.log("Download hasn't completed in permitted time, removing");
                                        kill = true;
                                    } else if (running_for > 240000L) {
                                        if (download.getStats().getDownloaded() == 0L) {
                                            SubscriptionManagerImpl.this.log("Download has zero downloaded, removing");
                                            kill = true;
                                        }
                                    } else if (running_for > 120000L && ((scrape = download.getLastScrapeResult()) == null || scrape.getSeedCount() <= 0)) {
                                        SubscriptionManagerImpl.this.log("Download has no seeds, removing");
                                        kill = true;
                                    }
                                }
                            }
                        }
                        catch (Throwable e) {
                            SubscriptionManagerImpl.this.log("Download failed", e);
                            kill = true;
                        }
                        if (kill && event2[0] != null) {
                            try {
                                event2[0].cancel();
                                if (!listener.isCancelled()) {
                                    listener.failed(new SubscriptionException("Download abandoned"));
                                }
                            }
                            finally {
                                SubscriptionManagerImpl.this.removeDownload(f_download, true);
                                torrent_file.delete();
                            }
                        }
                    }
                });
                download.addCompletionListener(new DownloadCompletionListener(){

                    @Override
                    public void onCompletion(Download d) {
                        listener.complete(d, torrent_file);
                    }
                });
                if (download.isComplete()) {
                    listener.complete(download, torrent_file);
                } else {
                    download.setForceStart(true);
                    if (peer != null) {
                        download.addPeerListener(new DownloadPeerListener(){

                            @Override
                            public void peerManagerAdded(Download download, PeerManager peer_manager) {
                                InetSocketAddress tcp = AddressUtils.adjustTCPAddress(peer, true);
                                InetSocketAddress udp = AddressUtils.adjustUDPAddress(peer, true);
                                SubscriptionManagerImpl.this.log("    Injecting peer into download: " + tcp);
                                peer_manager.addPeer(tcp.getAddress().getHostAddress(), tcp.getPort(), udp.getPort(), true);
                            }

                            @Override
                            public void peerManagerRemoved(Download download, PeerManager peer_manager) {
                            }
                        });
                    }
                }
            }
        }
        catch (Throwable e) {
            this.log("Failed to add download", e);
            listener.failed(e);
        }
    }

    protected void updateSubscription(final SubscriptionImpl subs, final int new_version, TOTorrent torrent, InetSocketAddress peer) {
        this.log("Subscription " + subs.getString() + " - update torrent: " + new String(torrent.getName()));
        if (!this.askIfCanUpgrade(subs, new_version)) {
            return;
        }
        this.downloadSubscription(torrent, peer, subs.getShortID(), new_version, subs.getName(false), new downloadListener(){

            @Override
            public void complete(File data_file) {
                SubscriptionManagerImpl.this.updateSubscription(subs, data_file);
            }

            @Override
            public void complete(Download download, File torrent_file) {
                SubscriptionManagerImpl.this.updateSubscription(subs, download, torrent_file, new File(download.getSavePath()));
            }

            @Override
            public void failed(Throwable error) {
                SubscriptionManagerImpl.this.log("Failed to download subscription", error);
            }

            @Override
            public Map getRecoveryData() {
                HashMap<String, Object> rd = new HashMap<String, Object>();
                rd.put("sid", subs.getShortID());
                rd.put("ver", new Long(new_version));
                return rd;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        });
    }

    protected boolean askIfCanUpgrade(SubscriptionImpl subs, int new_version) {
        subs.setHighestUserPromptedVersion(new_version);
        UIManager ui_manager = StaticUtilities.getUIManager(120000L);
        String details = MessageText.getString("subscript.add.upgradeto.desc", new String[]{String.valueOf(new_version), subs.getName()});
        long res = ui_manager.showMessageBox("subscript.add.upgrade.title", "!" + details + "!", 12L);
        if (res != 4L) {
            this.log("    User declined upgrade");
            return false;
        }
        return true;
    }

    protected boolean recoverSubscriptionUpdate(Download download, final Map rd) {
        byte[] sid = (byte[])rd.get("sid");
        int version = ((Long)rd.get("ver")).intValue();
        final SubscriptionImpl subs = this.getSubscriptionFromSID(sid);
        if (subs == null) {
            this.log("Can't recover '" + download.getName() + "' - subscription " + ByteFormatter.encodeString(sid) + " not found");
            return false;
        }
        this.downloadSubscription(((TorrentImpl)download.getTorrent()).getTorrent(), null, subs.getShortID(), version, subs.getName(false), new downloadListener(){

            @Override
            public void complete(File data_file) {
                SubscriptionManagerImpl.this.updateSubscription(subs, data_file);
            }

            @Override
            public void complete(Download download, File torrent_file) {
                SubscriptionManagerImpl.this.updateSubscription(subs, download, torrent_file, new File(download.getSavePath()));
            }

            @Override
            public void failed(Throwable error) {
                SubscriptionManagerImpl.this.log("Failed to download subscription", error);
            }

            @Override
            public Map getRecoveryData() {
                return rd;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSubscription(SubscriptionImpl subs, Download download, File torrent_file, File data_file) {
        try {
            this.removeDownload(download, false);
            try {
                this.updateSubscription(subs, data_file);
            }
            finally {
                if (!data_file.delete()) {
                    this.log("Failed to delete update file '" + data_file + "'");
                }
                if (!torrent_file.delete()) {
                    this.log("Failed to delete update torrent '" + torrent_file + "'");
                }
            }
        }
        catch (Throwable e) {
            this.log("Failed to remove update download", e);
        }
    }

    protected void removeDownload(Download download, boolean remove_data) {
        try {
            download.stop();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            download.remove(true, remove_data);
            this.log("Removed download '" + download.getName() + "'");
        }
        catch (Throwable e) {
            this.log("Failed to remove download '" + download.getName() + "'", e);
        }
    }

    protected void updateSubscription(SubscriptionImpl subs, File data_location) {
        this.log("Updating subscription '" + subs.getString() + " using '" + data_location + "'");
        VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
        VuzeFile vf = vfh.loadVuzeFile(data_location.getAbsolutePath());
        vfh.handleFiles(new VuzeFile[]{vf}, 16);
    }

    protected MagnetPlugin getMagnetPlugin() {
        PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(MagnetPlugin.class);
        if (pi == null) {
            return null;
        }
        return (MagnetPlugin)pi.getPlugin();
    }

    protected Engine getEngine(SubscriptionImpl subs, Map json_map, boolean local_only) throws SubscriptionException {
        long id = (Long)json_map.get("engine_id");
        Engine engine = MetaSearchManagerFactory.getSingleton().getMetaSearch().getEngine(id);
        if (engine != null) {
            return engine;
        }
        if (!local_only) {
            try {
                if (id >= 0L && id < Integer.MAX_VALUE) {
                    this.log("Engine " + id + " not present, loading");
                    try {
                        engine = MetaSearchManagerFactory.getSingleton().getMetaSearch().addEngine(id);
                        return engine;
                    }
                    catch (Throwable e) {
                        throw new SubscriptionException("Failed to load engine '" + id + "'", e);
                    }
                }
            }
            catch (Throwable e) {
                this.log("Failed to load search template", e);
            }
        }
        if ((engine = subs.extractEngine(json_map, id)) != null) {
            return engine;
        }
        throw new SubscriptionException("Failed to extract engine id " + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedHashMap<String, SubscriptionResultImpl> loadResults(SubscriptionImpl subs) {
        Map<SubscriptionImpl, Object[]> map = this.result_cache;
        synchronized (map) {
            Object[] entry = this.result_cache.get(subs);
            if (entry != null) {
                entry[1] = SystemTime.getMonotonousTime();
                return (LinkedHashMap)entry[0];
            }
            LinkedHashMap<String, SubscriptionResultImpl> results = new LinkedHashMap<String, SubscriptionResultImpl>(1024);
            try {
                File f = this.getResultsFile(subs);
                Map map2 = FileUtil.readResilientFile(f);
                List list = (List)map2.get("results");
                if (list != null) {
                    SubscriptionHistoryImpl history = (SubscriptionHistoryImpl)subs.getHistory();
                    for (int i = 0; i < list.size(); ++i) {
                        Map result_map = (Map)list.get(i);
                        try {
                            SubscriptionResultImpl result = new SubscriptionResultImpl(history, result_map);
                            results.put(result.getID(), result);
                            continue;
                        }
                        catch (Throwable e) {
                            this.log("Failed to decode result '" + result_map + "'", e);
                        }
                    }
                }
            }
            catch (Throwable e) {
                this.log("Failed to load results for '" + subs.getName() + "' - continuing with empty result set", e);
            }
            this.result_cache.put(subs, new Object[]{results, SystemTime.getMonotonousTime()});
            if (this.result_cache.size() > 5) {
                SubscriptionImpl oldest_sub = null;
                long oldest_time = Long.MAX_VALUE;
                for (Map.Entry<SubscriptionImpl, Object[]> x : this.result_cache.entrySet()) {
                    long time = (Long)x.getValue()[1];
                    if (time >= oldest_time) continue;
                    oldest_time = time;
                    oldest_sub = x.getKey();
                }
                this.result_cache.remove(oldest_sub);
            }
            return results;
        }
    }

    protected void setCategoryOnExisting(SubscriptionImpl subscription, String old_category, String new_category) {
        Download[] downloads;
        PluginInterface default_pi = PluginInitializer.getDefaultInterface();
        for (Download d : downloads = default_pi.getDownloadManager().getDownloads()) {
            String existing;
            if (!this.subscriptionExists(d, subscription) || (existing = d.getAttribute(this.ta_category)) != null && !existing.equals(old_category)) continue;
            d.setAttribute(this.ta_category, new_category);
        }
    }

    @Override
    public int getMaxNonDeletedResults() {
        return COConfigurationManager.getIntParameter(CONFIG_MAX_RESULTS);
    }

    @Override
    public void setMaxNonDeletedResults(int max) {
        if (max != this.getMaxNonDeletedResults()) {
            COConfigurationManager.setParameter(CONFIG_MAX_RESULTS, max);
        }
    }

    @Override
    public boolean getAutoStartDownloads() {
        return COConfigurationManager.getBooleanParameter(CONFIG_AUTO_START_DLS);
    }

    @Override
    public void setAutoStartDownloads(boolean auto_start) {
        if (auto_start != this.getAutoStartDownloads()) {
            COConfigurationManager.setParameter(CONFIG_AUTO_START_DLS, auto_start);
        }
    }

    @Override
    public int getAutoStartMinMB() {
        return COConfigurationManager.getIntParameter(CONFIG_AUTO_START_MIN_MB);
    }

    @Override
    public void setAutoStartMinMB(int mb) {
        if (mb != this.getAutoStartMinMB()) {
            COConfigurationManager.setParameter(CONFIG_AUTO_START_MIN_MB, mb);
        }
    }

    @Override
    public int getAutoStartMaxMB() {
        return COConfigurationManager.getIntParameter(CONFIG_AUTO_START_MAX_MB);
    }

    @Override
    public void setAutoStartMaxMB(int mb) {
        if (mb != this.getAutoStartMaxMB()) {
            COConfigurationManager.setParameter(CONFIG_AUTO_START_MAX_MB, mb);
        }
    }

    @Override
    public int getAutoDownloadMarkReadAfterDays() {
        return COConfigurationManager.getIntParameter(CONFIG_AUTO_MARK_READ);
    }

    @Override
    public void setAutoDownloadMarkReadAfterDays(int days) {
        if (days != this.getAutoDownloadMarkReadAfterDays()) {
            COConfigurationManager.setParameter(CONFIG_AUTO_MARK_READ, days);
        }
    }

    protected boolean shouldAutoStart(Torrent torrent) {
        if (this.getAutoStartDownloads()) {
            long min = (long)(this.getAutoStartMinMB() * 1024) * 1024L;
            long max = (long)(this.getAutoStartMaxMB() * 1024) * 1024L;
            if (min <= 0L && max <= 0L) {
                return true;
            }
            long size = torrent.getSize();
            if (min > 0L && size < min) {
                return false;
            }
            return max <= 0L || size <= max;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveResults(SubscriptionImpl subs, SubscriptionResultImpl[] results) {
        Map<SubscriptionImpl, Object[]> map = this.result_cache;
        synchronized (map) {
            this.result_cache.remove(subs);
            try {
                File f = this.getResultsFile(subs);
                HashMap map2 = new HashMap();
                ArrayList<Map> list = new ArrayList<Map>(results.length);
                map2.put("results", list);
                for (int i = 0; i < results.length; ++i) {
                    list.add(results[i].toBEncodedMap());
                }
                FileUtil.writeResilientFile(f, map2);
            }
            catch (Throwable e) {
                this.log("Failed to save results for '" + subs.getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig() {
        if (!FileUtil.resilientConfigFileExists(CONFIG_FILE)) {
            return;
        }
        this.log("Loading configuration");
        boolean some_are_mine = false;
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            Map map = FileUtil.readResilientConfigFile(CONFIG_FILE);
            List l_subs = (List)map.get("subs");
            if (l_subs != null) {
                for (int i = 0; i < l_subs.size(); ++i) {
                    Map m = (Map)l_subs.get(i);
                    try {
                        SubscriptionImpl sub = new SubscriptionImpl(this, m);
                        int index = Collections.binarySearch(this.subscriptions, sub, new Comparator<Subscription>(){

                            @Override
                            public int compare(Subscription arg0, Subscription arg1) {
                                return arg0.getID().compareTo(arg1.getID());
                            }
                        });
                        if (index < 0) {
                            index = -1 * index - 1;
                            this.subscriptions.add(index, sub);
                        }
                        if (sub.isMine()) {
                            some_are_mine = true;
                        }
                        this.log("    loaded " + sub.getString());
                        continue;
                    }
                    catch (Throwable e) {
                        this.log("Failed to import subscription from " + m, e);
                    }
                }
            }
        }
        if (some_are_mine) {
            this.addMetaSearchListener();
        }
    }

    protected void configDirty(SubscriptionImpl subs) {
        this.changeSubscription(subs);
        this.configDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configDirty() {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            if (this.config_dirty) {
                return;
            }
            this.config_dirty = true;
            new DelayedEvent("Subscriptions:save", 5000L, new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    SubscriptionManagerImpl subscriptionManagerImpl = SubscriptionManagerImpl.this;
                    synchronized (subscriptionManagerImpl) {
                        if (!SubscriptionManagerImpl.this.config_dirty) {
                            return;
                        }
                        SubscriptionManagerImpl.this.saveConfig();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveConfig() {
        this.log("Saving configuration");
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            this.config_dirty = false;
            if (this.subscriptions.size() == 0) {
                FileUtil.deleteResilientConfigFile(CONFIG_FILE);
            } else {
                HashMap map = new HashMap();
                ArrayList<Map> l_subs = new ArrayList<Map>();
                map.put("subs", l_subs);
                for (SubscriptionImpl sub : this.subscriptions) {
                    try {
                        l_subs.add(sub.toMap());
                    }
                    catch (Throwable e) {
                        this.log("Failed to save subscription " + sub.getString(), e);
                    }
                }
                FileUtil.writeResilientConfigFile(CONFIG_FILE, map);
            }
        }
    }

    private byte[] getKeyBytes(String key) {
        try {
            return key.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Debug.out(e);
            return key.getBytes();
        }
    }

    private AEDiagnosticsLogger getLogger() {
        if (this.logger == null) {
            this.logger = AEDiagnostics.getLogger(LOGGER_NAME);
        }
        return this.logger;
    }

    public void log(String s, Throwable e) {
        AEDiagnosticsLogger diag_logger = this.getLogger();
        diag_logger.log(s);
        diag_logger.log(e);
    }

    public void log(String s) {
        AEDiagnosticsLogger diag_logger = this.getLogger();
        diag_logger.log(s);
    }

    @Override
    public void addListener(SubscriptionManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(SubscriptionManagerListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        writer.println(LOGGER_NAME);
        try {
            writer.indent();
            Subscription[] subs = this.getSubscriptions();
            for (int i = 0; i < subs.length; ++i) {
                SubscriptionImpl sub = (SubscriptionImpl)subs[i];
                sub.generate(writer);
            }
        }
        finally {
            writer.exdent();
        }
    }

    private DHTPluginInterface selectDHTPlugin(SubscriptionImpl subs) {
        if (subs.isAnonymous()) {
            List<DistributedDatabase> ddbs = AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getUtilities().getDistributedDatabases(new String[]{"I2P"});
            if (ddbs.size() > 0) {
                return ddbs.get(0).getDHTPlugin();
            }
            return null;
        }
        return this.dht_plugin_public;
    }

    private DHTPluginInterface selectDHTPlugin(Download download) {
        String[] networks = download.getListAttribute(this.ta_networks);
        return this.selectDHTPlugin(networks);
    }

    private DHTPluginInterface selectDHTPlugin(String[] networks) {
        if (networks.length > 0) {
            for (String net : networks) {
                if (net != "Public") continue;
                return this.dht_plugin_public;
            }
            List<DistributedDatabase> ddbs = AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getUtilities().getDistributedDatabases(new String[]{"I2P"});
            if (ddbs.size() > 0) {
                return ddbs.get(0).getDHTPlugin();
            }
        }
        return null;
    }

    public static void main(String[] args) {
        String NAME = "lalalal";
        String URL_STR = "http://www.vuze.com/feed/publisher/ALL/1";
        try {
            VuzeFile vf = VuzeFileHandler.getSingleton().create();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", "lalalal");
            map.put("url", "http://www.vuze.com/feed/publisher/ALL/1");
            map.put("public", new Long(0L));
            map.put("check_interval_mins", new Long(345L));
            vf.addComponent(32, map);
            vf.write(new File("C:\\temp\\srss_2.vuze"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        int max_conc_assoc_pub = 3;
        try {
            max_conc_assoc_pub = Integer.parseInt(System.getProperty("azureus.subs.max.concurrent.assoc.publish", "" + max_conc_assoc_pub));
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        PUB_ASSOC_CONC_MAX = max_conc_assoc_pub;
        random_seed = RandomUtils.nextInt(256);
        SP_LAST_ATTEMPTED = new Object();
        SP_CONSEC_FAIL = new Object();
        SUBS_CHAT_KEY = new Object();
    }

    protected static interface downloadListener {
        public void complete(File var1);

        public void complete(Download var1, File var2);

        public void failed(Throwable var1);

        public Map getRecoveryData();

        public boolean isCancelled();
    }

    private static class searchMatcher {
        private String[] bits;
        private int[] bit_types;
        private Pattern[] bit_patterns;

        protected searchMatcher(String term) {
            this.bits = Constants.PAT_SPLIT_SPACE.split(term.toLowerCase());
            this.bit_types = new int[this.bits.length];
            this.bit_patterns = new Pattern[this.bits.length];
            for (int i = 0; i < this.bits.length; ++i) {
                this.bits[i] = this.bits[i].trim();
                String bit = this.bits[i];
                if (bit.length() <= 0) continue;
                char c = bit.charAt(0);
                if (c == '+') {
                    this.bit_types[i] = 1;
                    bit = this.bits[i] = bit.substring(1);
                } else if (c == '-') {
                    this.bit_types[i] = 2;
                    bit = this.bits[i] = bit.substring(1);
                }
                if (bit.startsWith("(") && bit.endsWith(")")) {
                    bit = bit.substring(1, bit.length() - 1);
                    try {
                        this.bit_patterns[i] = Pattern.compile(bit, 2);
                    }
                    catch (Throwable e) {}
                    continue;
                }
                if (!bit.contains("|")) continue;
                try {
                    this.bit_patterns[i] = Pattern.compile(bit, 2);
                    continue;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }

        public boolean matches(String str) {
            str = str.toLowerCase();
            boolean match = true;
            boolean at_least_one = false;
            for (int i = 0; i < this.bits.length; ++i) {
                String bit = this.bits[i];
                if (bit.length() <= 0) continue;
                boolean hit = this.bit_patterns[i] == null ? str.contains(bit) : this.bit_patterns[i].matcher(str).find();
                int type = this.bit_types[i];
                if (hit) {
                    if (type == 2) {
                        match = false;
                        break;
                    }
                    at_least_one = true;
                    continue;
                }
                if (type == 2) {
                    at_least_one = true;
                    continue;
                }
                match = false;
                break;
            }
            boolean res = match && at_least_one;
            return res;
        }
    }

    static interface subsLookupListener
    extends SubscriptionLookupListener {
        public boolean isCancelled();
    }
}

