/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.stats;

import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.average.Average;
import com.aelitis.azureus.core.util.average.AverageFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class AzureusCoreStats {
    public static final int AVERAGE_PERIOD = 1000;
    public static final String ST_ALL = ".*";
    public static final String ST_DISK = "disk.*";
    public static final String ST_DISK_READ_QUEUE_LENGTH = "disk.read.queue.length";
    public static final String ST_DISK_READ_QUEUE_BYTES = "disk.read.queue.bytes";
    public static final String ST_DISK_READ_REQUEST_COUNT = "disk.read.request.count";
    public static final String ST_DISK_READ_REQUEST_SINGLE = "disk.read.request.single";
    public static final String ST_DISK_READ_REQUEST_MULTIPLE = "disk.read.request.multiple";
    public static final String ST_DISK_READ_REQUEST_BLOCKS = "disk.read.request.blocks";
    public static final String ST_DISK_READ_BYTES_TOTAL = "disk.read.bytes.total";
    public static final String ST_DISK_READ_BYTES_SINGLE = "disk.read.bytes.single";
    public static final String ST_DISK_READ_BYTES_MULTIPLE = "disk.read.bytes.multiple";
    public static final String ST_DISK_READ_IO_TIME = "disk.read.io.time";
    public static final String ST_DISK_READ_IO_COUNT = "disk.read.io.count";
    public static final String ST_DISK_WRITE_QUEUE_LENGTH = "disk.write.queue.length";
    public static final String ST_DISK_WRITE_QUEUE_BYTES = "disk.write.queue.bytes";
    public static final String ST_DISK_WRITE_REQUEST_COUNT = "disk.write.request.count";
    public static final String ST_DISK_WRITE_REQUEST_BLOCKS = "disk.write.request.blocks";
    public static final String ST_DISK_WRITE_BYTES_TOTAL = "disk.write.bytes.total";
    public static final String ST_DISK_WRITE_BYTES_SINGLE = "disk.write.bytes.single";
    public static final String ST_DISK_WRITE_BYTES_MULTIPLE = "disk.write.bytes.multiple";
    public static final String ST_DISK_WRITE_IO_TIME = "disk.write.io.time";
    public static final String ST_DISK_WRITE_IO_COUNT = "disk.write.io.count";
    public static final String ST_NET_WRITE_CONTROL_WAIT_COUNT = "net.write.control.wait.count";
    public static final String ST_NET_WRITE_CONTROL_NP_COUNT = "net.write.control.np.count";
    public static final String ST_NET_WRITE_CONTROL_P_COUNT = "net.write.control.p.count";
    public static final String ST_NET_WRITE_CONTROL_ENTITY_COUNT = "net.write.control.entity.count";
    public static final String ST_NET_WRITE_CONTROL_CON_COUNT = "net.write.control.con.count";
    public static final String ST_NET_WRITE_CONTROL_READY_CON_COUNT = "net.write.control.ready.con.count";
    public static final String ST_NET_WRITE_CONTROL_READY_BYTE_COUNT = "net.write.control.ready.byte.count";
    public static final String ST_NET_READ_CONTROL_LOOP_COUNT = "net.read.control.loop.count";
    public static final String ST_NET_READ_CONTROL_NP_COUNT = "net.read.control.np.count";
    public static final String ST_NET_READ_CONTROL_P_COUNT = "net.read.control.p.count";
    public static final String ST_NET_READ_CONTROL_WAIT_COUNT = "net.read.control.wait.count";
    public static final String ST_NET_READ_CONTROL_ENTITY_COUNT = "net.read.control.entity.count";
    public static final String ST_NET_READ_CONTROL_CON_COUNT = "net.read.control.con.count";
    public static final String ST_NET_READ_CONTROL_READY_CON_COUNT = "net.read.control.ready.con.count";
    public static final String ST_NET_TCP_OUT_CONNECT_QUEUE_LENGTH = "net.tcp.outbound.connect.queue.length";
    public static final String ST_NET_TCP_OUT_PENDING_QUEUE_LENGTH = "net.tcp.outbound.pending.queue.length";
    public static final String ST_NET_TCP_OUT_CANCEL_QUEUE_LENGTH = "net.tcp.outbound.cancel.queue.length";
    public static final String ST_NET_TCP_OUT_CLOSE_QUEUE_LENGTH = "net.tcp.outbound.close.queue.length";
    public static final String ST_NET_TCP_SELECT_WRITE_COUNT = "net.tcp.select.write.count";
    public static final String ST_NET_TCP_SELECT_READ_COUNT = "net.tcp.select.read.count";
    public static final String ST_NET_HTTP_IN_REQUEST_COUNT = "net.http.inbound.request.count";
    public static final String ST_NET_HTTP_IN_REQUEST_OK_COUNT = "net.http.inbound.request.ok.count";
    public static final String ST_NET_HTTP_IN_REQUEST_INVALID_COUNT = "net.http.inbound.request.invalid.count";
    public static final String ST_NET_HTTP_IN_REQUEST_WEBSEED_COUNT = "net.http.inbound.request.webseed.count";
    public static final String ST_NET_HTTP_IN_REQUEST_GETRIGHT_COUNT = "net.http.inbound.request.getright.count";
    public static final String ST_PEER_CONTROL_SCHEDULE_COUNT = "peer.control.schedule.count";
    public static final String ST_PEER_CONTROL_LOOP_COUNT = "peer.control.loop.count";
    public static final String ST_PEER_CONTROL_YIELD_COUNT = "peer.control.yield.count";
    public static final String ST_PEER_CONTROL_WAIT_COUNT = "peer.control.wait.count";
    public static final String ST_PEER_CONTROL_WAIT_TIME = "peer.control.wait.time";
    public static final String ST_PEER_MANAGER_COUNT = "peer.manager.count";
    public static final String ST_PEER_MANAGER_PEER_COUNT = "peer.manager.peer.count";
    public static final String ST_PEER_MANAGER_PEER_SNUBBED_COUNT = "peer.manager.peer.snubbed.count";
    public static final String ST_PEER_MANAGER_PEER_STALLED_DISK_COUNT = "peer.manager.peer.stalled.disk.count";
    public static final String ST_TRACKER_READ_BYTES = "tracker.read.bytes.total";
    public static final String ST_TRACKER_WRITE_BYTES = "tracker.write.bytes.total";
    public static final String ST_TRACKER_ANNOUNCE_COUNT = "tracker.announce.count";
    public static final String ST_TRACKER_ANNOUNCE_TIME = "tracker.announce.time";
    public static final String ST_TRACKER_SCRAPE_COUNT = "tracker.scrape.count";
    public static final String ST_TRACKER_SCRAPE_TIME = "tracker.scrape.time";
    public static final String ST_XFER_UPLOADED_PROTOCOL_BYTES = "xfer.upload.protocol.bytes.total";
    public static final String ST_XFER_UPLOADED_DATA_BYTES = "xfer.upload.data.bytes.total";
    public static final String ST_XFER_DOWNLOADED_PROTOCOL_BYTES = "xfer.download.protocol.bytes.total";
    public static final String ST_XFER_DOWNLOADED_DATA_BYTES = "xfer.download.data.bytes.total";
    public static final String POINT = "Point";
    public static final String CUMULATIVE = "Cumulative";
    private static final List stats_names = new ArrayList();
    private static final Map stats_types = new HashMap();
    private static final String[][] _ST_ALL = new String[][]{{"disk.read.queue.length", "Point"}, {"disk.read.queue.bytes", "Point"}, {"disk.read.request.count", "Cumulative"}, {"disk.read.request.single", "Cumulative"}, {"disk.read.request.multiple", "Cumulative"}, {"disk.read.request.blocks", "Cumulative"}, {"disk.read.bytes.total", "Cumulative"}, {"disk.read.bytes.single", "Cumulative"}, {"disk.read.bytes.multiple", "Cumulative"}, {"disk.read.io.time", "Cumulative"}, {"disk.read.io.count", "Cumulative"}, {"disk.write.queue.length", "Point"}, {"disk.write.queue.bytes", "Point"}, {"disk.write.request.count", "Cumulative"}, {"disk.write.request.blocks", "Cumulative"}, {"disk.write.bytes.total", "Cumulative"}, {"disk.write.bytes.single", "Cumulative"}, {"disk.write.bytes.multiple", "Cumulative"}, {"disk.write.io.time", "Cumulative"}, {"disk.write.io.count", "Cumulative"}, {"net.write.control.wait.count", "Cumulative"}, {"net.write.control.p.count", "Cumulative"}, {"net.write.control.np.count", "Cumulative"}, {"net.write.control.entity.count", "Point"}, {"net.write.control.con.count", "Point"}, {"net.write.control.ready.con.count", "Point"}, {"net.write.control.ready.byte.count", "Point"}, {"net.read.control.loop.count", "Cumulative"}, {"net.read.control.p.count", "Cumulative"}, {"net.read.control.np.count", "Cumulative"}, {"net.read.control.wait.count", "Cumulative"}, {"net.read.control.entity.count", "Point"}, {"net.read.control.con.count", "Point"}, {"net.read.control.ready.con.count", "Point"}, {"net.tcp.outbound.connect.queue.length", "Point"}, {"net.tcp.outbound.pending.queue.length", "Point"}, {"net.tcp.outbound.cancel.queue.length", "Point"}, {"net.tcp.outbound.close.queue.length", "Point"}, {"net.tcp.select.write.count", "Cumulative"}, {"net.tcp.select.read.count", "Cumulative"}, {"net.http.inbound.request.count", "Cumulative"}, {"net.http.inbound.request.ok.count", "Cumulative"}, {"net.http.inbound.request.invalid.count", "Cumulative"}, {"net.http.inbound.request.webseed.count", "Cumulative"}, {"net.http.inbound.request.getright.count", "Cumulative"}, {"peer.control.schedule.count", "Cumulative"}, {"peer.control.loop.count", "Cumulative"}, {"peer.control.yield.count", "Cumulative"}, {"peer.control.wait.count", "Cumulative"}, {"peer.control.wait.time", "Cumulative"}, {"peer.manager.count", "Point"}, {"peer.manager.peer.count", "Point"}, {"peer.manager.peer.snubbed.count", "Point"}, {"peer.manager.peer.stalled.disk.count", "Point"}, {"tracker.read.bytes.total", "Cumulative"}, {"tracker.write.bytes.total", "Cumulative"}, {"tracker.announce.count", "Cumulative"}, {"tracker.announce.time", "Cumulative"}, {"tracker.scrape.count", "Cumulative"}, {"tracker.scrape.time", "Cumulative"}, {"xfer.upload.protocol.bytes.total", "Cumulative"}, {"xfer.upload.data.bytes.total", "Cumulative"}, {"xfer.download.protocol.bytes.total", "Cumulative"}, {"xfer.download.data.bytes.total", "Cumulative"}};
    private static final CopyOnWriteList providers;
    private static Map averages;
    private static boolean enable_averages;
    private static Timer average_timer;
    private static final CopyOnWriteList provider_listeners;
    private static final CopyOnWriteList derived_generators;

    public static void addStatsDefinitions(String[][] stats2) {
        for (int i = 0; i < stats2.length; ++i) {
            String name = stats2[i][0];
            stats_names.add(name);
            stats_types.put(name, stats2[i][1]);
        }
    }

    public static Map getStats(Set types) {
        HashSet<String> expanded = new HashSet<String>();
        for (String type : types) {
            if (type.endsWith(".average")) {
                type = type.substring(0, type.length() - 8);
            }
            if (!type.endsWith("*")) {
                type = type + ST_ALL;
            }
            Pattern pattern = Pattern.compile(type);
            for (int i = 0; i < stats_names.size(); ++i) {
                String s = (String)stats_names.get(i);
                if (!pattern.matcher(s).matches()) continue;
                expanded.add(s);
            }
            for (Object[] provider_entry : providers) {
                Set provider_types = (Set)provider_entry[0];
                for (String s : provider_types) {
                    if (!pattern.matcher(s).matches()) continue;
                    expanded.add(s);
                }
            }
            Iterator derived_it = derived_generators.iterator();
            while (derived_it.hasNext()) {
                try {
                    ((derivedStatsGenerator)derived_it.next()).match(pattern, expanded);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        Map result = AzureusCoreStats.getStatsSupport(expanded);
        Map ave = averages;
        if (ave != null) {
            Iterator<Object> it = result.keySet().iterator();
            HashMap<String, Long> ave_results = new HashMap<String, Long>();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object[] a_entry = (Object[])ave.get(key);
                if (a_entry == null) continue;
                Average average = (Average)a_entry[0];
                ave_results.put(key + ".average", new Long((long)average.getAverage()));
            }
            result.putAll(ave_results);
        }
        Iterator derived_it = derived_generators.iterator();
        while (derived_it.hasNext()) {
            try {
                ((derivedStatsGenerator)derived_it.next()).generate(result);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return result;
    }

    protected static Map getStatsSupport(Set types) {
        HashMap result = new HashMap();
        for (Object[] provider_entry : providers) {
            HashMap<String, Object> provider_result = new HashMap<String, Object>();
            Set target_types = types == null ? (Set)provider_entry[0] : types;
            try {
                ((AzureusCoreStatsProvider)provider_entry[1]).updateStats(target_types, provider_result);
                for (Map.Entry pe : provider_result.entrySet()) {
                    String key = (String)pe.getKey();
                    Object obj = pe.getValue();
                    if (obj instanceof Long) {
                        Long old = (Long)result.get(key);
                        if (old == null) {
                            result.put(key, obj);
                            continue;
                        }
                        long v = (Long)obj;
                        result.put(key, new Long(v + old));
                        continue;
                    }
                    result.put(key, obj);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerProvider(Set types, AzureusCoreStatsProvider provider2) {
        CopyOnWriteList copyOnWriteList = providers;
        synchronized (copyOnWriteList) {
            providers.add(new Object[]{types, provider2});
        }
        AzureusCoreStats.fireProvidersChangeListeners();
    }

    public static void addProvidersChangeListener(providersChangeListener l) {
        provider_listeners.add(l);
    }

    protected static void fireProvidersChangeListeners() {
        Iterator it = provider_listeners.iterator();
        while (it.hasNext()) {
            try {
                ((providersChangeListener)it.next()).providersChanged();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public static void registerDerivedStatsGenerator(derivedStatsGenerator gen) {
        derived_generators.add(gen);
    }

    public static synchronized void setEnableAverages(boolean enabled) {
        if (enabled == enable_averages) {
            return;
        }
        enable_averages = enabled;
        if (enabled) {
            if (average_timer == null) {
                average_timer = new Timer("AzureusCoreStats:average");
                averages = new HashMap();
                average_timer.addPeriodicEvent(1000L, new TimerEventPerformer(){
                    private final Map ave = AzureusCoreStats.access$000();

                    @Override
                    public void perform(TimerEvent event2) {
                        Map stats2 = AzureusCoreStats.getStatsSupport(null);
                        Iterator it = stats2.entrySet().iterator();
                        boolean new_averages = false;
                        while (it.hasNext()) {
                            boolean new_average;
                            long last_value;
                            Average a;
                            Map.Entry entry = it.next();
                            String key = (String)entry.getKey();
                            Object value = entry.getValue();
                            if (!(value instanceof Long)) continue;
                            Object[] a_entry = (Object[])this.ave.get(key);
                            if (a_entry == null) {
                                a = AverageFactory.MovingImmediateAverage(10);
                                last_value = 0L;
                                a_entry = new Object[]{a, value};
                                this.ave.put(key, a_entry);
                                new_average = true;
                                new_averages = true;
                            } else {
                                a = (Average)a_entry[0];
                                last_value = (Long)a_entry[1];
                                new_average = false;
                            }
                            if (stats_types.get(key) == AzureusCoreStats.CUMULATIVE) {
                                if (!new_average) {
                                    a.update((Long)value - last_value);
                                }
                            } else {
                                a.update(((Long)value).longValue());
                            }
                            a_entry[1] = value;
                        }
                        if (new_averages) {
                            AzureusCoreStats.fireProvidersChangeListeners();
                        }
                    }
                });
            }
        } else if (average_timer != null) {
            average_timer.destroy();
            average_timer = null;
            averages = null;
        }
    }

    public static synchronized boolean getEnableAverages() {
        return enable_averages;
    }

    static /* synthetic */ Map access$000() {
        return averages;
    }

    static {
        AzureusCoreStats.addStatsDefinitions(_ST_ALL);
        AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void generate(IndentWriter writer) {
                writer.println("Stats");
                boolean turn_on_averages = !AzureusCoreStats.getEnableAverages();
                try {
                    writer.indent();
                    if (turn_on_averages) {
                        AzureusCoreStats.setEnableAverages(true);
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    HashSet<String> types = new HashSet<String>();
                    types.add(AzureusCoreStats.ST_ALL);
                    Map reply = AzureusCoreStats.getStats(types);
                    Iterator it = reply.entrySet().iterator();
                    ArrayList<String> lines = new ArrayList<String>();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        lines.add(entry.getKey() + " -> " + entry.getValue());
                    }
                    Collections.sort(lines);
                    for (int i = 0; i < lines.size(); ++i) {
                        writer.println((String)lines.get(i));
                    }
                }
                finally {
                    if (turn_on_averages) {
                        AzureusCoreStats.setEnableAverages(false);
                    }
                    writer.exdent();
                }
            }
        });
        providers = new CopyOnWriteList();
        averages = new HashMap();
        provider_listeners = new CopyOnWriteList();
        derived_generators = new CopyOnWriteList();
    }

    public static interface derivedStatsGenerator {
        public void match(Pattern var1, Set var2);

        public void generate(Map var1);
    }

    public static interface providersChangeListener {
        public void providersChanged();
    }
}

