/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.speedmanager.SpeedManagerPingSource;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProvider;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProviderAdapter;
import com.aelitis.azureus.core.speedmanager.impl.v2.PingSourceManager;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMInstance;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMUpdate;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedLimitMonitor;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerLogger;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.SystemTime;

public class SpeedManagerAlgorithmProviderPingMap
implements SpeedManagerAlgorithmProvider,
COConfigurationListener {
    private final SpeedManagerAlgorithmProviderAdapter adapter;
    private long timeSinceLastUpdate;
    private int consecutiveUpticks = 0;
    private int consecutiveDownticks = 0;
    private final SpeedLimitMonitor limitMonitor;
    private float lastMetricValue;
    private static int numIntervalsBetweenCal = 2;
    private static boolean skipIntervalAfterAdjustment = true;
    private List pingTimeList = new ArrayList();
    private boolean hadAdjustmentLastInterval = false;
    private int intervalCount = 0;
    final PingSourceManager pingSourceManager = new PingSourceManager();
    int sessionMaxUploadRate = 0;

    SpeedManagerAlgorithmProviderPingMap(SpeedManagerAlgorithmProviderAdapter _adapter) {
        this.adapter = _adapter;
        SpeedManagerLogger.setAdapter("pm", this.adapter);
        this.limitMonitor = new SpeedLimitMonitor(this.adapter.getSpeedManager());
        COConfigurationManager.addListener(this);
        SMInstance.init(_adapter);
        this.limitMonitor.initPingSpaceMap();
    }

    @Override
    public void destroy() {
        COConfigurationManager.removeListener(this);
    }

    @Override
    public void configurationSaved() {
        try {
            this.limitMonitor.readFromPersistentMap();
            this.limitMonitor.updateFromCOConfigManager();
            skipIntervalAfterAdjustment = COConfigurationManager.getBooleanParameter("SpeedManagerAlgorithmProviderV2.setting.wait.after.adjust");
            numIntervalsBetweenCal = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.intervals.between.adjust");
            this.limitMonitor.initPingSpaceMap();
            SpeedManagerLogger.trace("..VariancePingMap - configurationSaved called.");
        }
        catch (Throwable t) {
            SpeedManagerLogger.log(t.getMessage());
        }
    }

    @Override
    public void reset() {
        this.log("reset");
        this.log("curr-data-m: curr-down-rate : curr-down-limit : down-capacity : down-bandwith-mode : down-limit-mode : curr-up-rate : curr-up-limit : up-capacity : upload-bandwidth-mode : upload-limit-mode : transfer-mode");
        this.log("new-limit:newLimit:currStep:signalStrength:multiple:currUpLimit:maxStep:uploadLimitMax:uploadLimitMin:transferMode");
        this.log("consecutive:up:down");
        this.log("metric:value:type");
        this.log("user-comment:log");
        this.log("pin:upload-status,download-status,upload-unpin-timer,download-unpin-timer");
        this.log("limits:down-max:down-min:down-conf:up-max:up-min:up-conf");
        this.limitMonitor.resetPingSpace();
    }

    @Override
    public void updateStats() {
        int currUploadLimit = this.adapter.getCurrentUploadLimit();
        int currDataUploadSpeed = this.adapter.getCurrentDataUploadSpeed();
        int currProtoUploadSpeed = this.adapter.getCurrentProtocolUploadSpeed();
        int upRateBitsPerSec = currDataUploadSpeed + currProtoUploadSpeed;
        int currDownLimit = this.adapter.getCurrentDownloadLimit();
        int downDataRate = this.adapter.getCurrentDataDownloadSpeed();
        int downProtoRate = this.adapter.getCurrentProtocolDownloadSpeed();
        int downRateBitsPerSec = downDataRate + downProtoRate;
        this.limitMonitor.setDownloadBandwidthMode(downRateBitsPerSec, currDownLimit);
        this.limitMonitor.setUploadBandwidthMode(upRateBitsPerSec, currUploadLimit);
        this.limitMonitor.setDownloadLimitSettingMode(currDownLimit);
        this.limitMonitor.setUploadLimitSettingMode(currUploadLimit);
        this.limitMonitor.updateTransferMode();
        if (this.limitMonitor.isConfTestingLimits()) {
            this.limitMonitor.updateLimitTestingData(downRateBitsPerSec, upRateBitsPerSec);
        }
        this.limitMonitor.setCurrentTransferRates(downRateBitsPerSec, upRateBitsPerSec);
        if (upRateBitsPerSec > this.sessionMaxUploadRate) {
            this.sessionMaxUploadRate = upRateBitsPerSec;
        }
        this.logCurrentData(downRateBitsPerSec, currDownLimit, upRateBitsPerSec, currUploadLimit);
    }

    private void logCurrentData(int downRate, int currDownLimit, int upRate, int currUploadLimit) {
        StringBuilder sb = new StringBuilder("curr-data-m:" + downRate + ":" + currDownLimit + ":");
        sb.append(this.limitMonitor.getDownloadMaxLimit()).append(":");
        sb.append(this.limitMonitor.getDownloadBandwidthMode()).append(":");
        sb.append(this.limitMonitor.getDownloadLimitSettingMode()).append(":");
        sb.append(upRate).append(":").append(currUploadLimit).append(":");
        sb.append(this.limitMonitor.getUploadMaxLimit()).append(":");
        sb.append(this.limitMonitor.getUploadBandwidthMode()).append(":");
        sb.append(this.limitMonitor.getUploadLimitSettingMode()).append(":");
        sb.append(this.limitMonitor.getTransferModeAsString());
        SpeedManagerLogger.log(sb.toString());
    }

    @Override
    public void pingSourceFound(SpeedManagerPingSource source, boolean is_replacement) {
        this.log("pingSourceFound");
        this.pingSourceManager.pingSourceFound(source, is_replacement);
    }

    @Override
    public void pingSourceFailed(SpeedManagerPingSource source) {
        this.log("pingSourceFailed");
        this.pingSourceManager.pingSourceFailed(source);
    }

    @Override
    public void calculate(SpeedManagerPingSource[] sources) {
        this.limitMonitor.logPMDataEx();
        int len = sources.length;
        for (int i = 0; i < len; ++i) {
            this.pingSourceManager.addPingTime(sources[i]);
            int pingTime = sources[i].getPingTime();
            if (pingTime <= 0) continue;
            ++this.intervalCount;
        }
        if (this.limitMonitor.isConfTestingLimits()) {
            if (this.limitMonitor.isConfLimitTestFinished()) {
                this.endLimitTesting();
                return;
            }
            SMUpdate ramp = this.limitMonitor.rampTestingLimit(this.adapter.getCurrentUploadLimit(), this.adapter.getCurrentDownloadLimit());
            this.logNewLimits(ramp);
            this.setNewLimits(ramp);
        }
        long currTime = SystemTime.getCurrentTime();
        if (this.timeSinceLastUpdate == 0L) {
            this.timeSinceLastUpdate = currTime;
        }
        if (this.calculatePingMetric()) {
            return;
        }
        this.log("metric:" + this.lastMetricValue);
        this.logLimitStatus();
        float signalStrength = this.determineSignalStrength(this.lastMetricValue);
        if (signalStrength != 0.0f && !this.limitMonitor.isConfTestingLimits()) {
            this.hadAdjustmentLastInterval = true;
            float multiple = this.consectiveMultiplier();
            int currUpLimit = this.adapter.getCurrentUploadLimit();
            int currDownLimit = this.adapter.getCurrentDownloadLimit();
            this.limitMonitor.checkForUnpinningCondition();
            SMUpdate update = this.limitMonitor.modifyLimits(signalStrength, multiple, currUpLimit, currDownLimit);
            this.logNewLimits(update);
            this.setNewLimits(update);
        } else {
            int currDownloadLimit;
            this.hadAdjustmentLastInterval = false;
            int currUploadLimit = this.adapter.getCurrentUploadLimit();
            if (!this.limitMonitor.areSettingsInSpec(currUploadLimit, currDownloadLimit = this.adapter.getCurrentDownloadLimit())) {
                SMUpdate update = this.limitMonitor.adjustLimitsToSpec(currUploadLimit, currDownloadLimit);
                this.logNewLimits(update);
                this.setNewLimits(update);
            }
        }
        this.pingSourceManager.checkPingSources(sources);
    }

    private void endLimitTesting() {
        int downLimitGuess = this.limitMonitor.guessDownloadLimit();
        int upLimitGuess = this.limitMonitor.guessUploadLimit();
        SMUpdate update = this.limitMonitor.endLimitTesting(downLimitGuess, upLimitGuess);
        this.limitMonitor.logPingMapData();
        this.limitMonitor.resetPingSpace();
        this.logNewLimits(update);
        this.setNewLimits(update);
    }

    private void logLimitStatus() {
        StringBuilder msg = new StringBuilder();
        msg.append("limits:");
        msg.append(this.limitMonitor.getUploadMaxLimit()).append(":");
        msg.append(this.limitMonitor.getUploadMinLimit()).append(":");
        msg.append(this.limitMonitor.getUploadConfidence()).append(":");
        msg.append(this.limitMonitor.getDownloadMaxLimit()).append(":");
        msg.append(this.limitMonitor.getDownloadMinLimit()).append(":");
        msg.append(this.limitMonitor.getDownloadConfidence());
        SpeedManagerLogger.log(msg.toString());
    }

    private boolean calculatePingMetric() {
        if (skipIntervalAfterAdjustment && this.hadAdjustmentLastInterval) {
            this.hadAdjustmentLastInterval = false;
            this.pingTimeList = new ArrayList();
            this.intervalCount = 0;
            return true;
        }
        if (this.intervalCount < numIntervalsBetweenCal) {
            return true;
        }
        this.lastMetricValue = (float)this.adapter.getPingMapper().getCurrentMetricRating();
        this.intervalCount = 0;
        return false;
    }

    private void logNewLimits(SMUpdate update) {
        if (update.hasNewUploadLimit) {
            int kbpsUpoadLimit = update.newUploadLimit / 1024;
            this.log(" new up limit  : " + kbpsUpoadLimit + " kb/s");
        }
        if (update.hasNewDownloadLimit) {
            int kpbsDownloadLimit = update.newDownloadLimit / 1024;
            this.log(" new down limit: " + kpbsDownloadLimit + " kb/s");
        }
    }

    private void setNewLimits(SMUpdate update) {
        this.adapter.setCurrentUploadLimit(update.newUploadLimit);
        this.adapter.setCurrentDownloadLimit(update.newDownloadLimit);
    }

    private float determineSignalStrength(float lastMetric) {
        float signal = this.convertTestMetricToSignal(lastMetric);
        if (signal > 0.0f) {
            ++this.consecutiveUpticks;
            this.consecutiveDownticks = 0;
        } else if (signal < 0.0f) {
            this.consecutiveUpticks = 0;
            ++this.consecutiveDownticks;
        }
        this.log("consecutive:" + this.consecutiveUpticks + ":" + this.consecutiveDownticks);
        return signal;
    }

    private float convertTestMetricToSignal(float testMetric) {
        if (testMetric >= 1.0f) {
            return 1.0f;
        }
        if (testMetric <= -1.0f) {
            return -1.0f;
        }
        if (testMetric > -0.5f && testMetric < 0.5f) {
            return 0.0f;
        }
        if (testMetric > 0.0f) {
            return (testMetric - 0.5f) * 2.0f;
        }
        return (testMetric + 0.5f) * 2.0f;
    }

    private float consectiveMultiplier() {
        float multiple;
        if (this.consecutiveUpticks > this.consecutiveDownticks) {
            if (this.limitMonitor.bandwidthUsageLow()) {
                this.consecutiveUpticks = 0;
            }
            multiple = this.calculateUpTickMultiple(this.consecutiveUpticks);
        } else {
            multiple = this.calculateDownTickMultiple(this.consecutiveDownticks);
            this.limitMonitor.notifyOfDownSignal();
        }
        return multiple;
    }

    private float calculateUpTickMultiple(int c) {
        float multiple = 0.0f;
        if (c < 0) {
            return multiple;
        }
        switch (c) {
            case 0: 
            case 1: {
                multiple = 0.25f;
                break;
            }
            case 2: {
                multiple = 0.5f;
                break;
            }
            case 3: {
                multiple = 1.0f;
                break;
            }
            case 4: {
                multiple = 1.25f;
                break;
            }
            case 5: {
                multiple = 1.5f;
                break;
            }
            case 6: {
                multiple = 1.75f;
                break;
            }
            case 7: {
                multiple = 2.0f;
                break;
            }
            case 8: {
                multiple = 2.25f;
                break;
            }
            case 9: {
                multiple = 2.5f;
                break;
            }
            default: {
                multiple = 3.0f;
            }
        }
        if (this.limitMonitor.bandwidthUsageMedium()) {
            multiple /= 2.0f;
        }
        return multiple;
    }

    private float calculateDownTickMultiple(int c) {
        float multiple = 0.0f;
        if (c < 0) {
            return multiple;
        }
        switch (c) {
            case 0: 
            case 1: {
                multiple = 0.25f;
                break;
            }
            case 2: {
                multiple = 0.5f;
                break;
            }
            case 3: {
                multiple = 1.0f;
                break;
            }
            case 4: {
                multiple = 2.0f;
                break;
            }
            case 5: {
                multiple = 3.0f;
                break;
            }
            case 6: {
                multiple = 4.0f;
                break;
            }
            case 7: {
                multiple = 6.0f;
                break;
            }
            case 8: {
                multiple = 9.0f;
                break;
            }
            case 9: {
                multiple = 15.0f;
                break;
            }
            default: {
                multiple = 20.0f;
            }
        }
        return multiple;
    }

    @Override
    public int getIdlePingMillis() {
        return 0;
    }

    @Override
    public int getCurrentPingMillis() {
        return 0;
    }

    @Override
    public int getMaxPingMillis() {
        return 910;
    }

    @Override
    public int getCurrentChokeSpeed() {
        return 0;
    }

    @Override
    public int getMaxUploadSpeed() {
        return this.sessionMaxUploadRate;
    }

    @Override
    public boolean getAdjustsDownloadLimits() {
        return true;
    }

    protected void log(String str) {
        SpeedManagerLogger.log(str);
    }
}

