/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProviderAdapter;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMConfigurationAdapter;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMInstance;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;

public class SMSearchLogger {
    private static final LogIDs ID = LogIDs.NWMAN;
    private static final AEDiagnosticsLogger dLog = AEDiagnostics.getLogger("AutoSpeedSearchHistory");

    private SMSearchLogger() {
    }

    public static void log(String str) {
        SpeedManagerAlgorithmProviderAdapter adpter = SMInstance.getInstance().getAdapter();
        int adptCurrUpLimit = adpter.getCurrentUploadLimit();
        int adptCurrDownLimit = adpter.getCurrentDownloadLimit();
        SMConfigurationAdapter conf = SMInstance.getInstance().getConfigManager();
        SpeedManagerLimitEstimate uploadSetting = conf.getUploadLimit();
        SpeedManagerLimitEstimate downloadSetting = conf.getDownloadLimit();
        StringBuilder sb = new StringBuilder(str);
        sb.append(", Download current =").append(adptCurrDownLimit);
        sb.append(", max limit =").append(downloadSetting.getString());
        sb.append(", Upload current = ").append(adptCurrUpLimit);
        sb.append(", max limit = ").append(uploadSetting.getString());
        String msg = sb.toString();
        LogEvent e = new LogEvent(ID, msg);
        Logger.log(e);
        if (dLog != null) {
            dLog.log(msg);
        }
    }
}

