/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.speedmanager.impl.v2.PingSpaceMapper;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerLogger;
import com.aelitis.azureus.core.speedmanager.impl.v2.TransferMode;
import org.gudy.azureus2.core3.util.SystemTime;

public class PingSpaceMonitor {
    PingSpaceMapper pingMap;
    long startTime;
    private static final long INTERVAL = 300000L;
    final int maxGoodPing;
    final int minBadPing;
    int nBadPings;
    int nGoodPings;
    int nNeutralPings = 0;
    int upNone;
    int upLow;
    int upMed;
    int upHigh;
    int upAtLimit = 0;
    int downNone;
    int downLow;
    int downMed;
    int downHigh;
    int downAtLimit = 0;
    TransferMode transferMode;
    public static final int UPLOAD = 88;
    public static final int DOWNLOAD = 89;
    public static final int NONE = 0;
    boolean hasNewLimit = false;
    int newLimit = -2;
    int limitType = 0;

    public PingSpaceMonitor(int _maxGoodPing, int _minBadPing, TransferMode mode) {
        this.maxGoodPing = _maxGoodPing;
        this.minBadPing = _minBadPing;
        this.reset(mode);
    }

    public void setCurrentTransferRates(int downRate, int upRate) {
        this.pingMap.setCurrentTransferRates(downRate, upRate);
    }

    public boolean addToPingMapData(int lastMetricValue, TransferMode mode) {
        if (this.transferMode == null) {
            this.transferMode = mode;
        }
        if (!this.transferMode.equals(mode)) {
            this.reset(mode);
            this.transferMode = mode;
            return false;
        }
        this.transferMode = mode;
        if (lastMetricValue < this.maxGoodPing) {
            ++this.nGoodPings;
        } else if (lastMetricValue > this.minBadPing) {
            ++this.nBadPings;
        } else {
            ++this.nNeutralPings;
        }
        this.pingMap.addMetricToMap(lastMetricValue);
        long curr = SystemTime.getCurrentTime();
        if (curr > this.startTime + 300000L) {
            boolean needLowerLimts = this.checkForLowerLimits();
            if (needLowerLimts) {
                if (this.transferMode.isConfTestingLimits()) {
                    this.reset(mode);
                    return false;
                }
                if (this.transferMode.isDownloadMode()) {
                    this.newLimit = this.pingMap.guessDownloadLimit();
                    SpeedManagerLogger.trace("PingSpaceMonitor -> guessDownloadLimit: newLimit=" + this.newLimit);
                    int uploadLimitGuess = this.pingMap.guessUploadLimit();
                    SpeedManagerLogger.trace("PingSpaceMonitor -> guessUploadLimit: guessUploadLimit=" + uploadLimitGuess);
                    if (this.newLimit < 40960) {
                        this.newLimit = 40960;
                    }
                    this.hasNewLimit = true;
                    this.limitType = 89;
                    this.reset(mode);
                    return true;
                }
                this.newLimit = this.pingMap.guessUploadLimit();
                if (this.newLimit < 20480) {
                    this.newLimit = 20480;
                }
                this.hasNewLimit = true;
                this.limitType = 88;
                this.reset(mode);
                return true;
            }
            this.reset(mode);
        }
        return false;
    }

    private boolean checkForLowerLimits() {
        int totalPings = this.nGoodPings + this.nBadPings + this.nNeutralPings;
        float percentBad = (float)this.nBadPings / (float)totalPings;
        return percentBad > 0.15f;
    }

    public void reset(TransferMode mode) {
        StringBuilder sb = new StringBuilder("ping-monitor:");
        sb.append("good=").append(this.nGoodPings).append(":");
        sb.append("bad=").append(this.nBadPings).append(":");
        sb.append("neutral=").append(this.nNeutralPings);
        SpeedManagerLogger.log(sb.toString());
        this.nNeutralPings = 0;
        this.nGoodPings = 0;
        this.nBadPings = 0;
        this.upAtLimit = 0;
        this.upHigh = 0;
        this.upMed = 0;
        this.upLow = 0;
        this.upNone = 0;
        this.downAtLimit = 0;
        this.downHigh = 0;
        this.downMed = 0;
        this.downLow = 0;
        this.downNone = 0;
        this.pingMap = new PingSpaceMapper(this.maxGoodPing, this.minBadPing);
        this.startTime = SystemTime.getCurrentTime();
        this.transferMode = mode;
    }

    boolean hasNewLimit() {
        return this.hasNewLimit;
    }

    public int getNewLimit() {
        return this.newLimit;
    }

    public int limitType() {
        return this.limitType;
    }

    public void resetNewLimit() {
        this.hasNewLimit = false;
        this.newLimit = -2;
        this.limitType = 0;
    }
}

