/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingMapper;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProviderAdapter;
import com.aelitis.azureus.core.speedmanager.impl.v2.PSMonitorListener;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMInstance;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerLogger;
import com.aelitis.azureus.core.speedmanager.impl.v2.TransferMode;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.SystemTime;

public class PingSpaceMon {
    private static final long INTERVAL = 900000L;
    long nextCheck = System.currentTimeMillis() + 900000L;
    TransferMode mode;
    final List listeners = new ArrayList();

    public void addListener(PSMonitorListener listener) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            PSMonitorListener t = (PSMonitorListener)this.listeners.get(i);
            if (t != listener) continue;
            SpeedManagerLogger.trace("Not logging same listener twice. listener=" + listener.toString());
            return;
        }
        this.listeners.add(listener);
    }

    public boolean removeListener(PSMonitorListener listener) {
        return this.listeners.remove(listener);
    }

    boolean checkForLowerLimits() {
        long curr = SystemTime.getCurrentTime();
        if (curr > this.nextCheck) {
            SpeedManagerLogger.trace("PingSpaceMon checking for lower limits.");
            for (int i = 0; i < this.listeners.size(); ++i) {
                PSMonitorListener l = (PSMonitorListener)this.listeners.get(i);
                if (l != null) {
                    l.notifyUpload(PingSpaceMon.getUploadEstCapacity());
                    continue;
                }
                SpeedManagerLogger.trace("listener index _" + i + "_ was null.");
            }
            this.resetTimer();
            return true;
        }
        return false;
    }

    boolean updateStatus(TransferMode tMode) {
        if (this.mode == null) {
            this.mode = tMode;
            return true;
        }
        if (this.mode.getMode() != tMode.getMode()) {
            this.mode = tMode;
            this.resetTimer();
            return true;
        }
        return this.checkForLowerLimits();
    }

    void resetTimer() {
        long curr = SystemTime.getCurrentTime();
        this.nextCheck = curr + 900000L;
        SpeedManagerLogger.trace("Monitor resetting time. Next check in interval.");
    }

    public static SpeedManagerLimitEstimate getUploadLimit(boolean persistent) {
        try {
            SMInstance pm = SMInstance.getInstance();
            SpeedManagerAlgorithmProviderAdapter adapter = pm.getAdapter();
            SpeedManagerPingMapper persistentMap = adapter.getPingMapper();
            SpeedManagerLimitEstimate upEst = persistentMap.getEstimatedUploadLimit(true);
            return upEst;
        }
        catch (Throwable t) {
            SpeedManagerLogger.log(t.toString());
            t.printStackTrace();
            return new DefaultLimitEstimate();
        }
    }

    public static SpeedManagerLimitEstimate getUploadEstCapacity() {
        try {
            SMInstance pm = SMInstance.getInstance();
            SpeedManagerAlgorithmProviderAdapter adapter = pm.getAdapter();
            SpeedManager sm = adapter.getSpeedManager();
            SpeedManagerLimitEstimate upEstCapacity = sm.getEstimatedUploadCapacityBytesPerSec();
            return upEstCapacity;
        }
        catch (Throwable t) {
            SpeedManagerLogger.log(t.toString());
            t.printStackTrace();
            return new DefaultLimitEstimate();
        }
    }

    public static SpeedManagerLimitEstimate getDownloadLimit() {
        try {
            SMInstance pm = SMInstance.getInstance();
            SpeedManagerAlgorithmProviderAdapter adapter = pm.getAdapter();
            SpeedManagerPingMapper persistentMap = adapter.getPingMapper();
            SpeedManagerLimitEstimate downEst = persistentMap.getEstimatedDownloadLimit(true);
            return downEst;
        }
        catch (Throwable t) {
            SpeedManagerLogger.log(t.toString());
            t.printStackTrace();
            return new DefaultLimitEstimate();
        }
    }

    public static SpeedManagerLimitEstimate getDownloadEstCapacity() {
        try {
            SMInstance pm = SMInstance.getInstance();
            SpeedManagerAlgorithmProviderAdapter adapter = pm.getAdapter();
            SpeedManager sm = adapter.getSpeedManager();
            SpeedManagerLimitEstimate downEstCapacity = sm.getEstimatedDownloadCapacityBytesPerSec();
            return downEstCapacity;
        }
        catch (Throwable t) {
            SpeedManagerLogger.log(t.toString());
            t.printStackTrace();
            return new DefaultLimitEstimate();
        }
    }

    static class DefaultLimitEstimate
    implements SpeedManagerLimitEstimate {
        DefaultLimitEstimate() {
        }

        @Override
        public int getBytesPerSec() {
            return 1;
        }

        @Override
        public float getEstimateType() {
            return -1.0f;
        }

        @Override
        public float getMetricRating() {
            return -1.0f;
        }

        @Override
        public int[][] getSegments() {
            return new int[0][];
        }

        @Override
        public long getWhen() {
            return 0L;
        }

        @Override
        public String getString() {
            return "default";
        }
    }
}

